/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.CustomQueue;
import com.eg.apm.JavaBTMOffloadLogger;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APMQueue<E>
implements CustomQueue<E> {
    private LinkedBlockingQueue<E> queue = null;
    private int maxLimit = 0;
    protected String loggerDispStr = "[APMQueue]";

    public APMQueue(int maxLimit) {
        this.maxLimit = maxLimit;
        this.queue = new LinkedBlockingQueue(this.maxLimit);
    }

    @Override
    public boolean enqueue(E e) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException ise) {
            int queueSize = this.queue.size();
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not add element to Queue, queue size is {} ", (Object)this.loggerDispStr, (Object)queueSize);
            try {
                e = this.queue.poll();
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Removed and Discarded the old(head) elements from queue ", (Object)this.loggerDispStr);
            }
            catch (Exception exp) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not delete element from Queue, due to the exception {} ", (Object)this.loggerDispStr, (Object)exp);
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Attempting to add element into queue after removing old(head) element ", (Object)this.loggerDispStr);
            return this.enqueue(e, true);
        }
        catch (Exception exp) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not add element to queue, due to the exception {} ", (Object)this.loggerDispStr, (Object)exp);
            return false;
        }
    }

    public boolean enqueue(E e, boolean retry) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException ise) {
            int queueSize = this.queue.size();
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} The second attempt to add element into queue is failed. Queue size is : {} ", (Object)this.loggerDispStr, (Object)queueSize);
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Discarding element .... {} ", (Object)this.loggerDispStr, (Object)e.toString());
            return false;
        }
        catch (Exception exp) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not add element to Queue, due to the exception {} ", (Object)this.loggerDispStr, (Object)exp);
            return false;
        }
    }

    @Override
    public E dequeue() {
        E e = null;
        try {
            e = this.queue.poll();
        }
        catch (Exception exp) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not delete element from Queue, due to the exception {} ", (Object)this.loggerDispStr, (Object)exp);
        }
        return e;
    }

    public E dequeue(boolean waitForData) {
        E e = null;
        try {
            e = this.queue.take();
        }
        catch (Exception exp) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not delete element from Queue, due to the exception ", (Object)this.loggerDispStr, (Object)exp);
        }
        return e;
    }

    final void clearQueue() {
        try {
            this.queue.clear();
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not clear elements from Queue, due to the exception {} ", (Object)this.loggerDispStr, (Object)e);
        }
    }

    public int getSize() {
        return this.queue.size();
    }
}

