/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMNodeComponentIDRepository;
import com.eg.apm.APMNodeQueue;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.NodeBTMDataParser;
import com.eg.apm.NodeBTMLogger;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.NodeMethodInfo;
import com.eg.jtm.NodePropsManager;
import com.eg.jtm.NodeUPDManager;
import com.eg.jtm.NodeURLPatternData;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APMNodeWorker
implements Runnable {
    private APMNodeQueue<Object> myQueue;
    public static int counter = 1;
    protected static String loggerDispStr = "[APMNodeWorker]";
    private static Hashtable<String, NodeUPDManager> UPDmanagerTable = new Hashtable();
    private static Hashtable<String, NodePropsManager> PropsManagerTable = new Hashtable();
    private static Hashtable<String, BTMDiscovery> DataBaseHT = new Hashtable();
    private static Hashtable<String, Integer> AutoNameHT = new Hashtable();
    private static Hashtable<String, String> computedNodeOrders = new Hashtable();
    private static Hashtable tempComponentIDTable = new Hashtable();
    private static Hashtable repositoryRemoved = new Hashtable();
    private static Hashtable heartBeatTable = new Hashtable();
    private Boolean workerSync = new Boolean(true);
    private boolean runThis = true;
    protected final Logger log = NodeBTMLogger.nodeLogger;
    private NodeBTMDataParser nodeBTMDataParser = new NodeBTMDataParser();

    public APMNodeWorker(APMNodeQueue<Object> aPMNodeQueue) {
        this.myQueue = aPMNodeQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        loggerDispStr = "[APMNodeWorker] [" + Thread.currentThread().getName() + "] ";
        do {
            try {
                boolean bl = false;
                NodeBTMLogger.nodeLogger.trace(loggerDispStr + "runThis : {}", (Object)this.runThis);
                while (!bl && this.runThis) {
                    block22: {
                        try {
                            Object object;
                            NodeMethodInfo nodeMethodInfo = null;
                            Object var3_5 = null;
                            Object object2 = this.myQueue.dequeue(true);
                            if (object2 == null) break block22;
                            String[] stringArray = object2.toString().split("\n");
                            ArrayList arrayList = null;
                            try {
                                if (stringArray[0].indexOf(":-:") <= 0) continue;
                                String string = stringArray[0].split(":-:")[1];
                                object = stringArray[stringArray.length - 1].split(":-:");
                                arrayList = this.nodeBTMDataParser.computeTestData(string, object[1], object[0]);
                            }
                            catch (Exception exception) {
                                NodeBTMLogger.nodeLogger.warn(loggerDispStr + "Exception while getting btmdata");
                            }
                            if (arrayList != null && arrayList.size() > 0) {
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    nodeMethodInfo = (NodeMethodInfo)arrayList.get(i);
                                    if (nodeMethodInfo == null) continue;
                                    object = nodeMethodInfo.getProperties();
                                    String string = (String)object.get("siteID");
                                    NodeBTMLogger.nodeLogger.trace(loggerDispStr + "rootProps : {}", object);
                                    String string2 = (String)object.get("PS");
                                    if (string == null || string.equalsIgnoreCase("")) {
                                        NodeBTMLogger.nodeLogger.warn(loggerDispStr + " No siteID from MethodInfo, So discarding this Methodinfo object");
                                        continue;
                                    }
                                    Boolean bl2 = this.workerSync;
                                    synchronized (bl2) {
                                        String string3;
                                        String string4 = (String)tempComponentIDTable.get(string);
                                        if (tempComponentIDTable.containsKey("$" + string)) {
                                            string3 = (String)tempComponentIDTable.get(string);
                                            NodeBTMLogger.nodeLogger.error(loggerDispStr + " Component ID from BTM Jar : {} , New Component ID(Renamed) : {} ", (Object)string, (Object)string3);
                                            string = string3;
                                        }
                                        string3 = nodeMethodInfo.getGuidString();
                                        this.updateRepositoryTables(string, (Map)object);
                                        NodeUPDManager nodeUPDManager = UPDmanagerTable.get(string);
                                        String string5 = nodeUPDManager.autoPatternTable.get(string2);
                                        boolean bl3 = (Boolean)object.get("firstNode");
                                        boolean bl4 = (Boolean)object.get("keyTransaction");
                                        if (bl4) {
                                            nodeUPDManager.manualPatternTable.put(string2, string2);
                                            nodeUPDManager.updateTables4Manual();
                                        }
                                        String string6 = (String)object.get("requestType");
                                        long l = (Long)object.get("cpuTime");
                                        long l2 = (Long)object.get("blockedTime");
                                        long l3 = (Long)object.get("waitedTime");
                                        NodeBTMLogger.nodeLogger.trace(loggerDispStr + " Response Time :  " + nodeMethodInfo.getRawURL() + "\t" + nodeMethodInfo.getExecutionTime());
                                        NodeBTMLogger.nodeLogger.debug(loggerDispStr + " firstNode - " + bl3 + ",keyTransaction - " + bl4 + ",requestType - " + string6 + "");
                                        NodeBTMLogger.nodeLogger.debug(loggerDispStr + " cpuTime - " + l + ",blockedTime - " + l2 + ",waitedTime - " + l3 + "");
                                        NodeBTMLogger.nodeLogger.debug(loggerDispStr + " methodInfo.isErrorURL() - " + nodeMethodInfo.isErrorURL() + ",methodInfo.isSlowURL() - " + nodeMethodInfo.isSlowURL() + ",methodInfo.isStalled() - " + nodeMethodInfo.isStalled() + "");
                                        if (string5 == null) {
                                            nodeUPDManager.autoPatternTable.put(string2, string2);
                                            nodeUPDManager.updateTables4Auto();
                                        }
                                        if (nodeMethodInfo.isErrorURL() || nodeMethodInfo.isSlowURL()) {
                                            this.addToUPD(nodeUPDManager, nodeMethodInfo, bl3, bl4, string6, l, l2, l3);
                                        } else if (nodeMethodInfo.isStalled()) {
                                            this.addStalledURLDetails(nodeUPDManager, nodeMethodInfo, bl3, bl4, string6, l, l2, l3);
                                        } else {
                                            this.updateAllUrlDetails(nodeUPDManager, nodeMethodInfo, bl3, bl4, string6, l, l2, l3);
                                        }
                                        continue;
                                    }
                                }
                            } else {
                                this.sleep(10L);
                            }
                            NodeBTMLogger.nodeLogger.trace(loggerDispStr + "Node worker while loop, methodInfo: " + nodeMethodInfo);
                        }
                        catch (Exception exception) {
                            NodeBTMLogger.nodeLogger.error(loggerDispStr + " Unable to parse Methodinfo object completely... ", (Throwable)exception);
                            bl = true;
                        }
                    }
                    this.sleep(1L);
                }
                this.sleep(1000L);
            }
            catch (Exception exception) {
                this.log.error("Error while getting btm data in apmnodeworker", (Throwable)exception);
                NodeBTMLogger.nodeLogger.warn(loggerDispStr + "Exception occured in the worker thread", (Throwable)exception);
                break;
            }
            this.sleep(100L);
        } while (this.runThis);
        NodeBTMLogger.nodeLogger.warn(loggerDispStr + " Worker exiting - runThis : {}", (Object)this.runThis);
    }

    public static Hashtable getTempComponentIDTable() {
        return tempComponentIDTable;
    }

    public static boolean IsThisAvailableInTempComponentIDTable(String string) {
        return tempComponentIDTable.containsKey(string);
    }

    public static String getValueFromTempComponentIDTable(String string) {
        return (String)tempComponentIDTable.get(string);
    }

    public static void removeThisFromTempComponentIDTable(String string) {
        tempComponentIDTable.remove(string);
    }

    public static void addNewEntryToTempComponentIDTable(String string, String string2) {
        tempComponentIDTable.put(string, string2);
    }

    public static Hashtable<String, NodeUPDManager> getUPDmanagerTable() {
        return UPDmanagerTable;
    }

    public static void setUPDmanagerTable(Hashtable<String, NodeUPDManager> hashtable) {
        UPDmanagerTable = hashtable;
    }

    public static boolean IsThisAvailableInUPDmanagerTable(String string) {
        return UPDmanagerTable.containsKey(string);
    }

    public static NodeUPDManager getValueFromUPDmanagerTable(String string) {
        return UPDmanagerTable.get(string);
    }

    public static void removeThisFromUPDmanagerTable(String string) {
        UPDmanagerTable.remove(string);
    }

    public static void addNewEntryToUPDmanagerTable(String string, NodeUPDManager nodeUPDManager) {
        UPDmanagerTable.put(string, nodeUPDManager);
    }

    public static Hashtable<String, BTMDiscovery> getDataBaseHT() {
        return DataBaseHT;
    }

    public static void setDataBaseHT(Hashtable<String, BTMDiscovery> hashtable) {
        DataBaseHT = hashtable;
    }

    public static boolean IsThisAvailableInDataBaseHT(String string) {
        return DataBaseHT.containsKey(string);
    }

    public static BTMDiscovery getValueFromDataBaseHT(String string) {
        return DataBaseHT.get(string);
    }

    public static void removeThisFromDataBaseHT(String string) {
        DataBaseHT.remove(string);
    }

    public static void addNewEntryToDataBaseHT(String string, BTMDiscovery bTMDiscovery) {
        DataBaseHT.put(string, bTMDiscovery);
    }

    public static Hashtable<String, NodePropsManager> getPropsManagerTable() {
        return PropsManagerTable;
    }

    public static void setPropsManagerTable(Hashtable<String, NodePropsManager> hashtable) {
        PropsManagerTable = hashtable;
    }

    public static boolean IsThisAvailableInPropsManagerTable(String string) {
        return PropsManagerTable.containsKey(string);
    }

    public static NodePropsManager getValueFromPropsManagerTable(String string) {
        return PropsManagerTable.get(string);
    }

    public static void removeThisFromPropsManagerTable(String string) {
        PropsManagerTable.remove(string);
    }

    public static void addNewEntryToPropsManagerTable(String string, NodePropsManager nodePropsManager) {
        PropsManagerTable.put(string, nodePropsManager);
    }

    public static Hashtable getHeartBeatTable() {
        return heartBeatTable;
    }

    public static void setHeartBeatTable(Hashtable hashtable) {
        heartBeatTable = hashtable;
    }

    public static boolean IsThisAvailableInHeartBeatTable(String string) {
        return heartBeatTable.containsKey(string);
    }

    public static String getValueFromHeartBeatTable(String string) {
        return (String)heartBeatTable.get(string);
    }

    public static void removeThisFromHeartBeatTable(String string) {
        heartBeatTable.remove(string);
    }

    public static void addNewEntryToHeartBeatTable(String string, long l) {
        heartBeatTable.put(string, l);
    }

    public static Hashtable getRepositoryRemoved() {
        return repositoryRemoved;
    }

    public static void setRepositoryRemoved(Hashtable hashtable) {
        repositoryRemoved = hashtable;
    }

    public static boolean IsThisAvailableInRepositoryRemoved(String string) {
        return repositoryRemoved.containsKey(string);
    }

    public static String getValueFromrepositoryRemoved(String string) {
        return (String)repositoryRemoved.get(string);
    }

    public static void removeThisFromRepositoryRemoved(String string) {
        repositoryRemoved.remove(string);
    }

    public static void addNewEntryTosRepositoryRemoved(String string, String string2) {
        repositoryRemoved.put(string, string2);
    }

    private void updateRepositoryTables(String string, Map map) {
        boolean bl;
        Object object;
        if (!PropsManagerTable.containsKey(string)) {
            object = new NodePropsManager();
            ((NodePropsManager)object).initProps();
            ((NodePropsManager)object).applyBTMProps();
            PropsManagerTable.put(string, (NodePropsManager)object);
        }
        if (!UPDmanagerTable.containsKey(string)) {
            object = new NodeUPDManager(PropsManagerTable.get(string));
            ((NodeUPDManager)object).clearStoredData();
            UPDmanagerTable.put(string, (NodeUPDManager)object);
            repositoryRemoved.remove(string);
        }
        boolean bl2 = bl = (object = (String)map.get("DataBaseHT")) != null && ((String)object).equalsIgnoreCase("true");
        if (bl) {
            String[] stringArray;
            Hashtable hashtable;
            String string2;
            String string3;
            BTMDiscovery bTMDiscovery = DataBaseHT.containsKey(string) ? DataBaseHT.get(string) : new BTMDiscovery();
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            String string4 = (String)map.remove("blockedWaitedTimeNotSupported");
            if (string4 != null) {
                hashtable2.put("blockedWaitedTimeNotSupported", string4);
            }
            if ((string3 = (String)map.remove("cpuTimeNotSupported")) != null) {
                hashtable2.put("cpuTimeNotSupported", string3);
            }
            if ((string2 = (String)map.remove("TimeZone")) != null) {
                hashtable2.put("TimeZone", string2);
            }
            if ((hashtable = (Hashtable)map.remove("CustomPC")) != null && hashtable.size() > 0) {
                hashtable2.put("CustomPC", hashtable);
            }
            if ((stringArray = (String[])map.remove("sessionUserMapping")) != null && stringArray.length > 0) {
                String string5 = stringArray[0];
                String string6 = stringArray[1];
                bTMDiscovery.addUserSessionDetails(string5, string6);
            }
            if (hashtable2.size() > 0) {
                bTMDiscovery.getDataBaseHT().putAll(hashtable2);
            }
            NodeBTMLogger.nodeLogger.trace(loggerDispStr + " dataBaseHTtemp :" + hashtable2);
            DataBaseHT.put(string, bTMDiscovery);
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateAllUrlDetails(NodeUPDManager nodeUPDManager, NodeMethodInfo nodeMethodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                NodeBTMLogger.nodeLogger.debug(loggerDispStr + " URL " + nodeMethodInfo.getProperties().get("requestID") + "  " + nodeMethodInfo.getExecutionTime() + " ms & matched patterns " + nodeMethodInfo.getUrlPatternsMatched());
                String string2 = nodeMethodInfo.getUrlPatternsMatched();
                Map map = nodeMethodInfo.getProperties();
                NodeBTMLogger.nodeLogger.debug(loggerDispStr + "updateAllUrlDetails");
                NodeURLPatternData nodeURLPatternData = (NodeURLPatternData)nodeUPDManager.getUPDTblWC(bl2).get(string2);
                if (nodeURLPatternData != null) {
                    nodeURLPatternData.updateAllUrlCount(nodeMethodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (nodeMethodInfo == null) break block3;
                nodeMethodInfo.clearURLTree();
            }
        }
    }

    private void addToUPD(NodeUPDManager nodeUPDManager, NodeMethodInfo nodeMethodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                NodeBTMLogger.nodeLogger.debug(loggerDispStr + " URL " + nodeMethodInfo.getProperties().get("requestID") + "  " + nodeMethodInfo.getExecutionTime() + " ms & matched patterns " + nodeMethodInfo.getUrlPatternsMatched());
                String string2 = nodeMethodInfo.getUrlPatternsMatched();
                NodeURLPatternData nodeURLPatternData = (NodeURLPatternData)nodeUPDManager.getUPDTblWC(bl2).get(string2);
                if (nodeURLPatternData != null) {
                    nodeURLPatternData.addURLInfo(nodeMethodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (nodeMethodInfo == null) break block3;
                nodeMethodInfo.clearURLTree();
            }
        }
    }

    public void addStalledURLDetails(NodeUPDManager nodeUPDManager, NodeMethodInfo nodeMethodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                NodeBTMLogger.nodeLogger.debug(loggerDispStr + "Stalled URL " + nodeMethodInfo.getProperties().get("requestID") + "  " + nodeMethodInfo.getExecutionTime() + " ms & matched patterns " + nodeMethodInfo.getUrlPatternsMatched());
                String string2 = nodeMethodInfo.getUrlPatternsMatched();
                NodeURLPatternData nodeURLPatternData = (NodeURLPatternData)nodeUPDManager.getUPDTblWC(bl2).get(string2);
                if (nodeURLPatternData != null) {
                    nodeURLPatternData.addStalledURLInfo(nodeMethodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (nodeMethodInfo == null) break block3;
                nodeMethodInfo.clearURLTree();
            }
        }
    }

    public static void snapShotTaker() {
        Hashtable<String, NodeUPDManager> hashtable = UPDmanagerTable;
        for (Map.Entry<String, NodeUPDManager> entry : hashtable.entrySet()) {
            NodeBTMLogger.nodeLogger.trace(loggerDispStr + " Doing Snapshot for - " + entry);
            NodeUPDManager nodeUPDManager = entry.getValue();
            nodeUPDManager.updateTransmitCopy4Auto();
            nodeUPDManager.updateTransmitCopy4Manual();
            nodeUPDManager.cleanupDeadPatterns(30000L);
        }
    }

    public static void removeEntriesFromApmDiscoveryIni(String string, String string2, boolean bl, boolean bl2) {
        if (string2 == null) {
            return;
        }
        try {
            IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH, true);
            String string3 = iniFile.getValue("JAVA_SERVER_DETAILS", string2) + "";
            if (bl2) {
                iniFile.deleteValue("JAVA_SERVER_DETAILS", string2);
                iniFile.deleteValue("JAVA_COMPONENT_NAME_MAPPING_GUID", string2);
                iniFile.deleteValue("LAST_HEART_BEAT_CHECK_TIME", string2);
            }
            if (bl) {
                iniFile.setValue("AUTO_DELETED_JAVA_SERVER_DETAILS", string2, string3 + "#~#" + System.currentTimeMillis());
            }
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
            String string4 = (String)tempComponentIDTable.remove(string) + "";
            tempComponentIDTable.remove("*" + string);
            tempComponentIDTable.remove("*" + string2);
            tempComponentIDTable.remove(string2);
            tempComponentIDTable.remove("*" + string4);
            tempComponentIDTable.remove(string4);
            String string5 = (String)tempComponentIDTable.remove("$$" + string) + "";
            tempComponentIDTable.remove("$" + string5);
            NodeBTMLogger.nodeLogger.debug(loggerDispStr + "{} Entries deleted from {} & tempComponentIDTable", (Object)string, (Object)BTMConstants.APM_DISCOVERY_FILEPATH);
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.error(loggerDispStr + "{}, Unable to delete from {} & tempComponentIDTable", (Object)string, (Object)BTMConstants.APM_DISCOVERY_FILEPATH);
        }
    }

    public static void clearOffloadBTMDataRepository(String string, String string2) {
        if (!UPDmanagerTable.containsKey(string)) {
            return;
        }
        UPDmanagerTable.remove(string);
        DataBaseHT.remove(string);
        PropsManagerTable.remove(string);
        NodeBTMLogger.nodeLogger.info(loggerDispStr + " Cleared data repository for {}, due to - {}", (Object)string, (Object)string2);
        NodeBTMLogger.nodeLogger.debug(loggerDispStr + " UPDmanagerTable :{}", UPDmanagerTable);
        NodeBTMLogger.nodeLogger.trace(loggerDispStr + " DataBaseHT :{}", DataBaseHT);
        NodeBTMLogger.nodeLogger.trace(loggerDispStr + " PropsManagerTable :{}", PropsManagerTable);
    }

    static void clearRepository(String string) {
        NodeUPDManager nodeUPDManager;
        if (repositoryRemoved.containsKey(string)) {
            APMNodeWorker.clearOffloadBTMDataRepository(string, " NodeTransTest is disabled. ");
            repositoryRemoved.remove(string);
        }
        NodeBTMLogger.nodeLogger.trace(loggerDispStr + " repositoryRemoved :{}", (Object)repositoryRemoved);
        NodeBTMLogger.nodeLogger.trace(loggerDispStr + " heartBeatTable :{}", (Object)heartBeatTable);
        boolean bl = APMNodeComponentIDRepository.isThisTestEnabled(string, "NodeTransTest");
        boolean bl2 = APMNodeComponentIDRepository.isThisTestEnabled(string, "KNodeTransTest");
        if (!bl && !bl2) {
            APMNodeWorker.clearOffloadBTMDataRepository(string, " [Key]NodeTransTest is disabled. ");
        }
        if (!bl && UPDmanagerTable.containsKey(string) && (nodeUPDManager = UPDmanagerTable.get(string)) != null) {
            nodeUPDManager.clearStoredDataForBusinessTransTest();
            NodeBTMLogger.nodeLogger.trace(loggerDispStr + " Data cleared for {}:{} ", (Object)"NodeTransTest", (Object)string);
        }
        if (!bl2 && UPDmanagerTable.containsKey(string) && (nodeUPDManager = UPDmanagerTable.get(string)) != null) {
            nodeUPDManager.clearStoredDataForKbusinessTransTest();
            NodeBTMLogger.nodeLogger.trace(loggerDispStr + " Data cleared for {}:{} ", (Object)"KNodeTransTest", (Object)string);
        }
    }

    public static Hashtable<String, Integer> getAutoNameHT() {
        return (Hashtable)AutoNameHT.clone();
    }

    public static void clearAutoNameHT() {
        AutoNameHT.clear();
    }

    public static Hashtable<String, String> getComputedNodeOrders() {
        return computedNodeOrders;
    }

    public static void setComputedNodeOrders(Hashtable<String, String> hashtable) {
        computedNodeOrders = hashtable;
    }

    public static void addEntryIntoComputedNodeOrders(String string) {
        computedNodeOrders.put(string, string);
    }

    public static boolean isAvilableInComputedNodeOrders(String string) {
        return computedNodeOrders.containsKey(string);
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
    }

    public static double getRandomDoubleBetweenRange(double d, double d2) {
        double d3 = Math.random() * (d2 - d + 1.0) + d;
        return d3;
    }
}

