/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

class WebLogicHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private int timeOut;
    private PrintWriter pw;
    private BufferedReader br;
    public boolean status;
    public boolean done;
    public boolean isWebLogic = false;

    public WebLogicHelperThread(String string, int n, int n2) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = n2;
        this.setName("WebLogicHelperThread");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        try {
            this.pw = new PrintWriter(this.sd.getOutputStream(), false);
            this.pw.print("GET / HTTP/1.0\r\n\r\n");
            this.pw.flush();
            this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
            String string = null;
            if (this.br != null) {
                String string2 = this.br.readLine();
                while (string2 != null) {
                    if (string2.startsWith("Server:") || string2.indexOf("WebLogic") > 0) {
                        string = string2;
                        break;
                    }
                    string2 = this.br.readLine();
                    if (!EgConfigInfo.todie) continue;
                    this.status = false;
                    this.done = true;
                    this.cleanup();
                    return;
                }
            }
            if (string != null && string.indexOf("WebLogic") >= 0) {
                this.isWebLogic = true;
            }
            this.done = true;
            this.cleanup();
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

