/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class WgClusterStatusTest
extends EgSnmpGenericTest {
    boolean isMasterFirst = false;
    boolean isBackupFirst = false;

    public WgClusterStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = 0.0;
            double d6 = this.getMeasures(".1.3.6.1.4.1.3097.6.6.1");
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (d6 == 1.0) {
                d = this.getMeasures(".1.3.6.1.4.1.3097.6.6.3");
                d2 = this.getMeasures(".1.3.6.1.4.1.3097.6.6.4");
                d3 = this.getMeasures(".1.3.6.1.4.1.3097.6.6.9");
                d4 = this.getMeasures(".1.3.6.1.4.1.3097.6.6.10");
                if (d == 3.0) {
                    if (this.isMasterFirst) {
                        d5 = 1.0;
                        this.isMasterFirst = false;
                    } else {
                        d5 = 0.0;
                        this.isBackupFirst = true;
                    }
                } else if (d == 2.0) {
                    if (this.isBackupFirst) {
                        d5 = d3 == 3.0 ? 1.0 : 1.0;
                        this.isBackupFirst = false;
                    } else {
                        d5 = 0.0;
                        this.isMasterFirst = true;
                    }
                } else {
                    d5 = 0.0;
                }
                if (d2 != 100.0) {
                    d2 = 0.0;
                }
                if (d4 != 100.0) {
                    d4 = 0.0;
                }
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
            } else {
                for (int i = 0; i < 5; ++i) {
                    arrayList.add(new Double(-5.0));
                }
            }
            System.out.println(this.entity + " MeasureList :" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", "WgClusterStatusTest Exception occured in computeMeasures() for" + this.targetHost, exception.toString());
        }
    }

    public double getMeasures(String string) {
        double d = -5.0;
        boolean bl = this.runSnmpCmdForOid(string);
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.rhs[i] == null || this.rhs[i].trim().length() <= 0) continue;
                    String string2 = this.rhs[i].trim();
                    d = Double.parseDouble(string2);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", "WgClusterStatusTest Exception occured in getMeasures() for" + this.targetHost, exception.toString());
        }
        return d;
    }

    public static void main(String[] stringArray) {
        WgClusterStatusTest wgClusterStatusTest = new WgClusterStatusTest(stringArray);
        wgClusterStatusTest.computeMeasures(new Hashtable());
    }
}

