/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class VirtualHostLocationTest_cf
extends GenericTest {
    String configFile = "";
    ApacheParser ap = null;

    public VirtualHostLocationTest_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.configFile = this.getValueForParam("ApacheConfig_File");
        this.ap = new ApacheParser(this.configFile);
        this.setConfigInfoTestFlag(true);
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.ap.getAllVirtualHostLocation();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.meAgentless) {
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostLocation();
        } else if (this.isPerfmon) {
            this.ap = new ApacheParser(this.configFile, "perfmon", this.targetHost);
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostLocation();
        } else if (this.isSSH || this.isRexec) {
            if (this.aluser.equalsIgnoreCase("NONE") || this.alpassword.equalsIgnoreCase("none")) {
                this.errorMsg = "Apache VirtualHost location is configured in Agentless and os/aluser can't be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.configError = true;
                return;
            }
            Object object = "";
            if (this.isSSH) {
                object = "ssh";
            } else if (this.isRexec) {
                object = "rexec";
            }
            this.ap = new ApacheParser(this.configFile, (String)object, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostLocation();
        }
        if (hashtable2 == null && hashtable2.isEmpty()) {
            this.configError = true;
            return;
        }
        for (String string : hashtable2.keySet()) {
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
            Iterator iterator = hashtable3.keySet().iterator();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    Hashtable hashtable4 = (Hashtable)hashtable3.get(string3);
                    Iterator iterator2 = hashtable4.keySet().iterator();
                    String string4 = "-";
                    while (iterator2.hasNext()) {
                        String string5 = (String)iterator2.next();
                        if (string5.startsWith("<")) continue;
                        String string6 = string2.trim() + "~M~" + string3.trim() + "~M~" + string5.trim();
                        ArrayList arrayList2 = (ArrayList)hashtable4.get(string5);
                        arrayList = new ArrayList();
                        if (arrayList2 != null && !arrayList2.isEmpty()) {
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                String string7 = (String)arrayList2.get(i);
                                string4 = i == 0 ? string7 : string4 + "," + string7;
                            }
                        }
                        arrayList.add(string4);
                        this.addNewMeasure(string6, arrayList);
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        VirtualHostLocationTest_cf virtualHostLocationTest_cf = new VirtualHostLocationTest_cf(stringArray);
        virtualHostLocationTest_cf.computeMeasures(new Hashtable());
    }
}

