/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;

public class VGStatusTest
extends GenericTest {
    private static String cmd = "vgdisplay -v";
    private String sudoCmd = "";

    public VGStatusTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("use_sudo");
        String string2 = this.getValueForParam("sudo_path");
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes");
        }
        String string3 = "";
        if (string2 != null && !string2.equalsIgnoreCase("None") && !string2.equalsIgnoreCase("Null")) {
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.lastIndexOf("/"));
            }
            if (string2.endsWith("/sudo")) {
                string2 = string2.substring(0, string2.lastIndexOf("/"));
            }
            string3 = string2 + "/";
        }
        if (bl) {
            this.sudoCmd = "sudo ";
            if (string3 != null && string3.trim().length() > 0) {
                this.sudoCmd = string3 + this.sudoCmd;
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = this.sudoCmd + cmd;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() < 2) {
                return;
            }
            if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
                return;
            }
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.trim().length() == 0 || !(string2 = string2.trim()).toLowerCase().startsWith("vg status")) continue;
                String string3 = string2.substring(10).trim();
                if (string3.equalsIgnoreCase("available")) {
                    arrayList2.add(new Double(1.0));
                    break;
                }
                if (string3.equalsIgnoreCase("available/inactive")) {
                    arrayList2.add(new Double(0.0));
                    break;
                }
                arrayList2.add(new Double(-5.0));
                break;
            }
            this.addNewMeasure(arrayList2);
        }
        catch (Exception exception) {
            System.out.println("[VGStatusTest] Exception occured while calling the computeMeasures method " + exception);
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "VGStatusTest", string);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        VGStatusTest vGStatusTest = new VGStatusTest(stringArray);
        vGStatusTest.computeMeasures(new Hashtable());
    }
}

