/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class TuxJdbcConnTest
extends GenericTest {
    private String tuxDir = "";
    private String appDir = "";
    private String tuxConfig = "";
    private String cmd = "";
    private String exeCmc = "";
    private String debugFlag = "";
    private String sys_OS = "";
    private String[] envp = null;
    private boolean debug = false;

    public TuxJdbcConnTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.tuxDir = this.getValueForParam("tuxdir");
        this.appDir = this.getValueForParam("appdir");
        this.tuxConfig = this.getValueForParam("tuxconfig");
        this.debugFlag = this.getValueForParam("debug");
        this.envp = new String[2];
        if (this.tuxDir == null || this.tuxDir.equalsIgnoreCase("NULL") || this.tuxDir.equalsIgnoreCase("none")) {
            this.tuxDir = "";
        }
        if (this.appDir == null || this.appDir.equalsIgnoreCase("NULL") || this.appDir.equalsIgnoreCase("none")) {
            this.appDir = "";
        }
        if (this.tuxConfig == null || this.tuxConfig.equalsIgnoreCase("NULL") || this.tuxConfig.equalsIgnoreCase("none")) {
            this.tuxConfig = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        this.cmd = "printjdbcconnpool";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.tuxDir.replace('/', '\\');
            this.appDir.replace('/', '\\');
            this.tuxConfig.replace('/', '\\');
            this.exeCmc = EgInstallInfo.getInstallDir() + "\\lib\\tux.bat " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.cmd;
        } else {
            this.tuxDir.replace('\\', '/');
            this.appDir.replace('\\', '/');
            this.tuxConfig.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exeCmc = EgInstallInfo.getInstallDir() + "/bin/tux.sh " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.cmd;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        int n;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        EgUtilities egUtilities = EgUtilities.createInstance();
        arrayList = this.sys_OS.trim().startsWith("WIN") ? egUtilities.getExecOutputLines(this.exeCmc) : egUtilities.getExecOutputLinesForUnix(this.exeCmc, this.envp);
        if (arrayList == null || arrayList.size() == 0) {
            this.logToErrorFile("Error:", "TuxedoJdbcConnTest.computeMeasures", "Tuxedo Jdbc connection details measures not available");
            System.out.println("[TuxedoJdbcConnTest] Error in executing the command ..." + this.exeCmc);
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = (String)arrayList2.get(n);
            ++n2;
            if (string.startsWith("---------")) break;
        }
        try {
            for (n = n2; n < arrayList2.size(); ++n) {
                string = (String)arrayList2.get(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n3 = stringTokenizer.countTokens();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = string3 + ":" + string2;
                double d = Double.valueOf(string5);
                double d2 = Double.valueOf(string7);
                double d3 = (d - d2) / d * 100.0;
                arrayList3.add(new Double(string6));
                arrayList3.add(new Double(string5));
                arrayList3.add(new Double(string7));
                arrayList3.add(new Double(d3));
                if (this.debug) {
                    System.out.println("[TuxedoJdbcConnTest] Info ======>" + string8 + "MeasureList=====>" + arrayList3);
                }
                this.addNewMeasure(string8, arrayList3);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", "TuxedoJdbcConnTest.computeMeasures", exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        TuxJdbcConnTest tuxJdbcConnTest = new TuxJdbcConnTest(stringArray);
        try {
            while (true) {
                tuxJdbcConnTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

