/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TibTableSpceTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private ArrayList tableSpaceNames = new ArrayList();
    private ArrayList prevPhysReads = new ArrayList();
    private ArrayList prevPhysWrites = new ArrayList();
    private String transQuery = null;
    private String autoExtendQuery = null;
    private String tableSpaceQuery = null;
    private String query4 = null;
    private static double bToMb = 1048576.0;
    private static double kbToMb = 1024.0;

    public TibTableSpceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.transQuery = "SELECT TS.NAME,SUM(FS.PHYRDS) AS PHYSICAL_READS,SUM(FS.PHYWRTS) AS PHYSICAL_WRITES FROM V$FILESTAT FS,V$DATAFILE DF,V$TABLESPACE TS,DBA_DATA_FILES DDF  WHERE FS.FILE#=DF.FILE#  AND \tDDF.FILE_ID=DF.FILE# AND DDF.TABLESPACE_NAME=TS.NAME GROUP BY  TS.NAME";
        this.autoExtendQuery = "SELECT TABLESPACE_NAME,MAX(AUTOEXTENSIBLE) AS AUTOEXTENSIBLE  FROM DBA_DATA_FILES GROUP BY TABLESPACE_NAME";
        this.tableSpaceQuery = "SELECT nvl(max_size.tablespace_name,0),nvl(\"SIZE\"/(1024*1024),0) \"SIZE(MB)\",nvl(free_size.biggest,0),nvl(free_size.smallest,0), nvl(max_size.max_extend / (1024 * 1024),0) \"MAX_SIZE(MB)\",nvl(TRUNC ((max_size.max_extend - \"SIZE\" + free)/ seg_max_next.next_extent),-3) \"EXHAUST_AFTER\",decode(free_size.contents,'UNDO',undo_size.undo_used_size_mb,((\"SIZE\"-free_size.free)/1024/1024)) \"USED\" FROM (SELECT B.tablespace_NAME as tablespace_name, nvl(A.FREE,0) as free,nvl(A.BIGGEST,0) as biggest,nvl(A.SMALLEST,0) as smallest,b.contents FROM (SELECT /*+ use_hash (A.ts A.fi) */ tablespace_name,SUM (BYTES) \"FREE\",MAX (BYTES) \"BIGGEST\",MIN (BYTES) \"SMALLEST\" FROM dba_free_space A GROUP BY tablespace_name) A,(SELECT TABLESPACE_NAME,CONTENTS FROM DBA_TABLESPACES ) B WHERE A.TABLESPACE_NAME(+)=B.tablespace_NAME) free_size,(SELECT B.NAME as tablespace_name, nvl(A.\"SIZE\",0) as \"SIZE\" FROM (SELECT tablespace_name,SUM (BYTES) \"SIZE\" FROM dba_data_files GROUP BY tablespace_name) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) phy_size, (SELECT B.NAME as tablespace_name, A.NEXT_EXTENT as next_extent FROM (SELECT tablespace_name, MAX (next_extent) next_extent FROM dba_segments GROUP BY tablespace_name ) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) seg_max_next,(SELECT B.NAME as tablespace_name,a.max_extend FROM (SELECT ts.tablespace_name,SUM (ts_size) max_extend FROM dba_tablespaces ts,(SELECT tablespace_name, autoextensible,GREATEST (maxbytes,BYTES) \"TS_SIZE\" FROM dba_data_files ) df WHERE df.tablespace_name = ts.tablespace_name GROUP BY ts.tablespace_name) A,  (SELECT NAME FROM V$TABLESPACE) B WHERE B.NAME(+)=A.TABLESPACE_NAME) max_size,(SELECT\tts_name,sum(bytes)/1024/1024 undo_used_size_mb \tfrom dba_undo_extents\twhere\tstatus <> 'EXPIRED' group by ts_name ) undo_size WHERE max_size.tablespace_name = seg_max_next.tablespace_name AND max_size.tablespace_name = phy_size.tablespace_name AND max_size.tablespace_name = free_size.tablespace_name and\tmax_size.tablespace_name = undo_size.ts_name(+)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        try {
            double d2;
            double d3;
            double d4;
            double d5;
            String string = "jdbc:tibero:thin:@";
            String string2 = string + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
            System.out.println("URL::" + string2);
            TbDataSource tbDataSource = new TbDataSource();
            tbDataSource.setURL(string2);
            tbDataSource.setUser(this.username);
            tbDataSource.setPassword(this.password);
            System.out.println("Bef Connection");
            try {
                connection = tbDataSource.getConnection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "TibTableSpceTest_ex Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                exception.printStackTrace();
                this.closeConn(connection);
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
            resultSet = statement.executeQuery(this.tableSpaceQuery);
            String string3 = "";
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (resultSet.next()) {
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                string = resultSet.getString(1);
                d5 = resultSet.getDouble(2);
                d4 = resultSet.getDouble(3);
                d4 /= bToMb;
                d3 = resultSet.getDouble(4);
                d3 /= bToMb;
                d2 = resultSet.getDouble(5);
                if (d2 == 0.0) continue;
                double d6 = resultSet.getDouble(6);
                double d7 = resultSet.getDouble(7);
                double d8 = d2 - d7;
                if (d5 > 0.0) {
                    d = d7 / d5 * 100.0;
                }
                if (arrayList != null && !arrayList.contains(string)) {
                    arrayList.add(string);
                }
                double d9 = 0.0;
                if (d8 < 0.0) {
                    d8 = 0.0;
                    d9 = 0.0;
                } else {
                    d9 = d8 * 100.0 / d2;
                }
                arrayList3.add(new Double(d));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(d5));
                arrayList3.add(new Double(d8));
                arrayList3.add(new Double(d9));
                arrayList3.add(new Double(d4));
                arrayList3.add(new Double(d3));
                arrayList3.add(new Double(d6));
                hashtable2.put(string, arrayList3);
            }
            this.closeRs(resultSet);
            resultSet = statement.executeQuery(this.transQuery);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                if (arrayList2 != null && !arrayList2.contains(string)) {
                    arrayList2.add(string);
                }
                double d10 = resultSet.getDouble(2);
                double d11 = resultSet.getDouble(3);
                if (!arrayList.contains(string)) continue;
                int n = this.tableSpaceNames.indexOf(string);
                if (n == -1) {
                    this.tableSpaceNames.add(string);
                    this.prevPhysReads.add(new Double(d10));
                    this.prevPhysWrites.add(new Double(d11));
                    continue;
                }
                if (this.timeSinceLastTest < 0.0) {
                    this.prevPhysReads.set(n, new Double(d10));
                    this.prevPhysWrites.set(n, new Double(d11));
                    continue;
                }
                Double d12 = (Double)this.prevPhysReads.get(n);
                d3 = d12;
                d12 = (Double)this.prevPhysWrites.get(n);
                d2 = d12;
                d5 = (d10 - d3) / this.timeSinceLastTest;
                d5 = d5 < 0.0 ? -5.0 : d5;
                d4 = (d11 - d2) / this.timeSinceLastTest;
                d4 = d4 < 0.0 ? -5.0 : d4;
                ArrayList arrayList4 = (ArrayList)hashtable2.get(string);
                if (arrayList4 != null) {
                    arrayList4.set(1, new Double(d5));
                    arrayList4.set(2, new Double(d4));
                    hashtable2.put(string, arrayList4);
                }
                this.prevPhysReads.set(n, new Double(d10));
                this.prevPhysWrites.set(n, new Double(d11));
            }
            this.closeRs(resultSet);
            resultSet = statement.executeQuery(this.autoExtendQuery);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                ArrayList arrayList5 = (ArrayList)hashtable2.get(string);
                if (arrayList5 == null) continue;
                string3 = resultSet.getString(2);
                boolean bl = false;
                if (string3 != null && string3.equalsIgnoreCase("Yes")) {
                    bl = true;
                }
                arrayList5.set(3, new Double((double)bl));
                hashtable2.put(string, arrayList5);
            }
            arrayList.clear();
            Enumeration enumeration = hashtable2.keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                String string4 = (String)enumeration.nextElement();
                ArrayList arrayList6 = (ArrayList)hashtable2.get(string4);
                if (arrayList6 == null) continue;
                this.addNewMeasure(string4, arrayList6);
            }
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibTableSpceTest tibTableSpceTest = new TibTableSpceTest(stringArray);
        tibTableSpceTest.computeMeasures(new Hashtable());
    }
}

