/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SysMemory {
    public double getMemory() {
        double d = 0.0;
        String string = this.getOsName();
        if (string == null || string.trim().length() == 0) {
            System.out.println("Could n't get the os name of this system");
            return -5.0;
        }
        if ((string = string.toLowerCase()).startsWith("windows")) {
            d = this.getWindowsSystemMemory();
        } else if (string.startsWith("linux")) {
            d = this.getLinuxSystemMemory();
        } else if (string.startsWith("sunos")) {
            d = this.getSolarisSystemMemory();
        } else if (string.startsWith("hp-ux")) {
            d = this.getHpuxSystemMemory();
        } else if (string.startsWith("aix")) {
            d = this.getAixSystemMemory();
        } else {
            System.out.println("Does not support this os '" + string + "'");
            d = -5.0;
        }
        return d;
    }

    private double getWindowsSystemMemory() {
        String string = "cscript.exe " + EgInstallInfo.getInstallDir() + "/bin/findmemory.vbs //NoLogo";
        BufferedReader bufferedReader = this.execute(string);
        double d = -5.0;
        if (bufferedReader == null) {
            return -5.0;
        }
        try {
            StringTokenizer stringTokenizer;
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return -5.0;
            }
            if (string2.toLowerCase().startsWith("ram") && (stringTokenizer = new StringTokenizer(string2, ":")).countTokens() >= 2) {
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                d = Double.parseDouble(string3);
            }
            while (bufferedReader.readLine() != null) {
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return -5.0;
        }
        return d;
    }

    private double getAixSystemMemory() {
        String string = "lsattr -El sys0 -a realmem";
        BufferedReader bufferedReader = this.execute(string);
        double d = -5.0;
        if (bufferedReader == null) {
            return -5.0;
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (!string2.toLowerCase().startsWith("realmem") || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 3) continue;
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                d = Double.parseDouble(string3);
                d /= 1024.0;
                break;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return -5.0;
        }
        return d;
    }

    private double getHpuxSystemMemory() {
        String string = EgInstallInfo.getInstallDir() + "/bin/memstat";
        BufferedReader bufferedReader = this.execute(string);
        double d = -5.0;
        if (bufferedReader == null) {
            return -5.0;
        }
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return -5.0;
            }
            string2 = string2.trim();
            d = Double.parseDouble(string2);
            while (bufferedReader.readLine() != null) {
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return -5.0;
        }
        return d;
    }

    private double getLinuxSystemMemory() {
        double d;
        block3: {
            d = -5.0;
            try {
                BufferedReader bufferedReader = this.getBufferedReader("/proc/meminfo");
                if (bufferedReader == null) break block3;
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (!string.toLowerCase().startsWith("memtotal") || (stringTokenizer = new StringTokenizer(string)).countTokens() < 2) continue;
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    d = Double.parseDouble(string2);
                    d /= 1024.0;
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Error in getLinuxSystemMemory:" + exception);
                return d;
            }
        }
        return d;
    }

    private double getSolarisSystemMemory() {
        String string = "/etc/prtconf";
        BufferedReader bufferedReader = this.execute(string);
        double d = -5.0;
        if (bufferedReader == null) {
            return -5.0;
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (!string2.toLowerCase().startsWith("memory size") || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 3) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                d = Double.parseDouble(string3);
                break;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return -5.0;
        }
        return d;
    }

    public String getOsName() {
        return System.getProperties().getProperty("os.name");
    }

    private BufferedReader execute(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(string);
            if (process == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BufferedReader getBufferedReader(String string) {
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (Exception exception) {
            bufferedReader = null;
        }
        return bufferedReader;
    }

    public static void main(String[] stringArray) {
        SysMemory sysMemory = new SysMemory();
        System.out.println("System Memory=" + sysMemory.getMemory());
    }
}

