/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SybCollectorThread
extends Thread {
    private String host = "";
    private String port = "";
    private String user = "";
    private String pwd = "";
    private long measurePeriod = 0L;
    private String sybInstanceKey = "";
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private String networkStats = "";
    private String lockStats = "";
    private String dataCacheStats = "";
    private String procedureCacheStats = "";
    private String deviceStats = "";
    private String transactionStats = "";
    private String transactionLogStats = "";
    private String tasksStats = "";
    private SybConnection conn = null;
    private boolean stopMe = false;

    public SybCollectorThread() {
    }

    public SybCollectorThread(String string, String string2) {
        this.host = string;
        this.port = string2;
        this.sybInstanceKey = string + ":" + string2;
    }

    public void run() {
        while (!this.stopMe) {
            this.updateTestParams();
            if (this.measurePeriod > 0L) {
                String string = this.getTestFlags();
                long l = this.measurePeriod / 1000L;
                if (!this.createConn()) {
                    System.out.println("SybCollectorThread: Sybase connection creation failed,wait: " + this.measurePeriod);
                    this.waitFor(this.measurePeriod);
                    continue;
                }
                if (this.collectMeasures(l, string)) {
                    this.storeMeasures();
                    this.storeCollectTime();
                    continue;
                }
                System.out.println("Sybase Procedure execution failed, wait" + this.measurePeriod);
                this.waitFor(this.measurePeriod);
                continue;
            }
            this.waitFor(10000L);
        }
        this.closeConn();
    }

    public void stopThread() {
        this.stopMe = true;
    }

    private void waitFor(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean createConn() {
        boolean bl = true;
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = null;
                this.conn = this.getConnection(this.host, this.port, this.user, this.pwd);
                if (this.conn == null || this.conn.isClosed()) {
                    this.conn = null;
                    bl = false;
                } else {
                    if (!this.createTempTable()) {
                        System.out.println("Unable to create temp tables for sybase monitoring.");
                    }
                    this.executeTraceOn();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void updateTestParams() {
        Vector vector = (Vector)EgSybaseTest.params.get(this.sybInstanceKey);
        if (vector == null) {
            return;
        }
        this.user = (String)vector.elementAt(0);
        this.pwd = (String)vector.elementAt(1);
        this.measurePeriod = (Long)vector.elementAt(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeTraceOn() {
        block10: {
            var1_1 = null;
            try {
                block11: {
                    if (this.conn != null) break block11;
                    var4_2 = null;
                    if (var1_1 == null) return;
                    ** GOTO lbl39
                }
                var1_1 = (SybStatement)this.conn.createStatement();
                var2_10 = "dbcc traceon(8399)";
                var1_1.execute(var2_10);
                ** GOTO lbl45
            }
            catch (Exception var2_11) {
                System.out.println("dbcc traceon(8399) execution failed");
                var2_11.printStackTrace();
                var4_4 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (Exception var5_8) {
                        var5_8.printStackTrace();
                    }
                }
                break block10;
            }
            {
                catch (Throwable var3_12) {
                    var4_5 = null;
                    if (var1_1 == null) throw var3_12;
                    ** try [egrp 2[TRYBLOCK] [6 : 74->85)] { 
lbl33:
                    // 1 sources

                    var1_1.close();
                    var1_1 = null;
                    throw var3_12;
lbl36:
                    // 1 sources

                    catch (Exception var5_9) {
                        var5_9.printStackTrace();
                    }
                    throw var3_12;
                }
lbl39:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6 : 74->85)] { 
lbl40:
                // 1 sources

                var1_1.close();
                return;
lbl42:
                // 1 sources

                catch (Exception var5_6) {
                    var5_6.printStackTrace();
                }
                return;
lbl45:
                // 1 sources

                var4_3 = null;
                if (var1_1 == null) break block10;
                ** try [egrp 2[TRYBLOCK] [6 : 74->85)] { 
lbl48:
                // 1 sources

                var1_1.close();
                var1_1 = null;
lbl51:
                // 1 sources

                catch (Exception var5_7) {}
                var5_7.printStackTrace();
            }
        }
        System.out.println("After completion of dbcc traceon(8399)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createTempTable() {
        SybStatement sybStatement;
        boolean bl;
        block12: {
            bl = false;
            sybStatement = null;
            if (this.conn != null) break block12;
            boolean bl2 = false;
            Object var6_6 = null;
            if (sybStatement == null) return bl2;
            try {
                sybStatement.close();
                return bl2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return bl2;
        }
        sybStatement = (SybStatement)this.conn.createStatement();
        String string = "drop table tempdb.dbo.egtempmonitor";
        try {
            sybStatement.executeUpdate(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = "create table tempdb.dbo.egtempmonitor(field_name char(79),group_name char(25),value int)";
        sybStatement.executeUpdate(string);
        bl = true;
        Object var6_7 = null;
        if (sybStatement == null) return bl;
        try {
            sybStatement.close();
            sybStatement = null;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
                Object var6_8 = null;
                if (sybStatement == null) return bl;
                try {
                    sybStatement.close();
                    sybStatement = null;
                    return bl;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (sybStatement == null) throw throwable;
            try {
                sybStatement.close();
                sybStatement = null;
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean collectMeasures(long l, String string) {
        SybStatement sybStatement;
        boolean bl;
        block10: {
            bl = false;
            sybStatement = null;
            if (this.conn != null) break block10;
            boolean bl2 = false;
            Object var11_8 = null;
            if (sybStatement == null) return bl2;
            try {
                sybStatement.close();
                return bl2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return bl2;
        }
        this.conn.setSybMessageHandler(new SybMessageHandler(){

            public SQLException messageHandler(SQLException sQLException) {
                if (sQLException != null) {
                    SybCollectorThread.this.parseMessage(sQLException.getMessage());
                }
                return sQLException;
            }
        });
        sybStatement = (SybStatement)this.conn.createStatement();
        String string2 = EgConfigInfo.egAgentConfigDir + "eg_sybase.ini";
        IniFile iniFile = new IniFile(string2);
        String string3 = iniFile.getValue("EG_SYBASE", "DB_NAME");
        String string4 = "";
        string4 = string3.length() > 0 ? string3 + ".dbo.sp_egmonitor " + l + ",'" + string + "'" : "master.dbo.sp_egmonitor " + l + ",'" + string + "'";
        sybStatement.executeUpdate(string4);
        bl = true;
        Object var11_9 = null;
        if (sybStatement == null) return bl;
        try {
            sybStatement.close();
            sybStatement = null;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
                Object var11_10 = null;
                if (sybStatement == null) return bl;
                try {
                    sybStatement.close();
                    sybStatement = null;
                    return bl;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (sybStatement == null) throw throwable;
            try {
                sybStatement.close();
                sybStatement = null;
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
    }

    private String getTestFlags() {
        String string = "";
        Vector vector = (Vector)EgSybaseTest.enabledTests.get(this.sybInstanceKey);
        if (vector == null) {
            return "";
        }
        string = vector.contains("NetworkTest") ? "1" : "0";
        string = vector.contains("LockTest") ? string + ",1" : string + ",0";
        string = vector.contains("DataCacheTest") ? string + ",1" : string + ",0";
        string = vector.contains("ProcedureCacheTest") ? string + ",1" : string + ",0";
        string = vector.contains("DeviceTest") ? string + ",1" : string + ",0";
        string = vector.contains("TransactionTest") ? string + ",1" : string + ",0";
        string = vector.contains("TransactionLogTest") ? string + ",1" : string + ",0";
        string = vector.contains("TasksTest") ? string + ",1" : string + ",0";
        return string;
    }

    protected void finalize() throws Throwable {
        this.closeConn();
        super.finalize();
    }

    private void closeConn() {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void storeMeasures() {
        Object object;
        if (!EgSybaseTest.measures.containsKey(this.sybInstanceKey)) {
            object = new Vector(8);
            ((Vector)object).add(0, this.getNetworkStats());
            ((Vector)object).add(1, this.getLockStats());
            ((Vector)object).add(2, this.getDataCacheStats());
            ((Vector)object).add(3, this.getProcedureCacheStats());
            ((Vector)object).add(4, this.getDeviceStats());
            ((Vector)object).add(5, this.getTransactionStats());
            ((Vector)object).add(6, this.getTransactionLogStats());
            ((Vector)object).add(7, this.getTasksStats());
            EgSybaseTest.measures.put(this.sybInstanceKey, object);
        } else {
            object = (Vector)EgSybaseTest.measures.get(this.sybInstanceKey);
            if (object == null) {
                return;
            }
            ((Vector)object).set(0, this.getNetworkStats());
            ((Vector)object).set(1, this.getLockStats());
            ((Vector)object).set(2, this.getDataCacheStats());
            ((Vector)object).set(3, this.getProcedureCacheStats());
            ((Vector)object).set(4, this.getDeviceStats());
            ((Vector)object).set(5, this.getTransactionStats());
            ((Vector)object).set(6, this.getTransactionLogStats());
            ((Vector)object).set(7, this.getTasksStats());
        }
        this.networkStats = "";
        object = "";
        this.dataCacheStats = "";
        this.procedureCacheStats = "";
        this.deviceStats = "";
        this.transactionStats = "";
        this.transactionLogStats = "";
        this.tasksStats = "";
    }

    private void storeCollectTime() {
        long l = System.currentTimeMillis();
        EgSybaseTest.lastCollectTime.put(this.sybInstanceKey, new Long(l));
    }

    private void parseMessage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer == null || stringTokenizer.countTokens() != 2) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("network")) {
            this.networkStats = new String(string3);
        } else if (string2.equalsIgnoreCase("lock")) {
            this.lockStats = new String(string3);
        } else if (string2.equalsIgnoreCase("data_cache")) {
            this.dataCacheStats = this.dataCacheStats.length() == 0 ? new String(string3) : this.dataCacheStats + "|" + new String(string3);
        } else if (string2.equalsIgnoreCase("procedure_cache")) {
            this.procedureCacheStats = new String(string3);
        } else if (string2.equalsIgnoreCase("device")) {
            this.deviceStats = this.deviceStats.length() == 0 ? new String(string3) : this.deviceStats + "|" + new String(string3);
        } else if (string2.equalsIgnoreCase("transaction")) {
            this.transactionStats = new String(string3);
        } else if (string2.equalsIgnoreCase("transaction_log")) {
            this.transactionLogStats = new String(string3);
        } else if (string2.equalsIgnoreCase("tasks")) {
            this.tasksStats = new String(string3);
        }
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        try {
            Class.forName(this.driver);
            String string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", "iso_1");
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string5, properties);
            return sybConnection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private ArrayList getNetworkStats() {
        return this.getMeasures(this.networkStats);
    }

    private ArrayList getLockStats() {
        return this.getMeasures(this.lockStats);
    }

    private Hashtable getDataCacheStats() {
        return this.getInfoMeasures(this.dataCacheStats);
    }

    private ArrayList getProcedureCacheStats() {
        return this.getMeasures(this.procedureCacheStats);
    }

    private Hashtable getDeviceStats() {
        return this.getInfoMeasures(this.deviceStats);
    }

    private ArrayList getTransactionStats() {
        return this.getMeasures(this.transactionStats);
    }

    private ArrayList getTransactionLogStats() {
        return this.getMeasures(this.transactionLogStats);
    }

    private ArrayList getTasksStats() {
        return this.getMeasures(this.tasksStats);
    }

    private ArrayList getMeasures(String string) {
        ArrayList<Double> arrayList = null;
        ArrayList arrayList2 = EgSybaseTest.getTokens(string, ",");
        int n = 0;
        if (arrayList2 == null || (n = arrayList2.size()) == 0) {
            return new ArrayList();
        }
        arrayList = new ArrayList<Double>(n);
        String string2 = "";
        double d = -1.0;
        for (int i = 0; i < n; ++i) {
            string2 = (String)arrayList2.get(i);
            d = -1.0;
            try {
                if (string2.trim().length() > 0) {
                    d = Double.parseDouble(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            arrayList.add(new Double(d));
        }
        return arrayList;
    }

    private Hashtable getInfoMeasures(String string) {
        Hashtable<String, ArrayList> hashtable = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer == null) {
            return null;
        }
        int n = stringTokenizer.countTokens();
        hashtable = new Hashtable<String, ArrayList>(n);
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken();
            String string3 = "";
            String string4 = "";
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
            if (stringTokenizer2 == null) continue;
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (string3 == null || string3.trim().length() <= 0) continue;
            hashtable.put(string3, this.getMeasures(string4));
        }
        return hashtable;
    }

    private String getSampleInterval(long l) {
        long l2;
        String string = "";
        if (l < 60L) {
            string = "00:00:" + this.getFormattedValue(l);
            return string;
        }
        if (l < 3600L) {
            long l3 = l % 60L;
            string = l3 == 0L ? "00:" + this.getFormattedValue(l / 60L) + ":00" : "00:" + this.getFormattedValue((l - l3) / 60L) + ":" + this.getFormattedValue(l3);
            return string;
        }
        long l4 = l % 3600L;
        string = l4 == 0L ? this.getFormattedValue(l / 3600L) + ":00:00" : ((l2 = l4 % 60L) == 0L ? this.getFormattedValue((l - l4) / 3600L) + ":" + this.getFormattedValue(l4 / 60L) + ":00" : this.getFormattedValue((l - l4) / 3600L) + ":" + this.getFormattedValue((l4 - l2) / 60L) + ":" + this.getFormattedValue(l2));
        return string;
    }

    private String getFormattedValue(long l) {
        return l < 9L ? "0" + l : String.valueOf(l);
    }

    public static void main(String[] stringArray) {
        SybCollectorThread sybCollectorThread = new SybCollectorThread("192.168.10.235", "5002");
        sybCollectorThread.run();
    }
}

