/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SmPolicyServerTest
extends EgSnmpGenericTest {
    private static String name = ".1.3.6.1.4.1.2552.200.300.1.3.1.9";
    private static String agentConn = ".1.3.6.1.4.1.2552.200.300.1.3.1.18";
    private static String acceptAuth = ".1.3.6.1.4.1.2552.200.300.1.3.1.19";
    private static String rejectAuth = ".1.3.6.1.4.1.2552.200.300.1.3.1.20";
    private static String acceptAz = ".1.3.6.1.4.1.2552.200.300.1.3.1.21";
    private static String rejectAz = ".1.3.6.1.4.1.2552.200.300.1.3.1.22";
    private static int numMeasures = 7;
    private int rediscCount = -1;
    private static int maxRediscPeriod = 4;
    private Hashtable idToNameMap = new Hashtable();
    private Hashtable htAgentConn = null;
    private Hashtable htAcceptAuth = null;
    private Hashtable htRejectAuth = null;
    private Hashtable htAcceptAz = null;
    private Hashtable htRejectAz = null;
    private Hashtable prevAcceptAuth = null;
    private Hashtable prevRejectAuth = null;
    private Hashtable prevAcceptAz = null;
    private Hashtable prevRejectAz = null;
    ArrayList idNames = new ArrayList();

    public SmPolicyServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private void initPrev() {
        this.prevAcceptAuth = new Hashtable();
        this.prevRejectAuth = new Hashtable();
        this.prevAcceptAz = new Hashtable();
        this.prevRejectAz = new Hashtable();
    }

    private void discIds() {
        int n;
        ++this.rediscCount;
        if (this.rediscCount >= maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(name);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.idToNameMap = new Hashtable();
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.lhs.length; ++n) {
            this.idToNameMap.put(this.lhs[n], this.rhs[n]);
            arrayList.add(this.rhs[n]);
        }
        if (arrayList.size() != this.idNames.size()) {
            bl2 = true;
        } else {
            String string;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.idNames.contains(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (n = 0; n < this.idNames.size(); ++n) {
                    string = (String)this.idNames.get(n);
                    if (arrayList.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.initPrev();
        }
        this.idNames = arrayList;
    }

    private void emptyAll() {
        this.htAgentConn = new Hashtable();
        this.htAcceptAuth = new Hashtable();
        this.htRejectAuth = new Hashtable();
        this.htAcceptAz = new Hashtable();
        this.htRejectAz = new Hashtable();
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d;
        double d2;
        double d3;
        int n;
        this.htAgentConn = new Hashtable();
        this.htAcceptAuth = new Hashtable();
        this.htRejectAuth = new Hashtable();
        this.htAcceptAz = new Hashtable();
        this.htRejectAz = new Hashtable();
        this.discIds();
        if (this.idNames == null || this.idNames.size() == 0) {
            return;
        }
        if (this.runSnmpCmdForOid(agentConn) && this.lhs != null && this.lhs.length > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.htAgentConn.put(this.lhs[n], new Double(this.getValue(this.rhs[n])));
            }
        }
        if (this.runSnmpCmdForOid(acceptAuth)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevAcceptAuth.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevAcceptAuth.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d4 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevAcceptAuth.put(this.lhs[n], new Double(d3));
                    }
                    this.htAcceptAuth.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.htAcceptAuth = new Hashtable();
        }
        if (this.runSnmpCmdForOid(rejectAuth)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevRejectAuth.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevRejectAuth.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d5 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevRejectAuth.put(this.lhs[n], new Double(d3));
                    }
                    this.htRejectAuth.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.htRejectAuth = new Hashtable();
        }
        if (this.runSnmpCmdForOid(acceptAz)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevAcceptAz.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevAcceptAz.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d6 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevAcceptAz.put(this.lhs[n], new Double(d3));
                    }
                    this.htAcceptAz.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.htAcceptAz = new Hashtable();
        }
        if (this.runSnmpCmdForOid(rejectAz)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevRejectAz.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevRejectAz.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d7 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevRejectAz.put(this.lhs[n], new Double(d3));
                    }
                    this.htRejectAz.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.htRejectAz = new Hashtable();
        }
        Enumeration enumeration = this.idToNameMap.keys();
        Double d8 = null;
        Double d9 = null;
        Double d10 = null;
        Double d11 = null;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.idToNameMap.get(string);
            if (string2 == null) {
                this.rediscCount = -1;
                continue;
            }
            double d12 = -5.0;
            d8 = (Double)this.htAcceptAuth.get(string);
            if (d8 != null) {
                d12 = d8;
            }
            double d13 = -1.0;
            d9 = (Double)this.htRejectAuth.get(string);
            if (d9 != null) {
                d13 = d9;
            }
            double d14 = -5.0;
            d10 = (Double)this.htAcceptAz.get(string);
            if (d10 != null) {
                d14 = d10;
            }
            double d15 = -5.0;
            d11 = (Double)this.htRejectAz.get(string);
            if (d11 != null) {
                d15 = d11;
            }
            double d16 = d12 / (d12 + d13) * 100.0;
            double d17 = d14 / (d14 + d15) * 100.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add((Double)this.htAgentConn.get(string));
            arrayList.add(new Double(d12));
            arrayList.add(new Double(d13));
            arrayList.add(new Double(d16));
            arrayList.add(new Double(d14));
            arrayList.add(new Double(d15));
            arrayList.add(new Double(d17));
            this.addNewMeasure(string2, arrayList);
        }
        this.emptyAll();
    }
}

