/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class RunNetstat
extends GenericTest {
    protected static ArrayList al_local = null;
    protected static ArrayList al_remote = null;
    protected static ArrayList al_sendQ = null;
    protected static ArrayList al_receiveQ = null;
    protected static ArrayList al_state_local = null;
    public static ArrayList al_localIps = null;
    public static ArrayList al_localPorts = null;
    public static ArrayList al_remoteIps = null;
    public static ArrayList al_remotePorts = null;
    public String str_os = System.getProperty("os.name").toLowerCase();
    private String str_cmd = null;
    private static long lastUpdateTime = 0L;
    private static long maxUpdatePeriod = EgMainAgent.netstatCacheTime;
    protected boolean isWindows = false;
    protected boolean isLinux = false;
    protected boolean isSun = false;
    protected boolean isAixHp = false;
    private static String syncString = "RunNetstat";
    protected EgUtilities egutil = null;

    public RunNetstat(String[] stringArray) {
        super(stringArray);
        if (this.str_os.indexOf("win") != -1) {
            this.str_cmd = "netstat -an -p tcp";
            this.isWindows = true;
        } else if (this.str_os.indexOf("lin") != -1) {
            this.str_cmd = "netstat -tan";
            this.isLinux = true;
        } else if (this.str_os.indexOf("sunos") != -1) {
            this.str_cmd = "netstat -an -P tcp";
            this.isSun = true;
        } else if (this.str_os.indexOf("hp-ux") != -1 || this.str_os.indexOf("aix") != -1) {
            this.str_cmd = "netstat -an";
            this.isAixHp = true;
        }
        maxUpdatePeriod = 30L;
        this.egutil = EgUtilities.createInstance();
    }

    public static void main(String[] stringArray) {
        RunNetstat runNetstat = new RunNetstat(stringArray);
        runNetstat.runNetstat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runNetstat() {
        ArrayList arrayList = null;
        long l = System.currentTimeMillis();
        if (l - lastUpdateTime >= maxUpdatePeriod) {
            String string = syncString;
            synchronized (string) {
                if (l - lastUpdateTime >= maxUpdatePeriod) {
                    maxUpdatePeriod = EgMainAgent.netstatCacheTime;
                    lastUpdateTime = System.currentTimeMillis();
                    StringTokenizer stringTokenizer = null;
                    try {
                        Object object;
                        if (!EgMainAgent.isNetStatExistsOnLinux && this.isLinux && (object = this.getAllConnectionList()) != null && ((ArrayList)object).size() > 0) {
                            this.parseConnDetails((ArrayList)object);
                            return;
                        }
                        arrayList = this.egutil.getExecOutputLines(this.str_cmd);
                        if (arrayList == null || arrayList.size() < 2) {
                            return;
                        }
                        object = null;
                        al_local = new ArrayList();
                        al_remote = new ArrayList();
                        al_state_local = new ArrayList();
                        al_sendQ = new ArrayList();
                        al_receiveQ = new ArrayList();
                        Object var7_7 = null;
                        boolean bl = false;
                        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                        if (arrayList2 == null || arrayList2.size() == 0) {
                            return;
                        }
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            String string2;
                            String string3;
                            String string4;
                            object = (String)arrayList2.get(i);
                            if (((String)object).indexOf("------") != -1) continue;
                            stringTokenizer = new StringTokenizer((String)object, " ");
                            if (this.isWindows) {
                                if (stringTokenizer.countTokens() != 4) continue;
                                stringTokenizer.nextToken();
                                al_receiveQ.add("0");
                                al_sendQ.add("0");
                                al_local.add(stringTokenizer.nextToken());
                                al_remote.add(stringTokenizer.nextToken());
                                al_state_local.add(stringTokenizer.nextToken());
                                continue;
                            }
                            if (this.isLinux) {
                                string4 = null;
                                if (stringTokenizer.countTokens() != 6 || (string4 = stringTokenizer.nextToken()).equalsIgnoreCase("Active")) continue;
                                al_receiveQ.add(stringTokenizer.nextToken());
                                al_sendQ.add(stringTokenizer.nextToken());
                                string3 = stringTokenizer.nextToken();
                                if (string3.startsWith("::ffff:")) {
                                    string3 = string3.substring(string3.indexOf("::ffff:") + 7);
                                }
                                al_local.add(string3);
                                string2 = stringTokenizer.nextToken();
                                if (string2.startsWith("::ffff:")) {
                                    string2 = string2.substring(string2.indexOf("::ffff:") + 7);
                                }
                                al_remote.add(string2);
                                al_state_local.add(stringTokenizer.nextToken());
                                continue;
                            }
                            if (this.isSun) {
                                if (stringTokenizer.countTokens() != 7) continue;
                                string4 = stringTokenizer.nextToken();
                                if (string4.startsWith("::ffff:")) {
                                    string4 = string4.substring(string4.indexOf("::ffff:") + 7);
                                }
                                al_local.add(string4);
                                string3 = stringTokenizer.nextToken();
                                if (string3.startsWith("::ffff:")) {
                                    string3 = string3.substring(string3.indexOf("::ffff:") + 7);
                                }
                                al_remote.add(string3);
                                stringTokenizer.nextToken();
                                al_sendQ.add(stringTokenizer.nextToken());
                                stringTokenizer.nextToken();
                                al_receiveQ.add(stringTokenizer.nextToken());
                                al_state_local.add(stringTokenizer.nextToken());
                                continue;
                            }
                            if (!this.isAixHp) continue;
                            string4 = null;
                            if (stringTokenizer.countTokens() != 6 || (string4 = stringTokenizer.nextToken()).equalsIgnoreCase("Active") || string4.indexOf("tcp") == -1) continue;
                            al_receiveQ.add(stringTokenizer.nextToken());
                            al_sendQ.add(stringTokenizer.nextToken());
                            string3 = stringTokenizer.nextToken();
                            if (string3.startsWith("::ffff:")) {
                                string3 = string3.substring(string3.indexOf("::ffff:") + 7);
                            }
                            al_local.add(string3);
                            string2 = stringTokenizer.nextToken();
                            if (string2.startsWith("::ffff:")) {
                                string2 = string2.substring(string2.indexOf("::ffff:") + 7);
                            }
                            al_remote.add(string2);
                            al_state_local.add(stringTokenizer.nextToken());
                        }
                        this.getLocalIpPorts();
                        this.getRemoteIpPorts();
                    }
                    catch (Exception exception) {
                        System.out.println("runNetstat : Caught here : " + exception);
                        exception.printStackTrace();
                        return;
                    }
                }
            }
        }
    }

    public ArrayList getAllConnectionList() {
        ArrayList arrayList = new ArrayList();
        try {
            ArrayList arrayList2;
            String string = "cat /proc/net/tcp";
            String string2 = "cat /proc/net/udp";
            ArrayList arrayList3 = this.egutil.getExecOutputLines(string);
            if (arrayList3 != null && arrayList3.size() >= 2) {
                arrayList = (ArrayList)arrayList3.get(0);
            }
            if ((arrayList3 = this.egutil.getExecOutputLines(string2)) != null && arrayList3.size() >= 2 && (arrayList2 = (ArrayList)arrayList3.get(0)) != null && arrayList2.size() > 0) {
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)arrayList2.get(i);
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return arrayList;
        }
    }

    public void parseConnDetails(ArrayList arrayList) {
        try {
            al_local = new ArrayList();
            al_remote = new ArrayList();
            al_state_local = new ArrayList();
            al_sendQ = new ArrayList();
            al_receiveQ = new ArrayList();
            al_localIps = new ArrayList();
            al_localPorts = new ArrayList();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer;
                int n2;
                String string = (String)arrayList.get(i);
                if (string == null || string.trim().length() == 0 || string.indexOf("local_address") >= 0 || string.indexOf("rem_address") >= 0 || (n2 = (stringTokenizer = new StringTokenizer(string)).countTokens()) < 17) continue;
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                int n3 = string2.indexOf(":");
                String string4 = string2.substring(0, n3);
                String string5 = string2.substring(n3 + 1);
                String string6 = this.getPortInDec(string5);
                String string7 = this.getIpAddressToDecForm(string4);
                String string8 = string7 + ":" + string6;
                n3 = string3.indexOf(":");
                String string9 = string3.substring(0, n3);
                String string10 = string3.substring(n3 + 1);
                String string11 = this.getIpAddressToDecForm(string9);
                String string12 = this.getPortInDec(string10);
                String string13 = stringTokenizer.nextToken();
                String string14 = this.getStatus(string13);
                String string15 = stringTokenizer.nextToken();
                n3 = string15.indexOf(":");
                String string16 = string15.substring(0, n3);
                String string17 = string15.substring(n3 + 1);
                al_receiveQ.add(string17);
                al_sendQ.add(string16);
                al_remote.add(string11);
                al_state_local.add(string14);
                al_local.add(string8);
                al_localIps.add(string7);
                al_localPorts.add(string6);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getStatus(String string) {
        String string2 = "-";
        try {
            if (string == null || string.trim().length() <= 0) {
                return string2;
            }
            if ((string = string.trim()).equalsIgnoreCase("01")) {
                string2 = "ESTABLISHED";
            } else if (string.equalsIgnoreCase("02")) {
                string2 = "SYN_SENT";
            } else if (string.equalsIgnoreCase("03")) {
                string2 = "SYN_RECEIVED";
            } else if (string.equalsIgnoreCase("04")) {
                string2 = "FIN_WAIT1";
            } else if (string.equalsIgnoreCase("05")) {
                string2 = "FIN_WAIT2";
            } else if (string.equalsIgnoreCase("06")) {
                string2 = "TIME_WAIT";
            } else if (string.equalsIgnoreCase("08")) {
                string2 = "CLOSE_WAIT";
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
    }

    private String getIpAddressToDecForm(String string) {
        try {
            long l = Long.parseLong(string, 16);
            long l2 = l >>> 24 | l << 24 | l << 8 & 0xFF0000L | l >> 8 & 0xFF00L;
            return (l2 >> 24 & 0xFFL) + "." + (l2 >> 16 & 0xFFL) + "." + (l2 >> 8 & 0xFFL) + "." + (l2 & 0xFFL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "0.0.0.0";
        }
    }

    private String getPortInDec(String string) {
        String string2 = "0";
        try {
            int n = Integer.parseInt(string, 16);
            string2 = String.valueOf(n);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
    }

    public void getLocalIpPorts() {
        block4: {
            block3: {
                String string = "";
                al_localIps = new ArrayList();
                al_localPorts = new ArrayList();
                if (!this.isWindows && !this.isLinux) break block3;
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < al_local.size(); ++i) {
                    string = (String)al_local.get(i);
                    stringTokenizer = new StringTokenizer(string, ":");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    if (arrayList.size() < 2) continue;
                    String string2 = (String)arrayList.get(arrayList.size() - 2);
                    String string3 = (String)arrayList.get(arrayList.size() - 1);
                    al_localIps.add(string2);
                    al_localPorts.add(string3);
                }
                break block4;
            }
            if (!this.isSun && !this.isAixHp) break block4;
            String string = null;
            String string4 = null;
            String string5 = null;
            int n = 0;
            for (int i = 0; i < al_local.size(); ++i) {
                string = (String)al_local.get(i);
                n = string.lastIndexOf(".");
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
                al_localIps.add(string4);
                al_localPorts.add(string5);
            }
        }
    }

    public void getRemoteIpPorts() {
        block3: {
            block2: {
                al_remoteIps = new ArrayList();
                al_remotePorts = new ArrayList();
                if (!this.isWindows && !this.isLinux) break block2;
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < al_remote.size(); ++i) {
                    String string = (String)al_remote.get(i);
                    stringTokenizer = new StringTokenizer(string, ":");
                    ArrayList arrayList = EgUtils.egTokenizer(string, ":");
                    if (arrayList.size() < 2) continue;
                    String string2 = (String)arrayList.get(arrayList.size() - 2);
                    String string3 = (String)arrayList.get(arrayList.size() - 1);
                    al_remoteIps.add(string2);
                    al_remotePorts.add(string3);
                }
                break block3;
            }
            if (!this.isSun && !this.isAixHp) break block3;
            String string = null;
            String string4 = null;
            String string5 = null;
            int n = 0;
            for (int i = 0; i < al_remote.size(); ++i) {
                string = (String)al_remote.get(i);
                n = string.lastIndexOf(".");
                if (n == -1) continue;
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
                al_remoteIps.add(string4);
                al_remotePorts.add(string5);
            }
        }
    }
}

