/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import redis.clients.jedis.Jedis;

public class RedisSlowLogTest
extends RedisBase {
    public static int previousSlowLogID = 0;
    public static final int firstLine = 1;
    int slowLogEntriesCount = 0;
    Jedis jedis = this.getConnection();

    public RedisSlowLogTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisSlowLogTest ...");
            this.setMeasureCount(this.measureCount);
            logger.info(this.logPrefix + " RedisSlowLogTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisSlowLogTest", (Throwable)exception);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            this.getRedisSlowLog();
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + "Exception occured inside [computeMeasures]" + exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public int getRedisSlowLogCount() {
        List list = this.jedis.slowlogGet(1L);
        int n = 0;
        if (list.size() > 0) {
            String string = list.get(0).toString().trim();
            String string2 = string.substring(0, string.indexOf(","));
            n = Integer.parseInt(string2);
            this.slowLogEntriesCount = n - previousSlowLogID;
        }
        logger.info(this.logPrefix + "New slowlog ID : " + n + ",Previous slowlog ID : " + previousSlowLogID + " Difference is : " + this.slowLogEntriesCount);
        previousSlowLogID = n;
        return this.slowLogEntriesCount;
    }

    public Set getUniqueSlowLogCmdsList() {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            if (this.slowLogEntriesCount > 0) {
                List list = this.jedis.slowlogGet((long)this.slowLogEntriesCount);
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString().trim();
                    if ((string = string.substring(string.indexOf("[") + 1, string.indexOf("]"))).contains(",")) {
                        string = string.substring(0, string.indexOf(","));
                    }
                    treeSet.add(string);
                }
                logger.info(this.logPrefix + " [getUniqueSlowLogCmdsList] Unique commands List = " + treeSet);
            }
        }
        catch (Exception exception) {
            logger.error("Error", (Object)"Exception while getting cmdList [RedisSlowLogTest][getUniqueSlowLogCmdsList]");
        }
        return treeSet;
    }

    public double getMaxLength() {
        List list = this.jedis.configGet("slowlog-max-len");
        double d = -5.0;
        String string = (String)list.get(1);
        if (string != null) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error(this.logPrefix + " Exception occurred in getRedisSlowLog", (Throwable)numberFormatException);
            }
        }
        logger.debug(this.logPrefix + "[getMaxLength] Slowlog maximum length : " + list);
        return d;
    }

    public String getSlowLogTreshold() {
        List list = this.jedis.configGet("slowlog-log-slower-than");
        String string = "";
        if (list.size() > 0) {
            string = (String)list.get(1);
        }
        logger.debug(this.logPrefix + " Slowlog threshold(Microseconds) : " + string);
        return string;
    }

    public void getRedisSlowLog() {
        int n = -5;
        int n2 = -5;
        int n3 = 0;
        this.slowLogEntriesCount = this.getRedisSlowLogCount();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Set set = this.getUniqueSlowLogCmdsList();
        double d = this.getMaxLength();
        String string = this.getSlowLogTreshold();
        int n4 = -5;
        try {
            List list = this.jedis.slowlogGet((long)this.slowLogEntriesCount);
            if (this.slowLogEntriesCount > 0) {
                logger.debug(this.logPrefix + " Result for REDIS Command [Slowlog get] : " + list);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int n5;
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    int n6 = 0;
                    int n7 = 0;
                    String string2 = iterator.next().toString();
                    int n8 = 0;
                    for (n5 = 0; n5 < list.size(); ++n5) {
                        String string3 = list.get(n5).toString().trim();
                        String[] stringArray = string3.split(",");
                        int n9 = Integer.parseInt(stringArray[2]);
                        n8 += n9;
                        if (!string3.contains(string2)) continue;
                        n7 += n9;
                        n4 = n8;
                        ++n6;
                    }
                    n3 += n6;
                    n = n6;
                    n5 = 0;
                    if (n <= 0) continue;
                    n2 = n5 = n7 / n;
                    arrayList2.add(new Double(n));
                    arrayList2.add(new Double(n2));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    logger.info(this.logPrefix + "[getRedisSlowLog] " + string2 + ",The ArrayList  measure contains = " + arrayList2);
                    this.addNewMeasure(string2, arrayList2);
                }
            } else {
                logger.debug(this.logPrefix + "[getRedisSlowLog] No slowlog commands... ");
                this.addNewMeasure(this.finalMeasures(this.measureCount));
            }
            int n10 = 0;
            if (n3 > 0) {
                n10 = n4 / n3;
            }
            arrayList.add(new Double(n3));
            arrayList.add(new Double(n10));
            arrayList.add(new Double(d));
            string = !string.isEmpty() ? string : "0";
            arrayList.add(new Double(string));
            logger.info(this.logPrefix + "[getRedisSlowLog] Summary,The ArrayList  measure contains = " + arrayList);
            this.addNewMeasure("Summary", arrayList);
            this.closeConnection(this.jedis);
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occurred in getRedisMeasure", (Throwable)exception);
        }
    }

    public Hashtable getRedisSlowLogDd() {
        Hashtable hashtable = new Hashtable();
        ArrayList<String> arrayList = null;
        String string = null;
        try {
            List list = this.jedis.slowlogGet((long)this.slowLogEntriesCount);
            Set set = this.getUniqueSlowLogCmdsList();
            if (this.slowLogEntriesCount > 0) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    arrayList = new ArrayList<String>();
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = list.get(i).toString().trim();
                        if (!string2.contains(string)) continue;
                        arrayList.add(string2);
                    }
                    if (arrayList == null) continue;
                    hashtable.put(string, arrayList);
                }
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in getRedisSlowLogDd", (Throwable)exception);
        }
        this.closeConnection(this.jedis);
        logger.info(this.logPrefix + " [getRedisSlowLogDd] [getRedisSlowLogDd] cmdsTest = " + hashtable);
        return hashtable;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisSlowLogTest redisSlowLogTest = new RedisSlowLogTest(stringArray);
        redisSlowLogTest.computeMeasures(new Hashtable());
        while (true) {
            redisSlowLogTest.computeMeasures(new Hashtable());
            Thread.sleep(100000L);
        }
    }
}

