/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class RedisCmdStatsTest
extends RedisBase {
    private static final String REDIS_CMDSTATS_COMMAND = "Commandstats";
    private static final String indexSubject = "REDIS_COMMANDSTAT_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_COMMANDSTAT_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private Hashtable previousMeasureTable = new Hashtable();
    private static String discriptorName = "";
    boolean isDiscriptorName = false;
    private static String previousDiscriptorName = "";
    private static Date modifiedDate;
    private static final boolean isInfoBased = true;
    private static String iniFilePath;
    private boolean firstTime = false;
    private static double previousUpTime;

    public RedisCmdStatsTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisCmdStatsTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisCmdStatsTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisCmdStatsTest", (Throwable)exception);
        }
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_CMDSTATS_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Command Stats Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, true);
                this.getRedisMeasureForCommandStats(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureForCommandStats(Hashtable hashtable) {
        block23: {
            if (hashtable == null || hashtable.size() == 0) {
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats]  metricObject is null or empty ,thus returning null");
                return;
            }
            try {
                long l = this.getModifiedTime();
                if (l - this.lastModifiedTime > 0L) {
                    modifiedDate = new Date(l);
                    this.updateINIFileObject();
                    measureIndexTable = this.getIndexTable(indexSubject);
                    measureNameTable = this.getNameTable(nameSubject);
                    redisNameList = this.getNameList(nameSubject);
                    this.lastModifiedTime = l;
                }
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] metricObject :" + hashtable);
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] measureIndexTable :" + measureIndexTable);
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] measureNameTable  :" + measureNameTable);
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] redisNameList     :" + redisNameList);
                if (this.firstTime) {
                    this.firstTime = false;
                    logger.info(this.logPrefix + " [getRedisMeasureForCommandStats] The test is running for the first time");
                    if (hashtable == null || hashtable.size() <= 0) break block23;
                    Hashtable hashtable2 = (Hashtable)hashtable.get(REDIS_CMDSTATS_COMMAND);
                    Set set = hashtable2.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
                        string = string.replace("cmdstat_", "");
                        logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats]The discriptor : " + string + " and its value : " + hashtable3);
                        Iterator iterator2 = (Iterator)((Object)hashtable3.keys());
                        ArrayList arrayList = this.finalMeasures(this.measureCount);
                        while (iterator2.hasNext()) {
                            String string2 = (String)iterator2.next();
                            Object object = null;
                            try {
                                object = hashtable3.get(string2);
                            }
                            catch (Exception exception) {
                                logger.debug(this.logPrefix + "[getRedisMeasureForCommandStats] Exception occured while iterating the metric value", (Throwable)exception);
                            }
                            if (!redisNameList.contains(string2)) continue;
                            String string3 = (String)measureNameTable.get(string2);
                            int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                            try {
                                double d = Double.parseDouble(object.toString());
                                double d2 = 0.0;
                                d2 = Double.parseDouble(object.toString());
                                arrayList.set(n, new Double(d2));
                                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] discriptor : " + string + " index : " + n + " ==> metric name : " + string2 + " value : " + object);
                            }
                            catch (Exception exception) {
                                logger.error(this.logPrefix + " [getRedisMeasureForCommandStats] Error while parsing the String to Double", (Throwable)exception);
                            }
                        }
                        logger.info(this.logPrefix + " [getRedisMeasureForCommandStats]  The ArrayList  measure contains = " + arrayList);
                        this.addNewMeasure(string, arrayList);
                    }
                    this.previousMeasureTable = hashtable2;
                    break block23;
                }
                boolean bl = false;
                logger.info(this.logPrefix + " [getRedisMeasureForCommandStats] The test is already running");
                if (hashtable == null || hashtable.size() <= 0) break block23;
                Hashtable hashtable4 = (Hashtable)hashtable.get(REDIS_CMDSTATS_COMMAND);
                Set set = hashtable4.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Hashtable hashtable5 = (Hashtable)hashtable4.get(string);
                    Hashtable hashtable6 = (Hashtable)this.previousMeasureTable.get(string);
                    ArrayList arrayList = this.finalMeasures(this.measureCount);
                    string = string.replace("cmdstat_", "");
                    logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats]The discriptor : " + string + "and its value : " + hashtable5 + "and its previous value : " + hashtable6);
                    if (hashtable6 == null || hashtable6.size() <= 0) continue;
                    Iterator iterator3 = (Iterator)((Object)hashtable5.keys());
                    while (iterator3.hasNext()) {
                        String string4 = (String)iterator3.next();
                        Object object = null;
                        Object object2 = null;
                        try {
                            object = hashtable5.get(string4);
                            object2 = hashtable6.get(string4);
                        }
                        catch (Exception exception) {
                            logger.debug(this.logPrefix + "[getRedisMeasureForCommandStats] Exception occured while iterating the metric value", (Throwable)exception);
                        }
                        if (!redisNameList.contains(string4)) continue;
                        String string5 = (String)measureNameTable.get(string4);
                        int n = Integer.parseInt(measureIndexTable.get(string5).toString());
                        try {
                            double d = Double.parseDouble(object.toString());
                            double d3 = Double.parseDouble(object2.toString());
                            double d4 = 0.0;
                            if (d3 > 0.0 && d3 < d && n != 0) {
                                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] Current Value is greater than previous value and the metric is not Usec_Per_Call");
                                d4 = d - d3;
                                bl = true;
                            } else if (n == 0) {
                                d4 = d;
                            } else if (d < d3) {
                                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] Current Value is lesser than previous value.");
                                if (this.isRedisRestarted()) {
                                    d4 = d;
                                    logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] Redis Server has been restarted......");
                                }
                            }
                            arrayList.set(n, new Double(d4));
                            logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] discriptor : " + string + "\n index : " + n + " ==> metric name : " + string4 + " value : " + object);
                        }
                        catch (Exception exception) {
                            logger.error(this.logPrefix + "[getRedisMeasureForCommandStats] Exception occured while parsing the String to Double", (Throwable)exception);
                        }
                    }
                    logger.info(this.logPrefix + " [getRedisMeasureForCommandStats]  The ArrayList  measure contains = " + arrayList);
                    if (!bl) continue;
                    this.addNewMeasure(string, arrayList);
                    bl = false;
                }
                this.previousMeasureTable = hashtable4;
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + "Exception occured inside [getRedisMeasureForCommandStats] ", (Throwable)exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        RedisCmdStatsTest redisCmdStatsTest = new RedisCmdStatsTest(stringArray);
        redisCmdStatsTest.computeMeasures(new Hashtable());
    }

    static {
        iniFilePath = "/agent/config/eg_measures.ini";
        previousUpTime = 0.0;
    }
}

