/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class RabMQNodeGCTest
extends RabbitMQBase {
    private static final int MEASURE_COUNT = 5;
    private Hashtable prevMeasureHash = new Hashtable();

    public RabMQNodeGCTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Object object;
        String string;
        Enumeration enumeration;
        String string2 = "[debugComputeMeasures] : ";
        String string3 = this.getJSONDataFromURL("nodes", this.rabbitMQHost, this.rabbitMQPort);
        this.printOut(string2 + "responseString " + string3);
        if ((string3 == null || string3.trim().length() == 0) && this.isCluster) {
            this.readClusterNodesFromFile();
            this.printOut(string2 + "Connection not established using " + this.rabbitMQHost + ":" + this.rabbitMQPort);
            this.printOut("RabbitMQ list of node read from log files " + this.rabMQNodeList);
            for (int i = 0; i < this.rabMQNodeList.size(); ++i) {
                enumeration = (String)this.rabMQNodeList.get(i);
                string = ((String)((Object)enumeration)).substring(((String)((Object)enumeration)).lastIndexOf("@") + 1, ((String)((Object)enumeration)).lastIndexOf("#"));
                object = ((String)((Object)enumeration)).substring(((String)((Object)enumeration)).lastIndexOf("#") + 1, ((String)((Object)enumeration)).length());
                this.printOut(string2 + "Trying connection for cluster using " + string + ":" + (String)object);
                string3 = this.getJSONDataFromURL("overview", string, (String)object);
                if (string3 != null) {
                    this.rabbitMQHost = string;
                    this.rabbitMQPort = object;
                    break;
                }
                this.printOut(string2 + "Connection not established using " + string + ":" + (String)object);
            }
        }
        if (string3 == null || string3.trim().length() == 0) {
            this.logMessage = string2 + "Response for method is null or empty ,Could not proceed further ,So test returning";
            this.printOut(this.logMessage, debug);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            return;
        }
        Hashtable hashtable2 = this.getRabbitMQNodeGC(string3);
        this.printOut(string2 + " Measure hashtable before adding measures " + hashtable2);
        this.printOut(string2 + " PrevHashtable measures " + this.prevMeasureHash);
        try {
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                enumeration = new ArrayList();
                for (int i = 0; i < this.measureCount; ++i) {
                    ((ArrayList)((Object)enumeration)).add((Double)new Double(-5.0));
                }
                this.addNewMeasure((ArrayList)((Object)enumeration));
                this.logMessage = string2 + "getMeasureDataHash is empty, passing default measures ";
                this.printOut(this.logMessage, debug);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            enumeration = hashtable2.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                ArrayList<Double> arrayList;
                string = (String)enumeration.nextElement();
                object = (ArrayList)hashtable2.get(string);
                double d = (Double)((ArrayList)object).get(0);
                double d2 = (Double)((ArrayList)object).get(1);
                double d3 = (Double)((ArrayList)object).get(2);
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = -5.0;
                double d8 = -5.0;
                double d9 = -5.0;
                double d10 = -5.0;
                double d11 = -5.0;
                if (this.prevMeasureHash != null && !this.prevMeasureHash.isEmpty() && this.prevMeasureHash.size() > 0 && this.prevMeasureHash.containsKey(string)) {
                    arrayList = (ArrayList<Double>)this.prevMeasureHash.get(string);
                    d4 = (Double)arrayList.get(0);
                    d5 = (Double)arrayList.get(1);
                    d6 = (Double)arrayList.get(2);
                    if (this.timeSinceLastTest > 0.0) {
                        d8 = d >= d4 ? (d - d4) / this.timeSinceLastTest : -5.0;
                        d7 = d >= d4 ? d - d4 : -5.0;
                        d10 = d3 >= d6 ? (d3 - d6) / this.timeSinceLastTest : -5.0;
                        d9 = d2 >= d5 ? (d2 - d5) / 1024000.0 / this.timeSinceLastTest : -5.0;
                        d11 = d2 >= d5 ? (d2 - d5) / 1024000.0 : -5.0;
                    }
                }
                d8 = this.removeExpAndRound(d8);
                d11 = this.removeExpAndRound(d11);
                d9 = this.removeExpAndRound(d9);
                d10 = this.removeExpAndRound(d10);
                d7 = this.removeExpAndRound(d7);
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d10));
                arrayList.add(new Double(d11));
                arrayList.add(new Double(d7));
                String string4 = string.substring(string.indexOf("@") + 1, string.length()) + this.fielSepar + string.substring(0, string.indexOf("@"));
                this.printOut(string2 + " Measure adding Info : " + string4 + " measurelist : " + arrayList);
                if (!bl) {
                    this.addNewMeasure(string4, arrayList);
                }
                this.printOut(string2 + " Measure adding Info : " + string4 + " measurelist : " + arrayList);
                if (bl) continue;
                this.addNewMeasure(string4, arrayList);
            }
            this.prevMeasureHash = hashtable2;
        }
        catch (Exception exception) {
            this.logMessage = string2 + "[Error in computeMeasures]";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
    }

    public Hashtable getRabbitMQNodeGC(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        ArrayList<Double> arrayList = null;
        Hashtable hashtable = null;
        String string2 = "[getRabbitMQNodeGC] : ";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        try {
            hashtable = new Hashtable();
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = (JSONArray)jSONParser.parse(string);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject = (JSONObject)jSONArray.get(i);
                string3 = this.getValueFromJSONObject(jSONObject, "name");
                d = this.stringToDouble(this.getValueFromJSONObject(jSONObject, "gc_num"));
                d2 = this.stringToDouble(this.getValueFromJSONObject(jSONObject, "gc_bytes_reclaimed"));
                d3 = this.stringToDouble(this.getValueFromJSONObject(jSONObject, "context_switches"));
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception happened while  parsing the outputs :";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string2 + "  Output Hashtable :" + hashtable);
        return hashtable;
    }

    public static void main(String[] stringArray) {
        RabMQNodeGCTest rabMQNodeGCTest = new RabMQNodeGCTest(stringArray);
        rabMQNodeGCTest.debugComputeMeasures(new Hashtable(), true);
    }
}

