/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.LogFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraAlertTest
extends GenericTest {
    public String oraSid;
    public String username = "";
    public String password = "";
    ArrayList excludeList = new ArrayList();
    private String fileName;
    String path = null;
    long oldTimeStamp;
    long oldFileSize;
    ArrayList al_prevPostLines;
    ArrayList al_patterns;
    ArrayList al_infos;
    public Hashtable h_patternsAL;
    ArrayList al_alertFileLines = new ArrayList();
    boolean b_readFile = false;
    private long defValue = -1L;
    long[] longErrorTypes = new long[0];
    private boolean isAll = false;
    private ArrayList interestedErrorTypes = new ArrayList();
    private boolean errorOccured = false;
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;

    public OraAlertTest(String[] stringArray) {
        super(stringArray);
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        this.setMeasureCount(this.measureCount);
        String string = null;
        String string2 = null;
        String string3 = null;
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.path = this.getValueForParam("alertFile");
        this.path = this.getCorrectPath(this.path);
        if (this.path == null || this.path.length() == 0) {
            System.err.println("OraAlertTest: error in getting alert file path for " + this.getValueForParam("alertFile") + " hence returning");
            return;
        }
        string = this.getValueForParam("searchPattern");
        string3 = this.getValueForParam("excludePattern");
        string2 = this.getValueForParam("lines");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string.equalsIgnoreCase("all") || string.startsWith("all:")) {
            this.isAll = true;
            string = "all:*ORA-*";
        }
        if (string3 != null && string3.equalsIgnoreCase("none")) {
            string3 = null;
        }
        this.setSid(this.oraSid);
        this.excludeList = new ArrayList();
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ",");
            n2 = stringTokenizer.countTokens();
            for (n = 0; n < n2; ++n) {
                String string4 = stringTokenizer.nextToken().trim();
                this.excludeList.add(string4);
            }
        }
        this.al_prevPostLines = new ArrayList();
        stringTokenizer = new StringTokenizer(string2, ",");
        n2 = stringTokenizer.countTokens();
        for (n = 0; n < n2; ++n) {
            this.al_prevPostLines.add(stringTokenizer.nextToken());
        }
        this.al_patterns = new ArrayList();
        this.al_infos = new ArrayList();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",");
        n2 = stringTokenizer2.countTokens();
        for (int i = 0; i < n2; ++i) {
            String string5 = stringTokenizer2.nextToken();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string5, ":");
            this.al_infos.add(stringTokenizer3.nextToken());
            this.al_patterns.add(stringTokenizer3.nextToken());
        }
        this.oldTimeStamp = -1L;
        this.oldFileSize = -1L;
        this.path = this.findAndReplaceString(this.path, "\\", "/");
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5L;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        double d = 0.0;
        ArrayList arrayList = new ArrayList();
        if (this.checkOracleVersion) {
            ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            arrayList = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 2) {
                int n = (Integer)arrayList.get(0);
                object = (String)arrayList.get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    String string = (String)arrayList.get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.checkOracleVersion = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Connection is null Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
        }
        if (this.isMultitenantDb && !this.isCDB) {
            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                this.logToErrorFile("INFO", "OraAlertTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.msgLogCounter = 0;
            }
            ++this.msgLogCounter;
            return;
        }
        this.path = this.path.equalsIgnoreCase("none") && this.username != null && !this.username.equalsIgnoreCase("none") ? this.getPath(this.targetHost, this.portNo, this.username, this.password) : this.findAndReplaceString(this.path, "\\", "/");
        if (this.path == null) {
            System.err.println("******Connection is null");
            this.logToErrorFile("INFO", "OraAlertTest Path is nulll for: ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        this.h_patternsAL = new Hashtable();
        try {
            object = new File(this.path);
            if (((File)object).exists()) {
                long l = ((File)object).lastModified();
                long l2 = ((File)object).length();
                double d2 = 0.0;
                double d3 = 0.0;
                if (this.oldFileSize > 0L && this.oldFileSize < l2) {
                    d3 = (double)l2 / 1048576.0 - (double)this.oldFileSize / 1048576.0;
                    d2 = d3 / this.timeSinceLastTest;
                }
                boolean bl = this.readAlertFile(l, l2);
                for (int i = 0; i < this.al_infos.size(); ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    ArrayList arrayList3 = null;
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    if (this.al_infos.size() == this.al_prevPostLines.size()) {
                        if (bl) {
                            object4 = (String)this.al_prevPostLines.get(i);
                            arrayList3 = this.computeErrorCount((String)this.al_patterns.get(i), (String)object4, this.excludeList);
                        } else {
                            arrayList3 = new ArrayList();
                            arrayList4 = new ArrayList();
                        }
                    } else if (bl) {
                        object4 = (String)this.al_prevPostLines.get(0);
                        arrayList3 = this.computeErrorCount((String)this.al_patterns.get(i), (String)object4, this.excludeList);
                    } else {
                        arrayList3 = new ArrayList();
                        arrayList4 = new ArrayList();
                    }
                    object4 = new Hashtable();
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        object3 = (ArrayList)arrayList3.get(j);
                        for (int k = 0; k < ((ArrayList)object3).size(); ++k) {
                            object2 = (String)((ArrayList)object3).get(k);
                            arrayList4.add((String)object2);
                        }
                    }
                    object4 = this.parseErrors(arrayList3, arrayList4, (Hashtable)object4);
                    System.out.println("results::" + object4);
                    Enumeration enumeration = ((Hashtable)object4).keys();
                    object3 = this.siteName + siteAndInfoSeparator + this.oraSid + EgConfigInfo.infoFieldSeparator;
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        object2 = (ArrayList)((Hashtable)object4).get(string);
                        if (object2 == null) continue;
                        double d4 = ((ArrayList)object2).size();
                        if (this.errorOccured) {
                            d4 = -1.0;
                        }
                        String string2 = this.oraSid + EgConfigInfo.infoFieldSeparator + string;
                        if (d4 > 0.0) {
                            ArrayList<Double> arrayList5 = new ArrayList<Double>();
                            arrayList5.add(new Double(d4));
                            if (this.measureCount > 1) {
                                arrayList5.add(new Double(-5.0));
                                arrayList5.add(new Double(-5.0));
                            }
                            d += d4;
                            this.addNewMeasure(string, arrayList5);
                        }
                        this.h_patternsAL.put(string, object2);
                    }
                }
                if (this.measureCount > 1) {
                    if (this.errorOccured) {
                        d = -1.0;
                    }
                    ArrayList<Double> arrayList6 = new ArrayList<Double>();
                    arrayList6.add(new Double(d));
                    arrayList6.add(new Double((double)l2 / 1048576.0));
                    arrayList6.add(new Double(d2));
                    this.addNewMeasure("Summary", arrayList6);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error in Compute measures");
            this.errorMsg = "Exception " + exception.toString() + " in OraAlertTest";
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
        }
    }

    private Hashtable parseErrors(ArrayList arrayList, ArrayList arrayList2, Hashtable hashtable) {
        System.out.println("Lines found in parseErrors " + arrayList2);
        System.out.println("al_temp in parseErrors " + arrayList);
        if (arrayList2 == null) {
            return hashtable;
        }
        int n = arrayList2.size();
        String string = "ORA-";
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList2.get(i);
            int n2 = string2.indexOf(string);
            if (n2 < 0) {
                System.out.println("Search failed ...");
                continue;
            }
            int n3 = string2.indexOf(58, n2 + 1);
            if (n3 < 0) continue;
            String string3 = string2.substring(n2, n3);
            ArrayList<ArrayList> arrayList3 = (ArrayList<ArrayList>)hashtable.get(string3);
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<ArrayList>();
            }
            arrayList3.add((ArrayList)arrayList.get(i));
            hashtable.put(string3, arrayList3);
        }
        return hashtable;
    }

    private boolean readAlertFile(long l, long l2) {
        boolean bl = false;
        long l3 = 0L;
        if (this.oldTimeStamp == -1L || this.oldFileSize == -1L) {
            this.oldTimeStamp = l;
            this.oldFileSize = l2;
        }
        this.al_alertFileLines = new ArrayList();
        this.errorOccured = false;
        this.errorOccured = this.checkFileAccess(this.path);
        if (this.errorOccured) {
            return false;
        }
        if (l == this.oldTimeStamp || l2 == this.oldFileSize) {
            return false;
        }
        LogFileReader logFileReader = null;
        try {
            logFileReader = new LogFileReader(this.path, this.oldFileSize);
            this.al_alertFileLines = logFileReader.readAllLines();
            this.oldTimeStamp = l;
            this.oldFileSize = l2;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.oldTimeStamp = l;
            this.oldFileSize = l2;
            return false;
        }
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int indexOfIgnoreCase(String string, String string2) {
        if (string == null || string.equals("")) {
            return -1;
        }
        if (string2 == null || string2.equals("")) {
            return -1;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        int n = -1;
        n = string.indexOf(string2);
        return n;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (string2 == null || string2.equals("")) {
            return false;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        return string.startsWith(string2);
    }

    private boolean endsWithIgnoreCase(String string, String string2) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (string2 == null || string2.equals("")) {
            return false;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        return string.endsWith(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getPath(String string, String string2, String string3, String string4) {
        String string5;
        block69: {
            String string6;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block60: {
                connection = null;
                statement = null;
                resultSet = null;
                string6 = "";
                string5 = "";
                connection = ConnectionManager.getConnection(this.entity, string, string2, this.oraSid, string3, string4, debug);
                if (connection != null) break block60;
                this.logToErrorFile("Error", "OraAlertTest connection is null for : ", "targetHost:" + string + " reportingName :" + this.reportingName + " Port :" + string2 + " SID :" + this.oraSid);
                String string7 = null;
                Object var14_14 = null;
                try {
                    Exception exception222;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception222) {}
                    }
                }
                catch (Exception exception) {
                    System.out.println("[OraAlertTest]   Could not connect to the database: " + exception.getMessage());
                }
                return string7;
            }
            string6 = this.isOracle12c ? "select name,value from v$diag_info where name='Diag Trace'" : "select name, value from v$parameter where name='background_dump_dest'";
            if (debug) {
                System.out.println("[OraAlertTest] Query  is " + string6);
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraAlertTest Failed to Create Statement targetHost:" + string + " reportingName :" + this.reportingName + " Port :" + string2 + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                String string8 = null;
                Object var14_15 = null;
                try {
                    Exception exception4222;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception4222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception4222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception4222) {}
                    }
                }
                catch (Exception exception5) {
                    System.out.println("[OraAlertTest]   Could not connect to the database: " + exception5.getMessage());
                }
                return string8;
            }
            resultSet = statement.executeQuery(string6);
            double d = -5.0;
            while (resultSet != null && resultSet.next()) {
                string5 = resultSet.getString(2);
                string5 = string5 + "//alert_" + this.oraSid + ".log";
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                }
            }
            Object var14_16 = null;
            try {
                Exception exception622;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception622) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception622) {
                        // empty catch block
                    }
                }
                if (connection == null) break block69;
                try {
                    connection.close();
                    break block69;
                }
                catch (Exception exception622) {
                }
            }
            catch (Exception exception) {
                System.out.println("[OraAlertTest]   Could not connect to the database: " + exception.getMessage());
            }
            break block69;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var14_17 = null;
                    try {
                        Exception exception7222;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception7222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception exception7222) {
                                // empty catch block
                            }
                        }
                        if (connection == null) break block69;
                        try {
                            connection.close();
                            break block69;
                        }
                        catch (Exception exception7222) {
                        }
                    }
                    catch (Exception exception8) {
                        System.out.println("[OraAlertTest]   Could not connect to the database: " + exception8.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    Exception exception922;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception922) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception922) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception922) {}
                    }
                }
                catch (Exception exception) {
                    System.out.println("[OraAlertTest]   Could not connect to the database: " + exception.getMessage());
                }
                throw throwable;
            }
        }
        if (debug) {
            System.out.println("[OraAlertTest] Alert Log Dir path is " + string5);
        }
        return string5;
    }

    private ArrayList isMatch(String string, ArrayList arrayList, int n, int n2, int n3) {
        int n4;
        String string2 = (String)arrayList.get(n);
        boolean bl = false;
        bl = OraAlertTest.isMatch(string2, string);
        if (!bl) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n5 = n - n2;
        if (n5 < 0) {
            n5 = 0;
        }
        for (n4 = n5; n4 <= n; ++n4) {
            String string3 = (String)arrayList.get(n4);
            arrayList2.add(string3);
        }
        n4 = n + n3;
        int n6 = arrayList.size();
        if (n4 >= n6) {
            n4 = n6 - 1;
        }
        for (int i = n + 1; i <= n4; ++i) {
            String string4 = (String)arrayList.get(i);
            arrayList2.add(string4);
        }
        ArrayList<ArrayList<String>> arrayList3 = new ArrayList<ArrayList<String>>();
        arrayList3.add(arrayList);
        arrayList3.add(arrayList2);
        return arrayList3;
    }

    public ArrayList computeErrorCount(String string, String string2, ArrayList arrayList) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (string2.indexOf(":") > -1) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "+");
        int n3 = stringTokenizer2.countTokens();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(stringTokenizer2.nextToken());
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        int n4 = arrayList.size();
        for (int i = 0; i < this.al_alertFileLines.size(); ++i) {
            Object object;
            String string3 = (String)this.al_alertFileLines.get(i);
            boolean bl = false;
            for (int j = 0; j < n4; ++j) {
                object = (String)arrayList.get(j);
                if (!OraAlertTest.isMatch(string3, (String)object)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ArrayList arrayList4 = new ArrayList();
            object = new ArrayList();
            int n5 = arrayList2.size();
            boolean bl2 = false;
            for (int j = 0; j < n5; ++j) {
                arrayList4 = this.isMatch((String)arrayList2.get(j), this.al_alertFileLines, i, n, n2);
                if (arrayList4 == null || arrayList4.size() != 2) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            this.al_alertFileLines = (ArrayList)arrayList4.get(0);
            object = (ArrayList)arrayList4.get(1);
            if (object == null || ((ArrayList)object).size() <= 0) continue;
            arrayList3.add(object);
        }
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkFileAccess(String string) {
        block16: {
            BufferedReader bufferedReader = null;
            String string2 = "";
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                // empty if block
            }
            bufferedReader.close();
            bufferedReader = null;
            Object var7_4 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                break block16;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block16;
            {
                catch (IOException iOException) {
                    this.logToErrorFile("Error : ", "[AlertLogTest]", " exception occured while reading a file:" + iOException.toString());
                    iOException.printStackTrace();
                    boolean bl = true;
                    Object var7_5 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl;
                    try {
                        exception.printStackTrace();
                        bl = true;
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                                bufferedReader = null;
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        OraAlertTest oraAlertTest = new OraAlertTest(stringArray);
        for (int i = 0; i < 10; ++i) {
            oraAlertTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(15000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCorrectPath(String string) {
        String string2;
        int n;
        if (string != null && string.length() > 0 && string.startsWith("%") && (n = (string2 = string.substring(1)).indexOf("%")) > 0) {
            String string3;
            String string4;
            String string5 = "";
            if (n + 1 < string2.length()) {
                string5 = string2.substring(n + 1);
            }
            if ((string4 = System.getenv(string3 = string2.substring(0, n))) != null && string4.length() > 0 && !string4.equalsIgnoreCase(string3)) {
                string = string4 + string5;
            }
        }
        return string;
    }
}

