/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class NscPolicyTest
extends EgSnmpGenericTest {
    private static final double MB = 1048576.0;
    private static String plyMonId = ".1.3.6.1.4.1.3224.10.2.1.1";
    private static String pktsRate = ".1.3.6.1.4.1.3224.10.2.1.4";
    private static String pktsTotal = ".1.3.6.1.4.1.3224.10.2.1.5";
    private static String dataRate = ".1.3.6.1.4.1.3224.10.2.1.7";
    private static String dataTotal = ".1.3.6.1.4.1.3224.10.2.1.8";
    private static String sessRate = ".1.3.6.1.4.1.3224.10.2.1.10";
    private static String sessTotal = ".1.3.6.1.4.1.3224.10.2.1.11";
    private static String plyName = ".1.3.6.1.4.1.3224.10.1.1.24";
    private static int numMeasures = 6;
    private int rediscCount = -1;
    private static int maxRediscPeriod = 4;
    ArrayList idNames = new ArrayList();
    private Hashtable plyMonIdMap = new Hashtable();
    private Hashtable prevPktsTotal = new Hashtable();
    private Hashtable prevDataTotal = new Hashtable();
    private Hashtable prevSessTotal = new Hashtable();
    private Hashtable pktsRateMap;
    private Hashtable dataRateMap;
    private Hashtable sessRateMap;
    private Hashtable pktsTotalMap;
    private Hashtable dataTotalMap;
    private Hashtable sessTotalMap;
    private Hashtable plyNames = new Hashtable();
    private int numPlyMonId = 0;

    public NscPolicyTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private void initAll() {
        this.pktsTotalMap = new Hashtable();
        this.dataTotalMap = new Hashtable();
        this.sessTotalMap = new Hashtable();
        this.pktsRateMap = new Hashtable();
        this.dataRateMap = new Hashtable();
        this.sessRateMap = new Hashtable();
    }

    private void initPrev() {
        this.prevPktsTotal = new Hashtable();
        this.prevDataTotal = new Hashtable();
        this.prevSessTotal = new Hashtable();
    }

    private void emptyAll() {
        this.pktsTotalMap = null;
        this.dataTotalMap = null;
        this.sessTotalMap = null;
        this.pktsRateMap = null;
        this.dataRateMap = null;
        this.sessRateMap = null;
    }

    private void discIds() {
        int n;
        ++this.rediscCount;
        if (this.rediscCount >= maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(plyMonId);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.plyMonIdMap = new Hashtable();
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.lhs.length; ++n) {
            this.plyMonIdMap.put(this.lhs[n], this.rhs[n]);
            arrayList.add(this.rhs[n]);
        }
        if (arrayList.size() != this.idNames.size()) {
            bl2 = true;
        } else {
            String string;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.idNames.contains(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (n = 0; n < this.idNames.size(); ++n) {
                    string = (String)this.idNames.get(n);
                    if (arrayList.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.initPrev();
        }
        this.idNames = arrayList;
        this.numPlyMonId = this.lhs.length;
        bl = this.runSnmpCmdForOid(plyName);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.plyNames = new Hashtable();
        for (n = 0; n < this.lhs.length; ++n) {
            int n2;
            if (this.rhs[n].equalsIgnoreCase("N/A") || (n2 = this.lhs[n].indexOf(46)) < 0) continue;
            this.lhs[n] = this.lhs[n].substring(0, n2);
            this.plyNames.put(this.lhs[n], this.rhs[n]);
        }
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d;
        double d2;
        double d3;
        int n;
        this.initAll();
        this.discIds();
        if (this.numPlyMonId == 0) {
            return;
        }
        if (this.runSnmpCmdForOid(pktsTotal)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevPktsTotal.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevPktsTotal.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d4 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevPktsTotal.put(this.lhs[n], new Double(d3));
                    }
                    this.pktsTotalMap.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.prevPktsTotal = new Hashtable();
        }
        if (this.runSnmpCmdForOid(dataTotal)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevDataTotal.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevDataTotal.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d5 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevDataTotal.put(this.lhs[n], new Double(d3));
                    }
                    this.dataTotalMap.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.prevDataTotal = new Hashtable();
        }
        if (this.runSnmpCmdForOid(sessTotal)) {
            if (this.lhs != null && this.lhs.length > 0) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d3 = this.getValue(this.rhs[n]);
                    d2 = -5.0;
                    if (this.prevSessTotal.containsKey(this.lhs[n])) {
                        d2 = (Double)this.prevSessTotal.get(this.lhs[n]);
                    }
                    d = -5.0;
                    if (d3 >= 0.0 && d2 >= 0.0) {
                        d = d3 - d2;
                        double d6 = d = d >= 0.0 ? d : -5.0;
                    }
                    if (d3 >= 0.0) {
                        this.prevSessTotal.put(this.lhs[n], new Double(d3));
                    }
                    this.sessTotalMap.put(this.lhs[n], new Double(d));
                }
            }
        } else {
            this.prevSessTotal = new Hashtable();
        }
        if (this.runSnmpCmdForOid(pktsRate) && this.lhs != null && this.lhs.length > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                d3 = this.getValue(this.rhs[n]);
                d3 = d3 >= 0.0 ? d3 : -5.0;
                this.pktsRateMap.put(this.lhs[n], new Double(d3));
            }
        }
        if (this.runSnmpCmdForOid(dataRate) && this.lhs != null && this.lhs.length > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                d3 = this.getValue(this.rhs[n]);
                d3 = d3 >= 0.0 ? d3 : -5.0;
                this.dataRateMap.put(this.lhs[n], new Double(d3));
            }
        }
        if (this.runSnmpCmdForOid(sessRate) && this.lhs != null && this.lhs.length > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                d3 = this.getValue(this.rhs[n]);
                d3 = d3 >= 0.0 ? d3 : -5.0;
                this.sessRateMap.put(this.lhs[n], new Double(d3));
            }
        }
        Enumeration enumeration = this.plyMonIdMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.plyMonIdMap.get(string);
            d2 = -5.0;
            d = -5.0;
            double d7 = -5.0;
            double d8 = -5.0;
            double d9 = -5.0;
            double d10 = -5.0;
            if (this.pktsRateMap != null && this.pktsRateMap.containsKey(string)) {
                d2 = (Double)this.pktsRateMap.get(string);
            }
            if (this.pktsTotalMap != null && this.pktsTotalMap.containsKey(string)) {
                d = (Double)this.pktsTotalMap.get(string);
            }
            if (this.dataRateMap != null && this.dataRateMap.containsKey(string) && (d7 = ((Double)this.dataRateMap.get(string)).doubleValue()) > 0.0) {
                d7 /= 1048576.0;
            }
            if (this.dataTotalMap != null && this.dataTotalMap.containsKey(string) && (d8 = ((Double)this.dataTotalMap.get(string)).doubleValue()) > 0.0) {
                d8 /= 1048576.0;
            }
            if (this.sessRateMap != null && this.sessRateMap.containsKey(string)) {
                d9 = (Double)this.sessRateMap.get(string);
            }
            if (this.sessTotalMap != null && this.sessTotalMap.containsKey(string)) {
                d10 = (Double)this.sessTotalMap.get(string);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d9));
            arrayList.add(new Double(d10));
            System.out.println("policy=" + string2 + " " + arrayList);
            String string3 = (String)this.plyNames.get(string2);
            if (string3 == null) {
                string3 = string2;
            }
            this.addNewMeasure(string3, arrayList);
        }
        this.emptyAll();
    }
}

