/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMLanguage;
import com.eg.apm.APMNodeComponentIDRepository;
import com.eg.apm.APMNodeWorker;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.NodeBTMLogger;
import com.eg.jtm.DataBaseUtils;
import com.eg.jtm.NodeMethodInfo;
import com.eg.jtm.NodePropsManager;
import com.eg.jtm.NodeUPDManager;
import com.eg.org.objectweb.asm.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.mail.URLName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeTransTestBase
extends NodeBTMBase {
    protected Hashtable sourceTable;
    protected Hashtable DataBaseHT;
    protected static String logPrefix = "NodeTransTestBase";
    protected static final Hashtable<String, Hashtable<String, String>> jdbcURLDetails = new Hashtable();
    protected Hashtable slowURLTable = null;
    protected Hashtable stalledURLTable = null;
    protected Hashtable errorURLTable = null;
    protected Hashtable allURLTable = null;
    protected Hashtable externalTable = null;
    protected Hashtable stackTraceTable = null;
    protected Hashtable recentThresholdTable = null;
    protected Hashtable previousThresholdTable = new Hashtable();
    protected boolean cpuTimeTrackingFlag = false;
    protected boolean contentionTimeTrackingFlag = false;
    private boolean isFirstTime = true;
    private static Hashtable<String, String> ldapMethodMapping = new Hashtable();
    private static final String SESSION_USER_KEY = "SESSION_USER_KEY";
    private HashMap sessionUserMapping = null;
    public static final String TRANSACTION_FLOW_TEST = "TransactionFlowTest";
    private static int read_timeout;
    private static int thread_timeout;
    protected int status_code;
    private boolean isSourceTableFromTempCompID = false;

    static {
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]search", "LDAP Search");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClient[*#*]search", "LDAP Client Search");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClientFactory[*#*]createPooledConnection", "LDAP ClientFactory Connect");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapNamingEnumeration[*#*]getNextBatch", "LDAP NamingEnumeration GetNextBatch");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapNamingEnumeration[*#*]nextAux", "LDAP NamingEnumeration NextAux");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]modifyAttributes", "LDAP ModifyAttributes");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClient[*#*]modify", "LDAP Client Modify");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]bind", "LDAP Bind");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]rebind", "LDAP Rebind");
    }

    public NodeTransTestBase(String[] args) {
        super(args);
        String contentionTimeTracking;
        String cpuTimeTracking;
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + logPrefix + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        this.trgtHost = this.getValueForParam("trgtHost");
        this.applicationName = this.getValueForParam("Application_Name");
        if (this.applicationName == null) {
            this.applicationName = "-";
        }
        if ((cpuTimeTracking = this.getValueForParam("Enable_Thread_Cpu_Monitoring")) != null && cpuTimeTracking.equalsIgnoreCase("true")) {
            this.cpuTimeTrackingFlag = true;
        }
        if ((contentionTimeTracking = this.getValueForParam("Enable_Thread_Contention_Monitoring")) != null && contentionTimeTracking.equalsIgnoreCase("true")) {
            this.contentionTimeTrackingFlag = true;
        }
        NodeBTMLogger.nodeLogger.debug("{} Thread CPU Time Tracking ? : {}  Thread Contention Monitoring ? {}", new Object[]{this.loggerDispStr, cpuTimeTracking, contentionTimeTracking});
    }

    public void computeMeasures(Hashtable paramList, String[] propsOrder) {
        this.printAllRepositoryTable();
        this.checkForPropsChanges(propsOrder);
        ComponentWatcherTracker.isWatcherNull(true);
        this.slowURLTable = new Hashtable();
        this.stalledURLTable = new Hashtable();
        this.errorURLTable = new Hashtable();
        this.allURLTable = new Hashtable();
        this.externalTable = new Hashtable();
        this.stackTraceTable = new Hashtable();
        this.sourceTable = new Hashtable();
        this.DataBaseHT = new Hashtable();
        this.recentThresholdTable = new Hashtable();
        Enumeration ee = this.results.keys();
        while (ee.hasMoreElements()) {
            Threshold thresh;
            double[] upperBound;
            String key = (String)ee.nextElement();
            EgResultSet e = (EgResultSet)this.results.get(key);
            Threshold[] thresholds = e.thresholds;
            if (thresholds == null || thresholds.length <= 0 || (upperBound = (thresh = thresholds[1]).getUpperBound()) == null || upperBound.length < 2) continue;
            String upperBoundString = String.valueOf(upperBound[0]) + "/" + upperBound[1];
            String infoKey = key;
            int ind = key.indexOf(siteAndInfoSeparator);
            if (ind > 0) {
                infoKey = key.substring(ind + 1);
            }
            this.recentThresholdTable.put(infoKey, upperBoundString);
        }
        this.getNodeJSData();
        NodeBTMLogger.nodeLogger.debug("{}  sourceTable: {}", (Object)this.loggerDispStr, (Object)this.sourceTable);
        if (this.status_code == 200 && this.sourceTable != null && this.sourceTable.size() > 0) {
            this.computeBTMData(this.sourceTable);
        } else {
            NodeBTMLogger.nodeLogger.warn("{} Discarding the data due to timeout reached or data is null & status code {}", (Object)this.loggerDispStr, (Object)this.status_code);
        }
    }

    protected void getNodeJSData() {
        Hashtable modifiedThreshPatterns = this.getModifiedThresholdPatterns(this.recentThresholdTable, this.previousThresholdTable);
        NodeBTMLogger.nodeLogger.debug("{} modifiedThreshPatterns: {}", (Object)this.loggerDispStr, (Object)modifiedThreshPatterns);
        if (!APMNodeComponentIDRepository.isOffloadComponentID(this.nodeId)) {
            this.updateThresholds(modifiedThreshPatterns, this.entity);
            NodeBTMLogger.nodeLogger.debug("{} First Time: Trying Agent offload computation on:- '{}' component {}", (Object)this.loggerDispStr, (Object)this.nodeId);
            boolean btmOffloadResult = this.getOffLoadData();
            int retryCount = 1;
            while (!btmOffloadResult && retryCount <= 10 && !APMNodeComponentIDRepository.isOffloadComponentID(this.nodeId)) {
                btmOffloadResult = this.getOffLoadData();
                NodeBTMLogger.nodeLogger.debug("{} Waiting for offload data  ", (Object)this.loggerDispStr);
                if (!btmOffloadResult) {
                    try {
                        NodeBTMLogger.nodeLogger.debug("{} Waiting for 3 second and retry  ", (Object)this.loggerDispStr);
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        NodeBTMLogger.nodeLogger.warn("{} Exception in sleep method {}", (Object)this.loggerDispStr, (Object)e);
                    }
                } else {
                    this.makePropsList(propsOrder);
                }
                ++retryCount;
            }
            if (btmOffloadResult && !this.isSourceTableFromTempCompID) {
                isOffloadDataCollection = true;
                APMNodeComponentIDRepository.registerIntoOffloadComponentIDTable(this.nodeId);
                APMNodeComponentIDRepository.unRegisterFromNonOffloadComponentIDTable(this.nodeId);
                NodeBTMLogger.nodeLogger.debug("{} {} uses AGENT OFFLOADING COMPUTATION LOGIC", (Object)this.loggerDispStr, (Object)this.reportingName);
            }
            this.isSourceTableFromTempCompID = false;
        } else if (APMNodeComponentIDRepository.isOffloadComponentID(this.nodeId)) {
            this.updateThresholds(modifiedThreshPatterns, this.entity);
            NodeBTMLogger.nodeLogger.debug("{} Trying Agent offload computation on:- '{}' component {}", (Object)this.loggerDispStr, (Object)this.nodeId);
            this.getOffLoadData();
            isOffloadDataCollection = true;
        }
    }

    protected void makePropsList(String[] propsOrder) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (propsOrder.length == 0) {
            this.propsList.add("BTM");
            this.propsList.add(this.entity);
            this.propsList.add(String.valueOf(this.measurePeriod));
        } else {
            String testConfValue = null;
            this.propsList.add("BTM");
            this.propsList.add(this.entity);
            int i = 0;
            while (i < propsOrder.length) {
                testConfValue = this.getValueForParam(propsOrder[i]);
                if (testConfValue != null) {
                    this.propsList.add(testConfValue);
                } else {
                    this.propsList.add("-");
                }
                ++i;
            }
            this.propsList.add(this.nodeId);
            Object var2_2 = null;
        }
        NodeBTMLogger.nodeLogger.debug("{} propsList value is {}", (Object)this.loggerDispStr, (Object)this.propsList);
    }

    @Override
    void checkForPropsChanges(String[] propsOrder) {
        try {
            HashMap<Object, Object> currentPropsTable = new HashMap();
            HashMap modifiedPropsTable = new HashMap();
            HashMap<Object, Object> previousPropsTable = new HashMap();
            if (APMNodeComponentIDRepository.isOffloadComponentID(this.nodeId)) {
                NodePropsManager nodePropsManager = APMNodeWorker.getValueFromPropsManagerTable(this.nodeId);
                HashMap<String, Object> propsData = new HashMap<String, Object>();
                if (nodePropsManager != null) {
                    ArrayList propsValuesByOrder = null;
                    if (this.isFirstTime) {
                        propsValuesByOrder = this.makePropsListForOffload(propsOrder);
                        nodePropsManager.handlePropChangesFromTest(propsValuesByOrder, this.entity);
                        modifiedPropsTable = new HashMap<Object, Object>(nodePropsManager.getBTMprops());
                        NodeBTMLogger.nodeLogger.debug("{}  propsValuesByOrder: {}", (Object)this.loggerDispStr, (Object)propsValuesByOrder);
                        this.isFirstTime = false;
                    } else {
                        previousPropsTable = new HashMap<Object, Object>(nodePropsManager.getBTMprops());
                        propsValuesByOrder = this.makePropsListForOffload(propsOrder);
                        nodePropsManager.handlePropChangesFromTest(propsValuesByOrder, this.entity);
                        currentPropsTable = new HashMap<Object, Object>(nodePropsManager.getBTMprops());
                        modifiedPropsTable = this.getModifiedProps(currentPropsTable, previousPropsTable);
                        NodeBTMLogger.nodeLogger.debug(" {} currentPropsTable: {} ", (Object)this.loggerDispStr, currentPropsTable);
                        NodeBTMLogger.nodeLogger.debug(" {}  propsValuesByOrder: {} ", (Object)this.loggerDispStr, (Object)propsValuesByOrder);
                        NodeBTMLogger.nodeLogger.debug(" {} previousPropsTable: {}", (Object)this.loggerDispStr, previousPropsTable);
                        NodeBTMLogger.nodeLogger.debug(" {}  modifiedPropsTable: {}", (Object)this.loggerDispStr, (Object)modifiedPropsTable);
                    }
                    if (modifiedPropsTable != null && modifiedPropsTable.size() > 0) {
                        propsData.put("ModifiedPropsTable", modifiedPropsTable);
                        propsData.put("Entity", this.entity);
                        propsData.put("PropsValuesByOrder", propsValuesByOrder);
                        if (this.entity.equalsIgnoreCase("NodeTransTest")) {
                            APMNodeComponentIDRepository.registerNewProps(this.nodeId, propsData);
                        } else if (this.entity.equalsIgnoreCase("KNodeTransTest")) {
                            APMNodeComponentIDRepository.registerNewProps("K_" + this.nodeId, propsData);
                        }
                        NodeBTMLogger.nodeLogger.debug("{}  PropsValuesByOrder: {}", (Object)this.loggerDispStr, (Object)propsValuesByOrder);
                    } else {
                        NodeBTMLogger.nodeLogger.debug("{}  No difference in props table:", (Object)this.loggerDispStr);
                    }
                } else {
                    nodePropsManager = new NodePropsManager();
                    nodePropsManager.initProps();
                    ArrayList propsValuesByOrder = this.makePropsListForOffload(propsOrder);
                    nodePropsManager.handlePropChangesFromTest(propsValuesByOrder, this.entity);
                    propsData = new HashMap();
                    propsData.put("Entity", this.entity);
                    propsData.put("PropsValuesByOrder", propsValuesByOrder);
                    propsData.put("ModifiedPropsTable", new HashMap<Object, Object>(nodePropsManager.getBTMprops()));
                    APMNodeWorker.addNewEntryToPropsManagerTable(this.nodeId, nodePropsManager);
                    NodeBTMLogger.nodeLogger.debug("{}  nodePropsManager.getBTMprops() : {}", (Object)this.loggerDispStr, (Object)nodePropsManager.getBTMprops());
                    NodeBTMLogger.nodeLogger.debug("{}  propsData : {}", (Object)this.loggerDispStr, propsData);
                    if (this.entity.equalsIgnoreCase("NodeTransTest")) {
                        APMNodeComponentIDRepository.registerNewProps(this.nodeId, propsData);
                    } else if (this.entity.equalsIgnoreCase("KNodeTransTest")) {
                        APMNodeComponentIDRepository.registerNewProps("K_" + this.nodeId, propsData);
                    }
                    NodeBTMLogger.nodeLogger.debug("{}  PropsValuesByOrder: {}", (Object)this.loggerDispStr, (Object)propsValuesByOrder);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ArrayList makePropsListForOffload(String[] propsOrder) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (propsOrder.length > 0) {
            String testConfValue = null;
            int i = 0;
            while (i < propsOrder.length) {
                testConfValue = this.getValueForParam(propsOrder[i]);
                if (testConfValue != null) {
                    this.propsList.add(testConfValue);
                } else {
                    this.propsList.add("-");
                }
                ++i;
            }
            this.propsList.add(this.nodeId);
            Object var2_2 = null;
        }
        NodeBTMLogger.nodeLogger.debug("{} propsList value is {}", (Object)this.loggerDispStr, (Object)this.propsList);
        return this.propsList;
    }

    public ArrayList getSlowURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.slowURLTable != null && this.slowURLTable.size() > 0) {
            result = (ArrayList)this.slowURLTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getSlowURLDetails returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public ArrayList getErrorURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.errorURLTable != null && this.errorURLTable.size() > 0) {
            result = (ArrayList)this.errorURLTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getErrorURLDetails returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public ArrayList getStalledURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.stalledURLTable != null && this.stalledURLTable.size() > 0) {
            result = (ArrayList)this.stalledURLTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getStalledURLDetails returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public ArrayList getAllURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.allURLTable != null && this.allURLTable.size() > 0) {
            result = (ArrayList)this.allURLTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getAllURLDetails returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public ArrayList getExternalCallDetails(String patDesc) {
        ArrayList result = null;
        if (this.externalTable != null && this.externalTable.size() > 0) {
            result = (ArrayList)this.externalTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getExternalCallDetails returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public Hashtable getStackTraceTable(String patDesc) {
        Hashtable resultTable = null;
        if (this.stackTraceTable != null && this.stackTraceTable.size() > 0) {
            resultTable = (Hashtable)this.stackTraceTable.get(patDesc);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method getStackTraceTable returns : {}", (Object)this.loggerDispStr, resultTable);
        return resultTable;
    }

    public Hashtable DataBaseInfo(String jdbcUrl) {
        Hashtable<Object, Object> result = new Hashtable();
        if (jdbcURLDetails.containsKey(jdbcUrl)) {
            result = jdbcURLDetails.get(jdbcUrl);
        } else {
            result = DataBaseUtils.getDBInfo(jdbcUrl, null, null, NodeBTMLogger.nodeLogger, APMLanguage.NODEJS);
            jdbcURLDetails.put(jdbcUrl, result);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method DataBaseInfo returns : {}", (Object)this.loggerDispStr, result);
        return result;
    }

    public HashMap getSessionUserMapping() {
        return this.sessionUserMapping;
    }

    public void clearSessionUserMapping() {
        if (this.sessionUserMapping != null) {
            this.sessionUserMapping.clear();
        }
        this.sessionUserMapping = null;
    }

    public String getApplicationName() {
        NodeBTMLogger.nodeLogger.debug("{} Method getApplicationName returns : {}", (Object)this.loggerDispStr, (Object)this.applicationName);
        return this.applicationName;
    }

    public void printOut(String msg) {
        System.out.println(String.valueOf(this.toString()) + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + msg);
    }

    public void printErr(String msg) {
        System.err.println(String.valueOf(this.toString()) + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + msg);
    }

    String STEs2Str(StackTraceElement[] STEArr) {
        StringBuffer TraceSB = new StringBuffer();
        int i = 0;
        while (i < STEArr.length) {
            TraceSB.append('\t').append(STEArr[i].toString()).append('\n');
            ++i;
        }
        return TraceSB.toString();
    }

    private long calculateExclusiveTime(NodeMethodInfo methodInfo, HashMap childMap) {
        long childTimes = 0L;
        List<Long> children = methodInfo.getChildMinfos();
        int len = children.size();
        long this_execution_time = methodInfo.getExecutionTime();
        int i = 0;
        while (i < len) {
            Long id = children.get(i);
            NodeMethodInfo childInfo = (NodeMethodInfo)childMap.get(id);
            if (childInfo != null) {
                childTimes += childInfo.getExecutionTime();
            }
            ++i;
        }
        long exclusiveTime = this_execution_time - childTimes;
        if (exclusiveTime < 0L) {
            exclusiveTime = 0L;
        }
        return exclusiveTime;
    }

    private String getUserName(String sessionString, String userName) {
        if (sessionString.equals("-")) {
            return userName;
        }
        if (userName.equals("-") && this.sessionUserMapping != null && this.sessionUserMapping.containsKey(sessionString)) {
            return (String)this.sessionUserMapping.get(sessionString);
        }
        return userName;
    }

    protected Hashtable formatSource(ArrayList sourceList, Hashtable CustomPCTable, String timezone, boolean traceAll) {
        if (sourceList == null || sourceList.isEmpty()) {
            return null;
        }
        Hashtable resultTable = new Hashtable();
        ArrayList resultList = new ArrayList();
        ArrayList extFinalList = new ArrayList();
        int k = 0;
        while (k < sourceList.size()) {
            block58: {
                NodeMethodInfo rootInfo = (NodeMethodInfo)sourceList.get(k);
                if (rootInfo == null) {
                    NodeBTMLogger.nodeLogger.debug("{} rootInfo is NULL ", (Object)this.loggerDispStr);
                } else {
                    String guidWithNodeOrder = null;
                    try {
                        guidWithNodeOrder = rootInfo.getGuidString();
                        NodeBTMLogger.nodeLogger.debug("{}  guidWithNodeOrder {}", (Object)this.loggerDispStr, (Object)guidWithNodeOrder);
                    }
                    catch (Exception exc) {
                        NodeBTMLogger.nodeLogger.error("{} guidWithNodeOrder is NULL in Catch Block ==> {}", (Object)this.loggerDispStr, (Object)exc);
                    }
                    if (guidWithNodeOrder == null) {
                        NodeBTMLogger.nodeLogger.debug("{} guidWithNodeOrder is NULL ", (Object)this.loggerDispStr);
                    } else {
                        int nodeIndex = guidWithNodeOrder.indexOf("#~#");
                        NodeBTMLogger.nodeLogger.debug("{} nodeIndex : {}", (Object)this.loggerDispStr, (Object)nodeIndex);
                        if (nodeIndex >= 0) {
                            String guidString = guidWithNodeOrder.substring(0, nodeIndex);
                            String nodeOrder = guidWithNodeOrder.substring(nodeIndex + 3);
                            String rawURL = rootInfo.getRawURL();
                            String[] splitRawURL = rawURL.split(" @ ");
                            String requestTime = splitRawURL[1];
                            String requestURL = splitRawURL[0];
                            String finalDate = "-";
                            try {
                                Date firstDate = mySDF.parse(requestTime);
                                finalDate = finalFormat.format(firstDate);
                            }
                            catch (Exception e) {
                                NodeBTMLogger.nodeLogger.error("{} Exception while Parsing Date : {} ", (Object)this.loggerDispStr, (Object)e);
                                break block58;
                            }
                            String transType = rootInfo.getType();
                            String requestType = "Web";
                            if (transType != null && transType.equals("THREAD")) {
                                requestType = "Thread";
                            }
                            Map rootMap = rootInfo.getProperties();
                            long exetime = rootInfo.getExecutionTime();
                            Double responseTime = new Double(exetime);
                            String contextName = (String)rootMap.get("CONTEXT");
                            String remoteHost = (String)rootMap.get("remoteHost");
                            String threadGuid = (String)rootMap.get("Thread_GUID");
                            Double slowThreshLimit = (Double)rootMap.get("SlowLimit");
                            Double stalledThreshLimit = (Double)rootMap.get("StalledLimit");
                            String queryString = (String)rootMap.get("QUERYSTRING");
                            String sessionId = (String)rootMap.get("SESSIONID");
                            String threadId = (String)rootMap.get("THREAD");
                            String device2 = (String)rootMap.get("DEVICE");
                            String os = (String)rootMap.get("OS");
                            String browser = (String)rootMap.get("BROWSER");
                            String referer = (String)rootMap.get("REFERER");
                            String country = "-";
                            String location = "-";
                            String postion = "-";
                            String preProcessorTime = "-5.0";
                            String methodType = "-";
                            String httpResponseCode = "-";
                            String headerString = "-";
                            String cookies = "-";
                            String userName = "-";
                            String businessContext = "-";
                            String cpuTime = "-5.0";
                            String waitTime = "-5.0";
                            String blockTime = "-5.0";
                            String serverName = "-";
                            String serverIP = "-";
                            String serverPort = "-";
                            String serverScheme = "-";
                            if (requestType.equals("Web")) {
                                try {
                                    methodType = (String)rootMap.get("METHODTYPE");
                                    if (methodType == null) {
                                        methodType = "-";
                                    }
                                }
                                catch (Exception e) {
                                    NodeBTMLogger.nodeLogger.error("{} Exception while getting HTTP Method Type!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                                }
                                Object responseStatusCode = null;
                                try {
                                    responseStatusCode = rootMap.get("STATUS");
                                }
                                catch (Exception e) {
                                    NodeBTMLogger.nodeLogger.error("{} Exception while getting HTTP Status Code!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                                }
                                if (responseStatusCode != null) {
                                    try {
                                        httpResponseCode = responseStatusCode.toString();
                                    }
                                    catch (Exception e) {
                                        NodeBTMLogger.nodeLogger.error("{} Exception occured while performing type casting for HTTP Status Code, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)e);
                                    }
                                }
                                Hashtable headersData = null;
                                try {
                                    headersData = (Hashtable)rootMap.get("HEADERS");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    NodeBTMLogger.nodeLogger.error("{} Exception while doing type casting for Header Data, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)e);
                                }
                                if (headersData != null && headersData.size() > 0) {
                                    try {
                                        Set cookieKey = headersData.keySet();
                                        Iterator cookieNameItr = cookieKey.iterator();
                                        String cookieName = null;
                                        while (cookieNameItr.hasNext()) {
                                            cookieName = (String)cookieNameItr.next();
                                            if (!cookieName.equalsIgnoreCase("cookie")) continue;
                                            cookies = (String)headersData.remove(cookieName);
                                            break;
                                        }
                                        if (cookies == null) {
                                            cookies = "-";
                                        } else if (cookies.length() > 2000) {
                                            String cookiesSubString = cookies.substring(0, 2000);
                                            cookies = cookiesSubString.substring(0, cookiesSubString.lastIndexOf(59));
                                        }
                                    }
                                    catch (Exception e) {
                                        NodeBTMLogger.nodeLogger.error("{} Exception while getting Cookie Values, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)e);
                                    }
                                    if (headersData != null && headersData.size() > 0) {
                                        headerString = this.getHeaderString(headersData);
                                    }
                                }
                                try {
                                    userName = (String)rootMap.get("Username");
                                    if (userName == null) {
                                        userName = "-";
                                    } else if (userName.length() > 2000) {
                                        userName = String.valueOf(userName.substring(0, 1995)) + "...";
                                    }
                                }
                                catch (Exception e) {
                                    NodeBTMLogger.nodeLogger.error("{} Exception while getting Username!!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)e);
                                }
                                try {
                                    businessContext = (String)rootMap.get("BusinessContext");
                                    if (businessContext == null) {
                                        businessContext = "-";
                                    } else if (businessContext.length() > 2000) {
                                        businessContext = String.valueOf(businessContext.substring(0, 1995)) + "...";
                                    }
                                }
                                catch (Exception e) {
                                    NodeBTMLogger.nodeLogger.error("{} Exception while getting BusinessContext!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                                }
                            }
                            userName = this.getUserName(sessionId, userName);
                            NodeBTMLogger.nodeLogger.debug("{} IC userName is : {}", (Object)this.loggerDispStr, (Object)userName);
                            NodeBTMLogger.nodeLogger.debug("{}  IC businessContext is : {}", (Object)this.loggerDispStr, (Object)businessContext);
                            NodeBTMLogger.nodeLogger.debug("{} HTTP MethodType : {}", (Object)this.loggerDispStr, (Object)methodType);
                            NodeBTMLogger.nodeLogger.debug("{}  HTTP ResponseStatusCode : {}", (Object)this.loggerDispStr, (Object)httpResponseCode);
                            NodeBTMLogger.nodeLogger.debug("{} headerString : {} requestType : {}", new Object[]{this.loggerDispStr, headerString, requestType});
                            NodeBTMLogger.nodeLogger.debug("{} cookies : {}", (Object)this.loggerDispStr, (Object)cookies);
                            HashMap fastSqlDetails = (HashMap)rootMap.get("Fast_Method_Map");
                            NodeBTMLogger.nodeLogger.debug("{} FastSql Map : {}", (Object)this.loggerDispStr, (Object)fastSqlDetails);
                            if (remoteHost.startsWith("127.") || remoteHost.equals("0:0:0:0:0:0:0:1")) {
                                remoteHost = "localhost";
                            }
                            if (threadGuid == null) {
                                threadGuid = "-";
                            }
                            if (queryString.length() > 1024) {
                                queryString = String.valueOf(queryString.substring(0, 1019)) + "...";
                            }
                            if (referer.length() > 2000) {
                                referer = String.valueOf(referer.substring(0, 1995)) + "...";
                            }
                            HashMap childMap = (HashMap)rootMap.get("CHILD_MAP");
                            ArrayList detailsList = this.getDetailsList(rootInfo, CustomPCTable, traceAll, childMap);
                            NodeBTMLogger.nodeLogger.debug("{} detailsList :{}", (Object)this.loggerDispStr, (Object)detailsList);
                            if (detailsList != null && detailsList.size() > 0) {
                                ArrayList extraDetailsList = (ArrayList)detailsList.get(0);
                                if (fastSqlDetails != null && fastSqlDetails.size() > 0) {
                                    Iterator fastSqlItr = fastSqlDetails.keySet().iterator();
                                    while (fastSqlItr.hasNext()) {
                                        StringBuffer fastSqlDetailsBuffer = new StringBuffer();
                                        String jdbcUrl = (String)fastSqlItr.next();
                                        StringBuffer exeTimeList = (StringBuffer)fastSqlDetails.get(jdbcUrl);
                                        String exeTimeListInStr = exeTimeList.toString();
                                        double exeTimeTotal = 0.0;
                                        int sqlCallCount = 0;
                                        StringTokenizer exeTimeToken = new StringTokenizer(exeTimeListInStr, ",");
                                        while (exeTimeToken.hasMoreTokens()) {
                                            String exeTime = exeTimeToken.nextToken();
                                            exeTimeTotal += Double.parseDouble(exeTime);
                                            ++sqlCallCount;
                                        }
                                        fastSqlDetailsBuffer.append("SQL").append("#=#");
                                        fastSqlDetailsBuffer.append("FASTQUERY").append("#=#");
                                        fastSqlDetailsBuffer.append(exeTimeTotal).append("#=#");
                                        fastSqlDetailsBuffer.append(jdbcUrl).append("#=#");
                                        fastSqlDetailsBuffer.append(sqlCallCount).append("#=#");
                                        fastSqlDetailsBuffer.append("-").append("#=#");
                                        fastSqlDetailsBuffer.append("-");
                                        NodeBTMLogger.nodeLogger.debug("{} fastSqlDetailsBuffer to DB : {}", (Object)this.loggerDispStr, (Object)fastSqlDetailsBuffer);
                                        extraDetailsList.add(fastSqlDetailsBuffer);
                                    }
                                }
                                if (extraDetailsList != null && extraDetailsList.size() > 0) {
                                    ArrayList<Object> extCallList = new ArrayList<Object>();
                                    extCallList.add(guidString);
                                    extCallList.add(nodeOrder);
                                    extCallList.add(requestType);
                                    extCallList.add(finalDate);
                                    extCallList.add(new ArrayList(extraDetailsList));
                                    extFinalList.add(extCallList);
                                }
                            }
                            try {
                                Long tmpCpuTime = (Long)rootMap.get("CPU_TIME");
                                Long tmpBlockTime = (Long)rootMap.get("BLOCK_TIME");
                                Long tmpWaitTime = (Long)rootMap.get("WAIT_TIME");
                                if (tmpCpuTime != null && tmpCpuTime >= 0L) {
                                    cpuTime = tmpCpuTime.toString();
                                }
                                if (tmpBlockTime != null && tmpBlockTime >= 0L) {
                                    blockTime = tmpBlockTime.toString();
                                }
                                if (tmpWaitTime != null && tmpWaitTime >= 0L) {
                                    waitTime = tmpWaitTime.toString();
                                }
                            }
                            catch (Exception e) {
                                NodeBTMLogger.nodeLogger.error("{} Exception while getting Thread Transaction Timings !!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                            requestURL = NodeTransTestBase.decodeUrlString(requestURL, this.loggerDispStr);
                            queryString = NodeTransTestBase.decodeUrlString(queryString, this.loggerDispStr);
                            referer = NodeTransTestBase.decodeUrlString(referer, this.loggerDispStr);
                            if (queryString.length() > 1024) {
                                queryString = String.valueOf(queryString.substring(0, 1019)) + "...";
                            }
                            if (referer.length() > 2000) {
                                referer = String.valueOf(referer.substring(0, 1995)) + "...";
                            }
                            String callGraphString = (String)rootMap.get("callTrace");
                            ArrayList<Object> dataList = new ArrayList<Object>();
                            dataList.add(guidString);
                            dataList.add(nodeOrder);
                            dataList.add(this.applicationName);
                            dataList.add(contextName);
                            dataList.add(finalDate);
                            dataList.add(threadGuid);
                            dataList.add(requestURL);
                            dataList.add(responseTime);
                            dataList.add(timezone);
                            dataList.add(remoteHost);
                            dataList.add(requestType);
                            dataList.add(transType);
                            dataList.add(slowThreshLimit);
                            dataList.add(stalledThreshLimit);
                            dataList.add(queryString);
                            dataList.add(sessionId);
                            dataList.add(threadId);
                            dataList.add(device2);
                            dataList.add(os);
                            dataList.add(browser);
                            dataList.add(referer);
                            dataList.add(country);
                            dataList.add(location);
                            dataList.add(postion);
                            dataList.add(callGraphString);
                            dataList.add(preProcessorTime);
                            dataList.add(methodType);
                            dataList.add(httpResponseCode);
                            dataList.add(cookies);
                            dataList.add(headerString);
                            dataList.add(userName);
                            dataList.add(businessContext);
                            if (this.measureCount > 23) {
                                dataList.add(cpuTime);
                                dataList.add(waitTime);
                                dataList.add(blockTime);
                            }
                            resultList.add(dataList);
                        }
                    }
                }
            }
            ++k;
        }
        resultTable.put("DD", resultList);
        resultTable.put("EXTRA", extFinalList);
        NodeBTMLogger.nodeLogger.debug("{} Result Table : {}", (Object)this.loggerDispStr, resultTable);
        return resultTable;
    }

    private String getHeaderString(Hashtable headersData) {
        StringBuffer headerBuffer = null;
        try {
            Set headerKeys = headersData.keySet();
            Iterator headerIterator = headerKeys.iterator();
            if (headerKeys.size() > 0) {
                headerBuffer = new StringBuffer();
                int dbSize = 2000;
                while (headerIterator.hasNext()) {
                    int valueSize;
                    String key = (String)headerIterator.next();
                    String value = (String)headersData.get(key);
                    int keySize = key.length();
                    int totalSize = keySize + (valueSize = value.length()) + 2;
                    if (totalSize < dbSize) {
                        headerBuffer.append(key);
                        headerBuffer.append("=");
                        headerBuffer.append(value);
                        headerBuffer.append("#~#");
                        dbSize -= totalSize;
                        continue;
                    }
                    NodeBTMLogger.nodeLogger.error("{} Header size too big ! Header Name........: {}", (Object)this.loggerDispStr, (Object)key);
                }
            } else {
                headerBuffer = new StringBuffer();
                headerBuffer.append("-");
            }
        }
        catch (Exception e) {
            NodeBTMLogger.nodeLogger.error("{} Exception occured while iterating header data : {}", (Object)this.loggerDispStr, (Object)e);
        }
        return headerBuffer.toString();
    }

    private ArrayList getDetailsList(NodeMethodInfo rootInfo, Hashtable customPCTable, boolean traceAll, HashMap childMap) {
        HashMap levelMap = this.prepareOrderMap(rootInfo, childMap);
        boolean isEjbHideChild = false;
        long ejbParentExecutionTime = 0L;
        String ejbParentKeyString = null;
        StringBuffer callGraphBuffer = null;
        ArrayList resultList = null;
        if (levelMap != null && levelMap.size() > 0) {
            Set levelKeys = levelMap.keySet();
            ArrayList sortedKeys = new ArrayList(levelKeys);
            Collections.sort(sortedKeys, new AlphanumComparator());
            int levelSize = sortedKeys.size();
            Iterator itr = sortedKeys.iterator();
            int level = 1;
            callGraphBuffer = new StringBuffer();
            resultList = new ArrayList();
            ArrayList<StringBuffer> extraDetailsList = new ArrayList<StringBuffer>();
            while (itr.hasNext()) {
                StringBuffer extCallBuffer;
                block68: {
                    String customPointCutDisplayName;
                    String queueName;
                    String jmsProvider;
                    String targetUrl;
                    String responseMessage;
                    String keyString = (String)itr.next();
                    NodeMethodInfo tempInfo = (NodeMethodInfo)levelMap.get(keyString);
                    String methodType = tempInfo.getType();
                    long executionTime = tempInfo.getExecutionTime();
                    extCallBuffer = null;
                    if (methodType.equals("SQL")) {
                        String sqlStmt = (String)tempInfo.getProperties().get("sqlStmt");
                        String jdbcUrl = (String)tempInfo.getProperties().get("jdbcUrl");
                        String sqlError = (String)tempInfo.getProperties().get("sqlError");
                        String expLines = (String)tempInfo.getProperties().get("stackTrace");
                        String formattedQueryString = NodeTransTestBase.prepQryForUI(sqlStmt);
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(jdbcUrl);
                        extCallBuffer.append("#=#").append(formattedQueryString);
                        extCallBuffer.append("#=#").append(sqlError);
                        extCallBuffer.append("#=#").append(expLines);
                    } else if (methodType.equals("EXCEPTION")) {
                        String excpnStr = (String)tempInfo.getProperties().get("EXCEPTION");
                        if (excpnStr != null && excpnStr.length() > 0 && excpnStr.indexOf("?^?") > 0) {
                            extCallBuffer = new StringBuffer();
                            extCallBuffer.append(methodType).append("#=#").append(keyString);
                            extCallBuffer.append("#=#").append(executionTime);
                            extCallBuffer.append("#=#").append(excpnStr.substring(0, excpnStr.indexOf("?^?")));
                            extCallBuffer.append("#=#").append(excpnStr);
                        }
                    } else if (methodType.equals("HTTP") || methodType.equals("HTTPStream") || methodType.equals("HttpConn")) {
                        String extUrl = null;
                        String doMethod = null;
                        String callOrder = null;
                        String statusCode = null;
                        responseMessage = null;
                        if (tempInfo.getProperties() != null) {
                            extUrl = (String)tempInfo.getProperties().get("EXTURL");
                            doMethod = (String)tempInfo.getProperties().get("METHOD");
                            callOrder = (String)tempInfo.getProperties().get("NODE_ORDER");
                            statusCode = (String)tempInfo.getProperties().get("SC");
                            responseMessage = (String)tempInfo.getProperties().get("RM");
                        }
                        if (callOrder == null) {
                            callOrder = "-";
                        }
                        if (extUrl == null) {
                            extUrl = "-";
                        }
                        if (doMethod == null) {
                            doMethod = "-";
                        }
                        if (statusCode == null) {
                            statusCode = "-";
                        }
                        if (responseMessage == null) {
                            responseMessage = "-";
                        }
                        if (!extUrl.equals("-")) {
                            extCallBuffer = new StringBuffer();
                            extCallBuffer.append(methodType).append("#=#").append(keyString);
                            extCallBuffer.append("#=#").append(executionTime);
                            extCallBuffer.append("#=#").append(extUrl);
                            extCallBuffer.append("#=#").append(doMethod);
                            extCallBuffer.append("#=#").append(callOrder);
                            extCallBuffer.append("#=#").append(statusCode);
                            extCallBuffer.append("#=#").append(responseMessage);
                        }
                    } else if (methodType.equals("WEBSERVICE")) {
                        targetUrl = (String)tempInfo.getProperties().get("TargetUrl");
                        String operationName = (String)tempInfo.getProperties().get("OperationName");
                        if (operationName.indexOf("[*#*]") > -1) {
                            String secondPart;
                            int extindex = operationName.indexOf("[*#*]");
                            String firstPart = operationName.substring(0, extindex);
                            int index = firstPart.lastIndexOf("/}");
                            if (index > -1) {
                                firstPart = firstPart.substring(index + 2, firstPart.length());
                            }
                            if ((index = (secondPart = operationName.substring(extindex, operationName.length())).lastIndexOf("/}")) > -1) {
                                secondPart = secondPart.substring(index + 2, secondPart.length());
                            }
                            operationName = String.valueOf(firstPart) + "." + secondPart;
                        }
                        String callOrder = (String)tempInfo.getProperties().get("NODE_ORDER");
                        String statusCode = (String)tempInfo.getProperties().get("SC");
                        responseMessage = (String)tempInfo.getProperties().get("RM");
                        if (callOrder == null) {
                            callOrder = "-";
                        }
                        if (statusCode == null) {
                            statusCode = "-";
                        }
                        if (responseMessage == null) {
                            responseMessage = "-";
                        }
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(targetUrl);
                        extCallBuffer.append("#=#").append(operationName);
                        extCallBuffer.append("#=#").append(callOrder);
                        extCallBuffer.append("#=#").append(statusCode);
                        extCallBuffer.append("#=#").append(responseMessage);
                    } else if (methodType.startsWith("EJB")) {
                        if (methodType.equalsIgnoreCase("EJB")) {
                            ejbParentExecutionTime = executionTime;
                            ejbParentKeyString = keyString;
                            isEjbHideChild = true;
                        } else {
                            methodType = "EJB";
                            String ejbHost = (String)tempInfo.getProperties().get("ejbhost");
                            String invokedMethod = (String)tempInfo.getProperties().get("method");
                            String ejbMethod = NodeTransTestBase.getEjbMethodName(invokedMethod);
                            if (ejbHost == null) {
                                ejbHost = "-";
                                ejbMethod = "-";
                            } else if (ejbHost != null && !ejbHost.contains("://") && ejbHost.lastIndexOf(47) > -1) {
                                ejbHost = ejbHost.substring(ejbHost.lastIndexOf(47) + 1);
                            }
                            try {
                                if (isEjbHideChild) {
                                    isEjbHideChild = false;
                                    extCallBuffer = new StringBuffer();
                                    extCallBuffer.append(methodType).append("#=#").append(ejbParentKeyString);
                                    extCallBuffer.append("#=#").append(ejbParentExecutionTime);
                                    extCallBuffer.append("#=#").append(ejbHost);
                                    extCallBuffer.append("#=#").append(ejbMethod);
                                    break block68;
                                }
                                extCallBuffer = new StringBuffer();
                                extCallBuffer.append(methodType).append("#=#").append(keyString);
                                extCallBuffer.append("#=#").append(executionTime);
                                extCallBuffer.append("#=#").append(ejbHost);
                                extCallBuffer.append("#=#").append(ejbMethod);
                            }
                            catch (Exception e) {
                                NodeBTMLogger.nodeLogger.error("{} Exception in [NodeTransTestBase] [getDetailsList] {}", (Object)this.loggerDispStr, (Object)e);
                            }
                        }
                    } else if (methodType.equals("RMI")) {
                        targetUrl = (String)tempInfo.getProperties().get("host");
                        String protocol = (String)tempInfo.getProperties().get("protocol");
                        try {
                            if (targetUrl != null) {
                                int startBracketIndex = targetUrl.indexOf(91) + 1;
                                int endBracketIndex = targetUrl.lastIndexOf(93);
                                targetUrl = targetUrl.substring(startBracketIndex, endBracketIndex);
                            }
                            extCallBuffer = new StringBuffer();
                            extCallBuffer.append(methodType).append("#=#").append(keyString);
                            extCallBuffer.append("#=#").append(executionTime);
                            extCallBuffer.append("#=#").append(targetUrl);
                            extCallBuffer.append("#=#").append(protocol);
                        }
                        catch (Exception e) {
                            NodeBTMLogger.nodeLogger.error("{} Exception in getDetailsList while preparing data for RMI : {}", (Object)this.loggerDispStr, (Object)e);
                        }
                    } else if (methodType.equals("RUNTIME")) {
                        String command = (String)tempInfo.getProperties().get("COMMAND");
                        try {
                            extCallBuffer = new StringBuffer();
                            extCallBuffer.append(methodType).append("#=#").append(keyString);
                            extCallBuffer.append("#=#").append(executionTime);
                            extCallBuffer.append("#=#").append(command);
                        }
                        catch (Exception e) {
                            NodeBTMLogger.nodeLogger.error("{} Exception in getDetailsList while preparing data for Runtime : {} ", (Object)this.loggerDispStr, (Object)e);
                        }
                    } else if (methodType.equals("EMAIL") || methodType.equals("LDAP")) {
                        String methodName = (String)tempInfo.getProperties().get("method");
                        String endPoint = (String)tempInfo.getProperties().get("endPoint");
                        try {
                            if (methodType.equals("LDAP")) {
                                methodName = NodeTransTestBase.getLdapDisplayMethodName(methodName);
                            } else {
                                endPoint = this.getEmailEndPoint(endPoint);
                            }
                            extCallBuffer = new StringBuffer();
                            extCallBuffer.append(methodType).append("#=#").append(keyString);
                            extCallBuffer.append("#=#").append(executionTime);
                            extCallBuffer.append("#=#").append(methodName);
                            extCallBuffer.append("#=#").append(endPoint);
                        }
                        catch (Exception e) {
                            NodeBTMLogger.nodeLogger.error("{} Exception in getDetailsList while preparing data for EMAIL/LDAP  : {}", (Object)this.loggerDispStr, (Object)e);
                        }
                    } else if (methodType.equals("JMS")) {
                        jmsProvider = (String)tempInfo.getProperties().get("JMS-PROVIDER");
                        queueName = (String)tempInfo.getProperties().get("JMS-QUEUE");
                        String jmsType = (String)tempInfo.getProperties().get("TYPE");
                        String callOrder = (String)tempInfo.getProperties().get("NODE_ORDER");
                        if (callOrder == null) {
                            callOrder = "-";
                        }
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(jmsProvider);
                        extCallBuffer.append("#=#").append(queueName);
                        extCallBuffer.append("#=#").append(jmsType);
                        extCallBuffer.append("#=#").append(callOrder);
                    } else if (methodType.equals("JMS_ENTRY")) {
                        jmsProvider = (String)tempInfo.getProperties().get("JMS-PROVIDER");
                        queueName = (String)tempInfo.getProperties().get("JMS-QUEUE");
                        String jmsType = (String)tempInfo.getProperties().get("TYPE");
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(jmsProvider);
                        extCallBuffer.append("#=#").append(queueName);
                        extCallBuffer.append("#=#").append(jmsType);
                    } else if (methodType.equals("SAP JCO")) {
                        Map sapMap = tempInfo.getProperties();
                        String ASHost = (String)sapMap.get("ASHost");
                        String Client2 = (String)sapMap.get("CLIENT");
                        String GWHost = (String)sapMap.get("GWHost");
                        String GWServ = (String)sapMap.get("GWServ");
                        String MSHost = (String)sapMap.get("MSHost");
                        String Group = (String)sapMap.get("Group");
                        String systemID = (String)sapMap.get("SystemID");
                        String systemNo = (String)sapMap.get("SystemNo");
                        String TPName = (String)sapMap.get("TPName");
                        String URL2 = (String)sapMap.get("URL");
                        String JCOFunction = (String)sapMap.get("JCOFunction");
                        String userName = (String)sapMap.get("User");
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(ASHost);
                        extCallBuffer.append("#=#").append(systemNo);
                        extCallBuffer.append("#=#").append(systemID);
                        extCallBuffer.append("#=#").append(userName);
                        extCallBuffer.append("#=#").append(Client2);
                        extCallBuffer.append("#=#").append(JCOFunction);
                        extCallBuffer.append("#=#").append(Group);
                        extCallBuffer.append("#=#").append(URL2);
                        extCallBuffer.append("#=#").append(TPName);
                        extCallBuffer.append("#=#").append(GWHost);
                        extCallBuffer.append("#=#").append(GWServ);
                        extCallBuffer.append("#=#").append(MSHost);
                    } else if (methodType.equals("MONGODB")) {
                        String mongoHost = "localhost";
                        String mongoPort = "27017";
                        String mongoServerObj = (String)tempInfo.getProperties().get("mongoServerDetails");
                        int hostPortIdx = mongoServerObj.indexOf(":");
                        if (hostPortIdx > -1) {
                            mongoHost = mongoServerObj.substring(0, hostPortIdx);
                            mongoPort = mongoServerObj.substring(hostPortIdx + 1);
                        }
                        String mongoDbName = (String)tempInfo.getProperties().get("mongoDBName");
                        String mongoTableName = (String)tempInfo.getProperties().get("mongoTableName");
                        String mongoMethodName = (String)tempInfo.getProperties().get("mongoMethodName");
                        String mongoQuery = (String)tempInfo.getProperties().get("mongoQuery");
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(mongoHost);
                        extCallBuffer.append("#=#").append(mongoPort);
                        extCallBuffer.append("#=#").append(mongoDbName);
                        extCallBuffer.append("#=#").append(mongoTableName);
                        extCallBuffer.append("#=#").append(mongoMethodName);
                        extCallBuffer.append("#=#").append(mongoQuery);
                    } else if (methodType.equals("REDIS")) {
                        String redisIP = (String)tempInfo.getProperties().get("redisIP");
                        String redisPort = (String)tempInfo.getProperties().get("redisPort");
                        String redisDetails = (String)tempInfo.getProperties().get("redisDetails");
                        HashMap<String, String> redisDetailsMap = new HashMap<String, String>();
                        if (redisDetails.contains(",")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(redisDetails, ",");
                            while (stringTokenizer.hasMoreElements()) {
                                String redisDBAndCommand = (String)stringTokenizer.nextElement();
                                NodeTransTestBase.retriveRedisDBAndCommand(redisDBAndCommand, redisDetailsMap);
                            }
                        } else {
                            NodeTransTestBase.retriveRedisDBAndCommand(redisDetails, redisDetailsMap);
                        }
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(redisIP);
                        extCallBuffer.append("#=#").append(redisPort);
                        if (redisDetailsMap != null && redisDetailsMap.size() >= 1) {
                            for (String key : redisDetailsMap.keySet()) {
                                extCallBuffer.append("#=#").append(key);
                                extCallBuffer.append("#=#").append((String)redisDetailsMap.get(key));
                            }
                        }
                    } else if (methodType.startsWith("Custom_") && (customPointCutDisplayName = (String)customPCTable.get(methodType)) != null && customPointCutDisplayName.length() > 0) {
                        extCallBuffer = new StringBuffer();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(customPointCutDisplayName);
                    }
                }
                if (extCallBuffer != null) {
                    NodeBTMLogger.nodeLogger.debug("{} extCallBuffer :  {}", (Object)this.loggerDispStr, (Object)extCallBuffer.toString());
                    extraDetailsList.add(extCallBuffer);
                }
                ++level;
            }
            NodeBTMLogger.nodeLogger.debug("{} callGraphBuffer :  {}", (Object)this.loggerDispStr, (Object)callGraphBuffer.toString());
            resultList.add(extraDetailsList);
        }
        NodeBTMLogger.nodeLogger.debug("{} resultList : {}", (Object)this.loggerDispStr, resultList);
        return resultList;
    }

    protected String getEmailEndPoint(String endPoint) {
        try {
            if (endPoint != null && endPoint.length() > 1) {
                StringBuffer tempURL = new StringBuffer();
                URLName urlName = new URLName(endPoint);
                String protocolName = urlName.getProtocol();
                String hostName = urlName.getHost();
                int portNumber = urlName.getPort();
                if (protocolName != null) {
                    tempURL.append(protocolName);
                    tempURL.append("://");
                }
                if (hostName != null) {
                    tempURL.append(hostName);
                }
                if (portNumber != -1) {
                    tempURL.append(":");
                    tempURL.append(portNumber);
                }
                return tempURL.toString();
            }
        }
        catch (Exception e) {
            NodeBTMLogger.nodeLogger.error("{} Exception occurred while retriving Email EndPoint {}", (Object)this.loggerDispStr, (Object)e);
        }
        return "-";
    }

    private static Map retriveRedisDBAndCommand(String redisDetails, Map<String, String> redisDetailsMap) {
        int indexHash = redisDetails.indexOf("#");
        String redisDB = redisDetails.substring(0, indexHash);
        String commandName = redisDetails.substring(indexHash + 1, redisDetails.length());
        if (redisDetailsMap.containsKey(redisDB)) {
            String cmd = redisDetailsMap.get(redisDB);
            String newCmd = String.valueOf(commandName) + "," + cmd;
            redisDetailsMap.put(redisDB, newCmd);
        } else {
            redisDetailsMap.put(redisDB, commandName);
        }
        return redisDetailsMap;
    }

    private static String getLdapDisplayMethodName(String fullyQualMethod) {
        String ldapMethodDisplayName = "-";
        if (ldapMethodMapping != null && ldapMethodMapping.containsKey(fullyQualMethod)) {
            ldapMethodDisplayName = ldapMethodMapping.get(fullyQualMethod);
        } else if (fullyQualMethod != null && fullyQualMethod.indexOf(93) > -1) {
            ldapMethodDisplayName = "LDAP " + fullyQualMethod.substring(fullyQualMethod.indexOf(93) + 1);
        }
        return ldapMethodDisplayName;
    }

    private static String getEjbMethodName(String invokedMethod) {
        String result = "";
        if (invokedMethod != null && invokedMethod.length() > 0) {
            try {
                String ejbMethodParams = invokedMethod.substring(invokedMethod.lastIndexOf(40));
                String invokedMethodWithoutParams = invokedMethod.substring(0, invokedMethod.lastIndexOf(40));
                int lastDotIndexValue = invokedMethodWithoutParams.lastIndexOf(46);
                String ejbMethodWithoutLastDotPart = invokedMethodWithoutParams.substring(0, lastDotIndexValue);
                String ejbMethodLastPart = invokedMethodWithoutParams.substring(invokedMethodWithoutParams.lastIndexOf(46));
                String ejbMethodLastSecondPart = ejbMethodWithoutLastDotPart.substring(ejbMethodWithoutLastDotPart.lastIndexOf(46) + 1);
                result = String.valueOf(ejbMethodLastSecondPart) + ejbMethodLastPart;
            }
            catch (Exception ex) {
                NodeBTMLogger.nodeLogger.error("Exception in [NodeTransTestBase] [getEjbMethodName] {}", (Throwable)ex);
            }
        }
        return result;
    }

    private static StringBuffer getMethodDisplayName(NodeMethodInfo methodInfo, String methodType) {
        StringBuffer methodDisplayName = null;
        String asyncGuid = null;
        if (methodInfo != null) {
            String className = methodInfo.getClassName();
            String methodName = methodInfo.getMethodName();
            String desc = methodInfo.getDesc();
            String threadName = null;
            if (methodType.equals("THREAD_INIT") && desc != null && desc.indexOf(" [ASYNC]-") > 0) {
                asyncGuid = desc.substring(desc.indexOf(" [ASYNC]-") + 1);
                int index = desc.indexOf("[#");
                if (index > 0) {
                    threadName = desc.substring(desc.indexOf("[#") + 2, desc.indexOf("#] "));
                    desc = desc.substring(0, desc.indexOf("[#"));
                }
            }
            String dotClassName = className.replace("/", ".");
            String paramNames = NodeTransTestBase.getParamNames(desc.trim());
            methodDisplayName = new StringBuffer();
            methodDisplayName.append(dotClassName);
            methodDisplayName.append(".");
            methodDisplayName.append(methodName);
            methodDisplayName.append("(");
            methodDisplayName.append(paramNames);
            methodDisplayName.append(")");
            if (threadName != null) {
                methodDisplayName.append(" [").append(threadName).append("] ");
            }
            if (asyncGuid != null) {
                methodDisplayName.append(asyncGuid);
            }
        }
        return methodDisplayName;
    }

    private static String prepQryForUI(String inQry) {
        String tempQry;
        if (inQry == null) {
            return "NULL";
        }
        if (inQry.indexOf(10) == -1) {
            tempQry = inQry;
        } else {
            StringTokenizer myTokenizer = new StringTokenizer(inQry, "\n");
            StringBuffer myBuffer = new StringBuffer();
            int tokCount = myTokenizer.countTokens();
            int k = 0;
            while (k < tokCount) {
                String myToken = myTokenizer.nextToken();
                if (myToken != null && myToken.length() > 0) {
                    myBuffer.append(myToken.trim());
                    myBuffer.append(' ');
                }
                ++k;
            }
            tempQry = myBuffer.toString();
        }
        if (tempQry.indexOf(",N'") != -1) {
            return tempQry.replaceAll(",N'", ",'");
        }
        return tempQry;
    }

    private static String getParamNames(String descString) {
        StringBuffer paramString = new StringBuffer();
        Type[] paramTypes = Type.getArgumentTypes(descString);
        int paramLen = paramTypes.length;
        int k = 0;
        while (k < paramLen) {
            Type tp = paramTypes[k];
            String internalName = "";
            internalName = tp.equals(Type.BOOLEAN_TYPE) ? "boolean" : (tp.equals(Type.BYTE_TYPE) ? "byte" : (tp.equals(Type.CHAR_TYPE) ? "char" : (tp.equals(Type.SHORT_TYPE) ? "short" : (tp.equals(Type.INT_TYPE) ? "int" : (tp.equals(Type.LONG_TYPE) ? "long" : (tp.equals(Type.FLOAT_TYPE) ? "float" : (tp.equals(Type.DOUBLE_TYPE) ? "double" : (tp.equals(Type.VOID_TYPE) ? "void" : tp.getInternalName()))))))));
            int lastIndex = internalName.lastIndexOf(47);
            if (lastIndex > 0) {
                String paramClassName = internalName.substring(lastIndex + 1);
                paramString.append(String.valueOf(paramClassName) + ",");
            } else {
                paramString.append(String.valueOf(internalName) + ",");
            }
            ++k;
        }
        String resultParam = paramString.toString();
        int index = resultParam.lastIndexOf(44);
        if (index > 0) {
            resultParam = resultParam.substring(0, index);
        }
        return resultParam;
    }

    private HashMap prepareOrderMap(NodeMethodInfo rootInfo, HashMap childMap) {
        HashMap<String, NodeMethodInfo> levelMap = new HashMap<String, NodeMethodInfo>();
        try {
            Stack<NodeMethodInfo> blocks = new Stack<NodeMethodInfo>();
            NodeMethodInfo thisInfo = rootInfo;
            blocks.push(thisInfo);
            HashMap<NodeMethodInfo, String> orderMap = new HashMap<NodeMethodInfo, String>();
            orderMap.put(thisInfo, "0");
            levelMap.put("0", thisInfo);
            ArrayList<NodeMethodInfo> hideInfo = new ArrayList<NodeMethodInfo>();
            while (!blocks.isEmpty()) {
                String orderString;
                block36: {
                    thisInfo = (NodeMethodInfo)blocks.pop();
                    if (hideInfo.contains(thisInfo)) continue;
                    orderString = (String)orderMap.get(thisInfo);
                    String methodType = thisInfo.getType();
                    if (methodType.equals("WEBSERVICE")) {
                        boolean isExceptionPresent = false;
                        ArrayList<Long> expMethodInfoIdList = new ArrayList<Long>();
                        ArrayList tempChildIdList = (ArrayList)thisInfo.getChildMinfos();
                        try {
                            int k = 0;
                            while (k < tempChildIdList.size()) {
                                Long methodId = (Long)tempChildIdList.get(k);
                                NodeMethodInfo hideMInfo = (NodeMethodInfo)childMap.get(methodId);
                                String hideMInfoType = hideMInfo.getType();
                                if (hideMInfoType.equals("HTTP")) {
                                    try {
                                        String callOrder = (String)hideMInfo.getProperties().get("NODE_ORDER");
                                        String statusCode = (String)hideMInfo.getProperties().get("SC");
                                        String responseMsg = (String)hideMInfo.getProperties().get("RM");
                                        if (callOrder == null) {
                                            callOrder = "-";
                                        }
                                        if (statusCode == null) {
                                            statusCode = "-";
                                        }
                                        if (responseMsg == null) {
                                            responseMsg = "-";
                                        }
                                        thisInfo.getProperties().put("NODE_ORDER", callOrder);
                                        thisInfo.getProperties().put("SC", statusCode);
                                        thisInfo.getProperties().put("RM", responseMsg);
                                    }
                                    catch (Exception e) {
                                        NodeBTMLogger.nodeLogger.error("{} Error Occured in prepareOrderMap : {}", (Object)this.loggerDispStr, (Object)e);
                                    }
                                    ArrayList tempHttpChild = (ArrayList)hideMInfo.getChildMinfos();
                                    int tempHttpChildSize = tempHttpChild.size();
                                    int j = 0;
                                    while (j < tempHttpChildSize) {
                                        Long httpInfoId = (Long)tempHttpChild.get(j);
                                        NodeMethodInfo httpChildMInfo = (NodeMethodInfo)childMap.get(httpInfoId);
                                        String httpChildMInfoType = httpChildMInfo.getType();
                                        if (httpChildMInfoType.equals("EXCEPTION")) {
                                            expMethodInfoIdList.add(httpChildMInfo.getId());
                                            isExceptionPresent = true;
                                        }
                                        ++j;
                                    }
                                    hideInfo.add(hideMInfo);
                                } else if (hideMInfoType.equals("EXCEPTION")) {
                                    expMethodInfoIdList.add(hideMInfo.getId());
                                    isExceptionPresent = true;
                                    hideInfo.add(hideMInfo);
                                } else {
                                    expMethodInfoIdList.add(hideMInfo.getId());
                                    isExceptionPresent = true;
                                }
                                ++k;
                            }
                            if (tempChildIdList != null) {
                                tempChildIdList.clear();
                            }
                        }
                        catch (Exception e) {
                            NodeBTMLogger.nodeLogger.error("{} Error while clearing WebService/ HTTP ChildInfos : {}", (Object)this.loggerDispStr, (Object)e);
                        }
                        if (!isExceptionPresent) continue;
                        tempChildIdList.addAll(expMethodInfoIdList);
                    } else if (methodType.equals("EMAIL")) {
                        ArrayList tempChildIdList = (ArrayList)thisInfo.getChildMinfos();
                        if (tempChildIdList.size() == 1) {
                            Long methodId = (Long)tempChildIdList.get(0);
                            NodeMethodInfo emailChildMethod = (NodeMethodInfo)childMap.get(methodId);
                            String emailChildMethodType = emailChildMethod.getType();
                            if (hideInfo.contains(emailChildMethod)) continue;
                            if (emailChildMethodType.equals("EMAIL")) {
                                String emailUrl = (String)emailChildMethod.getProperties().get("endPoint");
                                if (emailUrl == null) {
                                    emailUrl = "-";
                                }
                                thisInfo.getProperties().put("endPoint", emailUrl);
                            }
                        }
                    } else if (methodType.equals("SQL")) {
                        try {
                            ArrayList tempChildIdList = (ArrayList)thisInfo.getChildMinfos();
                            if (tempChildIdList == null || tempChildIdList.size() <= 0) break block36;
                            ArrayList<Long> expMethodInfoList = new ArrayList<Long>();
                            int k = 0;
                            while (k < tempChildIdList.size()) {
                                String transType;
                                Long methodId = (Long)tempChildIdList.get(k);
                                NodeMethodInfo hideMInfo = (NodeMethodInfo)childMap.get(methodId);
                                if (hideMInfo != null && ((transType = hideMInfo.getType()).equals("EXCEPTION") || transType.equals("THREAD_INIT"))) {
                                    expMethodInfoList.add(hideMInfo.getId());
                                }
                                ++k;
                            }
                            try {
                                if (tempChildIdList != null) {
                                    tempChildIdList.clear();
                                }
                            }
                            catch (Exception err) {
                                NodeBTMLogger.nodeLogger.error("{} Error while clearing SQL ChildInfos : {}", (Object)this.loggerDispStr, (Object)err);
                            }
                            NodeBTMLogger.nodeLogger.debug("{} expMethodInfoList    : {}", (Object)this.loggerDispStr, expMethodInfoList);
                            if (expMethodInfoList.size() > 0) {
                                tempChildIdList.addAll(expMethodInfoList);
                            }
                        }
                        catch (Exception e) {
                            NodeBTMLogger.nodeLogger.error("{} Exception occured due to : {}", (Object)this.loggerDispStr, (Object)e);
                        }
                    }
                }
                ArrayList childIDList = (ArrayList)thisInfo.getChildMinfos();
                NodeBTMLogger.nodeLogger.debug(String.valueOf(this.loggerDispStr) + " childIDList  : " + childIDList);
                if (childIDList == null || childIDList.size() <= 0) continue;
                int k = 0;
                while (k < childIDList.size()) {
                    Long childId = (Long)childIDList.get(k);
                    NodeMethodInfo tempInfo = (NodeMethodInfo)childMap.get(childId);
                    if (!tempInfo.equals(thisInfo)) {
                        blocks.push(tempInfo);
                        orderMap.put(tempInfo, String.valueOf(orderString) + "." + k);
                        levelMap.put(String.valueOf(orderString) + "." + k, tempInfo);
                    }
                    ++k;
                }
            }
            blocks = null;
        }
        catch (Exception e) {
            NodeBTMLogger.nodeLogger.error("{} Error Occured in prepareOrderMap : {}", (Object)this.loggerDispStr, (Object)e);
        }
        NodeBTMLogger.nodeLogger.debug("{} Method prepareOrderMap returns  : {}", (Object)this.loggerDispStr, levelMap);
        return levelMap;
    }

    public static String decodeUrlString(String encodedUrlString, String loggerDispString) {
        String decodedUrlString = encodedUrlString;
        if (encodedUrlString != null) {
            try {
                decodedUrlString = URLDecoder.decode(encodedUrlString, "UTF-8");
            }
            catch (Exception e) {
                NodeBTMLogger.nodeLogger.warn("{} Decoding fails for the string : {}", (Object)loggerDispString, (Object)encodedUrlString);
                NodeBTMLogger.nodeLogger.error("{} Exception occured while decoding the string : {} {}", new Object[]{loggerDispString, encodedUrlString, e});
            }
        }
        return decodedUrlString;
    }

    private void computeBTMData(Hashtable sourceTable) {
        NodeBTMLogger.nodeLogger.debug("{} {} DataBaseHT ==> {}", new Object[]{this.loggerDispStr, this.entity, this.DataBaseHT});
        this.sessionUserMapping = (HashMap)this.DataBaseHT.get(SESSION_USER_KEY);
        Set levelKeys = sourceTable.keySet();
        Iterator levelItr = levelKeys.iterator();
        long testFrequency = this.measurePeriod / 1000L / 60L;
        boolean isCPUTimeNotSupported = false;
        boolean isBlockedWaitedTimeNotSupported = false;
        String cpuTimeNotSupported = (String)this.DataBaseHT.get("cpuTimeNotSupported");
        String blockedWaitedTimeNotSupported = (String)this.DataBaseHT.get("blockedWaitedTimeNotSupported");
        if (cpuTimeNotSupported != null && cpuTimeNotSupported.equalsIgnoreCase("true")) {
            isCPUTimeNotSupported = true;
        }
        if (blockedWaitedTimeNotSupported != null && blockedWaitedTimeNotSupported.equalsIgnoreCase("true")) {
            isBlockedWaitedTimeNotSupported = true;
        }
        while (levelItr.hasNext()) {
            boolean summaryData = false;
            String levelString = (String)levelItr.next();
            Hashtable levelTable = (Hashtable)sourceTable.get(levelString);
            NodeBTMLogger.nodeLogger.debug("{}  {} levelString ==> {} [levelTable ==>] {}", new Object[]{this.loggerDispStr, this.entity, levelString, levelTable});
            if (levelTable == null || levelTable.size() <= 0) continue;
            ArrayList resultList = (ArrayList)levelTable.get("patternData");
            if (levelString.equals("SUMMARY_PATTERN")) {
                summaryData = true;
                resultList = (ArrayList)levelTable.get("SUMMARY_PATTERN");
            }
            int resultSize = 0;
            if (resultList != null) {
                resultSize = resultList.size();
            }
            NodeBTMLogger.nodeLogger.debug("{} {}  resultSize==> [resultList ==>] {}", new Object[]{this.loggerDispStr, this.entity, resultSize, resultList});
            if (resultSize >= 18) {
                ArrayList<Double> resultDataList = new ArrayList<Double>();
                double healthy = 0.0;
                double slow = 0.0;
                double stalled = 0.0;
                double sql = 0.0;
                double error = 0.0;
                double total = 0.0;
                double averageHealthyPercentage = 0.0;
                double averageSlowPercentage = 0.0;
                double averageErrorPercentage = 0.0;
                double averageStalledPercentage = 0.0;
                double totalCallPerMinutes = 0.0;
                double errorCallPerMinutes = 0.0;
                double cpuTime = 0.0;
                double waitTime = 0.0;
                double blockTime = 0.0;
                int updateCount = 18;
                if (summaryData) {
                    updateCount = 18;
                } else {
                    double all_url_count = (Double)resultList.get(0);
                    if (all_url_count == 0.0) {
                        NodeBTMLogger.nodeLogger.debug("{}  Transactions for the Pattern {} is 0, continuing...", (Object)this.loggerDispStr, (Object)levelString);
                        continue;
                    }
                }
                int i = 0;
                while (i < resultSize) {
                    double count = (Double)resultList.get(i);
                    double sum = (Double)resultList.get(i + 1);
                    double average = 0.0;
                    if (count > 0.0) {
                        average = sum / count;
                    }
                    if (i < updateCount) {
                        resultDataList.add(new Double(count));
                        resultDataList.add(new Double(average));
                    }
                    switch (i) {
                        case 0: {
                            total = count;
                            break;
                        }
                        case 2: {
                            slow = count;
                            break;
                        }
                        case 4: {
                            error = count;
                            break;
                        }
                        case 6: {
                            stalled = count;
                            break;
                        }
                        case 18: {
                            cpuTime = isCPUTimeNotSupported ? -4.0 : (this.cpuTimeTrackingFlag ? average : -5.0);
                            break;
                        }
                        case 20: {
                            waitTime = isCPUTimeNotSupported ? -4.0 : (this.contentionTimeTrackingFlag ? average : -5.0);
                            break;
                        }
                        case 22: {
                            blockTime = isCPUTimeNotSupported ? -4.0 : (this.contentionTimeTrackingFlag ? average : -5.0);
                        }
                    }
                    i += 2;
                }
                if (summaryData) {
                    levelString = "Summary";
                }
                healthy = total - (slow + error + stalled);
                resultDataList.add(new Double(healthy));
                if (total > 0.0) {
                    averageHealthyPercentage = Double.parseDouble(this.formatter.format(healthy / total * 100.0));
                    averageSlowPercentage = Double.parseDouble(this.formatter.format(slow / total * 100.0));
                    averageErrorPercentage = Double.parseDouble(this.formatter.format(error / total * 100.0));
                    averageStalledPercentage = Double.parseDouble(this.formatter.format(stalled / total * 100.0));
                    totalCallPerMinutes = Double.parseDouble(this.formatter.format(total / (double)testFrequency));
                    errorCallPerMinutes = Double.parseDouble(this.formatter.format(error / (double)testFrequency));
                }
                resultDataList.add(new Double(averageHealthyPercentage));
                resultDataList.add(new Double(averageSlowPercentage));
                resultDataList.add(new Double(averageErrorPercentage));
                resultDataList.add(new Double(averageStalledPercentage));
                if (this.numOutputFields > 23) {
                    resultDataList.add(new Double(cpuTime));
                    resultDataList.add(new Double(waitTime));
                    resultDataList.add(new Double(blockTime));
                    resultDataList.add(new Double(totalCallPerMinutes));
                    resultDataList.add(new Double(errorCallPerMinutes));
                }
                NodeBTMLogger.nodeLogger.debug("{} {}  levelString: {}  \t resultDataList :", new Object[]{this.loggerDispStr, this.entity, levelString, resultDataList});
                levelString = NodeTransTestBase.decodeUrlString(levelString, this.loggerDispStr);
                this.addNewMeasure(levelString, resultDataList);
                NodeBTMLogger.nodeLogger.debug(" {} {} Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, levelString, resultDataList});
            }
            if (summaryData) continue;
            ArrayList slowList = new ArrayList();
            Object slowObject = levelTable.get("SlowURLLists");
            if (slowObject != null && slowObject instanceof ArrayList) {
                slowList = (ArrayList)slowObject;
                NodeBTMLogger.nodeLogger.debug("{}  slowList Size ==> {} [slowList ==>] {}", new Object[]{this.loggerDispStr, slowList.size(), slowList});
            }
            ArrayList errorList = new ArrayList();
            Object errorObject = levelTable.get("ErrorURLLists");
            if (errorObject != null && errorObject instanceof ArrayList) {
                errorList = (ArrayList)errorObject;
                NodeBTMLogger.nodeLogger.debug("{}  slowList Size ==> {} [slowList ==>] {}", new Object[]{this.loggerDispStr, errorList.size(), errorList});
            }
            ArrayList allList = new ArrayList();
            Object allObject = levelTable.get("AllURLLists");
            if (allObject != null && allObject instanceof ArrayList) {
                allList = (ArrayList)allObject;
                NodeBTMLogger.nodeLogger.debug("{}  allList Size ==> {} [allList ==>] {}", new Object[]{this.loggerDispStr, allList.size(), errorList});
            }
            ArrayList stalledList = new ArrayList();
            Object stalledObject = levelTable.get("StalledURLLists");
            if (stalledObject != null && stalledObject instanceof ArrayList) {
                stalledList = (ArrayList)stalledObject;
                NodeBTMLogger.nodeLogger.debug("{}  stalledList Size ==> {} [stalledList ==>] {}", new Object[]{this.loggerDispStr, stalledList.size(), stalledList});
            }
            ArrayList slowThreadList = null;
            Object slowThreadObject = levelTable.get("SlowURLThreadLists");
            if (slowThreadObject != null && slowThreadObject instanceof ArrayList) {
                slowThreadList = (ArrayList)slowThreadObject;
            }
            ArrayList errorThreadList = null;
            Object errorThreadObject = levelTable.get("ErrorURLThreadLists");
            if (errorThreadObject != null && errorThreadObject instanceof ArrayList) {
                errorThreadList = (ArrayList)errorThreadObject;
            }
            ArrayList stalledThreadList = null;
            Object stalledThreadObject = levelTable.get("StalledURLThreadLists");
            if (stalledThreadObject != null && stalledThreadObject instanceof ArrayList) {
                stalledThreadList = (ArrayList)stalledThreadObject;
            }
            ArrayList healthyThreadList = null;
            Object healthyThreadObject = levelTable.get("HealthyURLThreadLists");
            if (healthyThreadObject != null && healthyThreadObject instanceof ArrayList) {
                healthyThreadList = (ArrayList)healthyThreadObject;
            }
            String serverTimeZone = (String)this.DataBaseHT.get("TimeZone");
            Hashtable customPointcutTable = (Hashtable)this.DataBaseHT.get("CustomPC");
            if (serverTimeZone == null) {
                serverTimeZone = "unknown";
            }
            if (slowThreadList != null && slowThreadList.size() > 0) {
                slowList.addAll(slowThreadList);
            }
            if (errorThreadList != null && errorThreadList.size() > 0) {
                errorList.addAll(errorThreadList);
            }
            if (stalledThreadList != null && stalledThreadList.size() > 0) {
                stalledList.addAll(stalledThreadList);
            }
            if (healthyThreadList != null && healthyThreadList.size() > 0) {
                allList.addAll(healthyThreadList);
            }
            ArrayList OtherCallDetails = new ArrayList();
            Hashtable slowResultTable = this.formatSource(slowList, customPointcutTable, serverTimeZone, true);
            NodeBTMLogger.nodeLogger.debug("{} slowResultTable : {}", (Object)this.loggerDispStr, (Object)slowResultTable);
            if (slowResultTable != null && slowResultTable.size() > 0) {
                ArrayList slowDDList = (ArrayList)slowResultTable.get("DD");
                ArrayList slowExtraList = (ArrayList)slowResultTable.get("EXTRA");
                NodeBTMLogger.nodeLogger.debug("{}  slowDDList : {}", (Object)this.loggerDispStr, (Object)slowDDList);
                if (slowDDList != null && slowDDList.size() > 0) {
                    this.slowURLTable.put(levelString, slowDDList);
                }
                NodeBTMLogger.nodeLogger.debug("{}  slowExtraList : {}", (Object)this.loggerDispStr, (Object)slowExtraList);
                if (slowExtraList != null && slowExtraList.size() > 0) {
                    OtherCallDetails.addAll(slowExtraList);
                }
            }
            Hashtable errorResultTable = this.formatSource(errorList, customPointcutTable, serverTimeZone, true);
            NodeBTMLogger.nodeLogger.debug("{} errorResultList :{}", (Object)this.loggerDispStr, (Object)errorResultTable);
            if (errorResultTable != null && errorResultTable.size() > 0) {
                ArrayList errorDDList = (ArrayList)errorResultTable.get("DD");
                ArrayList errorExtraList = (ArrayList)errorResultTable.get("EXTRA");
                NodeBTMLogger.nodeLogger.debug("{}  errorDDList : {}", (Object)this.loggerDispStr, (Object)errorDDList);
                if (errorDDList != null && errorDDList.size() > 0) {
                    this.errorURLTable.put(levelString, errorDDList);
                }
                NodeBTMLogger.nodeLogger.debug("{}  errorExtraList : {}", (Object)this.loggerDispStr, (Object)errorExtraList);
                if (errorExtraList != null && errorExtraList.size() > 0) {
                    OtherCallDetails.addAll(errorExtraList);
                }
            }
            Hashtable healthyResultTable = this.formatSource(allList, customPointcutTable, serverTimeZone, true);
            NodeBTMLogger.nodeLogger.debug("{} healthyResultTable :{}", (Object)this.loggerDispStr, (Object)healthyResultTable);
            if (healthyResultTable != null && healthyResultTable.size() > 0) {
                ArrayList healthyDDList = (ArrayList)healthyResultTable.get("DD");
                ArrayList healthyExtraList = (ArrayList)healthyResultTable.get("EXTRA");
                NodeBTMLogger.nodeLogger.debug("{} healthyDDList : {}", (Object)this.loggerDispStr, (Object)healthyDDList);
                if (healthyDDList != null && healthyDDList.size() > 0) {
                    this.allURLTable.put(levelString, healthyDDList);
                }
                NodeBTMLogger.nodeLogger.debug("{}  healthyExtraList : {}", (Object)this.loggerDispStr, (Object)healthyExtraList);
                if (healthyExtraList != null && healthyExtraList.size() > 0) {
                    OtherCallDetails.addAll(healthyExtraList);
                }
            }
            Hashtable stalledResultTable = this.formatSource(stalledList, customPointcutTable, serverTimeZone, true);
            NodeBTMLogger.nodeLogger.debug("{} stalledResultTable : {}", (Object)this.loggerDispStr, (Object)stalledResultTable);
            if (stalledResultTable != null && stalledResultTable.size() > 0) {
                ArrayList stalledDDList = (ArrayList)stalledResultTable.get("DD");
                ArrayList stalledExtraList = (ArrayList)stalledResultTable.get("EXTRA");
                NodeBTMLogger.nodeLogger.debug("{}  stalledDDList : {}", (Object)this.loggerDispStr, (Object)stalledDDList);
                if (stalledDDList != null && stalledDDList.size() > 0) {
                    this.stalledURLTable.put(levelString, stalledDDList);
                }
                NodeBTMLogger.nodeLogger.debug("{}  stalledExtraList : {}", (Object)this.loggerDispStr, (Object)stalledExtraList);
                if (stalledExtraList != null && stalledExtraList.size() > 0) {
                    OtherCallDetails.addAll(stalledExtraList);
                }
            }
            if (OtherCallDetails != null && OtherCallDetails.size() > 0) {
                this.externalTable.put(levelString, OtherCallDetails);
            }
            NodeBTMLogger.nodeLogger.debug("{}  externalTable : {}", (Object)this.loggerDispStr, (Object)this.externalTable);
        }
    }

    public boolean getOffLoadData() {
        boolean isSuccess = false;
        NodeBTMLogger.nodeLogger.debug("{} offload nodeId : {}", (Object)this.loggerDispStr, (Object)this.nodeId);
        NodeBTMLogger.nodeLogger.debug("{} offload entity : {}", (Object)this.loggerDispStr, (Object)this.entity);
        NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.UPDmanagerTable : {}", (Object)this.loggerDispStr, APMNodeWorker.getUPDmanagerTable());
        NodeUPDManager updm = APMNodeWorker.getValueFromUPDmanagerTable(this.nodeId);
        if (updm != null) {
            this.sourceTable = updm.getMeasures(false, this.entity);
            if (APMNodeWorker.IsThisAvailableInDataBaseHT(this.nodeId)) {
                this.DataBaseHT = APMNodeWorker.getValueFromDataBaseHT(this.nodeId).getGlobalDetails();
                APMNodeWorker.getValueFromDataBaseHT(this.nodeId).removeSessionUserKey();
            }
            this.isSourceTableFromTempCompID = false;
        } else {
            NodeBTMLogger.nodeLogger.debug("{} Trying to fetch data using Temporary Component ID {}", (Object)this.loggerDispStr, (Object)this.tempComponentID);
            NodeUPDManager updm2 = APMNodeWorker.getValueFromUPDmanagerTable(this.tempComponentID);
            if (updm2 == null) {
                return false;
            }
            APMNodeWorker.clearOffloadBTMDataRepository(this.tempComponentID, " No need of temporary component id data. ");
            this.sourceTable = updm2.getMeasures(false, this.entity);
            if (APMNodeWorker.IsThisAvailableInDataBaseHT(this.tempComponentID)) {
                this.DataBaseHT = APMNodeWorker.getValueFromDataBaseHT(this.tempComponentID).getGlobalDetails();
                APMNodeWorker.getValueFromDataBaseHT(this.nodeId).removeSessionUserKey();
            }
            this.isSourceTableFromTempCompID = true;
            NodeBTMLogger.nodeLogger.debug("{} isSourceTableFromTempCompID : {}", (Object)this.loggerDispStr, (Object)this.isSourceTableFromTempCompID);
        }
        if (this.sourceTable != null && this.sourceTable.size() > 0) {
            this.status_code = 200;
            isSuccess = true;
        }
        return isSuccess;
    }

    private void suspendForPeriod(long sleepPeriod) {
        long nextMeasureTime = System.currentTimeMillis() + sleepPeriod;
        while (sleepPeriod > 0L) {
            if (sleepPeriod < 25L) {
                sleepPeriod = 25L;
            }
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long currentTime = System.currentTimeMillis();
            sleepPeriod = nextMeasureTime - currentTime;
        }
    }
}

