/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeGC;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class NodeGCtest
extends NodeBase {
    private HashMap workers = null;

    public NodeGCtest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            logger.info("{} Initializing NodeGCtest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeGCtest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.error("{} Exception while initializing NodeGCtest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String string = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            Object object;
            Cloneable cloneable;
            if (!NodeDataRepository.isInfraIdExists(string)) {
                logger.debug("{}  siteId: {} is not available", (Object)this.logPrefix, (Object)string);
                return;
            }
            int n = 0;
            if (NodeDataRepository.isInfraIdExists(string)) {
                n = NodeDataRepository.getInfraById(string).getWorkerCount();
            }
            NodeInfraCluster nodeInfraCluster = NodeDataRepository.getInfraByIdFromPrev(string);
            NodeInfra nodeInfra = null;
            if (nodeInfraCluster != null) {
                nodeInfra = nodeInfraCluster.getMaster();
                logger.debug("{} - Previous NodeInfraCluster Available.", (Object)this.logPrefix);
            } else {
                nodeInfraCluster = new NodeInfraCluster();
                NodeDataRepository.setInfraByIdToPrev(string, nodeInfraCluster);
                logger.debug("{} - Previous NodeInfraCluster NOT-Available. Creating NodeInfraCluster.", (Object)this.logPrefix);
            }
            NodeInfraCluster nodeInfraCluster2 = NodeDataRepository.getInfraById(string);
            NodeInfra nodeInfra2 = nodeInfraCluster2.getMaster();
            NodeGC nodeGC = null;
            if (nodeInfra2 != null) {
                nodeGC = nodeInfra2.getGc();
            }
            if (nodeGC != null) {
                double d;
                double d2;
                double d3;
                cloneable = new ArrayList<Double>();
                ((ArrayList)cloneable).add(new Double(nodeGC.getFull()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getInc()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getMinor()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getFullTime()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getIncTime()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getMinorTime()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getTime()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getTick()));
                ((ArrayList)cloneable).add(new Double(nodeGC.getReleasedMem()));
                ((ArrayList)cloneable).add(new Double(-5.0));
                object = null;
                if (nodeInfra != null) {
                    object = nodeInfra.getGc();
                    logger.debug("{} {} - Previous NodeInfraCluster master Available.", (Object)this.logPrefix, (Object)string);
                } else {
                    nodeInfra = new NodeInfra();
                    nodeInfraCluster.setMaster(nodeInfra);
                    logger.debug("{} {} - Previous NodeInfraCluster master NOT-Available. Creating master-NodeInfra.", (Object)this.logPrefix, (Object)string);
                }
                if (object == null) {
                    logger.debug("{} {} - Previous NodeInfraCluster master GC NOT-Available. Creating NodeGC.", (Object)this.logPrefix, (Object)string);
                    object = new NodeGC();
                    nodeInfra.setGc((NodeGC)object);
                }
                logger.debug("{} Master Previous GC: {}", (Object)this.logPrefix, object);
                logger.debug("{} Master Current GC: {}", (Object)this.logPrefix, (Object)nodeGC);
                double d4 = nodeGC.getFullTime();
                double d5 = ((NodeGC)object).getFullTime();
                double d6 = d4 - d5;
                if (d6 > 0.0) {
                    d3 = d6 * 100.0 / (double)this.measurePeriod;
                    ((ArrayList)cloneable).add(new Double(Math.min(d3, 100.0)));
                } else {
                    ((ArrayList)cloneable).add(new Double(0.0));
                }
                d3 = nodeGC.getIncTime();
                double d7 = ((NodeGC)object).getIncTime();
                double d8 = d3 - d7;
                if (d8 > 0.0) {
                    d2 = d8 * 100.0 / (double)this.measurePeriod;
                    ((ArrayList)cloneable).add(new Double(Math.min(d2, 100.0)));
                } else {
                    ((ArrayList)cloneable).add(new Double(0.0));
                }
                d2 = nodeGC.getMinorTime();
                double d9 = ((NodeGC)object).getMinorTime();
                double d10 = d2 - d9;
                if (d10 > 0.0) {
                    d = d10 * 100.0 / (double)this.measurePeriod;
                    ((ArrayList)cloneable).add(new Double(Math.min(d, 100.0)));
                } else {
                    ((ArrayList)cloneable).add(new Double(0.0));
                }
                d = nodeGC.getTime();
                double d11 = ((NodeGC)object).getTime();
                double d12 = d2 - d9;
                if (d12 > 0.0) {
                    double d13 = d12 * 100.0 / (double)this.measurePeriod;
                    ((ArrayList)cloneable).add(new Double(Math.min(d13, 100.0)));
                } else {
                    ((ArrayList)cloneable).add(new Double(0.0));
                }
                if (n > 0) {
                    this.addNewMeasure("Master", (ArrayList)cloneable);
                } else {
                    this.addNewMeasure((ArrayList)cloneable);
                }
                nodeInfra.setGc(nodeGC);
                logger.debug("{} Master - measures: {} ", (Object)this.logPrefix, (Object)cloneable);
            } else {
                logger.debug("{} {}  Master - measure is null", (Object)this.logPrefix, (Object)string);
            }
            this.workers = nodeInfraCluster2.getWorkers();
            cloneable = nodeInfraCluster.getWorkers();
            if (this.workers != null && this.workers.size() > 0) {
                if (cloneable == null) {
                    logger.debug("{} {} - Previous NodeInfraCluster workers NOT-Available. Creating workers-HashMap.", (Object)this.logPrefix, (Object)string);
                    cloneable = new HashMap();
                    nodeInfraCluster.setWorkers((HashMap<String, NodeInfra>)cloneable);
                }
                if ((nodeGC = NodeDataRepository.aggregateGC(this.workers, this.measurePeriod, (HashMap)cloneable)) != null) {
                    object = new ArrayList<Double>();
                    ((ArrayList)object).add(new Double(nodeGC.getFull()));
                    ((ArrayList)object).add(new Double(nodeGC.getMinor()));
                    ((ArrayList)object).add(new Double(nodeGC.getInc()));
                    ((ArrayList)object).add(new Double(nodeGC.getFullTime()));
                    ((ArrayList)object).add(new Double(nodeGC.getIncTime()));
                    ((ArrayList)object).add(new Double(nodeGC.getMinorTime()));
                    ((ArrayList)object).add(new Double(nodeGC.getTime()));
                    ((ArrayList)object).add(new Double(nodeGC.getTick()));
                    ((ArrayList)object).add(new Double(nodeGC.getReleasedMem()));
                    ((ArrayList)object).add(new Double(nodeInfraCluster2.getWorkerCount()));
                    ((ArrayList)object).add(new Double(nodeGC.getFullPercentage()));
                    ((ArrayList)object).add(new Double(nodeGC.getIncPercentage()));
                    ((ArrayList)object).add(new Double(nodeGC.getMinorPercentage()));
                    ((ArrayList)object).add(new Double(nodeGC.getTotalPercentage()));
                    this.addNewMeasure("Workers", (ArrayList)object);
                    logger.debug("{}  Worker - measures: {}", (Object)this.logPrefix, object);
                } else {
                    logger.debug("{} {}  Worker - gc is null", (Object)this.logPrefix, (Object)string);
                }
            } else {
                logger.debug("{} {}  Worker - measure is null", (Object)this.logPrefix, (Object)string);
            }
            nodeInfraCluster.setWorkers(this.workers);
        }
        catch (Exception exception) {
            logger.error("{} Exception occured while collecting  gc : {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public HashMap getWorkers() {
        return this.workers;
    }

    public void setWorkers(HashMap hashMap) {
        this.workers = hashMap;
    }
}

