/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeError;
import com.eg.apm.NodeErrorCluster;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NodeErrorTest_DD
extends EgTest_DD {
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    public static final int MAX_MESSAGE_LENGTH = 256;
    public static final int MAX_STACK_LENGTH = 2000;
    public String prefix = "[NodejsErrorTest_DD]";

    public NodeErrorTest_DD(String entity) {
        super(entity);
        logger.info("{} is started", (Object)this.prefix);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean getStatusDiscriptor(EgTest test, String siteId, String info) {
        try {
            NodeErrorTest nodeErrorTest = (NodeErrorTest)test;
            NodeErrorCluster nodeErrorCluster = nodeErrorTest.getNodeErrorCluster();
            if (nodeErrorCluster != null) {
                if (info.equalsIgnoreCase("+") && nodeErrorCluster.getMaster().size() > 0) {
                    ArrayList<NodeError> masterErrorList = nodeErrorCluster.getMaster();
                    for (NodeError error : masterErrorList) {
                        String msg = error.getMessage();
                        String stack = error.getStack();
                        String pid = error.getProcessID();
                        if (msg.length() > 256) {
                            msg = String.valueOf(msg.substring(0, 253)) + "...";
                        }
                        if (stack.length() > 2000) {
                            stack = String.valueOf(stack.substring(0, 1997)) + "...";
                        }
                        this.addLine(String.valueOf(pid) + fieldSep + error.getErrorTime() + fieldSep + msg + fieldSep + stack);
                        logger.trace("{} DD Addline info:{} {} {} {} {}", new Object[]{this.prefix, error.getErrorTime(), fieldSep, msg, fieldSep, stack});
                    }
                    return true;
                }
                if (info.equalsIgnoreCase("+Master") && nodeErrorCluster.getMaster().size() > 0) {
                    ArrayList<NodeError> masterErrorList = nodeErrorCluster.getMaster();
                    for (NodeError error : masterErrorList) {
                        String msg = error.getMessage();
                        String stack = error.getStack();
                        if (msg.length() > 256) {
                            msg = String.valueOf(msg.substring(0, 253)) + "...";
                        }
                        if (stack.length() > 2000) {
                            stack = String.valueOf(stack.substring(0, 1997)) + "...";
                        }
                        this.addLine("-" + fieldSep + error.getErrorTime() + fieldSep + msg + fieldSep + stack);
                        logger.trace("{} DD Addline info:{} {} {} {} {}", new Object[]{this.prefix, error.getErrorTime(), fieldSep, msg, fieldSep, stack});
                    }
                    return true;
                }
                logger.debug("{} Master Error_DD list is empty", (Object)this.prefix);
                if (info.equalsIgnoreCase("+Workers") && nodeErrorCluster.getWorkers().size() > 0) {
                    HashMap<String, ArrayList<NodeError>> workerErrorMap = nodeErrorCluster.getWorkers();
                    Set<Map.Entry<String, ArrayList<NodeError>>> set = workerErrorMap.entrySet();
                    for (Map.Entry<String, ArrayList<NodeError>> mEntry : set) {
                        String pid = mEntry.getKey();
                        ArrayList<NodeError> workerErrorList = workerErrorMap.get(pid);
                        for (NodeError error : workerErrorList) {
                            String msg = error.getMessage();
                            String stack = error.getStack();
                            if (msg.length() > 256) {
                                msg = String.valueOf(msg.substring(0, 253)) + "...";
                            }
                            if (stack.length() > 2000) {
                                stack = String.valueOf(stack.substring(0, 1997)) + "...";
                            }
                            this.addLine(String.valueOf(pid) + fieldSep + error.getErrorTime() + fieldSep + msg + fieldSep + stack);
                            logger.debug("{} Pid: {}  DD Addline info: {} {} {} {} {}  ", new Object[]{this.prefix, pid, error.getErrorTime(), fieldSep, msg, fieldSep, stack});
                        }
                    }
                    return true;
                }
                logger.debug("{} Worker Error DD list is empty", (Object)this.prefix);
            } else {
                logger.debug("{} Site id not available", (Object)this.prefix);
            }
        }
        catch (Exception e) {
            logger.error("{} getStatusDiscriptor() Exception occcured {}", (Object)this.prefix, (Object)e);
        }
        return false;
    }

    public void Number_of_Errors_dd(String methodName, String measureName, String targetHost, String reportingName, String portNo, String siteName, String info, String msmtHost, String msmtTime, String state, EgTest test) {
        logger.debug("{} methodName={} \t measureName={} \t targetHost={}  \t reportingName={} \t  portNo={}\t siteName={} \t info={}  \t msmtHost={}  \t msmtTime={}  \t state={}  \t ", new Object[]{this.prefix, methodName, measureName, targetHost, reportingName, portNo, siteName, info, msmtHost, msmtTime, state});
        try {
            boolean success = this.getStatusDiscriptor(test, String.valueOf(msmtHost) + '_' + portNo, info);
            if (success) {
                this.uploadResults(methodName, measureName, reportingName, portNo, siteName, info, msmtHost, msmtTime, state);
            }
        }
        catch (Exception e) {
            logger.error("{} while upload results {}", (Object)this.prefix, (Object)e);
            return;
        }
    }
}

