/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeError;
import com.eg.apm.NodeErrorCluster;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class NodeErrorTest
extends NodeBase {
    NodeErrorCluster nodeErrorCluster = null;
    public static final int ZERO = 0;
    public static final int NOT_AVAILABLE = -5;

    public NodeErrorTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            logger.info("{} Initializing NodeErrorTest...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeErrorTest initialized successfully...", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.error("{}  Exception while initializing NodeErrorTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String string = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            this.nodeErrorCluster = null;
            int n = 0;
            ArrayList<Double> arrayList = null;
            if (NodeDataRepository.isInfraIdExists(string)) {
                n = NodeDataRepository.getInfraById(string).getWorkerCount();
            }
            if (!NodeDataRepository.isErrorClusterIdExists(string)) {
                logger.debug("{}  siteId: {}  is not available", (Object)this.logPrefix, (Object)string);
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                if (n > 0) {
                    this.addNewMeasure("Master", arrayList);
                } else {
                    this.addNewMeasure(arrayList);
                }
                if (n > 0) {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(0.0));
                    arrayList.add(new Double(n));
                    this.addNewMeasure("Workers", arrayList);
                }
                return;
            }
            this.nodeErrorCluster = NodeDataRepository.removeErrorClusterById(string);
            int n2 = this.nodeErrorCluster.getMaster().size();
            int n3 = 0;
            Set<Map.Entry<String, ArrayList<NodeError>>> set = this.nodeErrorCluster.getWorkers().entrySet();
            for (Map.Entry<String, ArrayList<NodeError>> entry : set) {
                ArrayList<NodeError> arrayList2 = entry.getValue();
                n3 += arrayList2.size();
            }
            logger.debug("{} - Nodejs master error count : {}", (Object)this.logPrefix, (Object)n2);
            if (n2 > 0) {
                logger.debug("{} - error message {}", (Object)this.logPrefix, (Object)this.nodeErrorCluster.getMaster().get(this.nodeErrorCluster.getMaster().size() - 1).getMessage());
            }
            logger.debug("{}  -  Nodejs Worker error count: {}", (Object)this.logPrefix, (Object)n3);
            arrayList = new ArrayList();
            arrayList.add(new Double(n2));
            arrayList.add(new Double(-5.0));
            logger.debug("{} master - measures: {} " + this.logPrefix, arrayList);
            if (n > 0) {
                this.addNewMeasure("Master", arrayList);
            } else {
                this.addNewMeasure(arrayList);
            }
            arrayList = new ArrayList();
            arrayList.add(new Double(n3));
            arrayList.add(new Double(n));
            if (n > 0) {
                logger.debug("{}  Worker - measures: {} ", (Object)this.logPrefix, arrayList);
                this.addNewMeasure("Workers", arrayList);
            }
        }
        catch (Exception exception) {
            logger.debug("{} Exception occured while collecting Errors : {} ", (Object)this.logPrefix, (Object)exception);
        }
    }

    public NodeErrorCluster getNodeErrorCluster() {
        return this.nodeErrorCluster;
    }

    public void setNodeErrorCluster(NodeErrorCluster nodeErrorCluster) {
        this.nodeErrorCluster = nodeErrorCluster;
    }
}

