/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMNodeComponentIDRepository;
import com.eg.apm.APMNodeWorker;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.NodeBTMLogger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class NodeBTMBase
extends NodeBase {
    protected static final String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected static final SimpleDateFormat mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a", Locale.US);
    protected static final SimpleDateFormat finalFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
    protected ArrayList propsList = new ArrayList();
    protected String trgtHost = "localhost";
    protected String logPrefix = "NodeBTMBase";
    protected String loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + this.logPrefix + "]";
    protected String applicationName = "My_Application";
    protected String tierName = "My_Tier";
    protected static final String DDCellColSep = "#=#";
    protected static final String DDCellRowSep = "%*%";
    protected static final String ExtCallSep = "[*#*]";
    protected static final String requestIDSep = " @ ";
    protected static final String LOCAL_HOST = "localhost";
    protected static final String acuteRegex = ",N'";
    protected static final String acuteReplStr = ",'";
    protected static final char newLineChar = '\n';
    protected static final char space = ' ';
    protected static final String btmSecurity = "BTM";
    protected static final String[] propsOrder = new String[]{"Monitoring_Mode", "Max_URL_Segments", "URL_Patterns", "Excluded_Patterns", "Key_Excluded_Patterns", "Slow_URL_Threshold", "Stalled_URL_Threshold", "Method_Exec_CutOff", "SQL_Exec_CutOff", "Max_Slow_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period", "Healthy_URL_Trace", "egMeasPeriod", "Pojo_Method_Tracing_Limit", "Pojo_Method_Tracing_Cutoff_Time", "Recursive_Method_Tracing_Limit", "Non-Pojo_Method_Tracing_Limit", "Exception_Stacktrace_Lines", "Included_Exceptions", "Ignored_Exceptions", "Ignored_Characters", "Max_Grouped_Urls_Per_Measure_Period", "Key_Max_Grouped_Urls_Per_Measure_Period", "Max_Sql_Queries_Per_Transaction", "Show_HTTPStatus", "Show_Cookies", "Show_Headers", "Enable_Thread_Cpu_Monitoring", "Enable_Thread_Contention_Monitoring", "Max_Mongodb_Query_Length"};
    DecimalFormat formatter = new DecimalFormat("#.##");
    protected static final Double minusFive = -5.0;
    protected String nodeId = "null";
    protected String componentIDForFolderName = null;
    protected static boolean isOffloadDataCollection = true;
    private String agentIpAddress = "127.0.0.1";
    String componentType = "null";
    String tempComponentID = "null";
    boolean isTempCompIdFound = false;
    public static boolean testRunsFirstTime = true;
    public static final HashMap MAPPING = new HashMap();

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        MAPPING.put("Monitoring_Mode", "Monitoring_Mode");
        MAPPING.put("Max_URL_Segments", "Max_URL_Segments");
        MAPPING.put("Excluded_Patterns", "Excluded_Patterns");
        MAPPING.put("Slow_URL_Threshold", "Slow_URL_Threshold");
        MAPPING.put("Stalled_URL_Threshold", "Stalled_URL_Threshold");
        MAPPING.put("Method_Exec_CutOff", "Method_Exec_CutOff");
        MAPPING.put("SQL_Exec_CutOff", "SQL_Exec_CutOff");
        MAPPING.put("Max_Slow_URLs_Per_Test_Period", "Max_Slow_URLs_Per_Test_Period");
        MAPPING.put("Max_Error_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period");
        MAPPING.put("Max_Healthy_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period");
        MAPPING.put("Max_Stalled_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period");
        MAPPING.put("Healthy_URL_Trace", "Healthy_URL_Trace");
        MAPPING.put("egMeasPeriod", "egMeasPeriod");
        MAPPING.put("Key_Excluded_Patterns", "Manual_Excluded_Patterns");
        MAPPING.put("URL_Patterns", "URL_Patterns");
        MAPPING.put("Key_Max_Grouped_Urls_Per_Measure_Period", "MAX_MANUAL_GROUPED_URLS");
        MAPPING.put("Show_HTTPStatus", "HTTP_STATUS_CODE");
        MAPPING.put("Show_Cookies", "HTTP_COOKIES");
        MAPPING.put("Show_Headers", "HTTP_HEADERS");
        MAPPING.put("Enable_Thread_Cpu_Monitoring", "TRACK_CPU_TIME");
        MAPPING.put("Enable_Thread_Contention_Monitoring", "TRACK_BLOCKED_WAITED_TIME");
        MAPPING.put("Pojo_Method_Tracing_Limit", "MAX_POJO_CALL_TRACE_COUNT");
        MAPPING.put("Pojo_Method_Tracing_Cutoff_Time", "MAX_POJO_CALL_TRACE_TIME");
        MAPPING.put("Recursive_Method_Tracing_Limit", "RECURSION_TRACE_LIMIT");
        MAPPING.put("Non-Pojo_Method_Tracing_Limit", "MAX_POINTCUT_LIMIT");
        MAPPING.put("Exception_Stacktrace_Lines", "MAX_EXCEPTION_TRACE_LINE_COUNT");
        MAPPING.put("Included_Exceptions", "INCLUDE_EXCEPTIONS");
        MAPPING.put("Ignored_Exceptions", "IGNORE_EXCEPTIONS");
        MAPPING.put("Ignored_Characters", "Chars_TO_Exclude");
        MAPPING.put("Max_Grouped_Urls_Per_Measure_Period", "MAX_AUTO_GROUPED_URLS");
        MAPPING.put("Max_Sql_Queries_Per_Transaction", "MAX_SQL_QUERY_COUNT");
        MAPPING.put("Max_Mongodb_Query_Length", "MAX_MONGODB_QUERY_LENGTH");
    }

    public NodeBTMBase(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        this.trgtHost = this.getValueForParam("trgtHost");
        this.applicationName = this.getValueForParam("Application_Name");
        this.tierName = this.getValueForParam("Tier_Name");
        this.fixedTestPeriod = true;
        if (this.applicationName == null) {
            this.applicationName = "-";
        }
        this.nodeId = "[" + this.reportingName + ":" + this.portNo + "]";
        this.componentIDForFolderName = String.valueOf(this.reportingName) + "_" + this.portNo;
        this.printAllRepositoryTable();
        try {
            ComponentWatcherTracker.isWatcherNull(true);
            APMNodeComponentIDRepository.registerComponentID(this.nodeId, this.entity);
            APMNodeComponentIDRepository.addNewEntryToNewComponetIDs(this.nodeId, this.nodeId);
        }
        catch (Exception e) {
            NodeBTMLogger.nodeLogger.error("{} Exception in NODEJSTransTest Constructor {}", (Object)this.loggerDispStr, (Object)e);
        }
    }

    protected void printAllRepositoryTable() {
        if (NodeBTMLogger.nodeLogger.isTraceEnabled()) {
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getComponentIDTable()  : {} ", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getComponentIDTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getNonOffloadComponentIDTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getNonOffloadComponentIDTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getOffloadComponentIDTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getOffloadComponentIDTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getOffloadThresholdTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getOffloadThresholdTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getOffloadPropsTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getOffloadPropsTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getComponentWithTestOffloadConfig()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getComponentWithTestOffloadConfig());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getPreviousComponentNameListTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getPreviousComponentNameListTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeComponentIDRepository.getnewComponetIDs()  : {}", (Object)this.loggerDispStr, (Object)APMNodeComponentIDRepository.getnewComponetIDs());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getUPDmanagerTable()  : {}", (Object)this.loggerDispStr, APMNodeWorker.getUPDmanagerTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getPropsManagerTable()  : {}", (Object)this.loggerDispStr, APMNodeWorker.getPropsManagerTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getDataBaseHT()  : {}", (Object)this.loggerDispStr, APMNodeWorker.getDataBaseHT());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getTempComponentIDTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeWorker.getTempComponentIDTable());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getRepositoryRemoved()  : {}", (Object)this.loggerDispStr, (Object)APMNodeWorker.getRepositoryRemoved());
            NodeBTMLogger.nodeLogger.trace("{} APMNodeWorker.getHeartBeatTable()  : {}", (Object)this.loggerDispStr, (Object)APMNodeWorker.getHeartBeatTable());
        }
    }

    private void getCompoenentType() {
        NodeBTMLogger.nodeLogger.debug("{} TargetHost Entity  : {}", (Object)this.loggerDispStr, (Object)this.entity);
        NodeBTMLogger.nodeLogger.debug("{} TargetHost IP : {}", (Object)this.loggerDispStr, (Object)this.trgtHost);
        NodeBTMLogger.nodeLogger.debug("{} TargetHost Port No : {}", (Object)this.loggerDispStr, (Object)this.portNo);
        this.componentType = this.getValueForParam("serverType");
        if (this.componentType == null) {
            this.componentType = "Not_Found";
        }
        NodeBTMLogger.nodeLogger.debug("{} TargetHost Component Type : {}", (Object)this.loggerDispStr, (Object)this.componentType);
    }

    protected Hashtable getModifiedThresholdPatterns(Hashtable currentTable, Hashtable previousTable) {
        Hashtable<String, String> resultTable = new Hashtable<String, String>();
        NodeBTMLogger.nodeLogger.debug("{} - getModifiedThresholdPatterns : currentTable:{} \t  previousTable : {}", new Object[]{this.loggerDispStr, currentTable, previousTable});
        if (currentTable != null && currentTable.size() > 0) {
            Set currentKeySet = currentTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentTable.get(currentKey);
                if (currentKey.startsWith("+")) {
                    currentKey = currentKey.substring(1);
                }
                if (previousTable.containsKey(currentKey)) {
                    String previousValue = (String)previousTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    previousTable.put(currentKey, currentValue);
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                previousTable.put(currentKey, currentValue);
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }

    protected void updateThresholds(Hashtable modifiedThreshPatterns, String entity) {
        if (modifiedThreshPatterns != null && modifiedThreshPatterns.size() > 0) {
            Set keys = modifiedThreshPatterns.keySet();
            Iterator patternItr = keys.iterator();
            HashMap<String, String> threhTable = new HashMap<String, String>();
            threhTable.put("Threshold", entity);
            while (patternItr.hasNext()) {
                String patternName = (String)patternItr.next();
                String thresholdValue = (String)modifiedThreshPatterns.get(patternName);
                if (entity.equalsIgnoreCase("NodeTransTest")) {
                    threhTable.put("Thresh4B>" + patternName, thresholdValue);
                    continue;
                }
                if (!entity.equalsIgnoreCase("KNodeTransTest")) continue;
                threhTable.put("Thresh4KB>" + patternName, thresholdValue);
            }
            if (entity.equalsIgnoreCase("NodeTransTest")) {
                APMNodeComponentIDRepository.registerNewThreshold(this.nodeId, threhTable);
            } else if (entity.equalsIgnoreCase("KNodeTransTest")) {
                APMNodeComponentIDRepository.registerNewThreshold("K_" + this.nodeId, threhTable);
            }
        }
    }

    private void updateOldNameList(String oldNodeIDList) {
        String[] nodeIdArray = oldNodeIDList.split(",");
        List<String> nodeIdList = Arrays.asList(nodeIdArray);
        APMNodeComponentIDRepository.setPreviousComponentNameList(this.nodeId, nodeIdList);
    }
}

