/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class NimbleIOLatencyTest
extends EgSnmpGenericTest {
    private double prevIOReadTime = -5.0;
    private double prevIOWriteTime = -5.0;
    private double prevIOReads = -5.0;
    private double prevIOWrites = -5.0;

    public NimbleIOLatencyTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.37447.1.3.6");
            double d2 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.7");
            double d3 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.2");
            double d4 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.4");
            if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0) {
                this.prevIOReadTime = -5.0;
                this.prevIOWriteTime = -5.0;
                this.prevIOReads = -5.0;
                this.prevIOWrites = -5.0;
                return;
            }
            double d5 = this.getDiff(d, this.prevIOReadTime);
            double d6 = this.getDiff(d2, this.prevIOWriteTime);
            double d7 = this.getDiff(d3, this.prevIOReads);
            double d8 = this.getDiff(d4, this.prevIOWrites);
            System.out.println("[NimbleIOLatencyTest] ReportingName :" + this.reportingName + " diff_ioReadTime :" + d5);
            System.out.println("[NimbleIOLatencyTest] ReportingName :" + this.reportingName + " diff_ioWriteTime :" + d6);
            System.out.println("[NimbleIOLatencyTest] ReportingName :" + this.reportingName + " diff_ioReads :" + d7);
            System.out.println("[NimbleIOLatencyTest] ReportingName :" + this.reportingName + " diff_ioWrites :" + d8);
            if (d5 > 0.0) {
                if (d7 > 0.0) {
                    d5 /= d7;
                    d5 /= 1000000.0;
                } else {
                    d5 = 0.0;
                }
            } else {
                d5 = 0.0;
            }
            if (d6 > 0.0) {
                if (d8 > 0.0) {
                    d6 /= d8;
                    d6 /= 1000000.0;
                } else {
                    d6 = 0.0;
                }
            } else {
                d6 = 0.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            System.out.println("[NimbleIOLatencyTest]  measureList===>" + arrayList);
            this.addNewMeasure(arrayList);
            this.prevIOReadTime = d;
            this.prevIOWriteTime = d2;
            this.prevIOReads = d3;
            this.prevIOWrites = d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d >= 0.0 && d2 >= 0.0 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.170", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        NimbleIOLatencyTest nimbleIOLatencyTest = new NimbleIOLatencyTest(stringArray2);
        try {
            while (true) {
                nimbleIOLatencyTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

