/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NexentaVolStTest
extends GenericTest {
    protected String userName = "";
    protected String password = "";
    protected String remoteType = "ssh";
    private static final int DEFAULT_CMD_TIME_OUT_SECONDS = 60;
    protected int cmd_time_out = 60;
    private static final String VOLUME_ST_CMD = "/usr/sbin/zpool list";
    private static final Hashtable sizeTypesHashtable = new Hashtable();
    private static final int NEXENTA_VOL_ST_MEASURE_COUNT = 4;

    public NexentaVolStTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.needAgentlessDD = true;
        this.userName = this.aluser;
        this.password = this.alpassword;
        String string = this.getValueForParam("timeout");
        if (string != null) {
            try {
                this.cmd_time_out = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.cmd_time_out = 60;
            }
        } else {
            this.cmd_time_out = 60;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = null;
        ArrayList<Double> arrayList2 = null;
        boolean bl = false;
        arrayList = new ArrayList();
        arrayList = this.cmdExecToNexenta(this.remoteType, this.targetHost, this.sshPort, this.userName, this.password, VOLUME_ST_CMD);
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + " :  Outdata    :" + arrayList);
        }
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
            System.out.println(this.entity + " : " + this.reportingName + "  No output for zpool list command output");
            this.logToErrorFile("ERROR :", this.reportingName, this.entity + " : " + "No output for zpool list command output");
            return;
        }
        int n = arrayList.size();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer;
            string = (String)arrayList.get(i);
            System.out.println("line  :" + string);
            if (string.indexOf("NAME") != -1 && string.indexOf("SIZE") != -1) {
                bl = true;
                continue;
            }
            if (!bl || (stringTokenizer = new StringTokenizer(string, " ")).countTokens() < 8) continue;
            string2 = this.getElementValue(stringTokenizer.nextToken(), "-");
            stringTokenizer.nextToken();
            string3 = this.getElementValue(stringTokenizer.nextToken(), "-5");
            string4 = this.getElementValue(stringTokenizer.nextToken(), "-5");
            string5 = this.getElementValue(stringTokenizer.nextToken(), "-5");
            stringTokenizer.nextToken();
            string6 = this.getElementValue(stringTokenizer.nextToken(), "-");
            d = this.convertStringToDouble(string3);
            d2 = this.convertStringToDouble(string4);
            d3 = this.convertStringToDouble(string5, "%");
            if (string6.equalsIgnoreCase("ONLINE")) {
                d4 = 1.0;
            } else if (string6.equalsIgnoreCase("DEGRADED")) {
                d4 = 2.0;
            } else if (string6.equalsIgnoreCase("UNAVAIL")) {
                d4 = 3.0;
            } else if (string6.equalsIgnoreCase("FAULTED")) {
                d4 = 4.0;
            } else if (string6.equalsIgnoreCase("REMOVED")) {
                d4 = 5.0;
            } else if (string6.equalsIgnoreCase("OFFLINE")) {
                d4 = 0.0;
            }
            arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d3));
            arrayList2.add(new Double(d4));
            if (debug) {
                System.out.println(this.entity + " : " + this.reportingName + ":  Info  :" + string2 + "  measures   : " + arrayList2);
            }
            this.addNewMeasure(string2, arrayList2);
        }
    }

    private ArrayList cmdExecToNexenta(String string, String string2, int n, String string3, String string4, String string5) {
        long l = System.currentTimeMillis();
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ":  cmdExecToNexenta  Start Time   :" + new Date());
        }
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, this.alencrypt, this.alkeyfile, this.cmd_time_out);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    ArrayList arrayList3 = new ArrayList();
                    if (arrayList2 != null) {
                        arrayList = (ArrayList)arrayList2.get(0);
                        arrayList3 = (ArrayList)arrayList2.get(1);
                        System.out.println(this.entity + " : " + this.reportingName + ":  Result Message  :" + arrayList + "      Error Message  :" + arrayList3);
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            this.logToErrorFile("ERROR :", this.reportingName, this.entity + " : " + this.reportingName + " : Error Message :" + arrayList3);
                            System.out.println(this.entity + " : " + this.reportingName + ": Result Message  :" + arrayList + "      Error Message  :" + arrayList3);
                        }
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults(string2, n, string3, string4, string5);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults(string2, n, string3, string4, string5);
            }
            if (arrayList == null) {
                System.out.println(this.entity + " : " + this.reportingName + " :    Could not execute the command, Please verify the username/password or network ");
                this.logToErrorFile("WARN  :", this.reportingName, this.entity + ":  Could not execute the command, Please verify the username/password or network ");
                return null;
            }
            if (arrayList.size() == 0) {
                System.out.println(this.entity + " : " + this.reportingName + ":    ArrayList size is  less than zero   " + string5 + " for " + this.targetHost);
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + " : " + this.reportingName + ":    Problem while executing the command " + string5 + " for " + this.targetHost);
            this.logToErrorFile("ERROR  :", this.reportingName, this.entity + ":  Problem while executing the command " + string5 + " for " + this.targetHost);
            arrayList = null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ": cmdExecToNexenta  End Time   :" + new Date() + "Command " + string5);
        }
        System.out.println(this.entity + " : " + this.reportingName + ":    Total time(millis) of cmdExecToNexenta  method process " + l3 + "  for the command  " + string5);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NexentaVolStTest nexentaVolStTest = new NexentaVolStTest(stringArray);
        nexentaVolStTest.computeMeasures(new Hashtable());
    }

    private String getElementValue(String string, String string2) {
        String string3 = string2;
        if (string == null || string.trim().length() == 0) {
            string3 = string2;
        } else {
            try {
                string3 = string.trim();
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    private double convertStringToDouble(String string, String string2) {
        double d = 0.0;
        String string3 = "";
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ":  percent strVaule  :" + string);
        }
        string3 = string.substring(0, string.indexOf(string2));
        d = EgLangInfo.getDoubleValue(string3);
        return d;
    }

    private double convertStringToDouble(String string) {
        double d = 0.0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        System.out.println(this.entity + " : " + this.reportingName + ":  strVaule  :" + string);
        string = this.getElementValue(string, "0");
        if (string.equalsIgnoreCase("0")) {
            return 0.0;
        }
        string3 = string.substring(0, string.length() - 1);
        string2 = string.substring(string.length() - 1);
        string3 = this.getElementValue(string3, "0");
        string2 = this.getElementValue(string2, "0");
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ": unit alphapet avail    =" + (sizeTypesHashtable.containsKey(string2) ? " :) avail " : " :( not avail "));
        }
        string4 = sizeTypesHashtable.containsKey(string2) ? "" + sizeTypesHashtable.get(string2) : "0";
        d = EgLangInfo.getDoubleValue(string3) * EgLangInfo.getDoubleValue(string4);
        double d2 = (Double)sizeTypesHashtable.get("M");
        d /= d2;
        if (debug) {
            System.out.println(this.entity + " : " + this.reportingName + ":  size =" + d);
        }
        return d;
    }

    static {
        sizeTypesHashtable.put("B", new Double(1.0));
        sizeTypesHashtable.put("K", new Double(1024.0));
        sizeTypesHashtable.put("M", new Double(1048576.0));
        sizeTypesHashtable.put("G", new Double(1.073741824E9));
        sizeTypesHashtable.put("T", new Double(1.073741824E9));
    }
}

