/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluCifsPerfTest
extends NAUSDCluBase {
    Hashtable prevPerfHT;

    public NetCluCifsPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<Object, ArrayList> hashtable3 = new Hashtable<Object, ArrayList>();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluCifsPerfTest ", "Connection is null");
                this.printOut("Error", "NetCluCifsPerfTest Connection is null");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluCifsPerfTest error occured while connecting ", exception.toString());
            this.printOut("Error", "NetCluCifsPerfTest error occured while connecting: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            List list;
            Object object;
            Object object2;
            Object object3;
            int n;
            String[] stringArray = new String[]{"cifs_ops", "cifs_latency", "cifs_read_ops", "cifs_write_ops", "cifs_read_latency", "cifs_write_latency", "cifs_latency_base"};
            NaElement naElement = new NaElement("perf-object-instance-list-info-iter");
            NaElement naElement2 = new NaElement("objectname", "cifs");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = this.execONTAPI(naServer, naElement);
            if (naElement3 == null) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluCifsPerfTest instance is null");
                return;
            }
            int n2 = naElement3.getChildIntValue("num-records", 0);
            if (n2 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluCifsPerfTest noOfRecords:" + n2);
                return;
            }
            List list2 = naElement3.getChildByName("attributes-list").getChildren();
            Iterator iterator = list2.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("name");
                arrayList.add(string);
            }
            int n3 = arrayList.size();
            String[] stringArray2 = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray2[i] = (String)arrayList.get(i);
            }
            NaElement naElement5 = new NaElement("perf-object-get-instances");
            NaElement naElement6 = new NaElement("objectname", "cifs");
            naElement5.addChildElem(naElement6);
            NaElement naElement7 = new NaElement("instances");
            NaElement naElement8 = new NaElement("counters");
            int n4 = stringArray2.length;
            int n5 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                naElement7.addNewChild("instance", stringArray2[n]);
            }
            for (n = 0; n < n5; ++n) {
                naElement8.addNewChild("counter", stringArray[n]);
            }
            naElement5.addChildElem(naElement7);
            naElement5.addChildElem(naElement8);
            String string = "";
            Iterator iterator2 = null;
            Iterator iterator3 = null;
            NaElement naElement9 = this.execONTAPI(naServer, naElement5);
            if (naElement9 == null) {
                this.printOut("DEBUG", "Output for cifsPerf is null");
                this.closeConnection(naServer);
                return;
            }
            Object object4 = naElement9.getChildContent("timestamp");
            Object object5 = naElement9.getChildByName("instances").getChildren();
            iterator2 = object5.iterator();
            while (iterator2.hasNext()) {
                String string2;
                object3 = (NaElement)iterator2.next();
                object2 = object3.getChildContent("name");
                object = object3.getChildContent("uuid");
                list = object3.getChildByName("counters").getChildren();
                object2 = (String)object2 + " [" + (String)object + "]";
                iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    NaElement naElement10 = (NaElement)iterator3.next();
                    string2 = naElement10.getChildContent("name");
                    long l = naElement10.getChildLongValue("value", 0L);
                    hashtable2.put(string2, new Double(l));
                }
                string2 = null;
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = this.getPerfList(hashtable2, stringArray, (String)object4, string2);
                hashtable3.put(object2, arrayList2);
            }
            if (hashtable3 == null) {
                this.closeConnection(naServer);
                return;
            }
            if (this.prevPerfHT == null) {
                this.prevPerfHT = (Hashtable)hashtable3.clone();
                this.closeConnection(naServer);
                return;
            }
            object4 = hashtable3.keys();
            object5 = null;
            object3 = null;
            object2 = null;
            object = null;
            list = null;
            while (object4.hasMoreElements()) {
                object5 = (String)object4.nextElement();
                object3 = (ArrayList)hashtable3.get(object5);
                object2 = (ArrayList)this.prevPerfHT.get(object5);
                object = this.calcPerfMeas((String)object5, (ArrayList)object3, (ArrayList)object2);
                if (((String)object5).length() > 128) {
                    int n6 = ((String)object5).length();
                    int n7 = n6 - 124;
                    int n8 = ((String)object5).lastIndexOf(93);
                    int n9 = n8 - n7;
                    String string3 = ((String)object5).substring(n9, n8);
                    object5 = this.findAndReplaceString((String)object5, string3, "...");
                }
                this.addNewMeasure((String)object5, (ArrayList)object);
            }
            this.prevPerfHT = (Hashtable)hashtable3.clone();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluCifsPerfTest error occured in computeMeasure ", exception.toString());
            this.printOut("Error", "NetCluCifsPerfTest error occured in computeMeasure:" + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    private ArrayList calcPerfMeas(String string, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList arrayList4 = this.getDiffList(arrayList, arrayList2);
        Object var6_6 = null;
        Object var7_7 = null;
        Double d = this.divide(arrayList4.get(1), arrayList4.get(0));
        Double d2 = this.divide(arrayList4.get(2), arrayList4.get(7));
        d2 = this.divide(d2, new Double(1000000.0));
        Double d3 = this.divide(arrayList4.get(3), arrayList4.get(0));
        Double d4 = this.divide(arrayList4.get(4), arrayList4.get(0));
        Double d5 = this.divide(arrayList4.get(5), arrayList4.get(3));
        d5 = this.divide(d5, new Double(1000000.0));
        Double d6 = this.divide(arrayList4.get(6), arrayList4.get(4));
        d6 = this.divide(d6, new Double(1000000.0));
        arrayList3.add(d);
        arrayList3.add(d2);
        arrayList3.add(d3);
        arrayList3.add(d4);
        arrayList3.add(d5);
        arrayList3.add(d6);
        return arrayList3;
    }

    private ArrayList getPerfList(Hashtable hashtable, String[] stringArray, String string, String string2) {
        Hashtable hashtable2 = new Hashtable();
        int n = stringArray.length;
        Double d = null;
        String string3 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(string));
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
            d = (Double)hashtable.get(string3);
            if (d == null) {
                d = NADbl;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NetCluCifsPerfTest netCluCifsPerfTest = new NetCluCifsPerfTest(stringArray);
        netCluCifsPerfTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        netCluCifsPerfTest.computeMeasures(new Hashtable());
    }
}

