/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class NAUSDiSCSIStsTest
extends NAUSDBase {
    ArrayList prevMeasList;
    ArrayList currMeasList;
    private static final int measCount = 11;
    private boolean connOk = false;
    private boolean iscsi = true;

    public NAUSDiSCSIStsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(11);
        this.isDynamicInfoTest = true;
    }

    void initializePrevMeasList() {
        this.prevMeasList = new ArrayList();
        for (int i = 0; i < 11; ++i) {
            this.prevMeasList.add(NADbl);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            if (this.connOk && this.prevMeasList != null) {
                this.initializePrevMeasList();
            }
            this.connOk = false;
            return;
        }
        this.connOk = true;
        NaElement naElement = new NaElement("iscsi-stats-list-info");
        Object object = this.execONTAPIlog(naServer, naElement);
        NaAPIFailedException naAPIFailedException = null;
        NaElement naElement2 = null;
        if (object instanceof Exception) {
            if (object instanceof NaAPIFailedException) {
                naAPIFailedException = (NaAPIFailedException)((Object)object);
                int n = naAPIFailedException.getErrno();
                if (13008 == n) {
                    if (this.iscsi) {
                        this.logToErrorFile("INFO", "NAUSDiSCSIstsTest", "NaAPIFailedException This test cannot be monitored without ISCSI License");
                        this.iscsi = false;
                    }
                } else {
                    this.logToErrorFile("INFO", "NAUSDiSCSIstsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                }
            } else {
                this.logToErrorFile("INFO", "NAUSDiSCSIstsTest", "Exception" + object.toString());
            }
        } else {
            naElement2 = (NaElement)object;
            NaElement naElement3 = naElement2.getChildByName("iscsi-stats-info");
            NaElement naElement4 = naElement3.getChildByName("iscsi-cdb-stats");
            naElement4 = naElement4.getChildByName("iscsi-cdb-stats-info");
            NaElement naElement5 = naElement3.getChildByName("iscsi-error-stats");
            naElement5 = naElement5.getChildByName("iscsi-error-stats-info");
            NaElement naElement6 = naElement3.getChildByName("iscsi-received-stats");
            naElement6 = naElement6.getChildByName("iscsi-received-stats-info");
            NaElement naElement7 = naElement3.getChildByName("iscsi-transmitted-stats");
            naElement7 = naElement3.getChildByName("iscsi-transmitted-stats-info");
            this.currMeasList = new ArrayList();
            this.currMeasList.add(this.getChildDbl(naElement4, "total"));
            this.currMeasList.add(this.getChildDbl(naElement4, "success-status"));
            this.currMeasList.add(this.getChildDbl(naElement4, "error-status"));
            this.currMeasList.add(this.getChildDbl(naElement5, "total"));
            this.currMeasList.add(this.getChildDbl(naElement5, "failed-logins"));
            this.currMeasList.add(this.getChildDbl(naElement5, "failed-logouts"));
            this.currMeasList.add(this.getChildDbl(naElement5, "failed-task-mgt"));
            this.currMeasList.add(this.getChildDbl(naElement5, "protocol"));
            this.currMeasList.add(this.getChildDbl(naElement6, "login-req"));
            this.currMeasList.add(this.getChildDbl(naElement6, "logout-req"));
            this.currMeasList.add(this.getChildDbl(naElement7, "reject"));
            this.printOut("DEBUG", "CurrMeasList is " + this.currMeasList);
            if (this.prevMeasList == null) {
                this.prevMeasList = this.currMeasList;
                this.printOut("INFO", "Returning after setting prevMeasList to " + this.prevMeasList);
                return;
            }
            ArrayList arrayList = this.getDiffList(this.prevMeasList, this.currMeasList);
            System.out.println("[NAUSDiSCSIStatsTest_ex] ===>  diffList  \t" + arrayList);
            this.addNewMeasure(arrayList);
            this.printOut("INFO", "Added diff List measure ");
        }
        this.closeConnection(naServer);
    }

    public static void main(String[] stringArray) {
        NAUSDiSCSIStsTest nAUSDiSCSIStsTest = new NAUSDiSCSIStsTest(stringArray);
        while (true) {
            try {
                while (true) {
                    nAUSDiSCSIStsTest.computeMeasures(new Hashtable());
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

