/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgTesterInfo;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;

public class NAUSDCluBase
extends GenericTest {
    private int AuthMech;
    private String user;
    private String password;
    private int APIPort;
    private boolean useSSL;
    private static final int majorVersion = 1;
    private int minorVersion;
    private int timeout;
    private SimpleDateFormat mySDF;
    protected static final Double NADbl = new Double(-5.0);
    protected static final Double FalseDbl = new Double(0.0);
    protected static final Double TrueDbl = new Double(1.0);
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    public static final String maxIterRecs = "20";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NAUSDCluBase(String[] stringArray) {
        block21: {
            Object object;
            String string;
            super(stringArray);
            this.useSSL = false;
            this.minorVersion = 0;
            this.timeout = 120;
            this.mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a");
            if (fieldSep.length() == 0) {
                string = sync0;
                synchronized (string) {
                    if (fieldSep.length() == 0) {
                        object = new EgTesterInfo("agent");
                        fieldSep = ((EgTesterInfo)object).getDDSeparator1();
                    }
                }
            }
            string = this.getValueForParam("Authentication_Mechanism");
            this.AuthMech = 1;
            System.out.println(" AuthMech:" + this.AuthMech);
            if (string == null || string.equalsIgnoreCase("LOGIN_PASSWORD")) {
                this.printOut("INFO", "Authentication Mechanism : login/password");
            } else if (string.equalsIgnoreCase("HOSTS.EQUIV FILE")) {
                this.AuthMech = 2;
                this.printOut("INFO", "Authentication Mechanism : hosts.equiv file");
            } else if (string.equalsIgnoreCase("WINDOWS RPC")) {
                this.AuthMech = 3;
                this.printOut("INFO", "Authentication Mechanism : Windows RPC authentication");
            }
            object = this.getValueForParam("Use_SSL");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                this.useSSL = true;
                this.printOut("INFO", "Transport type is HTTPS");
            } else {
                this.useSSL = false;
                this.printOut("INFO", "Transport type is HTTP");
            }
            String string2 = this.getValueForParam("API_Port");
            if (string2 != null && !string2.equalsIgnoreCase("default")) {
                try {
                    this.APIPort = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.useSSL) {
                        this.APIPort = 443;
                        break block21;
                    }
                    this.APIPort = 80;
                }
            } else {
                this.APIPort = this.useSSL ? 443 : 80;
            }
        }
        this.printOut("INFO", "Using API port : " + this.APIPort);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.AuthMech != 2 && this.user.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
            this.logToErrorFile("ERROR", this.entity, "For login/password authentication or Windows RPC authentication, both username and password cannot be 'none'");
            this.printOut("ERROR", "For login/password authentication or Windows RPC authentication, both username and password cannot be 'none'");
        }
        String string = this.getValueForParam("timeout(secs)");
        this.printOut("SUPER_DEBUG", "Timeout string is " + string);
        if (string != null && !string.equals("120")) {
            try {
                this.timeout = Integer.parseInt(string);
                this.printOut("INFO", "Timeout in seconds is " + this.timeout);
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("ERROR", "Could not parse specified timeout " + string + ". Using 120 seconds");
                this.timeout = 120;
            }
        }
    }

    protected NaServer getConnection() {
        if (this.AuthMech != 2 && this.user.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
            this.printOut("ERROR", "Not creating connection due to no user and password being specified");
            return null;
        }
        NaServer naServer = null;
        try {
            naServer = new NaServer(this.targetHost, 1, this.minorVersion);
            this.printOut("DEBUG", "Created NaServer for NA USD at " + this.targetHost + " object with version " + 1 + "." + this.minorVersion);
        }
        catch (UnknownHostException unknownHostException) {
            this.logToErrorFile("ERROR", this.entity, "UnknownHostException upon trying to create server connection to " + this.targetHost + " : " + unknownHostException.toString());
            this.printOut("ERROR", "UnknownHostException upon trying to create server connection to " + this.targetHost + " : " + unknownHostException.toString());
            return null;
        }
        naServer.setStyle(this.AuthMech);
        if (this.AuthMech != 2) {
            naServer.setAdminUser(this.user, this.password);
            this.printOut("DEBUG", "set server admin user");
        }
        if (this.useSSL) {
            naServer.setTransportType(2);
        } else {
            naServer.setTransportType(1);
        }
        naServer.setPort(this.APIPort);
        naServer.setTimeout(this.timeout);
        if (naServer != null) {
            this.printOut("INFO", "Connection created ");
        }
        return naServer;
    }

    protected NaElement execONTAPI(NaServer naServer, NaElement naElement) {
        this.printOut("DEBUG", "Executing " + naElement.getName() + "." + naElement.getContent());
        NaElement naElement2 = null;
        boolean bl = false;
        String string = "";
        try {
            naElement2 = naServer.invokeElem(naElement);
        }
        catch (NaAuthenticationException naAuthenticationException) {
            string = "username/password is invalid. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naAuthenticationException.toString();
            bl = true;
        }
        catch (NaAPIFailedException naAPIFailedException) {
            string = "Server returned a failure result. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naAPIFailedException.toString();
            bl = true;
        }
        catch (NaProtocolException naProtocolException) {
            string = "Protocol issue encountered. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naProtocolException.toString();
            bl = true;
        }
        catch (IOException iOException) {
            string = "Communication issue encountered. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + iOException.toString();
            bl = true;
        }
        catch (Exception exception) {
            string = "Exception occurred. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + exception.toString();
            bl = true;
        }
        if (!bl && naElement2 == null) {
            string = "No exceptions but output null while executing " + naElement.getName() + "." + naElement.getContent();
            bl = true;
        }
        if (bl) {
            this.logToErrorFile("ERROR", this.entity, string);
            this.printOut("ERROR", string);
            return null;
        }
        return naElement2;
    }

    protected Object execONTAPIlog(NaServer naServer, NaElement naElement) {
        this.printOut("DEBUG", "Executing with output/exception  : " + naElement.getName() + "." + naElement.getContent());
        NaElement naElement2 = null;
        boolean bl = false;
        String string = "";
        try {
            naElement2 = naServer.invokeElem(naElement);
        }
        catch (Exception exception) {
            return exception;
        }
        return naElement2;
    }

    protected void closeConnection(NaServer naServer) {
        if (naServer != null) {
            naServer.close();
            this.printOut("INFO", "Connection closed");
        }
    }

    protected void printOut(String string, String string2) {
        System.out.println("[ " + string + " ] [ " + this.targetHost + " " + this.mySDF.format(new Date()) + "] " + this.entity + " : " + string2);
    }

    protected Double getChildDbl(NaElement naElement, String string) {
        if (naElement == null) {
            this.printOut("DEBUG", "getChildDbl parent Element null for child " + string + ". returning NaDbl");
            return NADbl;
        }
        String string2 = naElement.getChildContent(string);
        Double d = null;
        if (string2 == null) {
            this.printOut("INFO", "Could not find child of name " + string + " in parent element " + naElement.getName());
            return NADbl;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.printOut("ERROR", "Could not parse value '" + string2 + "' for " + naElement.getName() + "." + string);
            d = NADbl;
        }
        return d;
    }

    protected Double getChildBooleanMeas(NaElement naElement, String string) {
        if (naElement == null) {
            this.printOut("DEBUG", "getChildBooleanMeas parent Element null for child " + string + ". returning false");
            return FalseDbl;
        }
        String string2 = naElement.getChildContent(string);
        if (string2.equalsIgnoreCase("true")) {
            return TrueDbl;
        }
        return FalseDbl;
    }

    protected Double calculatePercentage(Object object, Object object2) {
        double d = (Double)object;
        double d2 = (Double)object2;
        if (d2 == 0.0) {
            return NADbl;
        }
        double d3 = d / d2 * 100.0;
        return new Double(d3);
    }

    protected Double divide(Object object, Object object2) {
        double d = (Double)object;
        double d2 = (Double)object2;
        if (d2 > 0.0 && d >= 0.0) {
            double d3 = d / d2;
            return new Double(d3);
        }
        return FalseDbl;
    }

    public double convertBytesToMB(double d) {
        double d2 = -5.0;
        try {
            d2 = d / 1048576.0;
        }
        catch (Exception exception) {
            d2 = -5.0;
        }
        return d2;
    }

    protected double stringtoDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    protected ArrayList getDiffList(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.size() != arrayList.size()) {
            this.printOut("ERROR", "Cannot diff lists of unequal sizes. prev size = " + arrayList2.size() + " and  curr List size " + arrayList.size());
            return null;
        }
        this.printOut("INFO", "getDiffList: prevMeasList is " + arrayList2.toString());
        this.printOut("INFO", "getDiffList: currMeasList is " + arrayList.toString());
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Double d = (Double)arrayList2.get(i);
            Double d2 = (Double)arrayList.get(i);
            if (d.equals(NADbl) || d2.equals(NADbl)) {
                arrayList3.add(NADbl);
                continue;
            }
            double d3 = d;
            double d4 = d2;
            double d5 = d4 - d3;
            if (d5 < 0.0) {
                arrayList3.add(NADbl);
                continue;
            }
            arrayList3.add(new Double(d5));
        }
        this.printOut("INFO", "getDiffList: diffMeasList is " + arrayList3.toString());
        return arrayList3;
    }

    protected static ArrayList getDummyList(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(NADbl);
        }
        return arrayList;
    }

    protected String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"user_writes"};
        NAUSDCluBase nAUSDCluBase = new NAUSDCluBase(stringArray);
        NaServer naServer = nAUSDCluBase.getConnection();
        if (naServer == null) {
            return;
        }
        nAUSDCluBase.closeConnection(naServer);
    }
}

