/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MsSqlValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String sid = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String oracle_homeDir = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String NTLMv2 = "";
    public String sqlVersion = "";
    public boolean isConnectivityOk = true;
    public boolean isSqlInstanceOk = false;
    public boolean isTableInfoComing = true;
    public boolean isExternalTest = false;
    public boolean isAdminRole = true;
    public boolean meAgentLess = false;
    public boolean isNTLMv2 = false;
    public boolean isSystemAdminRole = false;
    private String instance = "default";
    private String ssl = "false";
    private String dbName = "master";
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private boolean isInstanceBased = false;
    EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

    public MsSqlValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-instance")) {
                    this.instance = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    String string4 = string3.substring(0, string3.indexOf("@"));
                    if (this.specsInfo.isExternalTest(this.test)) {
                        this.isExternalTest = true;
                    }
                    if (!string4.equalsIgnoreCase("MsSqlSpaceTest") && !string4.equalsIgnoreCase("MsSqlEngineTest")) continue;
                    this.isSystemAdminRole = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.ssl = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-isntlmv2")) continue;
                this.NTLMv2 = string3;
                if (this.NTLMv2 == null || !this.NTLMv2.trim().equalsIgnoreCase("true") && !this.NTLMv2.trim().equalsIgnoreCase("yes")) continue;
                this.isNTLMv2 = true;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.instance;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkMsSqlConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (this.isInstanceBased) {
                    if (!this.isIPReachable()) {
                        this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                        this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                        this.validationMsgs.add("Port$#$NA");
                    } else {
                        String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                        this.validationMsgs.add("SQL Server Connectivity$#$" + string);
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Port$#$NA");
                    }
                } else if (!this.isIPReachable()) {
                    this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (this.port != null && !this.port.equalsIgnoreCase("NULL") && !this.isPortReachable()) {
                    this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect or doesn't exist");
                } else {
                    String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                    this.validationMsgs.add("SQL Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("SQL Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                if (this.isInstanceBased) {
                    this.validationMsgs.add("Port$#$NA");
                } else {
                    this.validationMsgs.add("Port$#$OK");
                }
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMsSqlConnectivity() {
        this.host = IPV6Helper.getValidIPAddress(this.host);
        boolean bl = false;
        boolean bl2 = true;
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "";
        String string3 = "";
        String string4 = "SELECT IS_SRVROLEMEMBER('sysadmin')";
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Properties properties = new Properties();
            if (!this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            if (this.instance == null || this.instance.length() == 0 || this.instance.equalsIgnoreCase("default") || this.instance.equalsIgnoreCase("none")) {
                string2 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
            } else {
                this.isInstanceBased = true;
                if (this.port == null || this.port.equalsIgnoreCase("NULL")) {
                    string2 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                } else {
                    string2 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
                    if ("true".equalsIgnoreCase(this.ssl)) {
                        string2 = string2 + ";ssl=request";
                    }
                    string3 = string2;
                    try {
                        connection = DriverManager.getConnection(string3, properties);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (connection == null) {
                        string2 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                    }
                }
            }
            if (connection == null) {
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string2 = string2 + ";ssl=request";
                }
                string3 = string2;
                connection = DriverManager.getConnection(string3, properties);
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            if (this.isSystemAdminRole) {
                String string5;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                if (resultSet.next() && (string5 = resultSet.getString(1)).equalsIgnoreCase("0")) {
                    bl2 = false;
                }
                resultSet.close();
                statement.close();
                connection.commit();
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string6 = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string7 = this.getStackTraceAsString(sQLException);
            switch (n) {
                case 0: {
                    if (string6.indexOf("has no instance") > -1) {
                        string6 = " SQL Instance '" + this.instance + "' not running or unavailable";
                        bl = true;
                        break;
                    }
                    if (string6.indexOf("Unable to get information from SQL Server:") > -1) {
                        string6 = " Unable to get Infomation from SQL server due to some errors";
                        bl = true;
                        break;
                    }
                    if (string6.indexOf("DB server closed connection") > -1) {
                        string6 = "DB server closed connection due to some errors";
                        bl = true;
                        break;
                    }
                    if (string6.indexOf("SQL Server Browser service is not running") <= -1) break;
                    string6 = "SQL Server Browser service is not running or unavailable";
                    bl = true;
                    break;
                }
                case 18456: {
                    System.out.println("inside error code 18456 ");
                    string6 = "Invalid username/password; logon denied";
                    bl = true;
                    break;
                }
                case 18452: {
                    string6 = "Invalid username/password; or Domain Doesn't Exist ; logon denied";
                    bl = true;
                }
            }
            string = string7.substring(0, string7.indexOf("at"));
            this.validationErrorMsg = bl ? string6.trim() : string;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    stringBuffer.append(string8.trim() + " ");
                }
                this.validationErrorMsg = stringBuffer.toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            this.errorMsg = string6.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string7.trim() + "#" + this.getCurrentTime();
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            this.isConnectivityOk = false;
            String string9 = this.getStackTraceAsString(exception);
            this.validationErrorMsg = string;
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string9.trim() + "#" + this.getCurrentTime();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2) {
            this.validationErrorMsg = "User '" + this.user + "' doesn't have  SysAdmin role";
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            return false;
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkMsSqlVersion() {
        this.host = IPV6Helper.getValidIPAddress(this.host);
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string = "select @@version";
        String string2 = "Microsoft SQL Server ";
        String string3 = "";
        try {
            String string4;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Properties properties = new Properties();
            if (!this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            if (this.instance == null || this.instance.length() == 0 || this.instance.equalsIgnoreCase("default") || this.instance.equalsIgnoreCase("none")) {
                string4 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
            } else if (this.port == null || this.port.equalsIgnoreCase("NULL")) {
                string4 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
            } else {
                string4 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string4 = string4 + ";ssl=request";
                }
                string3 = string4;
                try {
                    connection = DriverManager.getConnection(string3, properties);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (connection == null) {
                    string4 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                }
            }
            if (connection == null) {
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string4 = string4 + ";ssl=request";
                }
                string3 = string4;
                connection = DriverManager.getConnection(string3, properties);
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }
}

