/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class McfeeMemoryTest
extends EgSnmpGenericTest {
    private static final int Mcafee_Memory_MEASURE_COUNT = 5;
    double bytomb = 1048576.0;

    public McfeeMemoryTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.247", "-port", "NULL", "snmpPort", "161", "snmpversion", "v1", "snmpCommunity", "public"};
        McfeeMemoryTest mcfeeMemoryTest = new McfeeMemoryTest(stringArray2);
        mcfeeMemoryTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.1230.2.4.1.2.3.1.5.0");
            double d2 = this.getMeasure(".1.3.6.1.4.1.1230.2.4.1.2.3.1.7.0");
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            if (d > 0.0 && d2 > 0.0) {
                d5 = d + d2;
                d3 = d / d5 * 100.0;
                d4 = d2 / d5 * 100.0;
                d5 /= this.bytomb;
                d /= this.bytomb;
                d2 /= this.bytomb;
            } else {
                d5 = -5.0;
                d = -5.0;
                d2 = -5.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", this.entity + "error occured in computeMeasure", exception.toString());
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    this.logToErrorFile("Error :", this.entity + ",error occured in getMeasure", exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }
}

