/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.egurkha.util.EgStreamReaderThread;
import com.egurkha.util.LogFileReader;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class JvmMemPoolGCTest
extends JVMInstrumentation {
    private String JVM_Version = null;
    private String JVM_1_3_1_MinorGC = "[GC";
    private String JVM_1_3_1_FullGC = "[Full GC ";
    private boolean measure_mode = true;
    private Hashtable prev_infoFileName = new Hashtable();
    private Hashtable logFileSizeLast = new Hashtable();
    private Hashtable logFileTimestampLast = new Hashtable();

    public JvmMemPoolGCTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("measure_mode");
        if (string == null || string.equalsIgnoreCase("false")) {
            this.measure_mode = false;
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeMeasures(Hashtable hashtable) {
        this.getJvmGuid();
        if (this.mode_type.equalsIgnoreCase("Log File")) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.JVM_1_3_1_MinorGC);
            arrayList.add(this.JVM_1_3_1_FullGC);
            if (this.JVM_Version == null) {
                string = (String)hashtable.get("JREHome");
                this.JVM_Version = this.getJVMVersion(string);
                if (this.JVM_Version.equals("-1")) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "jdkHome is " + string);
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Could not find JVM version; can't run JVMGCTest");
                    return;
                }
            } else if (this.JVM_Version.equals("-1")) {
                return;
            }
            string = (String)hashtable.get("LogFileName");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "@");
                String string3 = "NONE";
                if (stringTokenizer2.countTokens() == 2) {
                    string3 = stringTokenizer2.nextToken();
                } else {
                    if (bl) continue;
                    bl = true;
                }
                string = stringTokenizer2.nextToken();
                File file = new File(string);
                Object object2 = null;
                if (file.isDirectory()) {
                    object = file.listFiles();
                    int n = 0;
                    if (object != null && ((File[])object).length > 0) {
                        long l = 0L;
                        for (int i = 0; i < ((File[])object).length; ++i) {
                            if (((File)object[i]).lastModified() <= l) continue;
                            n = i;
                            l = ((File)object[i]).lastModified();
                        }
                        object2 = object[n];
                    }
                    if (object2 == null) {
                        this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Unable to find files inside the dir " + file);
                        continue;
                    }
                } else {
                    object2 = file;
                }
                object = (String)this.prev_infoFileName.get(string3);
                if (!((File)object2).exists()) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Log file " + ((File)object2).toString() + " does not exist for " + string3);
                    continue;
                }
                if (object != null && !((String)object).equals(((File)object2).toString())) {
                    this.uploadValues(string3, "[Full GC]", -1);
                    this.uploadValues(string3, "[Minor GC]", -1);
                    this.prev_infoFileName.put(string3, ((File)object2).toString());
                    this.logFileSizeLast.put(string3, ((File)object2).length() + "");
                    this.logFileTimestampLast.put(string3, ((File)object2).lastModified() + "");
                    continue;
                }
                if (((File)object2).length() == 0L) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Log file " + ((File)object2).toString() + " is empty for " + string3);
                    this.uploadValues(string3, "[Full GC]", -1);
                    this.uploadValues(string3, "[Minor GC]", -1);
                    this.prev_infoFileName.put(string3, ((File)object2).toString());
                    continue;
                }
                if (this.timeSinceLastTest == -1.0) {
                    this.logFileSizeLast.put(string3, ((File)object2).length() + "");
                    this.logFileTimestampLast.put(string3, ((File)object2).lastModified() + "");
                    this.uploadValues(string3, "[Full GC]", -1);
                    this.uploadValues(string3, "[Minor GC]", -1);
                    this.prev_infoFileName.put(string3, ((File)object2).toString());
                    continue;
                }
                ArrayList arrayList2 = this.getGCOutputFromLogFile((File)object2, arrayList, string3);
                if (arrayList2 == null || arrayList2.size() == 0) {
                    this.uploadValues(string3, "[Full GC]", 0);
                    this.uploadValues(string3, "[Minor GC]", 0);
                    this.prev_infoFileName.put(string3, ((File)object2).toString());
                    continue;
                }
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                int n = 0;
                if (arrayList2 != null) {
                    n = arrayList2.size();
                }
                String string4 = "";
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                String string5 = null;
                String string6 = null;
                String string7 = null;
                for (int i = 0; i < n; ++i) {
                    StringTokenizer stringTokenizer3;
                    String string8 = (String)arrayList2.get(i);
                    String string9 = this.parseValues(string8);
                    if (!this.JVM_Version.startsWith("1.3")) {
                        string4 = string9.substring(0, string9.indexOf(","));
                        string9 = string9.substring(string9.indexOf(",") + 1);
                    }
                    if ((stringTokenizer3 = new StringTokenizer(string9, ",")).countTokens() != 4) continue;
                    double d11 = Double.parseDouble(stringTokenizer3.nextToken().trim());
                    double d12 = Double.parseDouble(stringTokenizer3.nextToken().trim());
                    double d13 = Double.parseDouble(stringTokenizer3.nextToken().trim());
                    String string10 = stringTokenizer3.nextToken().trim();
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(3);
                    if (string10.equals("F")) {
                        d4 += 1.0;
                        d += d11;
                        d2 += d12;
                        d3 += d13;
                        if (d13 > d5) {
                            d5 = d13;
                        }
                        if (!this.JVM_Version.startsWith("1.3")) {
                            string5 = this.filterComma(numberFormat.format(this.convertToMBs(d11 + "")));
                            string6 = this.filterComma(numberFormat.format(this.convertToMBs(d12 + "")));
                            string7 = this.filterComma(numberFormat.format(d13));
                            vector.add(string4 + "," + string5 + "(MB)," + string6 + "(MB)," + string7 + "(Secs)");
                            continue;
                        }
                        string5 = this.filterComma(numberFormat.format(this.convertToMBs(d11 + "")));
                        string6 = this.filterComma(numberFormat.format(this.convertToMBs(d12 + "")));
                        string7 = this.filterComma(numberFormat.format(d13));
                        vector.add("NONE," + string5 + "(MB)," + string6 + "(MB)," + string7 + "(Secs)");
                        continue;
                    }
                    d9 += 1.0;
                    d6 += d11;
                    d7 += d12;
                    d8 += d13;
                    if (d13 > d10) {
                        d10 = d13;
                    }
                    if (!this.JVM_Version.startsWith("1.3")) {
                        string5 = this.filterComma(numberFormat.format(this.convertToMBs(d11 + "")));
                        string6 = this.filterComma(numberFormat.format(this.convertToMBs(d12 + "")));
                        string7 = this.filterComma(numberFormat.format(d13));
                        vector2.add(string4 + "," + string5 + "(MB)," + string6 + "(MB)," + string7 + "(Secs)");
                        continue;
                    }
                    string5 = this.filterComma(numberFormat.format(this.convertToMBs(d11 + "")));
                    string6 = this.filterComma(numberFormat.format(this.convertToMBs(d12 + "")));
                    string7 = this.filterComma(numberFormat.format(d13));
                    vector2.add("NONE," + string5 + "(MB)," + string6 + "(MB)," + string7 + "(Secs)");
                }
                ArrayList<Double> arrayList3 = null;
                if (d4 > 0.0) {
                    double d14 = d3 / d4;
                    double d15 = this.timeSinceLastTest / d4;
                    arrayList3 = new ArrayList<Double>();
                    arrayList3.add(new Double(d4));
                    arrayList3.add(new Double(d3));
                    arrayList3.add(new Double(d15));
                    arrayList3.add(new Double(d14));
                    arrayList3.add(new Double(d14 / d15 * 100.0));
                    arrayList3.add(new Double(d5));
                    arrayList3.add(new Double(d / d4 / 1024.0));
                    arrayList3.add(new Double(d2 / d4 / 1024.0));
                    if (string3.equals("NONE")) {
                        this.addNewMeasure("[Full GC]", arrayList3);
                    } else {
                        this.addNewMeasure(string3 + "[Full GC]", arrayList3);
                    }
                } else if (d4 == 0.0) {
                    this.uploadValues(string3, "[Full GC]", 0);
                }
                if (d9 > 0.0) {
                    double d16 = d8 / d9;
                    double d17 = this.timeSinceLastTest / d9;
                    arrayList3 = new ArrayList();
                    arrayList3.add(new Double(d9));
                    arrayList3.add(new Double(d8));
                    arrayList3.add(new Double(d17));
                    arrayList3.add(new Double(d16));
                    arrayList3.add(new Double(d16 / d17 * 100.0));
                    arrayList3.add(new Double(d10));
                    arrayList3.add(new Double(d6 / d9 / 1024.0));
                    arrayList3.add(new Double(d7 / d9 / 1024.0));
                    if (string3.equals("NONE")) {
                        this.addNewMeasure("[Minor GC]", arrayList3);
                    } else {
                        this.addNewMeasure(string3 + "[Minor GC]", arrayList3);
                    }
                } else if (d9 == 0.0) {
                    this.uploadValues(string3, "[Minor GC]", 0);
                }
                this.prev_infoFileName.put(string3, ((File)object2).toString());
            }
            return;
        }
        if (this.mode_type.equalsIgnoreCase("Jmx")) {
            Hashtable hashtable2 = null;
            JvmHelperThread jvmHelperThread = new JvmHelperThread(this.entity, this, this.urlStr, this.userName, this.password);
            long l = 0L;
            long l2 = this.timeout;
            long l3 = 250L;
            int n = 0;
            int n2 = 0;
            long l4 = System.currentTimeMillis();
            boolean bl = false;
            while (true) {
                this.suspendForPeriod(l3);
                if (jvmHelperThread.isDone()) {
                    n2 = jvmHelperThread.getStatusCode();
                    bl = jvmHelperThread.isStatus();
                    hashtable2 = jvmHelperThread.getResult();
                    break;
                }
                if (++n >= 5) {
                    n = 0;
                    l = System.currentTimeMillis() - l4;
                } else {
                    l += l3;
                }
                if (l >= l2 || l3 <= 0L) {
                    jvmHelperThread.closeJVMconnectionWhenInterrupt();
                    break;
                }
                long l5 = l2 - l;
                if (l5 >= l3) continue;
                l3 = l5;
            }
            if (n2 != 100 || !bl) return;
            try {
                this.getMeasures(hashtable2);
                return;
            }
            catch (Exception exception) {
                System.out.println(exception.toString() + " in " + this.entity + " JMX mode...");
                exception.printStackTrace();
            }
            return;
        }
        if (!this.mode_type.equalsIgnoreCase("Jar")) return;
        Hashtable<String, Hashtable> hashtable3 = new Hashtable<String, Hashtable>();
        Hashtable hashtable4 = null;
        try {
            Object object;
            Object object3;
            Object object4;
            ArrayList arrayList = this.getJarModeData();
            if (arrayList != null && arrayList.size() > 0 && (object4 = (Hashtable)arrayList.get(0)) != null) {
                hashtable4 = (Hashtable)((Hashtable)object4).get("collectorNames");
            }
            if (hashtable4 == null || hashtable4.size() <= 0) return;
            object4 = hashtable4.keySet();
            Iterator iterator = object4.iterator();
            String string = this.getPreviousValue();
            StringBuilder stringBuilder = new StringBuilder();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string != null && string.length() > 0) {
                try {
                    object3 = new StringTokenizer(string, "#");
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        object = ((StringTokenizer)object3).nextToken();
                        if (object == null || ((String)object).indexOf("|") <= -1) continue;
                        String string11 = ((String)object).substring(0, ((String)object).indexOf("|"));
                        String string12 = ((String)object).substring(((String)object).indexOf("|") + 1);
                        hashMap.put(string11, string12);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (iterator.hasNext()) {
                long l;
                String string13;
                Hashtable hashtable5;
                block63: {
                    block62: {
                        object3 = iterator.next().toString();
                        if (object3 == null || ((String)object3).length() <= 0) continue;
                        object = (Hashtable)hashtable4.get(object3);
                        long l6 = 0L;
                        long l7 = 0L;
                        hashtable5 = new Hashtable();
                        string13 = null;
                        try {
                            string13 = ((Hashtable)object).get("collectorName").toString();
                            if (string13 == null) {
                            }
                            break block62;
                        }
                        catch (Exception exception) {
                            System.out.println("[JvmMemPoolGCTest] collectorName is not available in the result data " + object);
                        }
                        continue;
                    }
                    l = 0L;
                    try {
                        if (!((Hashtable)object).containsKey("CollectionCount")) break block63;
                        l = (Long)((Hashtable)object).get("CollectionCount");
                        long l8 = 0L;
                        String string14 = (String)hashMap.get(string13);
                        if (string14 != null) {
                            try {
                                l8 = Long.parseLong(string14);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        long l9 = 0L;
                        if (l8 > 0L && l8 <= l) {
                            l9 = l - l8;
                        }
                        hashtable5.put("CollectionCount", new Long(l9));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                int n = stringBuilder.length();
                if (n > 0) {
                    stringBuilder.append("#");
                }
                stringBuilder.append(string13).append("|").append(l);
                Hashtable hashtable6 = (Hashtable)((Hashtable)object).get("fullGcTable");
                if (hashtable6 == null || hashtable6.size() == 0) continue;
                hashtable5 = JvmMemPoolGCTest.getDataFromFullGCTable(hashtable6, hashtable5);
                hashtable3.put(string13, hashtable5);
            }
            this.setCurrentValue(stringBuilder.toString());
            this.getMeasures(hashtable3);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString() + " in " + this.entity + " JAR mode...");
            exception.printStackTrace();
        }
    }

    public void getMeasures(Hashtable hashtable) {
        try {
            if (hashtable != null && hashtable.size() > 0) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable2;
                    String string = "";
                    String string2 = (String)enumeration.nextElement();
                    if (string2 != null) {
                        string = string2 + ":";
                    }
                    if ((hashtable2 = (Hashtable)hashtable.get(string2)) == null) continue;
                    double d = ((Long)hashtable2.get("startTime")).doubleValue();
                    double d2 = ((Long)hashtable2.get("endTime")).doubleValue();
                    double d3 = ((Long)hashtable2.get("CollectionCount")).doubleValue();
                    double d4 = -5.0;
                    double d5 = -5.0;
                    double d6 = -5.0;
                    double d7 = -5.0;
                    double d8 = -5.0;
                    double d9 = -5.0;
                    double d10 = -5.0;
                    double d11 = -5.0;
                    double d12 = -5.0;
                    double d13 = -5.0;
                    double d14 = 0.0;
                    if (!hashtable2.containsKey("memoryBeforeGc") || !hashtable2.containsKey("memoryAfterGc")) continue;
                    Hashtable hashtable3 = (Hashtable)hashtable2.get("memoryBeforeGc");
                    Hashtable hashtable4 = (Hashtable)hashtable2.get("memoryAfterGc");
                    Set set = hashtable3.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ArrayList<Double> arrayList = new ArrayList<Double>();
                        String string3 = (String)iterator.next();
                        if (string3 == null) continue;
                        String string4 = string + string3;
                        if (d3 > 0.0) {
                            d14 = 1.0;
                            d5 = (d2 - d) / 1000.0;
                            Hashtable hashtable5 = (Hashtable)hashtable3.get(string3);
                            Hashtable hashtable6 = (Hashtable)hashtable4.get(string3);
                            Long l = (Long)hashtable5.get("init");
                            String string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d6 = Double.parseDouble(string5);
                            l = (Long)hashtable6.get("init");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d7 = Double.parseDouble(string5);
                            l = (Long)hashtable5.get("max");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d8 = Double.parseDouble(string5);
                            l = (Long)hashtable6.get("max");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d9 = Double.parseDouble(string5);
                            l = (Long)hashtable5.get("committed");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d10 = Double.parseDouble(string5);
                            l = (Long)hashtable6.get("committed");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d11 = Double.parseDouble(string5);
                            l = (Long)hashtable5.get("used");
                            string5 = l.toString();
                            string5 = EgUtils.convertMemoryValues(string5, "B", "MB");
                            d12 = Double.parseDouble(string5);
                            l = (Long)hashtable6.get("used");
                            string5 = l.toString();
                            d13 = Double.parseDouble(string5 = EgUtils.convertMemoryValues(string5, "B", "MB"));
                            d4 = d12 > d13 ? (d12 - d13) / d8 * 100.0 : -5.0;
                            arrayList.add(new Double(d14));
                            arrayList.add(new Double(d3));
                            arrayList.add(new Double(d6));
                            arrayList.add(new Double(d7));
                            arrayList.add(new Double(d8));
                            arrayList.add(new Double(d9));
                            arrayList.add(new Double(d10));
                            arrayList.add(new Double(d11));
                            arrayList.add(new Double(d12));
                            arrayList.add(new Double(d13));
                            arrayList.add(new Double(d4));
                            arrayList.add(new Double(d5));
                            this.addNewMeasure(string4, arrayList);
                            continue;
                        }
                        arrayList.add(new Double(d14));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d7));
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d9));
                        arrayList.add(new Double(d10));
                        arrayList.add(new Double(d11));
                        arrayList.add(new Double(d12));
                        arrayList.add(new Double(d13));
                        arrayList.add(new Double(d4));
                        arrayList.add(new Double(d5));
                        this.addNewMeasure(string4, arrayList);
                    }
                }
            } else {
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.addNewMeasure(this.measures);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString() + " in " + this.entity + " " + this.mode_type + " mode...");
            exception.printStackTrace();
        }
    }

    private String filterComma(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (string.indexOf(",") > -1) {
            stringBuffer = stringBuffer.deleteCharAt(string.indexOf(","));
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getGCOutputFromLogFile(File file, ArrayList arrayList, String string) {
        ArrayList<String> arrayList2;
        block24: {
            long l = file.lastModified();
            long l2 = file.length();
            String string2 = (String)this.logFileSizeLast.get(string);
            long l3 = 0L;
            long l4 = 0L;
            if (string2 != null) {
                l3 = Long.parseLong(string2);
            }
            if ((string2 = (String)this.logFileTimestampLast.get(string)) != null) {
                l4 = Long.parseLong(string2);
            }
            if (l == l4 && l2 == l3) {
                return null;
            }
            if (l2 < l3) {
                l3 = l2;
            }
            arrayList2 = new ArrayList<String>();
            try {
                LogFileReader logFileReader = new LogFileReader(file, l3);
                String string3 = "";
                if (this.JVM_Version.startsWith("1.3")) {
                    block7: while ((string3 = logFileReader.readLine()) != null) {
                        if (string3.indexOf("[GC") <= -1 && string3.indexOf("[Full GC ") <= -1) continue;
                        if (string3.indexOf("->") > -1) {
                            arrayList2.add(string3);
                            continue;
                        }
                        boolean bl = false;
                        if (string3.indexOf("[Full GC") > -1) {
                            bl = true;
                        }
                        while ((string3 = logFileReader.readLine()) != null) {
                            if (string3.indexOf("->") <= -1) continue;
                            string3 = bl ? "[Full GC " + string3 : "[GC " + string3;
                            arrayList2.add(string3);
                            continue block7;
                        }
                    }
                    break block24;
                }
                block9: while ((string3 = logFileReader.readLine()) != null) {
                    if (string3.indexOf("[GC") <= -1 && string3.indexOf("[Full GC ") <= -1 && string3.indexOf("[Full GC") <= -1) continue;
                    if (string3.indexOf("->") > -1) {
                        arrayList2.add(string3);
                        continue;
                    }
                    boolean bl = false;
                    if (string3.indexOf("[Full GC") > -1) {
                        bl = true;
                    }
                    String string4 = null;
                    if (!string3.startsWith("[GC") && !string3.startsWith("[Full GC")) {
                        int n;
                        String string5 = null;
                        String string6 = ": [GC ";
                        if (bl) {
                            string6 = ": [Full GC ";
                        }
                        if ((n = string3.indexOf(string6)) > -1) {
                            string5 = string3.substring(0, n);
                            int n2 = string5.lastIndexOf(" ");
                            string4 = n2 > -1 ? string5.substring(n2 + 1, n) : string5.substring(0, n);
                        }
                        if (string4 != null) {
                            try {
                                Double.parseDouble(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                string4 = null;
                            }
                        }
                    }
                    while ((string3 = logFileReader.readLine()) != null) {
                        if (string3.indexOf("->") <= -1) continue;
                        string3 = bl ? (string4 != null ? string4 + ":[Full GC " + string3 : "[Full GC " + string3) : (string4 != null ? string4 + ":[GC " + string3 : "[GC " + string3);
                        arrayList2.add(string3);
                        continue block9;
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("Error while skipping N char in the file:" + iOException.toString());
            }
            finally {
                this.logFileTimestampLast.put(string, l + "");
                this.logFileSizeLast.put(string, l2 + "");
            }
        }
        return arrayList2;
    }

    private String parseValues(String string) {
        String string2 = "M";
        if (string.indexOf("[Full GC") > -1) {
            string2 = "F";
        }
        int n = 0;
        n = string.lastIndexOf("K->");
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(0, n);
        int n2 = string3.lastIndexOf(" ");
        if (n2 == -1) {
            return null;
        }
        string3 = string3.substring(n2);
        String string4 = string.substring(n + 3);
        int n3 = string4.indexOf("K(");
        if (n3 == -1) {
            return null;
        }
        String string5 = string4.substring(0, n3);
        int n4 = string4.indexOf(" ");
        int n5 = (string4 = string4.substring(n4 + 1)).indexOf(" secs]");
        if (n5 == -1) {
            return null;
        }
        String string6 = string4.substring(0, n5);
        String string7 = "";
        if (this.JVM_Version.startsWith("1.3")) {
            string7 = string3 + "," + string5 + "," + string6 + "," + string2;
        } else {
            String string8 = "NONE";
            if (string.indexOf(":") > -1) {
                string8 = string.substring(0, string.indexOf(":"));
            }
            string7 = string8 + "," + string3.trim() + "," + string5 + "," + string6 + "," + string2;
        }
        return string7;
    }

    private String getJVMVersion(String string) {
        System.out.println("jdkHome is : " + string);
        string = string.endsWith(System.getProperty("file.separator")) ? string : string + System.getProperty("file.separator");
        String string2 = string + "bin" + System.getProperty("file.separator") + "java";
        System.out.println("java is " + string2);
        String string3 = System.getProperty("os.name").toLowerCase();
        String string4 = "\"" + string2 + "\"";
        File file = new File(string2);
        System.out.println("java now is " + string2);
        if (!file.exists() && !(file = new File(string2 + ".exe")).exists()) {
            System.out.println("Java executable is not found at " + file.toString());
            return "-1";
        }
        String string5 = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            string5 = "cmd /c ";
            string2 = "\"" + string2 + "\"";
        }
        string5 = string5 + string2 + " -version";
        try {
            String string6;
            int n;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string5);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(process.getInputStream());
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(process.getErrorStream());
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            process.waitFor();
            ArrayList arrayList = egStreamReaderThread.getData();
            String string7 = null;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                string6 = (String)arrayList.get(n);
                System.out.println("Line : " + string6);
                if (!string6.startsWith("java version")) continue;
                string7 = string6.substring(string6.indexOf("\"") + 1, string6.length() - 2);
                break;
            }
            arrayList = egStreamReaderThread2.getData();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                string6 = (String)arrayList.get(n);
                System.out.println("Line 111 : " + string6);
                if (!string6.startsWith("java version")) continue;
                string7 = string6.substring(string6.indexOf("\"") + 1, string6.length() - 2);
                break;
            }
            return string7;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "-1";
    }

    private void uploadValues(String string, String string2, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d = new Double(n);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        if (string.equals("NONE")) {
            this.addNewMeasure(string2, arrayList);
        } else {
            this.addNewMeasure(string + string2, arrayList);
        }
    }

    protected double convertToMBs(String string) {
        try {
            double d = Double.parseDouble(string);
            return d / 1024.0;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }
}

