/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.eg.IPV6Helper;
import com.eg.IniFile;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMUtils;
import com.eg.apm.JVMDataRepository;
import com.eg.apm.JavaBTMLogger;
import com.egurkha.util.EgUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;

public abstract class JVMInstrumentation
extends EgSnmpGenericTest {
    protected boolean isSnmp = false;
    protected boolean isJmxSuccess = false;
    protected boolean isJarSuccess = false;
    protected boolean isSnmpSuccess = false;
    protected String urlStr = "";
    protected String userName = "";
    protected String password = "";
    protected String jvmPort = "";
    protected String jndiName = "";
    protected String jmappath = "";
    protected String heapOnOff = "";
    protected String include = "";
    protected String exclude = "";
    protected String server_type_name = "";
    protected String server_version = "";
    String jvmGUID = null;
    protected boolean isLpar = false;
    protected boolean firstTime = true;
    private boolean usePs = false;
    private boolean aixUsePs = false;
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    protected MBeanServerConnection beanServerConn = null;
    protected double threads_Cpu_Util_Low = 0.0;
    protected double threads_Cpu_Util_Medium = 0.0;
    protected double threads_Cpu_Util_High = 0.0;
    protected int no_Of_Top_Threads = 0;
    protected int dump_thread_limit = -1;
    protected ArrayList threads_runnable_info;
    protected ArrayList threads_waiting_info;
    protected ArrayList threads_blocked_info;
    protected ArrayList threads_timed_waiting_info;
    protected ArrayList threads_cpu_utils_high_info;
    protected ArrayList threads_cpu_utils_medium_info;
    protected ArrayList threads_cpu_utils_low_info;
    protected ArrayList deadlock_threads_info;
    protected Set blockingThreadsId;
    protected ArrayList heap_histo_info;
    private String sslPropertyFile = EgInstallInfo.getInstallDir() + "/agent/management.properties";
    private static String jvmInfoProps = EgInstallInfo.getInstallDir() + "/agent/logs/jvminfo.properties";
    public static String JVMSync = new String("JVMSync");
    protected String jvmUptimeDDLine = new String();
    private String reportMgrTime = new String("");
    private boolean isReportMgrTime = true;
    protected String targetJVMOsName;
    protected String tempHost;
    private String provider = null;
    private static DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance();
    private String jvmURL = null;
    private String serverName = "";
    String mode_type = "";
    protected String useSudo = "";
    protected String targetProcessUserName = "";
    protected ArrayList webPatternList = null;
    protected ArrayList rmiPatternList = null;
    private static final int MAX_SIZE = 2000;
    private Map<String, Integer> threadWeakHashMap = new WeakHashMap<String, Integer>(2000);
    private boolean isWASLiberty = false;
    private String serviceURLPath = null;
    private long lastModifiedTime = -1L;
    private String lastLocalAddress = null;
    private static final String LIBERTY_JMX_LOCAL_ADDRESS = "com.ibm.ws.jmx.local.address";
    protected boolean zingJVM = false;
    protected boolean zingMXBeanExists = false;
    protected boolean jvmIdentified = false;
    private static final String FIXED = "FIXED";
    private static final String ELASTIC = "ELASTIC";
    protected static final String MINUS_FIVE = "-5.0";
    protected static final String HASH = "#";
    protected static final String[] memoryAttribute = new String[]{"JavaHeapMemoryUsage", "NonJavaHeapMemoryUsage", "JavaHeapUsingMoreMemoryThanInitiallyReserved", "PercentJavaHeapOccupiedAfterCollection", "ApplicationObjectHeapUse", "ApplicationObjectHeapUsableMemory", "ApplicationObjectHeapMemoryPercentInUse"};
    protected static final String[] memoryPoolAttribute = new String[]{"Type", "Name", "MemoryPoolSizeType", "InitialReserved", "CurrentSize", "CurrentUse"};
    protected boolean isJreVersionFound = false;
    protected boolean isJreAbove6 = false;
    private boolean isOracleHotSpotVersion6u25 = false;
    private boolean isOracleHotSpotVersion6u25found = false;
    private boolean isOracleHotSpotVersion9 = false;
    private boolean isSap6orJrockitVersionb37 = false;
    private boolean isLocalAgentComponent = false;
    protected boolean showNewMemoryDescriptor = false;
    private boolean isAgentJRE6 = false;
    private boolean firstGCNotificationRun = false;
    private boolean jvmGCNotificationClosed = false;
    private String pid4GCNotification = null;
    private static final Hashtable GCNotificationListenerTable = new Hashtable();
    String componentType = null;
    private String loggerDispStr = null;
    boolean isContainerHost = false;
    private final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();
    private String seperator = ":";

    public JVMInstrumentation(String[] stringArray) {
        super(stringArray);
        String string;
        Object object;
        String string2;
        this.isContainerHost = this.isContainerApp && this.strContainerId != null && this.strContainerId.length() > 0;
        this.findServerType();
        System.setProperty("jboss.remoting.pooled-buffers", "false");
        this.loggerDispStr = "[" + this.entity + "] - [" + this.reportingName + ":" + this.portNo + "] ";
        this.fixedTestPeriod = true;
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        String string3 = this.getValueForParam("metric_collection_type");
        if (string3 != null && (string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("false"))) {
            this.mode_type = "Jar";
            this.getJvmGuid();
        } else {
            string2 = this.getValueForParam("mode");
            object = this.getValueForParam("measure_mode");
            this.mode_type = object == null || ((String)object).equalsIgnoreCase("false") || ((String)object).equalsIgnoreCase("no") ? "Jmx" : "Log File";
            if (string2 == null || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no")) {
                this.mode_type = "Jmx";
            } else {
                this.mode_type = "Snmp";
                if (this.componentType.equalsIgnoreCase("eg_agent")) {
                    this.isLocalAgentComponent = true;
                    this.mode_type = "Jmx";
                }
            }
            JavaBTMLogger.btmLogger.debug(this.loggerDispStr + " mode_type :" + this.mode_type);
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        this.jvmPort = this.getValueForParam("Jmx_Remote_Port");
        if (this.jvmPort == null || "None".equalsIgnoreCase(this.jvmPort)) {
            this.urlStr = this.tempHost;
        } else if (this.jvmPort != null) {
            this.urlStr = this.tempHost + ":" + this.jvmPort;
            if (!this.isLocalAgentComponent && this.jvmPort.equalsIgnoreCase("local") && this.componentType.equalsIgnoreCase("eg_agent")) {
                this.isLocalAgentComponent = true;
                this.mode_type = "Jmx";
                if (this.entity.equalsIgnoreCase("JmxConnectorTest")) {
                    this.mode_type = "Local";
                }
            }
        }
        this.jndiName = this.getValueForParam("Jndi_Name");
        if (this.jndiName == null || "None".equalsIgnoreCase(this.jndiName) || "Null".equalsIgnoreCase(this.jndiName)) {
            this.jndiName = "jmxrmi";
        }
        this.userName = this.getValueForParam("Jmx_user");
        if (this.userName == null) {
            string2 = this.getValueForParam("user");
            this.userName = string2 != null ? string2 : "none";
        }
        this.password = this.getValueForParam("Jmx_password");
        if (this.password == null) {
            string2 = this.getValueForParam("password");
            this.password = string2 != null ? string2 : "none";
        }
        if ((string2 = this.getValueForParam("usePS")) != null && string2.length() > 0 && string2.equalsIgnoreCase("yes")) {
            this.usePs = true;
        }
        this.server_type_name = this.getValueForParam("server_type_name");
        if (this.timeout >= 0L) {
            if (this.timeout < 240000L) {
                this.timeout = 240000L;
            }
        } else {
            this.timeout = 240000L;
        }
        if (this.entity.equals("JvmThreadTest")) {
            try {
                object = this.getValueForParam("Pct_Medium_Cpu_Util_Threads");
                this.threads_Cpu_Util_Medium = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                this.threads_Cpu_Util_Medium = 30.0;
            }
            try {
                object = this.getValueForParam("Pct_High_Cpu_Util_Threads");
                this.threads_Cpu_Util_High = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                this.threads_Cpu_Util_High = 50.0;
            }
            try {
                object = this.getValueForParam("Max_Thread_Count");
                if (object != null && (((String)object).equalsIgnoreCase("All") || ((String)object).equals("*"))) {
                    object = "-1";
                    this.no_Of_Top_Threads = Integer.parseInt((String)object);
                } else {
                    this.no_Of_Top_Threads = Integer.parseInt((String)object);
                }
            }
            catch (Exception exception) {
                this.no_Of_Top_Threads = 20;
            }
            try {
                int n;
                object = this.getValueForParam("Thread_Dump_Limit");
                this.dump_thread_limit = object != null ? (((String)(object = ((String)object).trim())).equals("*") || ((String)object).equalsIgnoreCase("all") || ((String)object).equalsIgnoreCase("none") ? -1 : ((n = Integer.parseInt((String)object)) < 0 ? -1 : n)) : -1;
            }
            catch (Exception exception) {
                this.dump_thread_limit = -1;
            }
            object = this.getValueForParam("Web_thread");
            string = this.getValueForParam("RMI_Thread");
            this.webPatternList = this.getThreadPatterns((String)object);
            this.rmiPatternList = this.getThreadPatterns(string);
            this.isAgentJRE6 = this.isAgentJRE6();
        } else if (this.entity.equals("JvmUptimeTest")) {
            this.reportMgrTime = this.getValueForParam("reportmanagertime");
            this.isReportMgrTime = this.reportMgrTime == null || !this.reportMgrTime.equalsIgnoreCase("no") && !this.reportMgrTime.equalsIgnoreCase("false");
        } else if (this.entity.equals("JvmMemoryDetailsTest")) {
            object = testerInfo.getValueFor("DD_ROWS", "ShowNewMemoryDescriptor");
            if (object != null && ((String)object).length() > 0 && (((String)object).equalsIgnoreCase("yes") || ((String)object).equalsIgnoreCase("true"))) {
                this.showNewMemoryDescriptor = true;
            }
        } else if (this.entity.equals("JVMGCTest")) {
            this.firstGCNotificationRun = true;
        }
        this.targetJVMOsName = this.alos != null ? this.alos.toLowerCase() : System.getProperty("os.name").toLowerCase();
        try {
            object = new File(jvmInfoProps);
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.getValueForParam("service_URL_path");
        string = this.getValueForParam("SSL");
        boolean bl = false;
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        this.server_version = this.getValueForParam("jboss_version");
        if (this.server_type_name != null && this.server_type_name.length() > 0) {
            this.provider = testerInfo.getJmxProvider(this.server_type_name);
            if (this.server_version != null && this.server_version.length() > 0) {
                this.server_type_name = this.server_type_name + ":" + this.server_version;
            }
            if (bl) {
                this.server_type_name = this.server_type_name + ":ssl";
            }
            if (object != null && ((String)object).length() > 0 && this.server_type_name.equals("IBMWLP")) {
                String string4 = System.getProperty("file.separator");
                this.serviceURLPath = (String)object + string4 + LIBERTY_JMX_LOCAL_ADDRESS;
                this.isWASLiberty = true;
            } else {
                this.jvmURL = testerInfo.getJmxServiceUrlPrefix(this.server_type_name);
                this.jvmURL = this.jvmURL + this.tempHost + ":" + this.jvmPort;
            }
        } else {
            this.server_type_name = "Default";
            this.provider = testerInfo.getJmxProvider(this.server_type_name);
            this.jvmURL = testerInfo.getJmxServiceUrlPrefix(this.server_type_name);
            this.jvmURL = this.jvmURL + this.tempHost + ":" + this.jvmPort + "/" + this.jndiName;
        }
        JavaBTMLogger.btmLogger.debug(this.loggerDispStr + " server_type_name :" + this.server_type_name + " provider :" + this.provider + " URL : " + this.jvmURL);
    }

    protected void getJvmGuid() {
        try {
            if (this.jvmGUID == null || this.jvmGUID.length() <= 0) {
                String string = this.getValueForParam("trgtHost");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.componentType);
                stringBuilder.append("^");
                if (this.isContainerHost) {
                    stringBuilder.append(this.strContainerId);
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append("^");
                stringBuilder.append(this.reportingName);
                stringBuilder.append("^");
                stringBuilder.append(this.portNo);
                String string2 = stringBuilder.toString();
                this.jvmGUID = APMUtils.readJvmGUID(string2);
                APMComponentIDRepository.registerJavaComponent(this.jvmGUID, this.entity, this.reportingName, string, this.portNo, this.componentType);
                JavaBTMLogger.btmLogger.info("{} INFO:- GUID fetch Key is {}, jvmGUID :{}  mode_type : {}", new Object[]{this.loggerDispStr, string2, this.jvmGUID, this.mode_type});
            }
            JavaBTMLogger.btmLogger.trace("{} {} Current JVM data repository : {}", new Object[]{this.loggerDispStr, this.jvmGUID, JVMDataRepository.dataTable.get(this.jvmGUID)});
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.warn("{} Unable to get JVM GUID {}", (Object)this.loggerDispStr, (Object)exception);
        }
        if (this.mode_type != null && this.mode_type.equalsIgnoreCase("Jmx")) {
            this.clearJarModeData();
        }
        JavaBTMLogger.btmLogger.trace("{} {} Current JVM mode : {}", new Object[]{this.loggerDispStr, this.jvmGUID, this.mode_type});
    }

    protected void makeFalse() {
        this.isJreVersionFound = false;
        this.isJreAbove6 = false;
        this.isOracleHotSpotVersion6u25 = false;
        this.isOracleHotSpotVersion6u25found = false;
        this.isOracleHotSpotVersion9 = false;
        this.isSap6orJrockitVersionb37 = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLibertyServiceURL() {
        File file = null;
        String string = null;
        FilterInputStream filterInputStream = null;
        try {
            file = new File(this.serviceURLPath);
            if (!file.exists()) {
                this.lastModifiedTime = -1L;
                this.lastLocalAddress = null;
                String string2 = string;
                return string2;
            }
            long l = file.lastModified();
            if (this.lastModifiedTime > 0L && this.lastModifiedTime == l) {
                String string3 = string = this.lastLocalAddress;
                return string3;
            }
            this.lastModifiedTime = l;
            filterInputStream = new DataInputStream(new FileInputStream(file));
            String string4 = null;
            while ((string4 = ((DataInputStream)filterInputStream).readLine()) != null) {
                this.lastLocalAddress = string = string4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {}
            filterInputStream = null;
        }
        return string;
    }

    protected boolean connectToJVM(String string, String string2, String string3) {
        boolean bl = false;
        if (this.isLocalAgentComponent) {
            this.beanServerConn = ManagementFactory.getPlatformMBeanServer();
            return true;
        }
        if (this.isWASLiberty) {
            this.jvmURL = this.getLibertyServiceURL();
            JavaBTMLogger.btmLogger.debug(this.loggerDispStr + "[connectToJVM] - isWASLiberty? :" + this.isWASLiberty + " jvmURL :" + this.jvmURL);
            if (this.jvmURL == null) {
                System.err.println(this.entity.toUpperCase() + " : Problem to find JMX Service URL from " + LIBERTY_JMX_LOCAL_ADDRESS + " for Host " + this.reportingName);
                return false;
            }
        }
        this.beanServerConn = null;
        try {
            Object object;
            this.jmxService = new JMXServiceURL(this.jvmURL);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = (int)this.timeout / 5;
            if (n < 30000) {
                n = 30000;
            }
            hashMap.put("jmx.remote.protocol.provider.pkgs", this.provider);
            if (n > 0) {
                hashMap.put("jmx.remote.x.request.waiting.timeout", Long.toString(n));
            }
            boolean bl2 = false;
            JavaBTMLogger.btmLogger.debug(this.loggerDispStr + "[connectToJVM] - jmxService :" + this.jmxService + " environment :" + hashMap);
            if (string2.equalsIgnoreCase("none") || string3.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = this.connectWithTimeout(this.jmxService, n, TimeUnit.MILLISECONDS, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    JavaBTMLogger.btmLogger.warn(this.loggerDispStr + "[connectToJVM] - jmxService :" + this.jmxService + " Exception occured :" + iOException);
                }
            } else {
                object = new String[]{string2, string3};
                hashMap.put("jmx.remote.credentials", object);
                try {
                    this.jmxConnector = this.connectWithTimeout(this.jmxService, n, TimeUnit.MILLISECONDS, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    JavaBTMLogger.btmLogger.warn(this.loggerDispStr + "[connectToJVM] - jmxService :" + this.jmxService + " Exception occured with credentials :" + iOException);
                }
            }
            if (bl2) {
                try {
                    object = new EgSslRMIClientSocketFactory(this.targetHost, Integer.parseInt(this.jvmPort), n);
                    Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(this.jvmPort), (RMIClientSocketFactory)object);
                    RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                    this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                    this.rmiConnector.connect(hashMap);
                    this.beanServerConn = this.rmiConnector.getMBeanServerConnection();
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.warn(this.loggerDispStr + "[connectToJVM] - jmxService :" + this.jmxService + " Exception occured SSL Block :" + exception);
                }
            } else {
                this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConn == null) {
                System.out.println(this.entity.toUpperCase() + " : Connection to JVM is not established for Host : " + this.reportingName);
                this.closeJVMConn();
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println(this.entity.toUpperCase() + " : Connection to JVM is not established for Host : " + this.reportingName);
            JavaBTMLogger.btmLogger.warn(this.loggerDispStr + "[connectToJVM] - jmxService :" + this.jmxService + " Exception occured due to :" + exception);
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnector connectWithTimeout(final JMXServiceURL jMXServiceURL, long l, TimeUnit timeUnit, final Map map) throws IOException {
        final ArrayBlockingQueue<String> arrayBlockingQueue = new ArrayBlockingQueue<String>(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor(this.daemonThreadFactory);
        executorService.submit(new Runnable(){

            public void run() {
                try {
                    JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, map);
                    if (!arrayBlockingQueue.offer(jMXConnector)) {
                        jMXConnector.close();
                    }
                }
                catch (Throwable throwable) {
                    arrayBlockingQueue.offer(throwable);
                }
            }
        });
        Object var8_7 = null;
        try {
            var8_7 = arrayBlockingQueue.poll(l, timeUnit);
            if (var8_7 == null && !arrayBlockingQueue.offer("")) {
                var8_7 = arrayBlockingQueue.take();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (var8_7 == null) {
            System.out.println("JMX Connection timed out: " + jMXServiceURL);
        }
        if (var8_7 instanceof JMXConnector) {
            return var8_7;
        }
        try {
            throw (Throwable)var8_7;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    public void closeJVMConn() {
        try {
            this.beanServerConn = null;
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected boolean setUnknownMeasure(int n) {
        if (n > 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Double(-5.0));
            }
            this.addNewMeasure(arrayList);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPreviousValue() {
        String string = null;
        String string2 = this.reportingName + ":" + this.portNo + ":" + this.entity;
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String string3 = JVMSync;
            synchronized (string3) {
                inputStream = new FileInputStream(jvmInfoProps);
                properties.load(new BufferedInputStream(inputStream));
                string = properties.getProperty(string2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    protected StringBuffer formatString(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ":";
        if (this.targetJVMOsName.startsWith("win")) {
            string = ";";
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i) + string;
            stringBuffer.append(string2);
        }
        return stringBuffer;
    }

    protected String pathString(String string) {
        String string2 = "";
        string2 = string.indexOf(";") > 0 ? ";" : ":";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string3 = string3 + string4 + string2 + "  ";
        }
        return string3;
    }

    private long getJVMRunTime() {
        if (this.beanServerConn == null) {
            return -1L;
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
            return runtimeMXBean.getUptime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    protected String changeUnit(double d) {
        String string = Double.toString(d);
        return EgUtils.convertMemoryValues(string, "B", "MB");
    }

    private int getLocalProcessors() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            return operatingSystemMXBean.getAvailableProcessors();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected double secondsToMinutes(double d) {
        if (d <= 0.0) {
            return d;
        }
        int n = (int)(d / 60.0);
        int n2 = (int)(d % 60.0);
        double d2 = n + n2;
        String string = n + "." + n2;
        d2 = Double.parseDouble(string);
        return d2;
    }

    protected String getRHS(int n) {
        if (this.lhs != null && this.lhs.length > 0 && n >= 0) {
            String string = this.rhs[n];
            return string;
        }
        return null;
    }

    protected boolean isIBMJvmRunning() {
        boolean bl = false;
        try {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            bl = this.beanServerConn.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean");
        }
        catch (Exception exception) {
            System.out.println("Unable to get JVM Type !!!");
        }
        return bl;
    }

    protected String getPID() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
            String string = runtimeMXBean.getName();
            string = string.substring(0, string.indexOf("@"));
            return string;
        }
        catch (Exception exception) {
            System.out.println("Unable to get PID information ...");
            return null;
        }
    }

    protected Hashtable pullFileDescriptorStatistics() {
        Hashtable<String, Object> hashtable = null;
        try {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            if (this.beanServerConn == null) {
                return new Hashtable();
            }
            if (hashtable == null) {
                hashtable = new Hashtable<String, Object>();
            }
            AttributeList attributeList = this.beanServerConn.getAttributes(objectName, new String[]{"OpenFileDescriptorCount", "MaxFileDescriptorCount"});
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                hashtable.put(attribute.getName(), attribute.getValue());
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    protected Hashtable pullClassLoadingStatistics() {
        ClassLoadingMXBean classLoadingMXBean;
        Hashtable<String, Double> hashtable = null;
        if (this.beanServerConn == null) {
            return new Hashtable();
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, Double>();
        }
        try {
            classLoadingMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return hashtable;
        }
        double d = classLoadingMXBean.getLoadedClassCount();
        double d2 = classLoadingMXBean.getTotalLoadedClassCount();
        double d3 = classLoadingMXBean.getUnloadedClassCount();
        hashtable.put("NumberOfClassesLoaded", new Double(d));
        hashtable.put("NumberOfClassesUnloaded", new Double(d3));
        hashtable.put("TotalNumberOfClassesLoaded", new Double(d2));
        return hashtable;
    }

    protected Hashtable pullResourcesStatistics() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string = new String();
        if (this.beanServerConn == null) {
            hashtable.put("CpuUsage", new Double(-5.0));
            return hashtable;
        }
        try {
            double d;
            String string2;
            Double d2;
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            long l5 = 0L;
            boolean bl = this.beanServerConn.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean");
            boolean bl2 = this.beanServerConn.isInstanceOf(objectName, "com.sun.management.OperatingSystemMXBean");
            if (this.targetJVMOsName.equalsIgnoreCase("aix") && bl && (d2 = this.getPercentCpuFromLPAR(string2 = this.getPID())) != null && (d = d2.doubleValue()) >= 0.0) {
                hashtable.put("CpuUsage", d2);
                return hashtable;
            }
            if (bl2 || bl) {
                l5 = (Long)this.beanServerConn.getAttribute(objectName, "ProcessCpuTime");
            }
            if ((string2 = this.getPreviousValue()) != null && string2.length() > 0) {
                try {
                    if (string2.indexOf("|") > -1) {
                        l3 = Long.parseLong(string2.substring(0, string2.indexOf("|")));
                        l4 = Long.parseLong(string2.substring(string2.indexOf("|") + 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((l = this.getJVMRunTime()) < 0L) {
                l3 = 0L;
            }
            l2 = l < l3 ? l : l - l3;
            string = string + String.valueOf(l);
            long l6 = 0L;
            int n = this.getLocalProcessors();
            double d3 = 0.0;
            l6 = l5 < l4 ? l5 : l5 - l4;
            string = string != null && string.length() > 0 ? string + "|" + String.valueOf(l5) : string + String.valueOf(l5);
            this.setCurrentValue(string);
            if (l2 <= 0L || n == 0) {
                d3 = -5.0;
                l4 = 0L;
            } else {
                d3 = Math.min(99.9, (double)l6 / ((double)l2 * 10000.0 * (double)n));
            }
            hashtable.put("CpuUsage", new Double(d3));
            return hashtable;
        }
        catch (Exception exception) {
            hashtable.put("CpuUsage", new Double(-5.0));
            return hashtable;
        }
    }

    private Object getObject(Hashtable hashtable, String string, Object object) {
        if (object instanceof CompositeData) {
            return this.getCompositeData(hashtable, string, (CompositeData)object);
        }
        if (object instanceof TabularData) {
            return this.getTabularData(hashtable, string, (TabularData)object);
        }
        if (object instanceof Map) {
            return this.getMapData(hashtable, string, (Map)object);
        }
        if (object instanceof Collection) {
            return this.getArrayData(hashtable, string, ((Collection)object).toArray());
        }
        return this.getSimpleData(hashtable, string, object);
    }

    private Object getSimpleData(Hashtable hashtable, String string, Object object) {
        if (string != null && object != null) {
            hashtable.put(string, object);
        }
        return hashtable;
    }

    private Object getArrayData(Hashtable hashtable, String string, Object object) {
        if (object == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            this.getObject(hashtable, string + "[" + i + "]", object2);
        }
        return hashtable;
    }

    private Object getMapData(Hashtable hashtable, String string, Map map) {
        if (map == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.getObject(hashtable, string + "[" + entry.getKey() + "]", entry.getValue());
        }
        return hashtable;
    }

    private Object getTabularData(Hashtable hashtable, String string, TabularData tabularData) {
        if (tabularData == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        List<String> list = tabularData.getTabularType().getIndexNames();
        int n = list.size();
        Set<?> set = tabularData.keySet();
        for (Object obj : set) {
            Object[] objectArray = ((List)obj).toArray();
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.seperator + objectArray[i]);
            }
            this.getCompositeData(hashtable, stringBuilder.toString(), tabularData.get(objectArray));
        }
        return hashtable;
    }

    private Object getCompositeData(Hashtable hashtable, String string, CompositeData compositeData) {
        if (compositeData == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        Set<String> set = compositeData.getCompositeType().keySet();
        for (String string2 : set) {
            if (string2.equals("key")) {
                Object object = compositeData.get(string2);
                string2 = "";
                continue;
            }
            if (string2.equals("value")) {
                this.getObject(hashtable, string, compositeData.get(string2));
                continue;
            }
            this.getObject(hashtable, string + this.seperator + string2, compositeData.get(string2));
        }
        return hashtable;
    }

    protected Hashtable pullFullGCStatistics() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
            Iterator<ObjectName> iterator = set.iterator();
            String string = this.getPreviousValue();
            StringBuilder stringBuilder = new StringBuilder();
            HashMap<MBeanAttributeInfo[], Object> hashMap = new HashMap<MBeanAttributeInfo[], Object>();
            if (string != null && string.length() > 0) {
                try {
                    object4 = new StringTokenizer(string, HASH);
                    while (((StringTokenizer)object4).hasMoreTokens()) {
                        object3 = ((StringTokenizer)object4).nextToken();
                        if (object3 == null || ((String)object3).indexOf("|") <= -1) continue;
                        object2 = ((String)object3).substring(0, ((String)object3).indexOf("|"));
                        object = ((String)object3).substring(((String)object3).indexOf("|") + 1);
                        hashMap.put((MBeanAttributeInfo[])object2, object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (iterator.hasNext()) {
                object4 = iterator.next();
                object3 = this.beanServerConn.getMBeanInfo((ObjectName)object4);
                object2 = ((MBeanInfo)object3).getAttributes();
                object = new Hashtable();
                String string2 = null;
                long l = 0L;
                for (int i = 0; i < ((MBeanAttributeInfo[])object2).length; ++i) {
                    MBeanAttributeInfo mBeanAttributeInfo = object2[i];
                    try {
                        String string3 = mBeanAttributeInfo.getName();
                        if (string3.equalsIgnoreCase("LastGcInfo")) {
                            try {
                                object = (Hashtable)this.getObject(new Hashtable(), string3, this.beanServerConn.getAttribute((ObjectName)object4, string3));
                            }
                            catch (Throwable throwable) {
                                System.out.println("[MemoryPoolGCTest] LastGCInfo is not available : " + throwable.getMessage());
                            }
                            continue;
                        }
                        if (string3.equalsIgnoreCase("Name")) {
                            string2 = (String)this.beanServerConn.getAttribute((ObjectName)object4, string3);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("CollectionCount")) continue;
                        l = (Long)this.beanServerConn.getAttribute((ObjectName)object4, string3);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (string2 == null) continue;
                Hashtable hashtable2 = new Hashtable();
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                String string4 = (String)hashMap.get(string2);
                if (string4 != null) {
                    try {
                        l4 = Long.parseLong(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                long l5 = 0L;
                if (l4 > 0L && l4 <= l) {
                    l5 = l - l4;
                }
                hashtable2.put("CollectionCount", new Long(l5));
                int n = stringBuilder.length();
                if (n > 0) {
                    stringBuilder.append(HASH);
                }
                stringBuilder.append(string2).append("|").append(l);
                if (((Hashtable)object).size() == 0) continue;
                hashtable2 = JVMInstrumentation.getDataFromFullGCTable((Hashtable)object, hashtable2);
                hashtable.put(string2, hashtable2);
            }
            this.setCurrentValue(stringBuilder.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected static Hashtable getDataFromFullGCTable(Hashtable hashtable, Hashtable hashtable2) {
        try {
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
            Set set = hashtable.keySet();
            for (String string : set) {
                Object object;
                int n;
                StringTokenizer stringTokenizer;
                String string2;
                String string3;
                if (string.equals("LastGcInfo:startTime")) {
                    hashtable2.put("startTime", (Long)hashtable.get("LastGcInfo:startTime"));
                    continue;
                }
                if (string.equals("LastGcInfo:endTime")) {
                    hashtable2.put("endTime", (Long)hashtable.get("LastGcInfo:endTime"));
                    continue;
                }
                if (string.indexOf("LastGcInfo:memoryUsageBeforeGc:") > -1) {
                    string3 = "";
                    string2 = "";
                    stringTokenizer = new StringTokenizer(string, ":");
                    n = stringTokenizer.countTokens();
                    while (stringTokenizer.hasMoreTokens() && n == 4) {
                        object = stringTokenizer.nextToken();
                        object = stringTokenizer.nextToken();
                        string3 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                    }
                    if (!hashtable3.containsKey(string3)) {
                        object = new Hashtable();
                        ((Hashtable)object).put(string2, hashtable.get(string));
                        hashtable3.put(string3, object);
                    } else {
                        object = (Hashtable)hashtable3.get(string3);
                        ((Hashtable)object).put(string2, hashtable.get(string));
                        hashtable3.put(string3, object);
                    }
                    hashtable2.put("memoryBeforeGc", hashtable3);
                    continue;
                }
                if (string.indexOf("LastGcInfo:memoryUsageAfterGc:") <= -1) continue;
                string3 = "";
                string2 = "";
                stringTokenizer = new StringTokenizer(string, ":");
                n = stringTokenizer.countTokens();
                while (stringTokenizer.hasMoreTokens() && n == 4) {
                    object = stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                }
                if (!hashtable4.containsKey(string3)) {
                    object = new Hashtable();
                    ((Hashtable)object).put(string2, hashtable.get(string));
                    hashtable4.put(string3, object);
                } else {
                    object = (Hashtable)hashtable4.get(string3);
                    ((Hashtable)object).put(string2, hashtable.get(string));
                    hashtable4.put(string3, object);
                }
                hashtable2.put("memoryAfterGc", hashtable4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable2;
    }

    protected Hashtable pullGCStatistics() {
        long l;
        String string;
        Hashtable<String, String> hashtable = null;
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        if (this.beanServerConn == null) {
            return new Hashtable();
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        if ((string = this.getPreviousValue()) != null && string.length() > 0) {
            try {
                if (string.indexOf(HASH) > -1) {
                    l2 = Long.parseLong(string.substring(0, string.indexOf(HASH)).trim());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((l = this.getJVMRunTime()) < 0L) {
            l2 = 0L;
        }
        long l3 = 0L;
        l3 = l < l2 ? l : l - l2;
        stringBuffer.append(l);
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
            Iterator<ObjectName> iterator = set.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string2;
                ObjectName objectName = iterator.next();
                if (bl) {
                    stringBuffer.append("~");
                }
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                double d = 0.0;
                double d2 = 0.0;
                long l7 = 0L;
                long l8 = 0L;
                ObjectName objectName2 = objectName;
                GarbageCollectorMXBean garbageCollectorMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, objectName2.toString(), GarbageCollectorMXBean.class);
                if (garbageCollectorMXBean == null) continue;
                String string3 = garbageCollectorMXBean.getName();
                l4 = garbageCollectorMXBean.getCollectionTime();
                long l9 = garbageCollectorMXBean.getCollectionCount();
                if (string != null && string.length() > 0) {
                    try {
                        if (string.indexOf(HASH) > -1 && (string2 = string.substring(string.indexOf(HASH) + 1)) != null && string2.length() > 0) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, "~");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string4 = stringTokenizer.nextToken();
                                if (!string4.substring(0, string4.indexOf("|")).equals(string3)) continue;
                                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ":");
                                String string5 = stringTokenizer2.nextToken();
                                string5 = string5.substring(string5.indexOf("|") + 1);
                                l5 = Long.parseLong(string5);
                                l7 = Long.parseLong(stringTokenizer2.nextToken());
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (l4 < l5) {
                    l6 = l4;
                } else {
                    l6 = l4 - l5;
                    d = l6 > 0L ? (double)l6 / 1000.0 : (double)l6;
                }
                d2 = l3 <= 0L ? 0.0 : (double)l6 / (double)l3 * 100.0;
                if (d2 > 100.0) {
                    d2 = 100.0;
                }
                l8 = l7 > l9 ? l9 : l9 - l7;
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    if (bl) {
                        stringBuffer.append(string3 + "|" + l4 + ":" + l9);
                    } else {
                        stringBuffer.append(HASH + string3 + "|" + l4 + ":" + l9);
                    }
                }
                bl = true;
                this.setCurrentValue(stringBuffer.toString());
                string2 = string3 + HASH + l8 + HASH + d + HASH + d2;
                hashtable.put(string3, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable = new Hashtable();
            return hashtable;
        }
        return hashtable;
    }

    private boolean isZVM() {
        if (this.jvmIdentified) {
            return this.jvmIdentified;
        }
        try {
            String[] stringArray;
            RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
            String string = runtimeMXBean.getVmName();
            String string2 = runtimeMXBean.getVmVersion();
            if (string != null && (string = string.toLowerCase()).indexOf("zing") > -1) {
                this.zingJVM = true;
            }
            if (string2 != null && (string2 = string2.toLowerCase()).indexOf("azul") > -1) {
                this.zingJVM = true;
            }
            if ((stringArray = this.beanServerConn.getDomains()) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (string3 == null || !string3.equals("com.azul.zing")) continue;
                    this.zingJVM = true;
                    this.zingMXBeanExists = true;
                }
            }
            this.jvmIdentified = true;
        }
        catch (Exception exception) {
            this.jvmIdentified = false;
            exception.printStackTrace();
        }
        return this.jvmIdentified;
    }

    protected ArrayList compositeResult(CompositeData compositeData) {
        ArrayList arrayList = new ArrayList();
        Set<String> set = null;
        try {
            set = compositeData.getCompositeType().keySet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (set != null && set.size() > 0) {
            Object object = compositeData.get("initialReserved");
            Object object2 = compositeData.get("memoryPoolSizeType");
            Object object3 = compositeData.get("size");
            Object object4 = compositeData.get("used");
            arrayList = this.getZingMemoryDetails(object, object2, object3, object4);
        }
        return arrayList;
    }

    protected ArrayList getZingMemoryDetails(Object object, Object object2, Object object3, Object object4) {
        String string;
        String string2 = MINUS_FIVE;
        String string3 = MINUS_FIVE;
        String string4 = MINUS_FIVE;
        String string5 = MINUS_FIVE;
        String string6 = MINUS_FIVE;
        String string7 = MINUS_FIVE;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object != null) {
            string = object.toString();
            double d = Double.parseDouble(string);
            string2 = this.changeUnit(d);
        }
        if (object2 != null) {
            string = object2.toString();
            string3 = string.equals(ELASTIC) ? "2.0" : (string.equals(FIXED) ? "1.0" : "0.0");
        }
        long l = 0L;
        if (object3 != null) {
            String string8 = object3.toString();
            l = Long.parseLong(string8);
            string4 = this.changeUnit(l);
        }
        long l2 = 0L;
        if (object4 != null) {
            String string9 = object4.toString();
            l2 = Long.parseLong(string9);
            string5 = this.changeUnit(l2);
        }
        long l3 = l - l2;
        string6 = this.changeUnit(l3);
        double d = -5.0;
        if (string3.equals("1.0") && l > 0L) {
            d = (double)l2 * 100.0 / (double)l;
            string7 = "" + d;
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        arrayList.add(string7);
        return arrayList;
    }

    private Hashtable queryZingMxBean(ObjectName objectName, boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(objectName, null);
            if (set != null && set.size() > 0) {
                Iterator<ObjectName> iterator = set.iterator();
                if (bl) {
                    while (iterator.hasNext()) {
                        ObjectName objectName2 = iterator.next();
                        for (int i = 0; i < memoryAttribute.length; ++i) {
                            ArrayList arrayList;
                            CompositeData compositeData;
                            String string = memoryAttribute[i];
                            Object object = this.beanServerConn.getAttribute(objectName2, string);
                            if (object == null) continue;
                            if (string.equals(memoryAttribute[0])) {
                                compositeData = (CompositeData)object;
                                arrayList = this.compositeResult(compositeData);
                                hashtable.put(string, arrayList);
                                continue;
                            }
                            if (string.equals(memoryAttribute[1])) {
                                compositeData = (CompositeData)object;
                                arrayList = this.compositeResult(compositeData);
                                hashtable.put(string, arrayList);
                                continue;
                            }
                            hashtable.put(string, object);
                        }
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object object;
                        ObjectName objectName3 = iterator.next();
                        String string = (String)this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[0]);
                        if (string != null && string.equalsIgnoreCase("SYSTEM")) continue;
                        String string2 = (String)this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[1]);
                        String string3 = (String)this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[2]);
                        Object object2 = this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[3]);
                        Object object3 = this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[4]);
                        Object object4 = this.beanServerConn.getAttribute(objectName3, memoryPoolAttribute[5]);
                        String string4 = "Memory Pool_" + string2 + " (" + string + ")";
                        if (this.showNewMemoryDescriptor) {
                            object = string.toLowerCase();
                            string4 = ((String)object).startsWith("heap") ? "Heap Memory:Memory Pool " + string2 : "Non-Heap Memory:Memory Pool " + string2;
                        }
                        object = this.getZingMemoryDetails(object2, string3, object3, object4);
                        hashtable.put(string4, object);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while querying MBeans on the method \"queryZingMxBean\"");
            exception.printStackTrace();
        }
        return hashtable;
    }

    private Hashtable getZingMxBeanDetails(boolean bl) {
        String string;
        CharSequence charSequence;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Hashtable<Object, String> hashtable = null;
        Hashtable hashtable2 = null;
        int n = 6;
        try {
            serializable = new ObjectName("com.azul.zing:type=Memory");
            hashtable2 = this.queryZingMxBean((ObjectName)serializable, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (hashtable2 != null && hashtable2.size() > 0) {
            hashtable = new Hashtable<Object, String>();
            serializable = new DecimalFormat("#.####");
            object4 = ((DecimalFormat)serializable).getDecimalFormatSymbols();
            ((DecimalFormatSymbols)object4).setDecimalSeparator('.');
            ((DecimalFormat)serializable).setDecimalFormatSymbols((DecimalFormatSymbols)object4);
            object3 = (ArrayList)hashtable2.get(memoryAttribute[0]);
            if (object3 != null && ((ArrayList)object3).size() == n) {
                object2 = this.showNewMemoryDescriptor ? "Heap Memory:Total" : "Heap Memory Usage";
                object = this.getHeapBufferDetails((ArrayList)object3, (String)object2);
                if (bl) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    charSequence = (String)((ArrayList)object3).get(1);
                    string = "0.0";
                    Object v = hashtable2.get(memoryAttribute[2]);
                    if (v != null && (string5 = v.toString().toLowerCase()).equals("true")) {
                        string = "1.0";
                    }
                    string5 = MINUS_FIVE;
                    Object v2 = hashtable2.get(memoryAttribute[3]);
                    if (v2 != null) {
                        string4 = v2.toString();
                        double d = Double.parseDouble(string4);
                        string5 = ((NumberFormat)serializable).format(d);
                    }
                    string4 = MINUS_FIVE;
                    Object v3 = hashtable2.get(memoryAttribute[4]);
                    if (v3 != null) {
                        string3 = v3.toString();
                        long l = Long.parseLong(string3);
                        string4 = this.changeUnit(l);
                    }
                    string3 = MINUS_FIVE;
                    Object v4 = hashtable2.get(memoryAttribute[5]);
                    if (v4 != null) {
                        string2 = v4.toString();
                        long l = Long.parseLong(string2);
                        string3 = this.changeUnit(l);
                    }
                    string2 = MINUS_FIVE;
                    Object v5 = hashtable2.get(memoryAttribute[6]);
                    if (v5 != null) {
                        String string6 = v5.toString();
                        double d = Double.parseDouble(string6);
                        string2 = ((NumberFormat)serializable).format(d);
                    }
                    ((StringBuffer)object).append(HASH).append(string);
                    ((StringBuffer)object).append(HASH).append(string5);
                    ((StringBuffer)object).append(HASH).append(string4);
                    ((StringBuffer)object).append(HASH).append(string3);
                    ((StringBuffer)object).append(HASH).append(string2);
                    ((StringBuffer)object).append(HASH).append((String)charSequence);
                }
                hashtable.put(object2, ((StringBuffer)object).toString());
            }
            if ((object2 = (ArrayList)hashtable2.get(memoryAttribute[1])) != null && ((ArrayList)object2).size() == n) {
                object = this.showNewMemoryDescriptor ? "Non-Heap Memory:Total" : "Non-Heap Memory Usage";
                charSequence = this.getHeapBufferDetails((ArrayList)object2, (String)object);
                if (bl) {
                    string = (String)((ArrayList)object2).get(1);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(string);
                }
                hashtable.put(object, ((StringBuffer)charSequence).toString());
            }
        }
        serializable = null;
        try {
            object4 = new ObjectName("com.azul.zing:type=MemoryPool,*");
            serializable = this.queryZingMxBean((ObjectName)object4, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (serializable != null && ((Hashtable)serializable).size() > 0) {
            object4 = ((Hashtable)serializable).keySet();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (ArrayList)((Hashtable)serializable).get(object2);
                if (object == null || ((ArrayList)object).size() != n) continue;
                charSequence = this.getHeapBufferDetails((ArrayList)object, (String)object2);
                if (bl) {
                    string = (String)((ArrayList)object).get(1);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(string);
                }
                hashtable.put(object2, ((StringBuffer)charSequence).toString());
            }
        }
        return hashtable;
    }

    protected StringBuffer getHeapBufferDetails(ArrayList arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)arrayList.get(0);
        String string3 = (String)arrayList.get(2);
        String string4 = (String)arrayList.get(3);
        String string5 = (String)arrayList.get(4);
        String string6 = (String)arrayList.get(5);
        String string7 = MINUS_FIVE;
        stringBuffer.append(string).append(HASH);
        stringBuffer.append(string2).append(HASH);
        stringBuffer.append(string4).append(HASH);
        stringBuffer.append(string3).append(HASH);
        stringBuffer.append(string5).append(HASH);
        stringBuffer.append(string7).append(HASH);
        stringBuffer.append(string6);
        return stringBuffer;
    }

    protected Hashtable pullMemoryStatistics() {
        if (this.beanServerConn == null) {
            return new Hashtable();
        }
        Hashtable<Object, Object> hashtable = null;
        this.heap_histo_info = new ArrayList();
        boolean bl = false;
        if (this.numOutputFields > 6) {
            bl = true;
        }
        boolean bl2 = false;
        if (this.isZVM()) {
            if (this.zingJVM && this.zingMXBeanExists) {
                hashtable = this.getZingMxBeanDetails(bl);
                return hashtable;
            }
            if (this.zingJVM) {
                bl2 = true;
            }
        }
        hashtable = new Hashtable<Object, Object>();
        try {
            long l;
            long l2;
            String string;
            String string2;
            double d;
            long l3;
            long l4;
            long l5;
            CharSequence charSequence;
            Object object;
            Object object2;
            Object object3;
            MemoryMXBean memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
            try {
                object3 = memoryMXBean.getHeapMemoryUsage();
                object2 = "";
                object = this.showNewMemoryDescriptor ? "Heap Memory:Total" : "Heap Memory Usage";
                charSequence = new StringBuffer();
                if (bl2) {
                    ((StringBuffer)charSequence).append((String)object).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getInit())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getUsed())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getCommitted())).append(HASH);
                    ((StringBuffer)charSequence).append(MINUS_FIVE).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getMax())).append(HASH);
                    ((StringBuffer)charSequence).append(MINUS_FIVE);
                } else {
                    l5 = ((MemoryUsage)object3).getMax();
                    l4 = ((MemoryUsage)object3).getUsed();
                    l3 = ((MemoryUsage)object3).getCommitted();
                    d = -5.0;
                    string2 = MINUS_FIVE;
                    string = MINUS_FIVE;
                    if (l5 >= 0L) {
                        d = (double)l4 * 100.0 / (double)l5;
                        string2 = this.changeUnit(l5);
                        l2 = l5 - l4;
                        string = this.changeUnit(l2);
                    }
                    ((StringBuffer)charSequence).append((String)object).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getInit())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(l4)).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(l3)).append(HASH);
                    ((StringBuffer)charSequence).append(string).append(HASH);
                    ((StringBuffer)charSequence).append(string2).append(HASH);
                    ((StringBuffer)charSequence).append(d);
                }
                if (bl) {
                    String string3 = "0.0";
                    if (((MemoryUsage)object3).getMax() >= 0L && (l = ((MemoryUsage)object3).getMax() - ((MemoryUsage)object3).getUsed()) < 0L) {
                        string3 = "1.0";
                    }
                    ((StringBuffer)charSequence).append(HASH).append(string3);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                }
                object2 = ((StringBuffer)charSequence).toString();
                hashtable.put(object, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object3 = memoryMXBean.getNonHeapMemoryUsage();
                object2 = "";
                object = this.showNewMemoryDescriptor ? "Non-Heap Memory:Total" : "Non-Heap Memory Usage";
                charSequence = new StringBuffer();
                if (bl2) {
                    ((StringBuffer)charSequence).append((String)object).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getInit())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getUsed())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getCommitted())).append(HASH);
                    ((StringBuffer)charSequence).append(MINUS_FIVE).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getMax())).append(HASH);
                    ((StringBuffer)charSequence).append(MINUS_FIVE);
                } else {
                    l5 = ((MemoryUsage)object3).getMax();
                    l4 = ((MemoryUsage)object3).getUsed();
                    l3 = ((MemoryUsage)object3).getCommitted();
                    d = -5.0;
                    string2 = MINUS_FIVE;
                    string = MINUS_FIVE;
                    if (l5 >= 0L) {
                        d = (double)l4 * 100.0 / (double)l5;
                        string2 = this.changeUnit(l5);
                        l2 = l5 - l4;
                        string = this.changeUnit(l2);
                    }
                    ((StringBuffer)charSequence).append((String)object).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(((MemoryUsage)object3).getInit())).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(l4)).append(HASH);
                    ((StringBuffer)charSequence).append(this.changeUnit(l3)).append(HASH);
                    ((StringBuffer)charSequence).append(string).append(HASH);
                    ((StringBuffer)charSequence).append(string2).append(HASH);
                    ((StringBuffer)charSequence).append(d);
                }
                if (bl) {
                    String string4 = "0.0";
                    if (((MemoryUsage)object3).getMax() >= 0L && (l = ((MemoryUsage)object3).getMax() - ((MemoryUsage)object3).getUsed()) < 0L) {
                        string4 = "1.0";
                    }
                    ((StringBuffer)charSequence).append(HASH).append(string4);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                    ((StringBuffer)charSequence).append(HASH).append(MINUS_FIVE);
                }
                object2 = ((StringBuffer)charSequence).toString();
                hashtable.put(object, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = this.pullMemoryPoolStatistics(true);
            if (object3 != null && ((Hashtable)object3).size() > 0) {
                object2 = ((Hashtable)object3).keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    charSequence = (String)object.next();
                    MemoryPoolMXBean memoryPoolMXBean = (MemoryPoolMXBean)((Hashtable)object3).get(charSequence);
                    try {
                        String string5;
                        String string6 = memoryPoolMXBean.getType().toString();
                        MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                        if (memoryUsage == null) continue;
                        String string7 = memoryPoolMXBean.getName();
                        if (string7 != null && string7.indexOf("'") > -1) {
                            string7 = string7.replace("'", "");
                        }
                        String string8 = "Memory Pool_" + string7 + " (" + string6 + ")";
                        if (this.showNewMemoryDescriptor) {
                            string5 = string6.toLowerCase();
                            string8 = string5.startsWith("heap") ? "Heap Memory:Memory Pool " + string7 : "Non-Heap Memory:Memory Pool " + string7;
                        }
                        string5 = "";
                        StringBuffer stringBuffer = new StringBuffer();
                        if (bl2) {
                            stringBuffer.append(string8).append(HASH);
                            stringBuffer.append(this.changeUnit(memoryUsage.getInit())).append(HASH);
                            stringBuffer.append(this.changeUnit(memoryUsage.getUsed())).append(HASH);
                            stringBuffer.append(this.changeUnit(memoryUsage.getCommitted())).append(HASH);
                            stringBuffer.append(MINUS_FIVE).append(HASH);
                            stringBuffer.append(this.changeUnit(memoryUsage.getMax())).append(HASH);
                            stringBuffer.append(MINUS_FIVE);
                        } else {
                            long l6 = memoryUsage.getMax();
                            long l7 = memoryUsage.getUsed();
                            long l8 = memoryUsage.getCommitted();
                            double d2 = -5.0;
                            String string9 = MINUS_FIVE;
                            String string10 = MINUS_FIVE;
                            if (l6 >= 0L) {
                                d2 = (double)l7 * 100.0 / (double)l6;
                                string9 = this.changeUnit(l6);
                                long l9 = l6 - l7;
                                string10 = this.changeUnit(l9);
                            }
                            stringBuffer.append(string8).append(HASH);
                            stringBuffer.append(this.changeUnit(memoryUsage.getInit())).append(HASH);
                            stringBuffer.append(this.changeUnit(l7)).append(HASH);
                            stringBuffer.append(this.changeUnit(l8)).append(HASH);
                            stringBuffer.append(string10).append(HASH);
                            stringBuffer.append(string9).append(HASH);
                            stringBuffer.append(d2);
                        }
                        if (bl) {
                            long l10;
                            String string11 = "0.0";
                            if (memoryUsage.getMax() >= 0L && (l10 = memoryUsage.getMax() - memoryUsage.getUsed()) < 0L) {
                                string11 = "1.0";
                            }
                            stringBuffer.append(HASH).append(string11);
                            stringBuffer.append(HASH).append(MINUS_FIVE);
                            stringBuffer.append(HASH).append(MINUS_FIVE);
                            stringBuffer.append(HASH).append(MINUS_FIVE);
                            stringBuffer.append(HASH).append(MINUS_FIVE);
                            stringBuffer.append(HASH).append(MINUS_FIVE);
                        }
                        string5 = stringBuffer.toString();
                        hashtable.put(string8, string5);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.heapOnOff != null && this.heapOnOff.equals("true")) {
                try {
                    object2 = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
                    object = object2.getName();
                    object = ((String)object).substring(0, ((String)object).indexOf("@"));
                    this.heap_histo_info = this.getJmapResult((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable = new Hashtable<Object, Object>();
            return hashtable;
        }
        return hashtable;
    }

    protected Hashtable pullMemoryPoolStatistics(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null);
            for (ObjectName objectName : set) {
                ObjectName objectName2 = objectName;
                MemoryPoolMXBean memoryPoolMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, objectName2.toString(), MemoryPoolMXBean.class);
                if (memoryPoolMXBean == null) continue;
                String string = memoryPoolMXBean.getName();
                if (bl) {
                    hashtable.put(string, memoryPoolMXBean);
                    continue;
                }
                String string2 = memoryPoolMXBean.getType().toString();
                String[] stringArray = memoryPoolMXBean.getMemoryManagerNames();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + ",");
                }
                String string3 = stringBuffer.toString();
                if (string3.endsWith(",")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                hashtable.put(string, string2 + HASH + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected int getLowCpuMin() {
        int n = 5;
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String string = iniFile.getValue("DD_ROWS", this.entity + ":" + "Low_cpu_threads");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 5;
        }
        return n;
    }

    private Hashtable getAllThreadCpuTime(boolean bl, boolean bl2, boolean bl3) {
        if (!bl || bl2 || !bl3 || this.isSap6orJrockitVersionb37) {
            return null;
        }
        if (this.isOracleHotSpotVersion6u25found && !this.isOracleHotSpotVersion6u25) {
            System.out.println(" JRE version is above 6 , but below 6u25 " + this.isOracleHotSpotVersion6u25found + "  " + this.isOracleHotSpotVersion6u25);
            return null;
        }
        Hashtable<Long, Long> hashtable = new Hashtable<Long, Long>();
        try {
            com.sun.management.ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Threading", com.sun.management.ThreadMXBean.class);
            long[] lArray = null;
            long[] lArray2 = null;
            try {
                lArray = threadMXBean.getAllThreadIds();
                lArray2 = threadMXBean.getThreadCpuTime(lArray);
            }
            catch (Exception exception) {
                System.out.println("Exception in the method getAllThreadCpuTime");
                exception.printStackTrace();
            }
            if (lArray != null && lArray2 != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    Long l = new Long(lArray2[i]);
                    Long l2 = new Long(lArray[i]);
                    hashtable.put(l2, l);
                }
                this.isOracleHotSpotVersion6u25found = true;
                this.isOracleHotSpotVersion6u25 = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Inside [getAllThreadCpuTime] - IllegalArgumentException " + illegalArgumentException.getMessage());
            this.isOracleHotSpotVersion6u25found = true;
            this.isOracleHotSpotVersion6u25 = false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.isOracleHotSpotVersion6u25found = true;
            this.isOracleHotSpotVersion6u25 = false;
            System.out.println("Seems the class com.sun.management.ThreadMXBean is not found in this JVM. " + noClassDefFoundError.getMessage());
        }
        catch (Throwable throwable) {
            this.isOracleHotSpotVersion6u25found = false;
            this.isOracleHotSpotVersion6u25 = false;
            throwable.printStackTrace();
        }
        return hashtable;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Hashtable pullThreadStatistics() {
        Object object;
        Object object2;
        Object object3;
        Hashtable<String, String> hashtable;
        long l;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long l2;
        long l3;
        void var19_33;
        int n8;
        Hashtable<Object, Object> hashtable2;
        Hashtable<Object, Long> hashtable3;
        boolean bl;
        StringBuilder stringBuilder;
        int n9;
        int n10;
        int n11;
        boolean bl2;
        boolean bl3;
        Object object4;
        double d9;
        Hashtable<String, Double> hashtable4;
        block145: {
            long l4;
            Object object5;
            ObjectName objectName;
            boolean bl4;
            long l5;
            block143: {
                Object object6;
                void var19_24;
                block144: {
                    Double d10;
                    hashtable4 = null;
                    if (this.beanServerConn == null) {
                        return new Hashtable();
                    }
                    hashtable4 = new Hashtable<String, Double>();
                    if (!this.isJreVersionFound) {
                        this.isJreAbove6 = this.isJava6();
                    }
                    d9 = 0.0;
                    if (this.targetJVMOsName.equalsIgnoreCase("aix") && (d10 = this.getPercentCpuFromLPAR((String)(object4 = this.getPID()))) != null && (d9 = d10.doubleValue()) < 0.0) {
                        this.isLpar = false;
                    }
                    this.threads_Cpu_Util_Low = this.getLowCpuMin();
                    try {
                        object4 = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Threading", ThreadMXBean.class);
                        bl3 = false;
                        bl2 = false;
                        n11 = 0;
                        l5 = 0L;
                        n10 = 0;
                        n9 = 0;
                        stringBuilder = new StringBuilder();
                        bl = true;
                        try {
                            if (object4.isThreadCpuTimeSupported()) {
                                if (!object4.isThreadCpuTimeEnabled()) {
                                    object4.setThreadCpuTimeEnabled(true);
                                }
                                bl3 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                        try {
                            if (object4.isThreadContentionMonitoringSupported()) {
                                if (!object4.isThreadContentionMonitoringEnabled()) {
                                    object4.setThreadContentionMonitoringEnabled(true);
                                }
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                        bl4 = false;
                        hashtable3 = null;
                        hashtable2 = new Hashtable<Object, Object>();
                        n8 = object4.getThreadCount();
                        if (this.dump_thread_limit != -1 && n8 <= this.dump_thread_limit) {
                            this.dump_thread_limit = -1;
                        }
                        objectName = new ObjectName("java.lang:type=Threading");
                        if (this.dump_thread_limit != -1) break block143;
                        if (this.isJreAbove6 && this.isAgentJRE6) {
                            Object var19_22 = null;
                            try {
                                CompositeData[] compositeDataArray = (CompositeData[])this.beanServerConn.invoke(objectName, "dumpAllThreads", new Object[]{new Boolean(true), new Boolean(true)}, new String[]{"boolean", "boolean"});
                            }
                            catch (SecurityException securityException) {
                                System.err.println(this.entity.toUpperCase() + " :[dumpAllThreads] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                                bl4 = true;
                            }
                            catch (JMRuntimeException jMRuntimeException) {
                                object5 = jMRuntimeException.getMessage();
                                if (object5 != null && ((String)object5).indexOf("Unauthorized access") > 0) {
                                    System.err.println(this.entity.toUpperCase() + " :[dumpAllThreads] Unauthorized access. User does not have required permission " + this.reportingName);
                                    bl4 = true;
                                } else {
                                    jMRuntimeException.printStackTrace();
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            hashtable3 = this.getAllThreadCpuTime(bl3, bl4, this.isAgentJRE6);
                            if (var19_24 == null || ((void)var19_24).length <= 0) break block143;
                            break block144;
                        }
                        Object var19_25 = null;
                        try {
                            void var19_27;
                            try {
                                long[] lArray = object4.getAllThreadIds();
                            }
                            catch (SecurityException securityException) {
                                System.err.println(this.entity.toUpperCase() + " :[getAllThreadIds] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                                bl4 = true;
                            }
                            if (var19_27 == null || ((void)var19_27).length <= 0) break block143;
                            for (int i = 0; i < ((void)var19_27).length; ++i) {
                                object5 = null;
                                try {
                                    object5 = (CompositeData)this.beanServerConn.invoke(objectName, "getThreadInfo", new Object[]{new Long((long)var19_27[i]), new Integer(Integer.MAX_VALUE)}, new String[]{"long", "int"});
                                }
                                catch (SecurityException securityException) {
                                    System.err.println(this.entity.toUpperCase() + " : [getThreadInfo] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                                    bl4 = true;
                                    break block143;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (object5 == null || (object6 = object5.get("threadId")) == null) continue;
                                hashtable2.put(object6, object5);
                            }
                            break block143;
                        }
                        catch (SecurityException securityException) {
                            System.err.println(this.entity.toUpperCase() + " :[getThreadInfo] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                            bl4 = true;
                            break block143;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block143;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new Hashtable();
                    }
                }
                for (int i = 0; i < ((void)var19_24).length; ++i) {
                    object5 = var19_24[i];
                    if (object5 == null || (object6 = object5.get("threadId")) == null) continue;
                    hashtable2.put(object6, object5);
                }
            }
            n11 = object4.getPeakThreadCount();
            l5 = object4.getTotalStartedThreadCount();
            n10 = object4.getDaemonThreadCount();
            Object var19_29 = null;
            if (!bl4) {
                try {
                    void var19_32;
                    if (this.isJreAbove6 && this.isAgentJRE6) {
                        long[] lArray = object4.findDeadlockedThreads();
                    } else {
                        long[] lArray = object4.findMonitorDeadlockedThreads();
                    }
                    if (var19_32 != null && ((void)var19_32).length > 0) {
                        n9 = ((void)var19_32).length;
                        Arrays.sort((long[])var19_32);
                    }
                }
                catch (SecurityException securityException) {
                    System.err.println(this.entity.toUpperCase() + " :[findDeadlockedThreads] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                    bl4 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.dump_thread_limit != -1 && !bl4 && var19_33 != null && ((void)var19_33).length > 0) {
                    hashtable3 = new Hashtable<Object, Long>();
                    for (int i = 0; i < ((void)var19_33).length; ++i) {
                        Object object7;
                        object5 = null;
                        void var22_51 = var19_33[i];
                        try {
                            object5 = (CompositeData)this.beanServerConn.invoke(objectName, "getThreadInfo", new Object[]{new Long((long)var22_51), new Integer(Integer.MAX_VALUE)}, new String[]{"long", "int"});
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (object5 == null || (object7 = object5.get("threadId")) == null) continue;
                        hashtable2.put(object7, object5);
                        long l6 = object4.getThreadCpuTime((long)var22_51);
                        hashtable3.put(object7, new Long(l6));
                    }
                }
            }
            long l7 = 0L;
            l3 = 0L;
            long l8 = 0L;
            l2 = 0L;
            String string = this.getPreviousValue();
            if (string != null && string.length() > 0) {
                try {
                    String string2;
                    if (string.indexOf(HASH) > -1 && (string2 = string.substring(0, string.indexOf(HASH)).trim()) != null && string2.indexOf("|") > -1) {
                        l7 = Long.parseLong(string2.substring(0, string2.indexOf("|")));
                        l8 = Long.parseLong(string2.substring(string2.indexOf("|") + 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((l4 = this.getJVMRunTime()) < 0L) {
                l7 = 0L;
            }
            l2 = l4 < l7 ? l4 : l4 - l7;
            stringBuilder.append(l4);
            if (l8 == 0L) {
                l3 = l5;
            } else {
                l3 = l5 - l8;
                if (l3 < 0L) {
                    l3 = l5;
                }
            }
            stringBuilder.append("|").append(l5);
            if (bl4) {
                long l9 = object4.getThreadCount();
                hashtable4.put("TotalNumberOfThreads", new Double(l9));
                hashtable4.put("NumberOfThreadsRunning", new Double(-5.0));
                hashtable4.put("NumberOfThreadsBlocked", new Double(-5.0));
                hashtable4.put("NumberOfThreadsWaiting", new Double(-5.0));
                hashtable4.put("NumberOfThreadsTimedWaiting", new Double(-5.0));
                hashtable4.put("NumberOfLowCpuUtil", new Double(-5.0));
                hashtable4.put("NumberOfMiddleCpuUtil", new Double(-5.0));
                hashtable4.put("NumberOfHighCpuUtil", new Double(-5.0));
                hashtable4.put("NumberOfPeakThreadCount", new Double(n11));
                hashtable4.put("TotalStartedThreadCount", new Double(l3));
                hashtable4.put("TotalDaemonThreadCount", new Double(n10));
                hashtable4.put("DeadLockThreadCount", new Double(-5.0));
                hashtable4.put("LowCpuThreadPercentage", new Double(-5.0));
                hashtable4.put("MediumCpuThreadPercentage", new Double(-5.0));
                hashtable4.put("HighCpuThreadPercentage", new Double(-5.0));
                hashtable4.put("WebThreadCpuPercentage", new Double(-5.0));
                hashtable4.put("RMIThreadCpuPercentage", new Double(-5.0));
                hashtable4.put("OtherThreadCpuPercentage", new Double(-5.0));
                hashtable4.put("GCThreadCpuPercentage", new Double(-5.0));
                this.setCurrentValue(stringBuilder.toString());
                return hashtable4;
            }
            if (hashtable2.size() == 0 && this.dump_thread_limit == -1) {
                return new Hashtable();
            }
            ArrayList arrayList = new ArrayList();
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            d8 = 0.0;
            d7 = 0.0;
            d6 = 0.0;
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            l = 0L;
            this.threads_runnable_info = new ArrayList();
            this.threads_waiting_info = new ArrayList();
            this.threads_blocked_info = new ArrayList();
            this.threads_timed_waiting_info = new ArrayList();
            this.threads_cpu_utils_high_info = new ArrayList();
            this.threads_cpu_utils_medium_info = new ArrayList();
            this.threads_cpu_utils_low_info = new ArrayList();
            this.deadlock_threads_info = new ArrayList();
            this.blockingThreadsId = new HashSet();
            hashtable = new Hashtable<String, String>();
            if ((bl3 || bl2) && string != null && string.length() > 0) {
                try {
                    String string3;
                    if (string.indexOf(HASH) <= -1 || (string3 = string.substring(string.indexOf(HASH) + 1)) == null || string3.length() <= 0) break block145;
                    int n12 = string3.indexOf("$$");
                    if (n12 > 0) {
                        object3 = string3.substring(n12 + 2);
                        string3 = string3.substring(0, n12);
                        try {
                            if (object3 != null && ((String)object3).length() > 0) {
                                l = Long.parseLong(((String)object3).trim());
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Exception occured while fetching previousJVMProcessTime due to the value - " + (String)object3);
                        }
                    }
                    object3 = new StringTokenizer(string3, "~");
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        object2 = ((StringTokenizer)object3).nextToken();
                        object = ((String)object2).substring(0, ((String)object2).indexOf("|"));
                        String string4 = ((String)object2).substring(((String)object2).indexOf("|") + 1);
                        hashtable.put(((String)object).trim(), string4);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        long l10 = 0L;
        if (this.isLpar && bl3) {
            object3 = hashtable2.keySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Long)object2.next();
                long l11 = (Long)object;
                long l12 = 0L;
                if (hashtable3 != null && hashtable3.size() > 0) {
                    Long l13 = (Long)hashtable3.get(object);
                    if (l13 != null) {
                        l12 = l13;
                    }
                } else {
                    l12 = object4.getThreadCpuTime(l11);
                }
                long l14 = 0L;
                long l15 = 0L;
                if (hashtable != null && hashtable.size() > 0) {
                    try {
                        Object object8;
                        StringTokenizer stringTokenizer;
                        if (hashtable.containsKey(String.valueOf(l11).trim()) && (stringTokenizer = new StringTokenizer((String)(object8 = (String)hashtable.get(String.valueOf(l11))), ":")) != null && stringTokenizer.countTokens() == 3 && bl3) {
                            l14 = Long.parseLong(stringTokenizer.nextToken());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (l12 <= l14) continue;
                l15 = l12 - l14;
                l10 += l15;
            }
        }
        int n13 = this.getLocalProcessors();
        object2 = hashtable2.keySet();
        object = object2.iterator();
        while (true) {
            void var72_112;
            void var72_110;
            Object object9;
            Object object10;
            Comparable<StringBuffer> comparable;
            String string;
            String string5;
            Object object11;
            Object object12;
            String string6;
            String string7;
            String string8;
            double d11;
            double d12;
            Object object13;
            long l16;
            long l17;
            Object object14;
            long l18;
            Hashtable<String, Object> hashtable5;
            block148: {
                block150: {
                    CharSequence charSequence;
                    ArrayList arrayList;
                    int n14;
                    block149: {
                        if (object.hasNext()) {
                            hashtable5 = new Hashtable<String, Object>();
                            try {
                                long l19;
                                long l20;
                                long l21;
                                long l22;
                                long l23;
                                long l24;
                                long l25;
                                long l26;
                                long l27;
                                Long l28;
                                block146: {
                                    l28 = (Long)object.next();
                                    String string9 = l28.toString();
                                    l18 = l28;
                                    CompositeData compositeData = (CompositeData)hashtable2.get(l28);
                                    if (compositeData == null) continue;
                                    CompositeType compositeType = compositeData.getCompositeType();
                                    Set<String> set = compositeType.keySet();
                                    for (String string10 : set) {
                                        object14 = compositeData.get(string10);
                                        if (object14 == null) continue;
                                        hashtable5.put(string10, object14);
                                    }
                                    if (hashtable5 == null || hashtable5.size() <= 0) continue;
                                    Object var72_108 = null;
                                    object14 = null;
                                    l17 = 0L;
                                    l16 = 0L;
                                    if (hashtable5.containsKey("threadName")) {
                                        String string11 = (String)hashtable5.get("threadName");
                                    }
                                    if (hashtable5.containsKey("threadState")) {
                                        object14 = (String)hashtable5.get("threadState");
                                    }
                                    if (hashtable5.containsKey("blockedCount")) {
                                        l17 = (Long)hashtable5.get("blockedCount");
                                    }
                                    if (hashtable5.containsKey("waitedCount")) {
                                        l16 = (Long)hashtable5.get("waitedCount");
                                    }
                                    l27 = 0L;
                                    l26 = 0L;
                                    l25 = 0L;
                                    l24 = 0L;
                                    l23 = 0L;
                                    l22 = 0L;
                                    l21 = 0L;
                                    l20 = 0L;
                                    l19 = 0L;
                                    object13 = 0.0;
                                    d12 = 0.0;
                                    d11 = 0.0;
                                    string8 = "Not available";
                                    string7 = "Not available";
                                    string6 = "Not available";
                                    if ((bl3 || bl2) && hashtable != null && hashtable.size() > 0) {
                                        try {
                                            if (!hashtable.containsKey(string9) || (object12 = new StringTokenizer((String)(object11 = (String)hashtable.get(string9)), ":")) == null || ((StringTokenizer)object12).countTokens() != 3) break block146;
                                            if (bl3) {
                                                l24 = Long.parseLong(((StringTokenizer)object12).nextToken());
                                            }
                                            if (bl2) {
                                                l23 = Long.parseLong(((StringTokenizer)object12).nextToken());
                                                l22 = Long.parseLong(((StringTokenizer)object12).nextToken());
                                            }
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                }
                                if (bl3) {
                                    if (hashtable3 != null && hashtable3.size() > 0) {
                                        object11 = (Long)hashtable3.get(l28);
                                        if (object11 != null) {
                                            l25 = (Long)object11;
                                        }
                                    } else {
                                        l25 = object4.getThreadCpuTime(l18);
                                    }
                                    object11 = this.getThreadCpuPercent(l25, l24, this.isLpar, l10, l2, n13, d9);
                                    object13 = object11[0];
                                    l21 = (long)object11[1];
                                    string6 = JVMInstrumentation.formatValue((double)(l21 / 1000000L) / 1000.0);
                                    if (bl) {
                                        stringBuilder.append(HASH).append(l18).append("|").append(l25);
                                    } else {
                                        stringBuilder.append("~").append(l18).append("|").append(l25);
                                    }
                                } else if (bl) {
                                    stringBuilder.append(HASH).append(l18).append("|").append("None");
                                } else {
                                    stringBuilder.append("~").append(l18).append("|").append("None");
                                }
                                if (bl2) {
                                    if (hashtable5.containsKey("blockedTime")) {
                                        l27 = (Long)hashtable5.get("blockedTime");
                                    }
                                    if ((d12 = (double)((l20 = l27 < l23 ? l27 : l27 - l23) / 1000L) / (double)(l2 / 1000L) * 100.0) > 100.0) {
                                        d12 = 100.0;
                                    }
                                    string8 = JVMInstrumentation.formatValue((double)l20 / 1000.0);
                                    stringBuilder.append(":").append(l27);
                                    if (hashtable5.containsKey("waitedTime")) {
                                        l26 = (Long)hashtable5.get("waitedTime");
                                    }
                                    if ((d11 = (double)((l19 = l26 < l22 ? l26 : l26 - l22) / 1000L) / (double)(l2 / 1000L) * 100.0) > 100.0) {
                                        d11 = 100.0;
                                    }
                                    string7 = JVMInstrumentation.formatValue((double)l19 / 1000.0);
                                    stringBuilder.append(":").append(l26);
                                } else {
                                    stringBuilder.append(":").append("None");
                                    stringBuilder.append(":").append("None");
                                }
                                bl = false;
                                object11 = null;
                                object12 = null;
                                string5 = null;
                                string = "";
                                if (!hashtable5.containsKey("stackTrace")) break block148;
                                comparable = new StringBuffer();
                                object10 = (CompositeData[])hashtable5.get("stackTrace");
                                if (this.isOracleHotSpotVersion9) {
                                    break block149;
                                }
                                for (n14 = 0; n14 < ((CompositeData[])object10).length; ++n14) {
                                    object9 = object10[n14].getCompositeType();
                                    Collection<?> collection = object10[n14].values();
                                    if (collection == null) continue;
                                    arrayList = new ArrayList(collection);
                                    charSequence = new StringBuffer();
                                    ((StringBuffer)charSequence).append((String)arrayList.get(0));
                                    ((StringBuffer)charSequence).append("." + (String)arrayList.get(3));
                                    int n15 = (Integer)arrayList.get(2);
                                    boolean bl5 = (Boolean)arrayList.get(4);
                                    if (n15 < 0 && bl5) {
                                        ((StringBuffer)charSequence).append("(Native Method)");
                                    } else if (n15 < 0) {
                                        ((StringBuffer)charSequence).append("(Unknown Source)");
                                    } else {
                                        ((StringBuffer)charSequence).append("(").append((String)arrayList.get(1)).append(":").append(n15).append(")");
                                    }
                                    ((StringBuffer)comparable).append((StringBuffer)charSequence).append(";").append("  ");
                                }
                                break block150;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (d3 >= 0.0 && (d2 = d3 - (d5 + d4 + d)) < 0.0) {
                            d2 = 0.0;
                        }
                        double d13 = 0.0;
                        double d14 = this.getJvmCpuPercentage(d9, l, this.isLpar, 0L, l2, n13, stringBuilder);
                        if (d14 >= 0.0 && (d13 = d14 - (d5 + d4 + d2)) < 0.0) {
                            d13 = 0.0;
                        }
                        if (this.dump_thread_limit == -1) {
                            n8 = n7 + n6 + n5 + n4;
                        } else {
                            n7 = -5;
                            n6 = -5;
                            n5 = -5;
                            n4 = -5;
                            n3 = -5;
                            n2 = -5;
                            n = -5;
                            this.threads_runnable_info = null;
                            this.threads_blocked_info = null;
                            this.threads_waiting_info = null;
                            this.threads_timed_waiting_info = null;
                            this.threads_cpu_utils_low_info = null;
                            this.threads_cpu_utils_medium_info = null;
                            this.threads_cpu_utils_high_info = null;
                        }
                        hashtable4.put("TotalNumberOfThreads", new Double(n8));
                        hashtable4.put("NumberOfThreadsRunning", new Double(n7));
                        hashtable4.put("NumberOfThreadsBlocked", new Double(n6));
                        hashtable4.put("NumberOfThreadsWaiting", new Double(n5));
                        hashtable4.put("NumberOfThreadsTimedWaiting", new Double(n4));
                        hashtable4.put("NumberOfLowCpuUtil", new Double(n3));
                        hashtable4.put("NumberOfMiddleCpuUtil", new Double(n2));
                        hashtable4.put("NumberOfHighCpuUtil", new Double(n));
                        hashtable4.put("NumberOfPeakThreadCount", new Double(n11));
                        hashtable4.put("TotalStartedThreadCount", new Double(l3));
                        hashtable4.put("TotalDaemonThreadCount", new Double(n10));
                        hashtable4.put("DeadLockThreadCount", new Double(n9));
                        d7 = this.getPercentage(d7, "LowCpuThreadPercentage");
                        d8 = this.getPercentage(d8, "MediumCpuThreadPercentage");
                        d6 = this.getPercentage(d6, "HighCpuThreadPercentage");
                        d5 = this.getPercentage(d5, "webThreadCpuPercentage");
                        d4 = this.getPercentage(d4, "rmiThreadCpuPercentage");
                        d2 = this.getPercentage(d2, "otherThreadCpuPercentage");
                        d13 = this.getPercentage(d13, "gcThreadCpuPercentage");
                        hashtable4.put("LowCpuThreadPercentage", new Double(d7));
                        hashtable4.put("MediumCpuThreadPercentage", new Double(d8));
                        hashtable4.put("HighCpuThreadPercentage", new Double(d6));
                        hashtable4.put("WebThreadCpuPercentage", new Double(d5));
                        hashtable4.put("RMIThreadCpuPercentage", new Double(d4));
                        hashtable4.put("OtherThreadCpuPercentage", new Double(d2));
                        hashtable4.put("GCThreadCpuPercentage", new Double(d13));
                        this.setCurrentValue(stringBuilder.toString());
                        return hashtable4;
                    }
                    for (n14 = 0; n14 < ((CompositeData[])object10).length; ++n14) {
                        object9 = object10[n14].getCompositeType();
                        Collection<?> collection = object10[n14].values();
                        if (collection == null) continue;
                        arrayList = new ArrayList(collection);
                        charSequence = (String)arrayList.get(0);
                        String string12 = (String)arrayList.get(1);
                        String string13 = (String)arrayList.get(2);
                        Integer n16 = (Integer)arrayList.get(3);
                        String string14 = (String)arrayList.get(4);
                        String string15 = (String)arrayList.get(5);
                        String string16 = (String)arrayList.get(6);
                        Boolean bl6 = (Boolean)arrayList.get(7);
                        StringBuffer stringBuffer = new StringBuffer();
                        boolean bl7 = false;
                        if (charSequence != null) {
                            stringBuffer.append((String)charSequence).append("/");
                            bl7 = true;
                        }
                        if (string15 != null && string15.length() > 0) {
                            stringBuffer.append(string15);
                            if (string16 != null) {
                                stringBuffer.append("@").append(string16);
                            }
                            stringBuffer.append("/");
                        } else if (bl7) {
                            stringBuffer.append("/");
                        }
                        stringBuffer.append(string12).append(".").append(string14);
                        boolean bl8 = bl6;
                        int n17 = n16;
                        if (n17 < 0 && bl8) {
                            stringBuffer.append("(Native Method)");
                        } else {
                            if (string13 == null) {
                                n17 = -2;
                            }
                            if (n17 < 0) {
                                stringBuffer.append("(Unknown Source)");
                            } else {
                                stringBuffer.append("(").append(string13).append(":").append(n16).append(")");
                            }
                        }
                        ((StringBuffer)comparable).append(stringBuffer).append(";").append("  ");
                    }
                }
                string = ((StringBuffer)comparable).toString();
            }
            if (hashtable5.containsKey("lockName")) {
                object11 = (String)hashtable5.get("lockName");
            }
            if (hashtable5.containsKey("lockOwnerName")) {
                object12 = (String)hashtable5.get("lockOwnerName");
            }
            if (hashtable5.containsKey("lockOwnerId")) {
                comparable = (Long)hashtable5.get("lockOwnerId");
                string5 = ((Long)comparable).toString();
            }
            boolean bl9 = false;
            if (string.trim().length() <= 3) {
                string = "-";
                bl9 = true;
            }
            object10 = new StringBuffer(((String)object14).toString());
            if (object11 != null && ((String)object11).length() > 0) {
                ((StringBuffer)object10).append(" on ").append(((String)object11).toString());
            }
            if (object12 != null && ((String)object12).length() > 0) {
                ((StringBuffer)object10).append(" owned by: ").append(((String)object12).toString());
                if (string5 != null && string5.length() > 0) {
                    ((StringBuffer)object10).append("(").append(string5.toString()).append(")");
                    this.blockingThreadsId.add(string5);
                }
            }
            if (var72_110.length() > 512) {
                String string17 = var72_110.substring(0, 507) + "...";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((String)var72_112).append("~").append(l18).append("~").append((StringBuffer)object10).append("~").append(string6).append("~").append(JVMInstrumentation.formatValue(object13)).append("~").append(l17).append("~").append(string8).append("~").append(JVMInstrumentation.formatValue(d12)).append("~").append(l16).append("~").append(string7).append("~").append(JVMInstrumentation.formatValue(d11)).append("~").append(string);
            object9 = stringBuffer.toString();
            object10 = null;
            stringBuffer = null;
            if (((String)object14).toString().compareToIgnoreCase("RUNNABLE") == 0) {
                ++n7;
                this.threads_runnable_info.add(object9);
            } else if (((String)object14).toString().compareToIgnoreCase("BLOCKED") == 0) {
                ++n6;
                this.threads_blocked_info.add(object9);
            } else if (((String)object14).toString().compareToIgnoreCase("WAITING") == 0) {
                ++n5;
                this.threads_waiting_info.add(object9);
            } else if (((String)object14).toString().compareToIgnoreCase("TIMED_WAITING") == 0) {
                ++n4;
                this.threads_timed_waiting_info.add(object9);
            }
            if (var19_33 != null && ((void)var19_33).length > 0 && Arrays.binarySearch((long[])var19_33, l18) >= 0) {
                this.deadlock_threads_info.add(object9);
            }
            if (object13 > 0.0) {
                if (bl9) {
                    d += object13;
                } else {
                    int n18 = this.getThreadCategory((String)var72_112);
                    if (n18 == 1) {
                        d5 += object13;
                    } else if (n18 == 2) {
                        d4 += object13;
                    }
                }
                d3 += object13;
            }
            if (object13 >= this.threads_Cpu_Util_Low && object13 < this.threads_Cpu_Util_Medium) {
                ++n3;
                d7 += object13;
                this.threads_cpu_utils_low_info.add(object9);
                continue;
            }
            if (object13 >= this.threads_Cpu_Util_Medium && object13 < this.threads_Cpu_Util_High) {
                ++n2;
                d8 += object13;
                this.threads_cpu_utils_medium_info.add(object9);
                continue;
            }
            if (!(object13 >= this.threads_Cpu_Util_High)) continue;
            ++n;
            d6 += object13;
            this.threads_cpu_utils_high_info.add(object9);
        }
    }

    protected double getPercentage(double d, String string) {
        if (d > 100.0) {
            System.out.println(this.entity.toUpperCase() + " :  " + string + " Percentage crosses 100 % for " + this.reportingName);
            d = 99.9;
        }
        return d;
    }

    protected Hashtable pullUptimeStatistics(String string, long l) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        long l2 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (string != null && string.equalsIgnoreCase("jmx") && this.beanServerConn == null) {
            this.setCurrentValue("0.0#" + System.currentTimeMillis());
            hashtable.put("Reboot", new Double(-5.0));
            hashtable.put("Uptime", new Double(-5.0));
            hashtable.put("TotalUptime", new Double(-5.0));
            return hashtable;
        }
        try {
            Object object;
            l2 = string != null && string.equalsIgnoreCase("jmx") ? this.getJVMRunTime() : l;
            double d4 = 0.0;
            long l3 = 0L;
            String string2 = this.getPreviousValue();
            if (string2 != null && string2.length() > 0 && string2.indexOf(HASH) > -1 && ((StringTokenizer)(object = new StringTokenizer(string2, HASH))).countTokens() == 2) {
                try {
                    d4 = Double.parseDouble(((StringTokenizer)object).nextToken());
                    l3 = Long.parseLong(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (l2 < 0L) {
                d2 = -5.0;
                d = -5.0;
                d3 = -5.0;
                this.setCurrentValue("0.0#" + System.currentTimeMillis());
            } else if ((double)l2 < d4) {
                long l4;
                d = (double)l2 / 1000.0;
                d2 = 1.0;
                d3 = d;
                object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date date = null;
                long l5 = 0L;
                long l6 = 0L;
                String string3 = "";
                String string4 = "";
                long l7 = System.currentTimeMillis();
                if (this.isReportMgrTime) {
                    l4 = l7 - l3;
                    l5 = dateInfo.egetUTCDate() - l4;
                    string3 = dateInfo.egetDate(l5);
                    l6 = dateInfo.egetUTCDate() - l2;
                    string4 = dateInfo.egetDate(l6);
                } else {
                    l5 = l3;
                    date = new Date(l5);
                    string3 = ((DateFormat)object).format(date);
                    l6 = l7 - l2;
                    date = new Date(l6);
                    string4 = ((DateFormat)object).format(date);
                }
                l4 = l6 - l5;
                if (l4 > 0L) {
                    double d5 = (double)l4 / 1000.0 / 60.0;
                    String string5 = "No";
                    if (this.checkMaintenance()) {
                        string5 = "Yes";
                    }
                    String string6 = HASH;
                    this.jvmUptimeDDLine = string3 + string6 + string4 + string6 + this.round(d5, 4) + string6 + string5;
                }
                this.setCurrentValue(String.valueOf(l2 + HASH + System.currentTimeMillis()));
            } else {
                d = ((double)l2 - d4) / 1000.0;
                d2 = 0.0;
                d3 = (double)l2 / 1000.0;
                this.setCurrentValue(String.valueOf(l2 + HASH + System.currentTimeMillis()));
            }
            d3 = this.secondsToMinutes(d3);
            hashtable.put("Reboot", new Double(d2));
            hashtable.put("Uptime", new Double(d));
            hashtable.put("TotalUptime", new Double(d3));
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable = new Hashtable();
            hashtable.put("Reboot", new Double(-5.0));
            hashtable.put("Uptime", new Double(-5.0));
            hashtable.put("TotalUptime", new Double(-5.0));
            return hashtable;
        }
    }

    protected Hashtable pullJvmInfoStatistics() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        ArrayList<String> arrayList = null;
        String string5 = new String();
        String string6 = new String();
        String string7 = new String();
        String string8 = new String();
        String string9 = new String();
        String string10 = new String();
        if (this.beanServerConn == null) {
            hashtable.put("Virtual_machine", new Double(-5.0));
            hashtable.put("Version", new Double(-5.0));
            hashtable.put("Vendor", new Double(-5.0));
            hashtable.put("JIT_compiler", new Double(-5.0));
            hashtable.put("VM_arguments", new Double(-5.0));
            hashtable.put("Classpath", new Double(-5.0));
            hashtable.put("Librarypath", new Double(-5.0));
            hashtable.put("Boot_classpath", new Double(-5.0));
            hashtable.put("Max_heap_size", new Double(-5.0));
            hashtable.put("Java_version", new Double(-5.0));
            hashtable.put("Java_architecture", new Double(-5.0));
            return hashtable;
        }
        try {
            CharSequence charSequence;
            MemoryMXBean memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
            RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
            CompilationMXBean compilationMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Compilation", CompilationMXBean.class);
            String string11 = this.getPreviousValue();
            long l = 0L;
            String string12 = "";
            try {
                if (string11 != null && string11.length() > 0 && string11.indexOf(HASH) > -1) {
                    string12 = string11.substring(string11.indexOf(HASH) + 1);
                    l = Long.parseLong(string11.substring(0, string11.indexOf(HASH)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l2 = runtimeMXBean.getStartTime();
            if (l == 0L || l != l2) {
                string8 = String.valueOf(memoryMXBean.getHeapMemoryUsage().getMax());
                this.setCurrentValue(String.valueOf(l2 + HASH + string8));
            } else {
                string8 = string12;
            }
            string = runtimeMXBean.getVmName();
            string2 = runtimeMXBean.getVmVersion();
            string3 = runtimeMXBean.getVmVendor();
            string4 = compilationMXBean.getName();
            try {
                arrayList = (ArrayList<String>)runtimeMXBean.getInputArguments();
            }
            catch (SecurityException securityException) {
                System.err.println(this.entity.toUpperCase() + " :[RuntimeMXBean.getInputArguments] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                arrayList = new ArrayList<String>();
                arrayList.add("Unavailable");
            }
            string5 = runtimeMXBean.getClassPath();
            string6 = runtimeMXBean.getLibraryPath();
            boolean bl = runtimeMXBean.isBootClassPathSupported();
            if (bl) {
                try {
                    string7 = runtimeMXBean.getBootClassPath();
                }
                catch (SecurityException securityException) {
                    System.err.println(this.entity.toUpperCase() + " :[RuntimeMXBean.getBootClassPath] security manager exists and the caller does not have ManagementPermission(\"monitor\") " + this.reportingName);
                    string7 = "Unavailable";
                }
            } else {
                string7 = "Unavailable";
            }
            Map<String, String> map = runtimeMXBean.getSystemProperties();
            Set<String> set = map.keySet();
            Iterator<String> iterator = set.iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                charSequence = iterator.next();
                String string13 = map.get(charSequence);
                if (((String)charSequence).equals("java.version")) {
                    bl2 = true;
                    string9 = string13;
                } else if (((String)charSequence).equals("sun.arch.data.model")) {
                    bl3 = true;
                    string10 = string13;
                }
                if (!bl2 || !bl3) continue;
                break;
            }
            charSequence = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                ((StringBuffer)charSequence).append((String)arrayList.get(i));
                if (i == arrayList.size() - 1) continue;
                ((StringBuffer)charSequence).append(" ");
            }
            hashtable.put("Virtual_machine", string);
            hashtable.put("Version", string2);
            hashtable.put("Vendor", string3);
            hashtable.put("JIT_compiler", string4);
            hashtable.put("VM_arguments", ((StringBuffer)charSequence).toString());
            hashtable.put("Classpath", string5);
            hashtable.put("Librarypath", string6);
            hashtable.put("Boot_classpath", string7);
            hashtable.put("Max_heap_size", string8);
            hashtable.put("Java_version", string9);
            hashtable.put("Java_architecture", string10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getSudoCommandForJmap(String string, String string2) {
        String string3 = "";
        if (this.useSudo != null && (this.useSudo.equalsIgnoreCase("yes") || this.useSudo.equalsIgnoreCase("true")) && this.targetProcessUserName != null && !this.targetProcessUserName.equalsIgnoreCase("none")) {
            File file = new File("/usr/bin/sudo");
            if (file.exists()) {
                string3 = "/usr/bin/sudo -u " + this.targetProcessUserName + " " + string + " -histo " + string2;
            } else {
                file = new File("/usr/local/bin/sudo");
                if (file.exists()) {
                    string3 = "/usr/local/bin/sudo -u " + this.targetProcessUserName + " " + string + " -histo " + string2;
                } else {
                    System.err.println(" sudo not found in /usr/bin (or) /usr/local/bin ");
                }
            }
        }
        return string3;
    }

    protected ArrayList getJmapResult(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList2 = new ArrayList();
            String string2 = "";
            String string3 = "";
            boolean bl = false;
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            if (this.beanServerConn != null) {
                bl = this.beanServerConn.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean");
            }
            if (bl) {
                return arrayList;
            }
            if (this.jmappath.equals("none")) {
                if (this.targetJVMOsName.startsWith("win")) {
                    string2 = "jmap -histo " + string;
                } else {
                    string3 = "jmap";
                    string2 = this.getSudoCommandForJmap(string3, string);
                    if (string2 != null && string2.length() == 0) {
                        string2 = "jmap -histo " + string;
                    }
                }
            } else if (this.targetJVMOsName.startsWith("win")) {
                string2 = "\"" + this.jmappath + "/bin/jmap\" -histo " + string;
            } else {
                string3 = this.jmappath + "/bin/jmap";
                string2 = this.getSudoCommandForJmap(string3, string);
                if (string2 != null && string2.length() == 0) {
                    string2 = this.jmappath + "/bin/jmap -histo " + string;
                }
            }
            try {
                arrayList2 = egUtilities.getExecOutputLines(string2);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    System.err.println("[" + this.entity + "] Cannot able to execute command " + string2 + " for the Host : " + this.reportingName);
                    System.err.print(arrayList3 + "\n");
                }
            }
            catch (Exception exception) {
                return arrayList;
            }
            arrayList = this.processJmapResult(arrayList2);
        }
        catch (Exception exception) {
            return arrayList;
        }
        return arrayList;
    }

    public ArrayList processJmapResult(ArrayList arrayList) {
        ArrayList<String> arrayList2;
        block20: {
            arrayList2 = new ArrayList<String>();
            try {
                Object object;
                CharSequence charSequence;
                Object object2;
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                boolean bl = false;
                if (this.include != null && this.include.trim().length() > 0) {
                    if (this.include.equalsIgnoreCase("all") || this.include.equals("*")) {
                        bl = true;
                    } else {
                        object2 = new StringTokenizer(this.include, ",");
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            charSequence = ((StringTokenizer)object2).nextToken().trim();
                            if (charSequence == null || ((String)charSequence).length() <= 0) continue;
                            if (((String)charSequence).equalsIgnoreCase("all") || ((String)charSequence).equals("*")) {
                                bl = true;
                                break;
                            }
                            if (((String)charSequence).length() > 1 && ((String)charSequence).endsWith("*")) {
                                charSequence = ((String)charSequence).substring(0, ((String)charSequence).lastIndexOf("*"));
                            }
                            arrayList3.add((String)charSequence);
                        }
                    }
                }
                if (this.exclude != null && this.exclude.trim().length() > 0 && !this.exclude.trim().equalsIgnoreCase("NONE")) {
                    object2 = new StringTokenizer(this.exclude, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        charSequence = ((StringTokenizer)object2).nextToken().trim();
                        if (charSequence == null || ((String)charSequence).length() <= 0) continue;
                        if (((String)charSequence).length() > 1 && ((String)charSequence).endsWith("*")) {
                            charSequence = ((String)charSequence).substring(0, ((String)charSequence).lastIndexOf("*"));
                        }
                        arrayList4.add((String)charSequence);
                    }
                }
                if (arrayList == null || arrayList.size() <= 0) break block20;
                object2 = (ArrayList)arrayList.get(0);
                charSequence = null;
                StringTokenizer stringTokenizer = null;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                long l = 0L;
                long l2 = 0L;
                if (object2 == null || ((ArrayList)object2).size() <= 0) break block20;
                String string5 = (String)((ArrayList)object2).get(((ArrayList)object2).size() - 1);
                stringTokenizer = new StringTokenizer(string5);
                if (stringTokenizer.countTokens() == 3) {
                    object = stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    l = Long.parseLong((String)object);
                    object = stringTokenizer.nextToken();
                    l2 = Long.parseLong((String)object);
                }
                object = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
                String string6 = ((IniFile)object).getValue("DD_ROWS", this.entity);
                int n = Integer.parseInt(string6);
                DecimalFormat decimalFormat = new DecimalFormat("#.####");
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator('.');
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                int n2 = 0;
                for (int i = 3; i < ((ArrayList)object2).size() - 1; ++i) {
                    String string7 = (String)((ArrayList)object2).get(i);
                    stringTokenizer = new StringTokenizer(string7);
                    charSequence = new StringBuffer();
                    if (stringTokenizer.countTokens() == 4) {
                        int n3;
                        string = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        string3 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        if (string4.startsWith("<") && string4.endsWith(">")) continue;
                        boolean bl2 = false;
                        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                            String string8 = (String)arrayList4.get(n3);
                            if (!string4.startsWith(string8)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        n3 = 0;
                        if (bl) {
                            n3 = 1;
                        } else {
                            for (int j = 0; j < arrayList3.size(); ++j) {
                                String string9 = (String)arrayList3.get(j);
                                if (!string4.startsWith(string9)) continue;
                                n3 = 1;
                                break;
                            }
                        }
                        if (n3 != 0) {
                            double d = Double.parseDouble(string2) / (double)l * 100.0;
                            double d2 = Double.parseDouble(string3) / (double)l2 * 100.0;
                            double d3 = Double.parseDouble(EgUtils.convertMemoryValues(string3, "B", "MB"));
                            ((StringBuffer)charSequence).append(string4 + "^" + string2 + "^" + decimalFormat.format(d) + "^" + decimalFormat.format(d3) + "^" + decimalFormat.format(d2));
                            arrayList2.add(((StringBuffer)charSequence).toString());
                            ++n2;
                        }
                    }
                    if (n2 < n) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception occured while executing jmap");
                exception.printStackTrace();
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentValue(String string) {
        Properties properties = new Properties();
        String string2 = this.reportingName + ":" + this.portNo + ":" + this.entity;
        InputStream inputStream = null;
        try {
            String string3 = JVMSync;
            synchronized (string3) {
                inputStream = new FileInputStream(jvmInfoProps);
                properties.load(new BufferedInputStream(inputStream));
                properties.setProperty(string2, string);
                properties.store(new BufferedOutputStream(new FileOutputStream(jvmInfoProps)), "eG Java Monitor Information file <P> PLEASE DO NOT DELETE <P>");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Double getPercentCpuFromLPAR(String string) {
        Object object;
        Hashtable hashtable = new Hashtable();
        Double d = new Double(-1.0);
        if (this.meAgentless) {
            Object object2;
            IniFile iniFile;
            object = "";
            if (this.isSSH) {
                object = "ssh";
            } else if (this.isRexec) {
                object = "rexec";
            }
            if (this.firstTime) {
                String string2;
                iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
                object2 = iniFile.getValue("AGENT_SETTINGS", "AIXusePS");
                this.aixUsePs = object2 != null && (((String)object2).equalsIgnoreCase("yes") || ((String)object2).equalsIgnoreCase("true"));
                ProcessGeneric processGeneric = new ProcessGeneric((String)object, this.targetHost, this.sshPort, this.aluser, this.alpassword, false, false);
                String string3 = "uname -L";
                ArrayList arrayList = processGeneric.getLparstatValue(string3);
                if (arrayList != null && arrayList.size() > 0 && (string2 = (String)arrayList.get(0)) != null && string2.length() > 0) {
                    this.isLpar = string2.indexOf("-1") <= -1 || string2.indexOf("NULL") <= -1;
                }
                this.firstTime = false;
            }
            if (this.aixUsePs || this.usePs) {
                this.isLpar = false;
            }
            if (this.isLpar) {
                iniFile = new GetTprofRemote((String)object, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                object2 = iniFile.runTprof();
                hashtable = (Hashtable)((Hashtable)object2).get("tprof");
            }
        } else {
            Object object3;
            if (this.firstTime) {
                String string4;
                object = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
                object3 = ((IniFile)object).getValue("AGENT_SETTINGS", "AIXusePS");
                this.aixUsePs = object3 != null && (((String)object3).equalsIgnoreCase("yes") || ((String)object3).equalsIgnoreCase("true"));
                String string5 = "uname -L";
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getExecOutputLines(string5);
                if (arrayList != null && arrayList.size() >= 2 && (arrayList = (ArrayList)arrayList.get(0)) != null && arrayList.size() > 0 && (string4 = (String)arrayList.get(0)) != null && string4.length() > 0) {
                    this.isLpar = string4.indexOf("-1") <= -1 || string4.indexOf("NULL") <= -1;
                }
                this.firstTime = false;
            }
            if (this.aixUsePs || this.usePs) {
                this.isLpar = false;
            }
            if (this.isLpar) {
                object = new GetTprof();
                object3 = object.runTprof();
                hashtable = (Hashtable)((Hashtable)object3).get("tprof");
            }
        }
        if (this.isLpar && hashtable != null) {
            try {
                if (string != null && (d = (Double)hashtable.get(string)) == null) {
                    d = new Double(0.0);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while getting CPU Usage in LAPR ");
                exception.printStackTrace();
            }
        }
        return d;
    }

    private boolean isJava6() {
        boolean bl;
        block11: {
            bl = false;
            try {
                int n;
                RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
                Map<String, String> map = runtimeMXBean.getSystemProperties();
                boolean bl2 = this.isSAPorJRockitJVM(map);
                if (bl2) {
                    return true;
                }
                String string = "java.version";
                String string2 = map.get(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                int n2 = stringTokenizer.countTokens();
                if (n2 < 1) break block11;
                String string3 = stringTokenizer.nextToken();
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(string3);
                    if (n3 >= 9) {
                        bl = true;
                        this.isOracleHotSpotVersion9 = true;
                        return bl;
                    }
                }
                catch (Exception exception) {
                    try {
                        String string4;
                        n = string3.indexOf("-");
                        if (n > 0 && (n3 = Integer.parseInt(string4 = string3.substring(0, n))) >= 9) {
                            bl = true;
                            this.isOracleHotSpotVersion9 = true;
                            return bl;
                        }
                    }
                    catch (Exception exception2) {
                        System.out.println("Unable to find the JDK / JRE Version from " + string2);
                        exception2.printStackTrace();
                    }
                }
                if (n2 > 1 && n3 > 0) {
                    String string5 = stringTokenizer.nextToken();
                    n = Integer.parseInt(string5);
                    if (n3 >= 1 && n > 5) {
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isSAPorJRockitJVM(Map map) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (map != null) {
            String string = (String)map.get("java.vm.name");
            String string2 = (String)map.get("java.version");
            if (string != null) {
                if ((string = string.toLowerCase()).indexOf("jrockit") > -1) {
                    bl2 = true;
                } else if (string.indexOf("sap") > -1) {
                    bl2 = true;
                    bl3 = true;
                }
            }
            if (bl2) {
                StringTokenizer stringTokenizer;
                int n;
                this.isSap6orJrockitVersionb37 = false;
                if (string2 != null && string2.length() > 0 && (n = (stringTokenizer = new StringTokenizer(string2, ".")).countTokens()) >= 2) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(string4);
                    if (n2 == 6) {
                        if (bl3) {
                            this.isSap6orJrockitVersionb37 = true;
                            bl = true;
                            return bl;
                        }
                        if (n >= 3) {
                            String string5 = stringTokenizer.nextToken();
                            int n3 = string5.indexOf("_");
                            if (n3 > 0) {
                                int n4;
                                String string6 = string5.substring(n3 + 1);
                                if (string6 != null && string6.length() > 0 && (n4 = Integer.parseInt(string6 = string6.trim())) < 37) {
                                    this.isSap6orJrockitVersionb37 = true;
                                    bl = true;
                                }
                            } else {
                                this.isSap6orJrockitVersionb37 = true;
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    private boolean isAgentJRE6() {
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        boolean bl = false;
        if (n >= 1) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string2);
                if (n3 >= 9) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                try {
                    String string3;
                    n2 = string2.indexOf("-");
                    if (n2 > 0 && (n3 = Integer.parseInt(string3 = string2.substring(0, n2))) >= 9) {
                        bl = true;
                    }
                }
                catch (Exception exception2) {
                    System.out.println("Unable to find the JDK / JRE Version from " + string);
                    exception2.printStackTrace();
                }
            }
            if (n > 1 && n3 > 0) {
                String string4 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string4);
                if (n3 >= 1 && n2 > 5) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static String formatValue(String string) {
        String string2 = "";
        try {
            String string3 = null;
            if (string != null && string.length() > 0) {
                string3 = string.toLowerCase().trim();
            }
            if (string3 != null && string3.indexOf("e") > -1) {
                string2 = string;
            } else {
                BigDecimal bigDecimal = new BigDecimal(string);
                string2 = decimalFormat.format(bigDecimal);
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    protected static String formatValue(double d) {
        String string = "";
        try {
            string = decimalFormat.format(d);
        }
        catch (Exception exception) {
            string = d + "";
        }
        return string;
    }

    public Hashtable getJiraJMXEntityMetrics(String string) {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        String[] stringArray = new String[]{"Value"};
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName(string), null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = ((Object)iterator.next()).toString();
                int n = string2.indexOf("=");
                if (n == -1) continue;
                String string3 = string2.substring(n + 1);
                ObjectName objectName = null;
                MBeanInfo mBeanInfo = null;
                try {
                    objectName = new ObjectName(string2);
                    mBeanInfo = this.beanServerConn.getMBeanInfo(objectName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (mBeanInfo == null) continue;
                Long l = (Long)this.beanServerConn.getAttribute(objectName, "Value");
                hashtable.put(string3, l);
            }
            return hashtable;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return hashtable;
        }
    }

    public Hashtable confluenceContainerMetrics(String string) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = objectName.toString();
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.beanServerConn.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("No such instance for the ObjectName " + string2);
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (mBeanInfo == null) {
            return hashtable;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        String string3 = "";
        Object object = "";
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            block13: {
                try {
                    string3 = mBeanAttributeInfoArray[i].getName();
                    if (string3 != null && !string3.equalsIgnoreCase("")) {
                        object = this.beanServerConn.getAttribute(objectName, string3);
                    }
                    if (string3 == null || object == null || string3.equalsIgnoreCase("")) continue;
                    if (object.equals("")) {
                    }
                    break block13;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            hashtable.put(string3, object);
        }
        return hashtable;
    }

    public Hashtable confluenceMailServerMetrics() {
        Hashtable hashtable = new Hashtable();
        if (this.beanServerConn == null) {
            return hashtable;
        }
        String[] stringArray = new String[]{"EmailsAttempted", "EmailsSent"};
        String string = "Confluence:name=MailServer*";
        try {
            Set<ObjectName> set = this.beanServerConn.queryNames(new ObjectName(string), null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = ((Object)iterator.next()).toString();
                int n = string2.indexOf("=");
                if (n == -1) continue;
                String string3 = string2.substring(n + 1);
                ObjectName objectName = null;
                MBeanInfo mBeanInfo = null;
                try {
                    objectName = new ObjectName(string2);
                    mBeanInfo = this.beanServerConn.getMBeanInfo(objectName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (mBeanInfo == null) continue;
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4 = stringArray[i];
                        Integer n2 = (Integer)this.beanServerConn.getAttribute(objectName, string4);
                        if (n2 == null) continue;
                        hashtable2.put(string4, n2);
                    }
                }
                hashtable.put(string3, hashtable2);
            }
            return hashtable;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("No such instance for the ObjectName " + string);
            return hashtable;
        }
        catch (Exception exception) {
            return hashtable;
        }
    }

    public String confluenceDatabaseLatency(String string) {
        ObjectName objectName = null;
        String string2 = "";
        try {
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        String string3 = objectName.toString();
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.beanServerConn.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("No such instance for the ObjectName " + string);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (mBeanInfo == null) {
            return string2;
        }
        try {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
                String string4 = "DatabaseExampleLatency";
                Long l = (Long)this.beanServerConn.getAttribute(objectName, string4);
                string2 = l.toString();
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String measureComputationGC(long l, long l2, String string, String string2, StringBuffer stringBuffer, long l3, boolean bl) {
        String string3 = null;
        try {
            long l4 = 0L;
            long l5 = 0L;
            double d = 0.0;
            double d2 = 0.0;
            long l6 = 0L;
            long l7 = 0L;
            if (string2 != null && string2.length() > 0) {
                try {
                    String string4;
                    if (string2.indexOf(HASH) > -1 && (string4 = string2.substring(string2.indexOf(HASH) + 1)) != null && string4.length() > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, "~");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            if (!string5.substring(0, string5.indexOf("|")).equals(string)) continue;
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ":");
                            String string6 = stringTokenizer2.nextToken();
                            string6 = string6.substring(string6.indexOf("|") + 1);
                            l4 = Long.parseLong(string6);
                            l6 = Long.parseLong(stringTokenizer2.nextToken());
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (l < l4) {
                l5 = l;
            } else {
                l5 = l - l4;
                d = l5 > 0L ? (double)l5 / 1000.0 : (double)l5;
            }
            d2 = l3 <= 0L ? 0.0 : (double)l5 / (double)l3 * 100.0;
            if (d2 > 100.0) {
                d2 = 100.0;
            }
            l7 = l6 > l2 ? l2 : l2 - l6;
            if (stringBuffer != null && stringBuffer.length() > 0) {
                if (bl) {
                    stringBuffer.append(string);
                    stringBuffer.append("|");
                    stringBuffer.append(l);
                    stringBuffer.append(":");
                    stringBuffer.append(l2);
                } else {
                    stringBuffer.append(HASH);
                    stringBuffer.append(string);
                    stringBuffer.append("|");
                    stringBuffer.append(l);
                    stringBuffer.append(":");
                    stringBuffer.append(l2);
                }
            }
            this.setCurrentValue(stringBuffer.toString());
            string3 = string + HASH + l7 + HASH + d + HASH + d2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    protected ArrayList getJarModeData() {
        ArrayList arrayList = JVMDataRepository.getData(this.jvmGUID, this.entity);
        return arrayList;
    }

    protected void clearJarModeData() {
        JVMDataRepository.clearData(this.jvmGUID);
    }

    protected ArrayList compositeResultList(Object object) {
        CompositeData compositeData = (CompositeData)object;
        ArrayList arrayList = this.compositeResult(compositeData);
        return arrayList;
    }

    public Hashtable pullFullGCNotification() {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        String string = this.reportingName + ":" + this.portNo;
        Object var3_3 = null;
        try {
            Object object;
            String string2 = this.getPID();
            ListenerThread listenerThread = null;
            if (this.firstGCNotificationRun || !string2.equals(this.pid4GCNotification)) {
                try {
                    listenerThread = (ListenerThread)GCNotificationListenerTable.get(string);
                    if (listenerThread != null) {
                        if (this.firstGCNotificationRun) {
                            listenerThread.removeExistingNotification();
                        }
                        JVMGCDataRepository.removeGCNotificationDatas(string);
                        listenerThread = null;
                    }
                    if (!(listenerThread = new ListenerThread(string, this.beanServerConn, this.measurePeriod)).isListenerFaildToAttach()) {
                        object = new Thread(listenerThread);
                        ((Thread)object).setName("eG GC_Attach Listener");
                        ((Thread)object).setDaemon(true);
                        ((Thread)object).start();
                        this.pid4GCNotification = string2;
                        this.firstGCNotificationRun = false;
                        GCNotificationListenerTable.put(string, listenerThread);
                        this.jvmGCNotificationClosed = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.jvmGCNotificationClosed = true;
            }
            if ((object = JVMGCDataRepository.JVMGetRepository(string)) != null && ((ArrayList)object).size() > 0) {
                hashtable.put("gcResult", (ArrayList)object);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception has been occured while attaching the listener in JVMnstrumentation" + exception.getMessage());
        }
        return hashtable;
    }

    public boolean isGCNotificationJMXConnectionClose() {
        return this.jvmGCNotificationClosed;
    }

    public static ListenerThread getGCNotificationListenerTable(String string) {
        return (ListenerThread)GCNotificationListenerTable.get(string);
    }

    private void findServerType() {
        this.componentType = this.getValueForParam("serverType");
        String string = this.getValueForParam("trgtHost");
        if (this.componentType == null) {
            this.componentType = "Not_Found";
            JavaBTMLogger.btmLogger.debug(this.loggerDispStr + " Could not find the server type for " + string + ":" + this.portNo + ", " + this.entity);
        } else {
            JavaBTMLogger.btmLogger.debug(this.loggerDispStr + " Found server type as " + this.componentType + " for " + string + ":" + this.portNo + ", " + this.entity);
        }
    }

    protected double getJvmCpuPercentage(double d, long l, boolean bl, long l2, long l3, int n, StringBuilder stringBuilder) {
        double d2 = 0.0;
        if (this.beanServerConn == null) {
            d2 = -5.0;
            return d2;
        }
        try {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            long l4 = 0L;
            boolean bl2 = this.beanServerConn.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean");
            boolean bl3 = this.beanServerConn.isInstanceOf(objectName, "com.sun.management.OperatingSystemMXBean");
            if (this.targetJVMOsName.equalsIgnoreCase("aix") && bl2 && bl && d >= 0.0) {
                return d;
            }
            if (bl3 || bl2) {
                l4 = (Long)this.beanServerConn.getAttribute(objectName, "ProcessCpuTime");
            }
            stringBuilder.append("$$").append(l4);
            double[] dArray = this.getThreadCpuPercent(l4, l, bl, l2, l3, n, 0.0);
            d2 = Math.min(99.9, dArray[0]);
        }
        catch (Exception exception) {
            d2 = -5.0;
            return d2;
        }
        return d2;
    }

    protected ArrayList getThreadPatterns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && !string.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private boolean patternMatch(String string, String string2) {
        if (string2.equals("*")) {
            return true;
        }
        int n = string2.indexOf("*");
        if (n < 0) {
            return string.equalsIgnoreCase(string2);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n2;
            StringTokenizer stringTokenizer;
            int n3;
            if (!string2.startsWith("*")) {
                bl2 = true;
            }
            if (!string2.endsWith("*")) {
                bl3 = true;
            }
            if ((n3 = (stringTokenizer = new StringTokenizer(string2, "*")).countTokens()) <= 0) {
                return false;
            }
            String string3 = new String(string);
            String[] stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = stringTokenizer.nextToken();
            }
            n2 = 0;
            if (bl2 && !string3.startsWith(stringArray[0])) {
                return false;
            }
            if (bl3 && !string3.endsWith(stringArray[n3 - 1])) {
                return false;
            }
            String string4 = null;
            for (int i = 0; i < n3; ++i) {
                string4 = stringArray[i];
                n2 = string3.indexOf(string4);
                if (n2 == -1) {
                    return false;
                }
                bl = true;
                string3 = new String(string3.substring(n2 += string4.length()));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occurred while matching the string patterns");
        }
        return bl;
    }

    protected double[] getThreadCpuPercent(long l, long l2, boolean bl, long l3, long l4, int n, double d) {
        double d2 = 0.0;
        long l5 = 0L;
        if (l < l2) {
            l5 = l;
            if (bl) {
                d2 = 0.0;
            }
        } else {
            l5 = l - l2;
            if (bl) {
                d2 = d * ((double)l5 / (double)l3);
            }
        }
        if (!bl) {
            if (l4 <= 0L) {
                d2 = 0.0;
            } else {
                d2 = (double)l5 / (double)l4 / 10000.0;
                if (n > 1) {
                    d2 /= (double)n;
                }
            }
        }
        if (d2 > 100.0) {
            d2 = 100.0;
        }
        double[] dArray = new double[]{d2, l5};
        return dArray;
    }

    protected int getThreadCategory(String string) {
        int n;
        int n2;
        Integer n3 = this.threadWeakHashMap.get(string);
        if (n3 != null) {
            return n3;
        }
        int n4 = 0;
        int n5 = this.webPatternList.size();
        if (n5 > 0) {
            for (n2 = 0; n2 < n5; ++n2) {
                n = this.patternMatch(string, (String)this.webPatternList.get(n2)) ? 1 : 0;
                if (n == 0) continue;
                n4 = 1;
                break;
            }
        }
        if ((n2 = this.threadWeakHashMap.size()) >= 2000) {
            this.threadWeakHashMap.clear();
            this.threadWeakHashMap = new WeakHashMap<String, Integer>(2000);
        }
        if (n4 > 0) {
            this.threadWeakHashMap.put(string, n4);
            return n4;
        }
        n = this.rmiPatternList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                boolean bl = this.patternMatch(string, (String)this.rmiPatternList.get(i));
                if (!bl) continue;
                n4 = 2;
                break;
            }
        }
        this.threadWeakHashMap.put(string, n4);
        return n4;
    }
}

