/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class IsiCluCapactyTest
extends EgSnmpGenericTest {
    boolean isFirst = true;
    double ByteToGB = 1.073741824E9;

    public IsiCluCapactyTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d;
            double d2 = this.getMeasure(".1.3.6.1.4.1.12124.1.3.1.0");
            double d3 = this.getMeasure(".1.3.6.1.4.1.12124.1.3.2.0");
            double d4 = this.getMeasure(".1.3.6.1.4.1.12124.1.3.4.0");
            double d5 = -5.0;
            double d6 = -5.0;
            double d7 = -5.0;
            double d8 = -5.0;
            double d9 = -5.0;
            double d10 = -5.0;
            double d11 = -5.0;
            double d12 = -5.0;
            if (d2 >= 0.0) {
                d5 = d2 / this.ByteToGB;
            }
            if (d5 >= 0.0) {
                d = d5 / 1024.0;
                d10 = this.removeExpAndRound(d);
            }
            if (d3 >= 0.0) {
                d6 = d3 / this.ByteToGB;
            }
            if (d6 >= 0.0) {
                d = d6 / 1024.0;
                d11 = this.removeExpAndRound(d);
            }
            if (d4 >= 0.0) {
                d7 = d4 / this.ByteToGB;
            }
            if (d7 >= 0.0) {
                d = d7 / 1024.0;
                d12 = this.removeExpAndRound(d);
            }
            if (d5 >= 0.0 && d6 > 0.0) {
                d8 = d6 / d5 * 100.0;
            }
            if (d8 >= 0.0) {
                d8 = this.removeExpAndRound(d8);
            }
            if (d5 >= 0.0 && d7 >= 0.0) {
                d9 = d7 / d5 * 100.0;
            }
            if (d9 >= 0.0) {
                d9 = this.removeExpAndRound(d9);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d10));
            arrayList.add(new Double(d11));
            arrayList.add(new Double(d12));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d9));
            System.out.println(this.entity + " MeasureList ==> " + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.rhs[i].trim();
                    d = string2 != null && string2.length() > 0 ? Double.parseDouble(string2) : -5.0;
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "IsiCluCapactyTest Exception occured in getMeasure() for ", this.targetHost);
            d = -5.0;
        }
        return d;
    }

    private double removeExpAndRound(double d) {
        String string = "0.0";
        double d2 = 0.0;
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            double d3 = bigDecimal.doubleValue();
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            try {
                string = decimalFormat.format(d3).toString();
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                string = "0.0";
                d2 = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            string = "0.0";
            d2 = Double.parseDouble(string);
            return d2;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        IsiCluCapactyTest isiCluCapactyTest = new IsiCluCapactyTest(stringArray);
        isiCluCapactyTest.computeMeasures(new Hashtable());
    }
}

