/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class IIBStatisticsAccountingParserHandler
extends DefaultHandler {
    private boolean insideDebug = false;
    Hashtable messageFlowHashtable = new Hashtable();
    ArrayList msgArrayList = new ArrayList();
    Hashtable threadsHashtable = new Hashtable();
    ArrayList threadsArrayList = new ArrayList();
    Hashtable nodeHashtable = new Hashtable();
    ArrayList nodeArrayList = new ArrayList();
    Hashtable intervalHashtable = new Hashtable();
    ArrayList intervalArrayList = new ArrayList();
    long statsInterval = 0L;
    String executionGroupName = null;
    String messageFlowName = null;
    String threadNumber = null;
    String nodeLabel = null;
    Hashtable allHastable = new Hashtable();

    IIBStatisticsAccountingParserHandler() {
    }

    public void startDocument() throws SAXException {
        if (this.insideDebug) {
            System.out.println("start of the document   : ");
        }
    }

    public void endDocument() throws SAXException {
        if (this.insideDebug) {
            System.out.println("end of the document document     : ");
        }
    }

    public void startElement(String uri2, String localName, String qName, Attributes attrs) throws SAXException {
        String value = "";
        if (qName.equalsIgnoreCase("WMQIStatisticsAccounting")) {
            this.messageFlowHashtable = new Hashtable();
            this.executionGroupName = "";
            this.intervalHashtable = new Hashtable();
        }
        if (qName.equalsIgnoreCase("Threads")) {
            this.threadsHashtable = new Hashtable();
        }
        if (qName.equalsIgnoreCase("Nodes")) {
            this.nodeHashtable = new Hashtable();
        }
        if (qName.equalsIgnoreCase("MessageFlow")) {
            this.msgArrayList = new ArrayList();
            if (this.insideDebug) {
                System.out.println("Start Element qName   :" + qName);
            }
            this.executionGroupName = attrs.getValue("ExecutionGroupName");
            this.messageFlowName = attrs.getValue("MessageFlowName");
            String endDate = attrs.getValue("EndDate");
            String endTime = attrs.getValue("EndTime");
            String startDate = attrs.getValue("StartDate");
            String startTime = attrs.getValue("StartTime");
            this.statsInterval = this.convertingTimeStamp(startDate, startTime, endDate, endTime);
            value = attrs.getValue("TotalElapsedTime");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("MaximumElapsedTime");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalCPUTime");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("MaximumCPUTime");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalInputMessages");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalSizeOfInputMessages");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TimesMaximumNumberOfThreadsReached");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfMQErrors");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfMessagesWithErrors");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfErrorsProcessingMessages");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfCommits");
            this.msgArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfBackouts");
            this.msgArrayList.add(new Double(value));
        }
        if (qName.equalsIgnoreCase("ThreadStatistics")) {
            this.threadsArrayList = new ArrayList();
            this.threadNumber = attrs.getValue("Number");
            value = attrs.getValue("TotalElapsedTime");
            this.threadsArrayList.add(new Double(value));
            value = attrs.getValue("TotalCPUTime");
            this.threadsArrayList.add(new Double(value));
            value = attrs.getValue("TotalNumberOfInputMessages");
            this.threadsArrayList.add(new Double(value));
            value = attrs.getValue("TotalSizeOfInputMessages");
            this.threadsArrayList.add(new Double(value));
        }
        if (qName.equalsIgnoreCase("NodeStatistics")) {
            this.nodeArrayList = new ArrayList();
            if (this.insideDebug) {
                System.out.println("Start Element qName   :" + qName);
            }
            this.nodeLabel = attrs.getValue("Label");
            value = attrs.getValue("TotalElapsedTime");
            this.nodeArrayList.add(new Double(value));
            value = attrs.getValue("MaximumElapsedTime");
            this.nodeArrayList.add(new Double(value));
            value = attrs.getValue("TotalCPUTime");
            this.nodeArrayList.add(new Double(value));
            value = attrs.getValue("MaximumCPUTime");
            this.nodeArrayList.add(new Double(value));
            value = attrs.getValue("CountOfInvocations");
            this.nodeArrayList.add(new Double(value));
        }
    }

    public void endElement(String uri2, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("MessageFlow")) {
            this.messageFlowHashtable.put(String.valueOf(this.executionGroupName) + "/" + this.messageFlowName, this.msgArrayList);
            if (this.insideDebug) {
                System.out.println("End Element messageFlowHashtable  :" + this.messageFlowHashtable);
            }
            String flow = String.valueOf(this.executionGroupName) + "/" + this.messageFlowName;
            this.intervalArrayList = new ArrayList();
            this.intervalArrayList.add(new Double(this.statsInterval));
            this.intervalHashtable.put(flow, this.intervalArrayList);
        }
        if (qName.equalsIgnoreCase("ThreadStatistics")) {
            this.threadsHashtable.put(String.valueOf(this.executionGroupName) + "/" + this.messageFlowName + ":" + this.threadNumber, this.threadsArrayList);
            if (this.insideDebug) {
                System.out.println("End Element threadsHashtable  :" + this.threadsHashtable);
            }
        }
        if (qName.equalsIgnoreCase("NodeStatistics")) {
            this.nodeHashtable.put(String.valueOf(this.executionGroupName) + "/" + this.messageFlowName + ":" + this.nodeLabel, this.nodeArrayList);
            if (this.insideDebug) {
                System.out.println("End Element nodeHashtable  :" + this.nodeHashtable);
            }
        }
        if (qName.equalsIgnoreCase("WMQIStatisticsAccounting")) {
            this.allHastable.put("MSG", this.messageFlowHashtable);
            this.allHastable.put("THREAD", this.threadsHashtable);
            this.allHastable.put("NODE", this.nodeHashtable);
            this.allHastable.put("INTERVAL", this.intervalHashtable);
            if (this.insideDebug) {
                System.out.println("End Element messageFlowHashtable  :" + this.messageFlowHashtable);
                System.out.println("End Element threadsHashtable  :" + this.threadsHashtable);
                System.out.println("End Element nodeHashtable  :" + this.nodeHashtable);
                System.out.println("End Element intervalHashtable  :" + this.intervalHashtable);
            }
        }
    }

    public Hashtable getAllDataHashtable() {
        return this.allHastable;
    }

    protected long convertingTimeStamp(String startDate, String startTime, String endDate, String endTime) {
        if (startTime.lastIndexOf(".") > -1) {
            startTime = startTime.substring(0, startTime.lastIndexOf("."));
        }
        if (endTime.lastIndexOf(".") > -1) {
            endTime = endTime.substring(0, endTime.lastIndexOf("."));
        }
        String startDateString = String.valueOf(startDate) + " " + startTime;
        String endDateString = String.valueOf(endDate) + " " + endTime;
        long startDateTimeInMilliSeconds = this.timeStampToMillsecond(startDateString);
        long endDateTimeInMilliSeconds = this.timeStampToMillsecond(endDateString);
        long statisticsInterval = endDateTimeInMilliSeconds - startDateTimeInMilliSeconds;
        if (statisticsInterval > 0L) {
            statisticsInterval /= 1000L;
        }
        return statisticsInterval;
    }

    protected long timeStampToMillsecond(String timeStamp) {
        String IBM_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timeInMillis = 0L;
        try {
            Date startDate = originalFormat.parse(timeStamp);
            timeInMillis = startDate.getTime();
        }
        catch (Exception ex) {
            System.out.println("Error  in timeStampToMillsecond()  :" + ex.getMessage().toString());
        }
        return timeInMillis;
    }
}

