/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBNodeStTest
extends IIBStatisticsAccountingBase {
    private static final int NODE_STAT_MEASURE_COUNT = 5;

    public IIBNodeStTest(String[] args) {
        super(args);
        this.setMeasureCount(5);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("NODE_STATS");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Hashtable intervalData = this.getData("INTERVAL_VALUE");
        Enumeration enu = data.keys();
        double totalElapsedTime = 0.0;
        double maximumElapsedTime = 0.0;
        double totalCPUTime = 0.0;
        double maximumCPUTime = 0.0;
        double countOfInvocations = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            String intervalDataKey = null;
            double measPeriod = 1.0;
            if (key != null && key.trim().length() > 0) {
                if (key.indexOf("/") > -1) {
                    Enumeration enu1 = intervalData.keys();
                    while (enu1.hasMoreElements()) {
                        String key1;
                        String tempKey = key1 = (String)enu1.nextElement();
                        if (key1.indexOf("/") > -1) {
                            key1 = key1.substring(0, key1.indexOf("/"));
                        } else {
                            measPeriod = this.timeSinceLastTest;
                        }
                        String key2 = key.substring(0, key.indexOf("/"));
                        if (!key2.equals(key1)) continue;
                        intervalDataKey = tempKey;
                    }
                    this.printOut("intervalDataKey  :" + intervalDataKey);
                    ArrayList intervalArrayList = (ArrayList)intervalData.get(intervalDataKey);
                    measPeriod = (Double)intervalArrayList.get(0);
                    this.printOut("Execution group name :" + intervalDataKey + "  statistic collection time " + measPeriod);
                } else {
                    measPeriod = this.timeSinceLastTest;
                    this.printOut("Execution group name not found for this  " + intervalDataKey + "  statistic collection time is assigned time since last measure period value ");
                }
            }
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            totalElapsedTime = (Double)tempArrayList.get(0);
            maximumElapsedTime = (Double)tempArrayList.get(1);
            totalCPUTime = (Double)tempArrayList.get(2);
            maximumCPUTime = (Double)tempArrayList.get(3);
            countOfInvocations = (Double)tempArrayList.get(4);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            if (countOfInvocations > 0.0) {
                this.printOut("DEEP DEBUGS :Node name :" + key + " CountofInvocations  " + countOfInvocations);
                double avgElapsedTime = (totalElapsedTime /= 1000000.0) / countOfInvocations;
                double maxElapsedTime = (maximumElapsedTime /= 1000000.0) / countOfInvocations;
                double avgCPUTime = (totalCPUTime /= 1000000.0) / countOfInvocations;
                double maxCpuTime = (maximumCPUTime /= 1000000.0) / countOfInvocations;
                if (EgTest.debug) {
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average ElapsedTime(" + avgElapsedTime + ")is derived from totalElapsedTime(" + totalElapsedTime + ") / countOfInvocations(" + countOfInvocations + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Maximum ElapsedTime(" + maxElapsedTime + ")is derived from maximumElapsedTime(" + maximumElapsedTime + ") / countOfInvocations(" + countOfInvocations + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average CPUTime(" + avgCPUTime + ")is derived from totalCPUTime(" + totalCPUTime + ") / countOfInvocations(" + countOfInvocations + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Maximum CPU Time(" + maxCpuTime + ")is derived from maximumCPUTime(" + maximumCPUTime + ") / countOfInvocations(" + countOfInvocations + ")");
                }
                measureArrayList.add(new Double(avgElapsedTime));
                measureArrayList.add(new Double(maxElapsedTime));
                measureArrayList.add(new Double(avgCPUTime));
                measureArrayList.add(new Double(maxCpuTime));
            } else {
                this.printOut("DEEP DEBUGS :Node name :" + key + " CountofInvocations  is zero ,So assinging default values  ");
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
            }
            if (measPeriod > 0.0) {
                double invocationRate = countOfInvocations / measPeriod;
                this.printOut("DEEP DEBUGS :Node name :" + key + " Invocation Rate(" + invocationRate + ")is derived from countOfInvocations(" + countOfInvocations + ") / Statisics interval(" + measPeriod + ")");
                measureArrayList.add(new Double(invocationRate));
            } else {
                measureArrayList.add(new Double(0.0));
            }
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBNodeStTest obj = new IIBNodeStTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

