/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBJMSStatTest
extends IIBResourceStatisticsBase {
    private static final int JMS_STAT_MEASURE_COUNT = 6;
    public Hashtable prevhash = new Hashtable();

    public IIBJMSStatTest(String[] args) {
        super(args);
        this.setMeasureCount(6);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable currHashtable = new Hashtable();
        currHashtable = this.getData("JMS");
        if (currHashtable == null || currHashtable.size() == 0 || currHashtable.isEmpty()) {
            return;
        }
        if (currHashtable != null) {
            Enumeration en = currHashtable.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (this.prevhash != null && this.prevhash.size() > 0) {
                    ArrayList prevlist = (ArrayList)this.prevhash.get(key);
                    ArrayList currentlist = (ArrayList)currHashtable.get(key);
                    if (prevlist == null || currentlist == null) continue;
                    double openConnections = (Double)currentlist.get(0);
                    double openSessions = (Double)currentlist.get(2);
                    double messagesReceived = (Double)currentlist.get(4);
                    double messagesSent = (Double)currentlist.get(5);
                    double messageBrowsed = (Double)currentlist.get(6);
                    double currClosedConnections = (Double)currentlist.get(1);
                    double currClosedSessions = (Double)currentlist.get(3);
                    double currConnectionFailures = (Double)currentlist.get(7);
                    double prevClosedConnections = (Double)prevlist.get(1);
                    double prevClosedSessions = (Double)prevlist.get(3);
                    double prevConnectionFailures = (Double)prevlist.get(7);
                    double closedConnections = currClosedConnections - prevClosedConnections;
                    double closedSessions = currClosedSessions - prevClosedSessions;
                    double connectionFailures = currConnectionFailures - prevConnectionFailures;
                    double messageReceivedRate = 0.0;
                    double messageSentRate = 0.0;
                    double messageBrowsedRate = 0.0;
                    if (this.timeSinceLastTest > 0.0) {
                        messageReceivedRate = messagesReceived / this.timeSinceLastTest;
                        messageSentRate = messagesSent / this.timeSinceLastTest;
                        messageBrowsedRate = messageBrowsed / this.timeSinceLastTest;
                    } else {
                        messageReceivedRate = -5.0;
                        messageSentRate = -5.0;
                        messageBrowsedRate = -5.0;
                    }
                    if (EgTest.debug) {
                        this.printOut(" openConnections ======>" + openConnections);
                        this.printOut(" closedConnections ======>" + closedConnections);
                        this.printOut(" openSessions ======>" + openSessions);
                        this.printOut(" closedSessions ======>" + closedSessions);
                        this.printOut(" messageReceivedRate ======>" + messageReceivedRate);
                        this.printOut(" messageSentRate =====>" + messageSentRate);
                        this.printOut(" messageBrowsedRate ======>" + messageBrowsedRate);
                        this.printOut(" connectionFailures ======>" + connectionFailures);
                    }
                    ArrayList<Double> measurelist = new ArrayList<Double>();
                    measurelist.add(new Double(openConnections));
                    measurelist.add(new Double(openSessions));
                    measurelist.add(new Double(messageReceivedRate));
                    measurelist.add(new Double(messageSentRate));
                    measurelist.add(new Double(messageBrowsedRate));
                    measurelist.add(new Double(connectionFailures));
                    if (EgTest.debug) {
                        this.printOut(" key1====>" + key + " value1===>" + measurelist);
                    }
                    this.addNewMeasure(key, measurelist);
                    continue;
                }
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                if (EgTest.debug) {
                    this.printOut("NotAvaliablevalue key==>" + key + " value===>" + al);
                }
                this.addNewMeasure(key, al);
            }
            this.prevhash = currHashtable;
            if (EgTest.debug) {
                this.printOut(" previoushash======>" + this.prevhash);
            }
        }
    }

    public static void main(String[] args) {
        IIBJMSStatTest obj = new IIBJMSStatTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

