/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class IBMDb2ConnTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String dbName;

    public static void main(String[] stringArray) {
        new IBMDb2ConnTest(stringArray).computeMeasures(null);
    }

    public IBMDb2ConnTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getConnectionsStats();
        if (arrayList != null) {
            this.addNewMeasure(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConnectionsStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Double> arrayList = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbmSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT LOCAL_CONS,REM_CONS_IN,LOCAL_CONS_IN_EXEC,REM_CONS_IN_EXEC FROM table(" + string + ") DBM";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                d = resultSet.getDouble("LOCAL_CONS");
                d2 = resultSet.getDouble("REM_CONS_IN");
                d3 = resultSet.getDouble("LOCAL_CONS_IN_EXEC");
                d4 = resultSet.getDouble("REM_CONS_IN_EXEC");
                d5 = d + d2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        arrayList = new ArrayList<Double>(5);
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        return arrayList;
    }
}

