/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class HwDriveTest
extends EgSnmpGenericTest {
    private boolean isDell = false;
    private boolean isCpq = true;
    private static int numMeasures = 2;
    private static String logStatusOid = ".1.3.6.1.4.1.232.3.2.3.1.1.4";
    private static String phyStatusOid = ".1.3.6.1.4.1.232.3.2.5.1.1.6";
    private static String logCondOid = ".1.3.6.1.4.1.232.3.2.3.1.1.11";
    private static String phyCondOid = ".1.3.6.1.4.1.232.3.2.5.1.1.37";
    private static String logicalName = ".1.3.6.1.4.1.232.3.2.3.1.1.14";
    private static String physSerialNum = ".1.3.6.1.4.1.232.3.2.5.1.1.51";
    private static String physDriveName = ".1.3.6.1.4.1.232.3.2.5.1.1.64";

    public HwDriveTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private void discover() {
    }

    private double getCpqValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return 1.0;
        }
        if (d == 3.0) {
            return 2.0;
        }
        return 3.0;
    }

    private double getCpqStatusValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = true;
        if (!this.isDell && !this.isCpq) {
            bl = false;
        }
        if (this.isDell || !bl) {
            this.runDellStatusTest();
        }
        if (!this.isDell && this.isCpq || !bl) {
            this.runCpqStatusTest();
        }
    }

    private void runCpqStatusTest() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (this.runSnmpCmdForOid(logCondOid)) {
            String string;
            ArrayList<Double> arrayList;
            Double d;
            Double d2;
            String string2;
            int n;
            int n2;
            Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
            Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
            Hashtable<String, Double> hashtable5 = new Hashtable<String, Double>();
            Hashtable<String, Double> hashtable6 = new Hashtable<String, Double>();
            if (this.lhs != null) {
                this.isCpq = true;
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable5.put(this.lhs[n2], new Double(this.getCpqValue(n2)));
                }
            }
            if (this.runSnmpCmdForOid(phyCondOid) && this.lhs != null) {
                this.isCpq = true;
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable6.put(this.lhs[n2], new Double(this.getCpqValue(n2)));
                }
            }
            if (this.runSnmpCmdForOid(phyStatusOid) && this.lhs != null) {
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable4.put(this.lhs[n2], new Double(this.getCpqStatusValue(n2)));
                }
            }
            if (this.runSnmpCmdForOid(logStatusOid) && this.lhs != null) {
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable3.put(this.lhs[n2], new Double(this.getCpqStatusValue(n2)));
                }
            }
            if (this.runSnmpCmdForOid(logicalName) && this.lhs != null) {
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable.put(this.lhs[n2], this.rhs[n2]);
                }
            }
            n2 = 0;
            if (this.runSnmpCmdForOid(physDriveName) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    n2 = 1;
                    hashtable2.put(this.lhs[n], this.rhs[n]);
                }
            }
            if (n2 == 0 && this.runSnmpCmdForOid(physSerialNum) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable2.put(this.lhs[n], this.rhs[n]);
                }
            }
            Enumeration enumeration = hashtable5.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                d2 = (Double)hashtable5.get(string2);
                d = (Double)hashtable3.get(string2);
                if (d2 == null) {
                    d2 = new Double(-5.0);
                }
                if (d == null) {
                    d = new Double(-5.0);
                }
                arrayList = new ArrayList<Double>();
                arrayList.add(d2);
                arrayList.add(d);
                string = (String)hashtable.get(string2);
                if (string != null && string.trim().length() > 0) {
                    string2 = string;
                }
                this.addNewMeasure("Logical_" + string2, arrayList);
            }
            enumeration = hashtable6.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                d2 = (Double)hashtable6.get(string2);
                d = (Double)hashtable4.get(string2);
                if (d2 == null) {
                    d2 = new Double(-5.0);
                }
                if (d == null) {
                    d = new Double(-5.0);
                }
                arrayList = new ArrayList();
                arrayList.add(d2);
                arrayList.add(d);
                string = (String)hashtable2.get(string2);
                if (string != null && string.trim().length() > 0) {
                    string2 = string;
                }
                this.addNewMeasure("Physical_" + string2, arrayList);
            }
        } else {
            this.isCpq = false;
        }
    }

    private void runDellStatusTest() {
    }
}

