/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HostProcessTest
extends EgSnmpGenericTest {
    private static String processOid = ".1.3.6.1.2.1.25.4.2.1.2";
    private static String processPathOid = ".1.3.6.1.2.1.25.4.2.1.4";
    private static String cpuOid = ".1.3.6.1.2.1.25.5.1.1.1";
    private static String memOid = ".1.3.6.1.2.1.25.5.1.1.2";
    private static String totalMemOid = ".1.3.6.1.2.1.25.2.2";
    private static int numMeasures = 4;
    private int listLength = 0;
    private Hashtable pidToCpuMap = new Hashtable();
    private long lastTestTime = System.currentTimeMillis();
    ArrayList list = new ArrayList();
    public double[] cpuUtil;
    public double[] memUtil;
    public double[] memSize;
    public int[] countProcesses;
    public double totalMemory = 0.0;
    public String[] names;
    public String[] patterns;
    public int patternCount = 0;
    public Hashtable cpuDetails = new Hashtable();
    public Hashtable memDetails = new Hashtable();
    private boolean useProcessPath = false;

    public HostProcessTest(String[] stringArray) {
        super(stringArray);
        StringTokenizer stringTokenizer;
        int n;
        this.setMeasureCount(numMeasures);
        this.isNewDynamicInfoTest = true;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-process")) {
                if (++n < stringArray.length) {
                    stringTokenizer = new StringTokenizer(stringArray[n], "|");
                    int n2 = stringTokenizer.countTokens();
                    for (int i = 0; i < n2; ++i) {
                        this.list.add(stringTokenizer.nextToken());
                    }
                    continue;
                }
                System.err.println("Usage: ProcessTest -host <host> -port <portNo> -user <userName> -pwd <passWords>  -process <name:pattern> -method <perfmon/none>");
                return;
            }
            if (!stringArray[n].equalsIgnoreCase("-useProcessPath") || ++n >= stringArray.length || !stringArray[n].equalsIgnoreCase("true") && !stringArray[n].equalsIgnoreCase("yes") && !stringArray[n].equalsIgnoreCase("y")) continue;
            this.useProcessPath = true;
        }
        this.listLength = this.list.size();
        this.names = new String[this.listLength];
        this.patterns = new String[this.listLength];
        this.countProcesses = new int[this.listLength];
        this.cpuUtil = new double[this.listLength];
        this.memUtil = new double[this.listLength];
        this.memSize = new double[this.listLength];
        this.patternCount = 0;
        for (n = 0; n < this.listLength; ++n) {
            stringTokenizer = new StringTokenizer((String)this.list.get(n), ":");
            if (stringTokenizer.countTokens() <= 1) continue;
            this.names[n] = new String(stringTokenizer.nextToken());
            this.patterns[n] = new String(stringTokenizer.nextToken());
            ++this.patternCount;
        }
        this.real_sid = this.getValueForParam("info");
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Object> arrayList;
        int n;
        this.cpuDetails = new Hashtable();
        this.memDetails = new Hashtable();
        boolean bl = false;
        bl = !this.useProcessPath ? this.runSnmpCmdForOid(processOid) : this.runSnmpCmdForOid(processPathOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        String[] stringArray = this.lhs;
        String[] stringArray2 = this.rhs;
        bl = this.runSnmpCmdForOid(totalMemOid);
        double d = -5.0;
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            d = -5.0;
        } else {
            try {
                d = Double.parseDouble(this.rhs[0]);
            }
            catch (Exception exception) {
                d = -5.0;
            }
        }
        if (d == -5.0) {
            return;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        bl = this.runSnmpCmdForOid(cpuOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable2.put(this.lhs[i], this.rhs[i]);
        }
        bl = this.runSnmpCmdForOid(memOid);
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable3.put(this.lhs[i], this.rhs[i]);
        }
        long l = System.currentTimeMillis();
        double d2 = (double)(l - this.lastTestTime) / 10.0;
        this.lastTestTime = l;
        for (n = 0; n < this.patterns.length; ++n) {
            double d3;
            String string;
            String string2;
            String string3;
            int n2;
            this.countProcesses[n] = 0;
            this.cpuUtil[n] = 0.0;
            this.memUtil[n] = 0.0;
            this.memSize[n] = 0.0;
            arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!HostProcessTest.isPatternMatch(stringArray2[n2], this.patterns[n])) continue;
                int n3 = n;
                this.countProcesses[n3] = this.countProcesses[n3] + 1;
                arrayList.add(stringArray[n2]);
                arrayList2.add(stringArray2[n2]);
            }
            n2 = 0;
            double d4 = 0.0;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                double d5;
                double d6;
                String string4 = (String)arrayList.get(i);
                string3 = (String)arrayList2.get(i);
                string2 = (String)hashtable2.get(string4);
                if (string2 == null || (string = (String)this.pidToCpuMap.get(string4)) == null || (d6 = (d3 = Double.parseDouble(string2)) - (d5 = Double.parseDouble(string))) < 0.0) continue;
                arrayList3.add(string3 + ";" + string4 + ";" + d6 * 100.0 / d2);
                n2 = 1;
                d4 += d6;
            }
            this.cpuDetails.put(this.names[n], arrayList3);
            d4 = n2 == 0 ? -5.0 : d4 * 100.0 / d2;
            this.cpuUtil[n] = d4;
            this.memUtil[n] = -5.0;
            n2 = 0;
            d4 = 0.0;
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = (String)arrayList.get(i);
                string2 = (String)arrayList2.get(i);
                string = (String)hashtable3.get(string3);
                if (string == null) continue;
                d3 = Double.parseDouble(string);
                arrayList4.add(string2 + ";" + string3 + ";" + d3 / 1024.0);
                n2 = 1;
                d4 += d3;
            }
            this.memDetails.put(this.names[n], arrayList4);
            if (d < 0.0) {
                d = -5.0;
            }
            if (n2 == 0 || d4 < 0.0) {
                d4 = -5.0;
                this.memSize[n] = -5.0;
            } else {
                this.memSize[n] = d4 / 1024.0;
                d4 = d4 * 100.0 / d;
            }
            this.memUtil[n] = d4 <= 0.0 ? -5.0 : d4;
        }
        this.pidToCpuMap = hashtable2;
        for (n = 0; n < this.patterns.length; ++n) {
            arrayList = new ArrayList<Object>();
            arrayList.add(new Double(this.countProcesses[n]));
            arrayList.add(new Double(this.cpuUtil[n]));
            arrayList.add(new Double(this.memUtil[n]));
            arrayList.add(new Double(this.memSize[n]));
            this.addNewMeasure(this.names[n], arrayList);
        }
    }
}

