/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class HanaDiskUsageTest
extends GenericTest {
    private static final int DISK_USAGE_MEASURE_COUNT = 4;
    private String userName = "";
    private String password = "";
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private Hashtable prevHash = new Hashtable();
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private boolean isTenantDB = false;
    private int msgLogCounter = 0;

    public HanaDiskUsageTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block40: {
            Statement statement;
            Object object;
            Object object2;
            block39: {
                String string;
                double d;
                double d2;
                String string2;
                String string3;
                String string4;
                Hashtable hashtable2;
                String string5;
                double d3;
                double d4;
                double d5;
                double d6;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                block38: {
                    if (this.checkHostName) {
                        ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                        object2 = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                        if (object2 != null && ((ArrayList)object2).size() > 0) {
                            this.hostNameToFilter = (String)((ArrayList)object2).get(0);
                            object = (String)((ArrayList)object2).get(1);
                            if (object != null && ((String)object).trim().length() > 0 && ((String)object).trim().equalsIgnoreCase("true")) {
                                this.isTenantDB = true;
                            }
                            this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                            this.checkHostName = false;
                        } else {
                            this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            return;
                        }
                    }
                    System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    System.out.println(this.entity + " ::isTenantDB==>" + this.isTenantDB + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    if (this.isTenantDB) {
                        this.isNewDynamicInfoTest = true;
                        if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                            this.logToErrorFile("INFO", this.entity + " doesnot run for TENANT database : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            this.msgLogCounter = 0;
                        }
                        ++this.msgLogCounter;
                        return;
                    }
                    object2 = null;
                    object = null;
                    statement = null;
                    string11 = "";
                    string10 = "";
                    string9 = "";
                    string8 = "";
                    string7 = "";
                    string6 = "";
                    d6 = 0.0;
                    d5 = 0.0;
                    d4 = 0.0;
                    d3 = 0.0;
                    string5 = "";
                    hashtable2 = new Hashtable();
                    string4 = "";
                    string3 = "";
                    string2 = "";
                    String string12 = "";
                    d2 = -5.0;
                    d = -5.0;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("select disk_id, device_id, host,path, subpath, usage_type, total_size,");
                    stringBuffer.append("used_size/1024/1024 used_size_mb,(total_size - used_size)/1024/1024  free_size_mb, ");
                    stringBuffer.append("used_size from m_disks where lower(host)='" + this.hostNameToFilter + "'");
                    string = stringBuffer.toString();
                    System.out.println(this.entity + "==>Query:" + string + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    if (object2 != null) break block38;
                    this.printOut("  Connection is null   ");
                    this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    try {
                        this.closeRs((ResultSet)object);
                        this.closeSt(statement);
                        this.closeConn((Connection)object2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                try {
                    statement = object2.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                    exception.printStackTrace();
                    try {
                        this.closeRs((ResultSet)object);
                        this.closeSt(statement);
                        this.closeConn((Connection)object2);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return;
                }
                object = statement.executeQuery(string);
                while (object.next()) {
                    string11 = object.getString(1);
                    string10 = object.getString(2);
                    string9 = object.getString(3);
                    string8 = object.getString(4);
                    string7 = object.getString(5);
                    string6 = object.getString(6);
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    string4 = object.getString(7);
                    d6 = this.getDoubleValue(string4);
                    d6 /= 1048576.0;
                    d6 = this.roundDouble(d6);
                    string3 = object.getString(8);
                    d5 = this.getDoubleValue(string3);
                    d5 = this.roundDouble(d5);
                    string2 = object.getString(9);
                    d4 = this.getDoubleValue(string2);
                    d4 = this.roundDouble(d4);
                    d2 = object.getDouble(7);
                    d = object.getDouble(10);
                    if (d2 > 0.0) {
                        d3 = (d2 - d) / d2 * 100.0;
                        d3 = this.roundDouble(d3);
                    } else {
                        d3 = -5.0;
                    }
                    string5 = string8 + ":" + string6;
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d3));
                    hashtable2.put(string5, arrayList);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) break block39;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    ArrayList<Double> arrayList;
                    ArrayList arrayList2;
                    String string13 = (String)enumeration.nextElement();
                    if (this.prevHash != null && this.prevHash.size() > 0) {
                        arrayList2 = (ArrayList)this.prevHash.get(string13);
                        arrayList = (ArrayList<Double>)hashtable2.get(string13);
                        if (arrayList2 == null) continue;
                        d8 = (Double)arrayList2.get(1);
                        if (arrayList == null || arrayList.size() != 4) continue;
                        d6 = (Double)arrayList.get(0);
                        d7 = (Double)arrayList.get(1);
                        d4 = (Double)arrayList.get(2);
                        d3 = (Double)arrayList.get(3);
                        if (d8 >= 0.0 && d7 >= d8) {
                            d9 = d7 - d8;
                        }
                        if (d9 > 0.0) {
                            if (this.timeSinceLastTest > 0.0) {
                                d10 = d9 / this.timeSinceLastTest;
                            }
                            if (d10 > 0.0) {
                                d10 = this.roundDouble(d10);
                            }
                        }
                        ArrayList<Double> arrayList3 = new ArrayList<Double>();
                        arrayList3.add(new Double(d6));
                        arrayList3.add(new Double(d4));
                        arrayList3.add(new Double(d3));
                        arrayList3.add(new Double(d10));
                        this.addNewMeasure(string13, arrayList3);
                    } else {
                        arrayList2 = (ArrayList)hashtable2.get(string13);
                        if (arrayList2 == null || arrayList2.size() != 4) continue;
                        d6 = (Double)arrayList2.get(0);
                        d4 = (Double)arrayList2.get(2);
                        d3 = (Double)arrayList2.get(3);
                        arrayList = new ArrayList<Double>();
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d4));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(-5.0));
                        this.addNewMeasure(string13, arrayList);
                    }
                    this.prevHash = (Hashtable)hashtable2.clone();
                }
            }
            try {
                this.closeRs((ResultSet)object);
                this.closeSt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block40;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                sQLException.printStackTrace();
                this.printOut("SQL Error  " + sQLException);
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block40;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                this.printOut(" Error  : " + exception);
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs((ResultSet)object);
                            this.closeSt(statement);
                            this.closeConn((Connection)object2);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                string = string.trim();
                d = EgLangInfo.getDoubleValue(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    public void printOut(String string) {
        System.out.println(" >> " + this.reportingName + " : " + this.entity + ": [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public static void main(String[] stringArray) {
        HanaDiskUsageTest hanaDiskUsageTest = new HanaDiskUsageTest(stringArray);
        hanaDiskUsageTest.password = EgCrypt.decrypt(hanaDiskUsageTest.password);
        while (true) {
            try {
                while (true) {
                    hanaDiskUsageTest.computeMeasures(new Hashtable());
                    Thread.sleep(30000L);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                continue;
            }
            break;
        }
    }
}

