/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class HPStOReplicaTest
extends HPStoreOnceBase {
    private String logMessage = "";
    boolean isFirstTime = true;
    double prevReceiveBandwidthTotal = 0.0;
    double prevTransmitBandwidthTotal = 0.0;

    public HPStOReplicaTest(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        HPStOReplicaTest hPStOReplicaTest = new HPStOReplicaTest(stringArray);
        hPStOReplicaTest.debugComputeMeasures(new Hashtable(), true);
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        hPStOReplicaTest.debugComputeMeasures(new Hashtable(), true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = "[debugComputeMeasures] :";
        try {
            this.setData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + " Exception occured in setData()", exception);
        }
        try {
            Hashtable hashtable2 = this.getReplicationDataHashtable();
            this.printOut(string + "Measure from service set info : " + hashtable2);
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                this.logMessage = "[debugComputeMeasures] :command output null or size is zero or empty for " + this.targetHost + ",So returning";
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            double d = this.getDoubleData(hashtable2, "repHealthLevel");
            String string2 = this.getStringData(hashtable2, "repStatus");
            double d2 = this.getHealthStatus(string2);
            double d3 = this.getDoubleData(hashtable2, "receiveBandwidthTotal");
            this.printOut(string + "  current received bandwidth total :" + d3);
            double d4 = this.getDoubleData(hashtable2, "transmitBandwidthTotal");
            this.printOut(string + "  current transmit bandwidth total :" + d4);
            double d5 = -5.0;
            double d6 = -5.0;
            if (this.isFirstTime) {
                this.prevReceiveBandwidthTotal = d3;
                this.prevTransmitBandwidthTotal = d4;
                this.isFirstTime = false;
            } else {
                d5 = d3 >= 0.0 && this.prevReceiveBandwidthTotal >= 0.0 && d3 - this.prevReceiveBandwidthTotal >= 0.0 ? d3 - this.prevReceiveBandwidthTotal : -5.0;
                d6 = d4 >= 0.0 && this.prevTransmitBandwidthTotal > 0.0 && d4 - this.prevTransmitBandwidthTotal >= 0.0 ? d4 - this.prevTransmitBandwidthTotal : -5.0;
                this.prevReceiveBandwidthTotal = d3;
                this.prevTransmitBandwidthTotal = d4;
            }
            this.printOut(string + "  repStatus\t    \t:" + d2);
            this.printOut(string + "  repHealthLevel  :" + d);
            this.printOut(string + "  receiveBandwidth\t    :" + d5);
            this.printOut(string + "  transmitBandwidth\t    :" + d6);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (d5 > 0.0) {
                d5 /= 1024.0;
            }
            if (d6 > 0.0) {
                d6 /= 1024.0;
            }
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            if (!bl) {
                this.addNewMeasure(arrayList);
            }
            this.printOut(string + "Measure list " + arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + " Exception occured ", exception);
        }
    }
}

