/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HCPBase
extends EgSnmpGenericTest {
    private static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    protected static final String DEBUG_COMPUTE_MEASURE_METHOD_NAME = "[debugComputeMeasures] :";
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double DEFAULT_MINUS_ONE = -1.0;
    protected static final double BYTES_TO_KB = 1024.0;
    protected static final double BYTES_TO_MB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double BYTES_TO_TB = 1.099511627776E12;
    protected static final double KB_TO_MB = 1024.0;
    protected static final double MB_TO_GB = 1024.0;
    private static final String HCP_TIME_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    protected static final String TEMPERATURE = "Temp_";
    protected static final String CELCIOUS = "C";
    protected static final String VOLT = "Volt_";
    protected static final String VOLTS = "Volts";
    protected static final String FAN = "Fan_";
    protected static final String RPM = "RPM";
    protected static final String CAPCITY_BALANCING = "Capcity balancing";
    protected static final String COMPRESSION = "Compression";
    protected static final String CONTENT_VERIFICATION = "Content verification";
    protected static final String DUPLICATE_ELIMINATION = "Duplicate elimination";
    protected static final String GARBAGE_COLLECTION = "Garbage collection";
    protected static final String PROTECTION = "Protection";
    protected static final String SCAVENGING = "Scavenging";
    protected static final String STORAGE_TIERING = "Storage tiering";
    protected static final String DISPOSITION = "Disposition";
    protected String logMessage = null;
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    protected double WARNING_DAYS = 100.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HCPBase(String[] stringArray) {
        super(stringArray);
        this.setConfigInfoTestFlag(true);
        this.needAgentlessDD = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    protected Hashtable getMeasures(String string) {
        String string2 = "getMeasures";
        string2 = this.methodNameTemplate(string2);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = "";
        String string4 = "";
        boolean bl = this.runSnmpCmdForOid(string);
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string3 = this.lhs[i].trim();
                    string4 = this.rhs[i] != null && this.rhs[i].trim().length() > 0 ? this.rhs[i].trim() : "-";
                    hashtable.put(string3, string4);
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Exception occured ", exception);
        }
        return hashtable;
    }

    protected String removeDoubleQuotes(String string) {
        String string2 = "removeDoubleQuotes";
        string2 = this.methodNameTemplate(string2);
        String string3 = "";
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        string3 = this.replaceAll(string, "\"", "");
        return string3;
    }

    protected long getHCPNodeBootTime(String string) {
        String string2 = "getHCPNodeBootTime";
        string2 = this.methodNameTemplate(string2);
        return this.getHCPTimeConvertToMilliSeconds(string);
    }

    protected long getHCPLicenseExpireDateTime(String string) {
        String string2 = "getHCPLicenseExpireDateTime";
        string2 = this.methodNameTemplate(string2);
        return this.getHCPTimeConvertToMilliSeconds(string);
    }

    protected long getHCPTimeConvertToMilliSeconds(String string) {
        String string2 = "getHCPTimeConvertToMilliSeconds";
        string2 = this.methodNameTemplate(string2);
        long l = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HCP_TIME_FORMAT, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.printOut(string2 + "Current time in GMT : " + simpleDateFormat.format(new Date()));
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            this.logMessage = string2 + "Exception happened while  parsing the time string  ";
            this.printOutStackTrace(this.logMessage, parseException);
            this.logMessage = "";
        }
        if (date != null) {
            try {
                l = date.getTime();
            }
            catch (Exception exception) {
                this.logMessage = string2 + "Exception happened while  getTime()  ";
                this.printOutStackTrace(this.logMessage, exception);
                this.logMessage = "";
            }
        }
        return l;
    }

    protected String getHCPTimeForEG(long l) {
        String string = "getHCPTimeForEG";
        string = this.methodNameTemplate(string);
        String string2 = "-";
        try {
            Date date = new Date(l);
            string2 = MY_SDF.format(date);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception happened while  formattedDate   ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
        return string2;
    }

    protected double getHCPBytesToConverter(double d, double d2) {
        String string = "getHCPBytesToConverter";
        string = this.methodNameTemplate(string);
        if (d > 0.0) {
            d /= d2;
            d = this.roundDouble(d, 2);
        }
        return d;
    }

    protected String removePrefixString(String string, String string2) {
        String string3 = "removePrefixString";
        string3 = this.methodNameTemplate(string3);
        String string4 = "";
        if ((string = this.removeDoubleQuotes(string)).indexOf(string2) <= -1) {
            return string;
        }
        string4 = string.substring(string2.length());
        return string4;
    }

    protected String removeMiddleString(String string, String string2) {
        String string3 = "removeMiddleString";
        string3 = this.methodNameTemplate(string3);
        String string4 = "";
        if ((string = this.removeDoubleQuotes(string)).indexOf(string2) <= -1) {
            return string;
        }
        string4 = string.substring(0, string.indexOf(string2));
        return string4;
    }

    protected double getHCPPowerSupplyStatus(String string) {
        String string2 = "getHCPPowerSupplyStatus";
        string2 = this.methodNameTemplate(string2);
        double d = -1.0;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            return d;
        }
        if ((string = string.trim()).equalsIgnoreCase("Presence detected")) {
            d = 0.0;
        } else {
            d = -1.0;
            this.printOut(string2 + " Found new status \"" + string + "\"");
            this.putInfoMessageToLogfile(string2 + " Found new status \"" + string + "\"");
        }
        return d;
    }

    protected double getHCPReplicationStatus(String string) {
        String string2 = "getHCPReplicationStatus";
        string2 = this.methodNameTemplate(string2);
        double d = -1.0;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            return d;
        }
        if (string.equalsIgnoreCase("Replicating")) {
            d = 0.0;
        } else {
            d = -1.0;
            this.printOut(string2 + " Found new status \"" + string + "\"");
            this.putInfoMessageToLogfile(string2 + " Found new status \"" + string + "\"");
        }
        return d;
    }

    protected String getHCPServiceStatusForCF(String string) {
        String string2 = "getHCPServiceStatusForCF";
        string2 = this.methodNameTemplate(string2);
        if (this.getHCPNullNoneCheck(string)) {
            string = string.equalsIgnoreCase("1") ? "Yes" : (string.equalsIgnoreCase("2") ? "No" : "Unknown");
        }
        return string;
    }

    protected boolean getHCPNullNoneCheck(String string) {
        String string2 = "getHCPNullNoneCheck";
        string2 = this.methodNameTemplate(string2);
        return string != null && string.trim().length() > 0 && !string.equalsIgnoreCase("none") && !string.equalsIgnoreCase("null");
    }

    protected double getHCPMigrationStatus(String string) {
        String string2 = "getHCPMigrationStatus";
        string2 = this.methodNameTemplate(string2);
        double d = -1.0;
        if (this.getHCPNullNoneCheck(string)) {
            if (string.equalsIgnoreCase("Not Migrating")) {
                d = 0.0;
            } else {
                d = -1.0;
                this.printOut(string2 + " Found new status \"" + string + "\"");
                this.putInfoMessageToLogfile(string2 + " Found new status \"" + string + "\"");
            }
        }
        return d;
    }

    protected double getHCPServiceStatus(double d) {
        String string = "getHCPServiceStatus";
        string = this.methodNameTemplate(string);
        double d2 = -1.0;
        if (d == 7.0) {
            d2 = 0.0;
        } else if (d == 5.0) {
            d2 = 1.0;
        } else if (d == 0.0) {
            d2 = 2.0;
        } else if (d == 6.0) {
            d2 = 3.0;
        } else if (d == 4.0) {
            d2 = 4.0;
        } else if (d == -1.0) {
            d2 = 5.0;
        } else if (d == 2.0) {
            d2 = 6.0;
        } else if (d == 1.0) {
            d2 = 7.0;
        } else if (d == 3.0) {
            d2 = 8.0;
        } else {
            d2 = -1.0;
            this.printOut(string + " Found new status \"" + d + "\"");
            this.putInfoMessageToLogfile(string + " Found new status \"" + d + "\"");
        }
        return d2;
    }

    protected double getHCPVolumeStatus(double d) {
        String string = "getHCPVolumeStatus";
        string = this.methodNameTemplate(string);
        double d2 = -1.0;
        if (d == 0.0) {
            d2 = 0.0;
        } else if (d == 5.0) {
            d2 = 1.0;
        } else if (d == 1.0) {
            d2 = 2.0;
        } else if (d == 2.0) {
            d2 = 3.0;
        } else if (d == 3.0) {
            d2 = 4.0;
        } else if (d == 4.0) {
            d2 = 5.0;
        } else {
            d2 = -1.0;
            this.printOut(string + " Found new status \"" + d + "\"");
            this.putInfoMessageToLogfile(string + " Found new status \"" + d + "\"");
        }
        return d2;
    }

    protected double getHCPDiffValuesFromString(String string, String string2, String string3) {
        String string4 = "getHCPDiffValuesFromString";
        string4 = this.methodNameTemplate(string4);
        double d = -5.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (string2 == null || string2.trim().length() == 0 || string3 == null || string3.length() == 0) {
            return d;
        }
        d2 = this.convertToDouble(string2);
        if (d2 >= (d3 = this.convertToDouble(string3))) {
            d = d2 - d3;
        } else {
            d = d2;
            this.putInfoMessageToLogfile(string4 + "KEY  :" + string + ", Current value  :" + d2 + " is less than Previous value :" + d3);
        }
        return d;
    }

    protected String replaceAll(String string, String string2, String string3) {
        String string4 = "replaceAll";
        string4 = this.methodNameTemplate(string4);
        String string5 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string5 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string5 = string5 + string3 + stringTokenizer.nextToken();
        }
        return string5;
    }

    protected double convertToDouble(String string) {
        String string2 = "convertToDouble";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (!this.getHCPNullNoneCheck(string)) {
            return d;
        }
        string = string.trim();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    protected double roundDouble(double d) {
        double d2 = 0.0;
        int n = 2;
        d2 = this.roundDouble(d, n);
        return d2;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + "-";
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.printOut(string + "Error in method :" + exception.toString());
            this.putErrorMessageToLogfile("Error in method :" + exception.toString());
        }
        return d2;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + string3);
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public void computeMeasures(Hashtable hashtable) {
    }
}

