/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class EgDnsManager {
    private static EgDnsManager instance = null;
    private Hashtable hostnames = new Hashtable();
    private Hashtable dnstimes = new Hashtable();
    private long lastDnsCleanupTime = 0L;
    private EgDateInfo dateInfo = new EgDateInfo();
    private long dnsCacheTime = 3L * EgConfigInfo.msecPerHour;
    private Hashtable hostnames_auditlog = new Hashtable();
    private Hashtable dnstimes_auditlog = new Hashtable();
    private long lastDnsCleanupTime_auditlog = 0L;

    public static void main(String[] stringArray) {
        System.out.println(EgInstallInfo.getHostName(stringArray[0]));
    }

    private EgDnsManager() {
    }

    public static synchronized EgDnsManager getInstance() {
        if (instance == null) {
            instance = new EgDnsManager();
        }
        return instance;
    }

    public void init() {
        long l = this.dateInfo.egetUTCDate(false);
        this.hostnames = new Hashtable();
        this.dnstimes = new Hashtable();
        this.lastDnsCleanupTime = l;
        this.hostnames_auditlog = new Hashtable();
        this.dnstimes_auditlog = new Hashtable();
        this.lastDnsCleanupTime_auditlog = l;
    }

    public String getHostName(String string) {
        long l;
        long l2 = this.dateInfo.egetUTCDate(false);
        if (l2 - this.lastDnsCleanupTime > EgConfigInfo.msecPerDay && l2 - this.lastDnsCleanupTime > EgConfigInfo.msecPerDay) {
            this.lastDnsCleanupTime = l2;
            this.hostnames.clear();
            this.dnstimes.clear();
        }
        if (this.hostnames != null && this.hostnames.containsKey(string) && (l = ((Long)this.dnstimes.get(string)).longValue()) - l2 < this.dnsCacheTime) {
            return (String)this.hostnames.get(string);
        }
        try {
            String string2 = EgInstallInfo.getHostName(string);
            this.hostnames.put(string, string2);
            this.dnstimes.put(string, new Long(l2));
            return string2;
        }
        catch (Exception exception) {
            this.hostnames.put(string, string);
            this.dnstimes.put(string, new Long(l2));
            return string;
        }
    }

    public String getAuditLogHostName(String string) {
        long l;
        long l2 = this.dateInfo.egetUTCDate(false);
        if (l2 - this.lastDnsCleanupTime_auditlog > EgConfigInfo.msecPerDay && l2 - this.lastDnsCleanupTime_auditlog > EgConfigInfo.msecPerDay) {
            this.lastDnsCleanupTime_auditlog = l2;
            this.hostnames_auditlog.clear();
            this.dnstimes_auditlog.clear();
        }
        if (this.hostnames_auditlog != null && this.hostnames_auditlog.containsKey(string) && (l = ((Long)this.dnstimes_auditlog.get(string)).longValue()) - l2 < this.dnsCacheTime) {
            return (String)this.hostnames_auditlog.get(string);
        }
        try {
            String string2 = EgInstallInfo.getHostName(string);
            this.hostnames_auditlog.put(string, string2);
            this.dnstimes_auditlog.put(string, new Long(l2));
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.hostnames_auditlog.put(string, string);
            this.dnstimes_auditlog.put(string, new Long(l2));
            return string;
        }
    }

    public Hashtable getAuditLogHostNames() {
        return this.hostnames_auditlog;
    }
}

