/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class DbBaseTest
extends GenericTest {
    protected static final double MB = 1024.0;
    protected static final double SECS = 1000.0;
    protected static final String Db = "Db";
    protected static final String NA = "NA";
    Connection conn = null;
    Statement stmt = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;
    String dbName = this.getValueForParam("databasename");
    String username = this.getValueForParam("username");
    String password = this.getValueForParam("password");
    String host = this.targetHost;
    String port = this.portNo;
    double respTime = 0.0;

    public DbBaseTest(String[] stringArray) {
        super(stringArray);
    }

    private boolean dbConnect() {
        try {
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            String string = "jdbc:sapdb://" + this.host + ":" + this.port + "/" + this.dbName;
            this.conn = DriverManager.getConnection(string, this.username, this.password);
            if (this.conn != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("class exception:" + classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            System.out.println("SQL exception:" + sQLException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("exception:" + exception.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getOutput(String string) {
        ArrayList arrayList = new ArrayList();
        Hashtable<String, String> hashtable = null;
        String string2 = Db;
        synchronized (Db) {
            try {
                if (!this.dbConnect()) {
                    this.respTime = -5.0;
                    ArrayList arrayList2 = null;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return arrayList2;
                }
                this.stmt = this.conn.createStatement();
                long l = System.currentTimeMillis();
                this.rs = this.stmt.executeQuery(string);
                long l2 = System.currentTimeMillis();
                this.respTime = (double)(l2 - l) / 1000.0;
                this.rsmd = this.rs.getMetaData();
                int n = this.rsmd.getColumnCount();
                String string3 = null;
                String string4 = null;
                while (this.rs.next()) {
                    hashtable = new Hashtable<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        string3 = this.rsmd.getColumnName(i);
                        string4 = this.rs.getString(string3);
                        if (string4 == null) {
                            string4 = NA;
                        }
                        hashtable.put(string3, string4);
                    }
                    arrayList.add(hashtable);
                }
            }
            catch (Exception exception) {
                System.out.println("unable to run query :" + exception.getMessage());
            }
            finally {
                this.dbDisConnect();
            }
            return arrayList;
        }
    }

    public void dbDisConnect() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

