/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB2JdbcHelper {
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final String URL_PREFIX = "jdbc:db2://";
    private static final String CLASS_NAME = "DB2JdbcHelper";
    private String host;
    private String portNo;
    private String user;
    private String password;
    private String dbName;
    private boolean debug = true;

    public DB2JdbcHelper(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.portNo = string2;
        this.user = string3;
        this.password = string4;
        this.dbName = string5;
    }

    public Connection getConnection() {
        Connection connection;
        block6: {
            connection = null;
            String string = URL_PREFIX + this.host + ":" + this.portNo + "/" + this.dbName;
            try {
                Class.forName(DRIVER_CLASS);
                connection = DriverManager.getConnection(string, this.user, this.password);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                if (this.debug) {
                    System.out.println("DB2JdbcHelper: Could not load DB2 JDBC driver " + classNotFoundException);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.debug) {
                    System.out.println("DB2JdbcHelper: SQL Exception " + sQLException);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block6;
                System.out.println("DB2JdbcHelper: Exception" + exception);
            }
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        block3: {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing connection " + exception);
            }
        }
        connection = null;
    }

    public void closeStatement(Statement statement) {
        block3: {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing statement " + exception);
            }
        }
        statement = null;
    }

    public void closeResultSet(ResultSet resultSet) {
        block3: {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing resultset " + exception);
            }
        }
        resultSet = null;
    }

    public int getDb2MajorVersion(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public String getDbSnapshotFunction(Connection connection) {
        int n = 8;
        int n2 = 1;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
            n2 = connection.getMetaData().getDatabaseMinorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_DATABASE(cast(NULL as varchar(128)),-2)";
        } else if (n == 9) {
            string = "SNAP_GET_DB_V" + n + "" + n2 + "(CAST (NULL AS VARCHAR(128)),-2)";
        } else if (n > 9) {
            string = "SNAP_GET_DB(CAST (NULL AS VARCHAR(128)),-2)";
        }
        return string;
    }

    public String getDbmSnapshotFunction(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_DBM(-2)";
        } else if (n >= 9) {
            string = "SNAP_GET_DBM(-2)";
        }
        return string;
    }

    public String getTbsSnapshotFunction(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_TBS_CFG(cast(NULL as varchar(128)),-2)";
        }
        return string;
    }
}

