/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CronExpressionParser {
    public static final int MINUTES = 0;
    public static final int HOURS = 1;
    public static final int DAYS_OF_MONTH = 2;
    public static final int MONTHS = 3;
    public static final int DAYS_OF_WEEK = 4;
    public static final int YEARS = 5;
    public static final int NUM_FIELDS = 6;
    private static final int MIN_MINUTES = 0;
    private static final int MAX_MINUTES = 59;
    private static final int MIN_HOURS = 0;
    private static final int MAX_HOURS = 23;
    private static final int MIN_DAYS_OF_MONTH = 1;
    private static final int MAX_DAYS_OF_MONTH = 31;
    private static final int MIN_MONTHS = 1;
    private static final int MAX_MONTHS = 12;
    private static final int MIN_DAYS_OF_WEEK = 0;
    private static final int MAX_DAYS_OF_WEEK = 6;
    private static final int MIN_YEARS = 1970;
    private static final int MAX_YEARS = 2099;
    private static final int THIS_YEAR = Calendar.getInstance().get(1);
    private static final int[][] RANGES = new int[][]{{0, 59}, {0, 23}, {1, 31}, {1, 12}, {0, 6}, {THIS_YEAR, THIS_YEAR + 30 < 2099 ? THIS_YEAR + 30 : 2099}};
    private static final Map sMapMonths = new HashMap();
    private static final Map sMapDaysOfWeek;
    private final String expression;
    private boolean parsed = false;
    private SortedSet[] cronFields = null;

    public CronExpressionParser(String string) {
        this.expression = string;
        try {
            this.cronFields = CronExpressionParser.parse(this.expression);
            this.parsed = true;
        }
        catch (Exception exception) {
            System.out.println(" Failed to parse the cron expression: " + this.expression);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "12,13,23-28,40-50/2 * * * *";
            CronExpressionParser cronExpressionParser = new CronExpressionParser(string);
            Calendar calendar = Calendar.getInstance();
            long l = cronExpressionParser.getNextCronTime(calendar);
            Calendar calendar2 = Calendar.getInstance();
            Date date = new Date(l);
            calendar2.setTime(date);
            calendar2.set(13, 0);
        }
        catch (Exception exception) {
            System.out.println("some wrong expression");
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public SortedSet[] getCronFields() {
        return this.cronFields;
    }

    public static SortedSet[] parse(String string) throws Exception {
        int n;
        if (string == null || string.length() == 0) {
            throw new Exception("Null/Empty cron expression.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() == 1) {
            if (string.indexOf("@reboot") != -1) {
                string = " ";
            } else if (string.indexOf("@yearly") != -1 || string.indexOf("@annually") != -1) {
                string = "0 0 1 1 *";
            } else if (string.indexOf("@monthly") != -1) {
                string = "0 0 1 * *";
            } else if (string.indexOf("@weekly") != -1) {
                string = "0 0 * * 0";
            } else if (string.indexOf("@daily") != -1 || string.indexOf("@midnight") != -1) {
                string = "0 0 * * *";
            } else if (string.indexOf("@hourly") != -1) {
                string = "0 * * * *";
            } else {
                throw new Exception("Invalid cron expression.");
            }
        }
        if (string.indexOf("L") > -1 || string.indexOf("l") > -1 || string.indexOf("W") > -1 || string.indexOf("w") > -1) {
            System.out.println("Invalid cron expression.");
        }
        SortedSet[] sortedSetArray = new SortedSet[6];
        StringTokenizer stringTokenizer2 = new StringTokenizer(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer2.hasMoreElements()) {
            arrayList.add(stringTokenizer2.nextElement());
        }
        int n2 = arrayList.size();
        if (n2 < 5) {
            throw new Exception("Incorrect field count: " + n2);
        }
        if (n2 < 6) {
            System.out.println(" (Optional) Year field is missing.");
        } else if (n2 > 6) {
            System.out.println(" Incorrect field count: " + n2 + ". Trailing fields will be ignored.");
        }
        for (n = 0; n < n2; ++n) {
            sortedSetArray[n] = new TreeSet();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String string2 = (String)arrayList.get(n);
            StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ",");
            while (stringTokenizer3.hasMoreElements()) {
                arrayList2.add(stringTokenizer3.nextElement());
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                int n3;
                int n4;
                int n5;
                block45: {
                    String string3;
                    String string4 = string3 = (String)arrayList2.get(i);
                    n5 = 1;
                    if (string3.indexOf("/") > 0) {
                        StringTokenizer stringTokenizer4 = new StringTokenizer(string3, "/");
                        string4 = stringTokenizer4.nextToken();
                        try {
                            n5 = Integer.valueOf(stringTokenizer4.nextToken());
                        }
                        catch (Exception exception) {
                            System.out.println("Incorrect division format: atom = " + string3);
                        }
                    }
                    int n6 = 0;
                    n4 = 0;
                    if ("*".equals(string4)) {
                        n6 = RANGES[n][0];
                        n4 = RANGES[n][1];
                    } else if ("?".equals(string4) && (n == 2 || n == 4)) {
                        n6 = RANGES[n][0];
                        n4 = RANGES[n][1];
                    } else if (string4.indexOf("-") > 0) {
                        StringTokenizer stringTokenizer5 = new StringTokenizer(string4, "-");
                        String string5 = stringTokenizer5.nextToken();
                        String string6 = stringTokenizer5.nextToken();
                        try {
                            n6 = Integer.valueOf(string5);
                            n4 = Integer.valueOf(string6);
                        }
                        catch (Exception exception) {
                            if (n == 3 && sMapMonths.containsKey(string5.toUpperCase()) && sMapMonths.containsKey(string6.toUpperCase())) {
                                n6 = (Integer)sMapMonths.get(string5.toUpperCase());
                                n4 = (Integer)sMapMonths.get(string6.toUpperCase());
                                break block45;
                            }
                            if (n == 4 && sMapDaysOfWeek.containsKey(string5.toUpperCase()) && sMapDaysOfWeek.containsKey(string6.toUpperCase())) {
                                n6 = (Integer)sMapDaysOfWeek.get(string5.toUpperCase());
                                n4 = (Integer)sMapDaysOfWeek.get(string6.toUpperCase());
                                break block45;
                            }
                            System.out.println("Incorrect range format: numerator = " + string4);
                        }
                    } else {
                        try {
                            n6 = Integer.valueOf(string4);
                        }
                        catch (Exception exception) {
                            if (n == 3 && sMapMonths.containsKey(string4.toUpperCase())) {
                                n6 = (Integer)sMapMonths.get(string4.toUpperCase());
                            }
                            if (n == 4 && sMapDaysOfWeek.containsKey(string4.toUpperCase())) {
                                n6 = (Integer)sMapDaysOfWeek.get(string4.toUpperCase());
                            }
                            System.out.println("Incorrect range format: numerator = " + string4);
                        }
                        n4 = n6;
                    }
                }
                if (n == 4) {
                    for (n3 = n6; n3 <= n4; n3 += n5) {
                        sortedSetArray[4].add(new Integer(n3 % 7));
                    }
                    continue;
                }
                for (n3 = n6; n3 <= n4; n3 += n5) {
                    sortedSetArray[n].add(new Integer(n3));
                }
            }
        }
        if (sortedSetArray[5] == null) {
            sortedSetArray[5] = new TreeSet();
            n = RANGES[5][0];
            int n7 = RANGES[5][1];
            int n8 = n;
            for (int i = n; i < n7; ++i) {
                sortedSetArray[5].add(new Integer(n8));
                ++n8;
            }
        }
        return sortedSetArray;
    }

    public SortedSet getMinutes() {
        return this.cronFields[0];
    }

    public SortedSet getHours() {
        return this.cronFields[1];
    }

    public SortedSet getDays() {
        return this.cronFields[2];
    }

    public SortedSet getMonths() {
        return this.cronFields[3];
    }

    public SortedSet getDaysOfWeek() {
        return this.cronFields[4];
    }

    public SortedSet getYears() {
        return this.cronFields[5];
    }

    public long getNextCronTime(Calendar calendar) {
        long l = calendar.getTime().getTime();
        return this.getNextCronTime(l);
    }

    public long getNextCronTime(long l) {
        int n;
        int n2;
        Object object2;
        if (!this.isParsed()) {
            System.out.println("Parser not initialized!");
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        Date date = new Date(l);
        calendar.setTime(date);
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        int n5 = calendar.get(5);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        long l2 = -1L;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Object object2 : this.cronFields[5]) {
            n2 = (Integer)object2;
            if (n2 < n3) continue;
            treeSet.add(object2);
        }
        if (treeSet != null && treeSet.size() > 0 && n3 < (n2 = ((Integer)(object2 = (Integer)treeSet.first())).intValue())) {
            for (n = n3; n < n2; ++n) {
                treeSet.add(new Integer(n));
            }
        }
        object2 = treeSet.iterator();
        n2 = 0;
        block2: while (object2.hasNext()) {
            n = (Integer)object2.next();
            SortedSet<Integer> sortedSet = new TreeSet();
            if (n == n3) {
                for (Integer n8 : this.cronFields[3]) {
                    int n9 = n8;
                    if (n9 < n4) continue;
                    sortedSet.add(n8);
                }
            } else {
                sortedSet = this.cronFields[3];
            }
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n10;
                int n11 = (Integer)iterator.next();
                SortedSet<Integer> sortedSet2 = new TreeSet();
                if (n == n3 && n11 == n4) {
                    for (Integer n12 : this.cronFields[2]) {
                        n10 = n12;
                        if (n10 < n5) continue;
                        sortedSet2.add(n12);
                    }
                } else {
                    sortedSet2 = this.cronFields[2];
                }
                Iterator iterator2 = sortedSet2.iterator();
                block6: while (iterator2.hasNext()) {
                    int n13 = (Integer)iterator2.next();
                    n10 = CronExpressionParser.getDayOfWeek(n, n11, n13);
                    if (n10 < 0 || !this.cronFields[4].contains(new Integer(n10))) continue;
                    SortedSet<Integer> sortedSet3 = new TreeSet();
                    if (n == n3 && n11 == n4 && n13 == n5) {
                        for (Integer n14 : this.cronFields[1]) {
                            int n15 = n14;
                            if (n15 < n6) continue;
                            sortedSet3.add(n14);
                        }
                    } else {
                        sortedSet3 = this.cronFields[1];
                    }
                    Iterator iterator3 = sortedSet3.iterator();
                    while (iterator3.hasNext()) {
                        int n16 = (Integer)iterator3.next();
                        SortedSet<Integer> sortedSet4 = new TreeSet();
                        if (n == n3 && n11 == n4 && n13 == n5 && n16 == n6) {
                            for (Integer n17 : this.cronFields[0]) {
                                int n18 = n17;
                                if (n18 < n7) continue;
                                sortedSet4.add(n17);
                            }
                            continue block6;
                        }
                        sortedSet4 = this.cronFields[0];
                        Iterator iterator4 = sortedSet4.iterator();
                        while (iterator4.hasNext()) {
                            int n19 = (Integer)iterator4.next();
                            if (n19 == n7) continue;
                            long l3 = CronExpressionParser.getTime(n, n11, n13, n16, n19);
                            if (l3 >= l) {
                                l2 = l3;
                                break block2;
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        return l2;
    }

    public String toString() {
        if (this.isParsed() && this.cronFields != null) {
            return CronExpressionParser.toDebugString(this.cronFields);
        }
        return this.expression;
    }

    private static String toDebugString(SortedSet[] sortedSetArray) {
        if (sortedSetArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            for (int i = 0; i < sortedSetArray.length; ++i) {
                stringBuffer.append("[");
                SortedSet sortedSet = sortedSetArray[i];
                if (sortedSet != null) {
                    Iterator iterator = sortedSet.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        stringBuffer.append(n);
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(",");
                    }
                }
                stringBuffer.append("]");
                if (i >= sortedSetArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(n, n2 - 1, n3);
            calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static int getDayOfWeek(int n, int n2, int n3) {
        int n4 = -1;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(n, n2 - 1, n3);
            n4 = calendar.get(7) - 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return n4;
    }

    public static long getTime(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, n4, n5);
        long l = calendar.getTime().getTime();
        return l;
    }

    static {
        sMapMonths.put("JAN", new Integer(1));
        sMapMonths.put("FEB", new Integer(2));
        sMapMonths.put("MAR", new Integer(3));
        sMapMonths.put("APR", new Integer(4));
        sMapMonths.put("MAY", new Integer(5));
        sMapMonths.put("JUN", new Integer(6));
        sMapMonths.put("JUL", new Integer(7));
        sMapMonths.put("AUG", new Integer(8));
        sMapMonths.put("SEP", new Integer(9));
        sMapMonths.put("OCT", new Integer(10));
        sMapMonths.put("NOV", new Integer(11));
        sMapMonths.put("DEC", new Integer(12));
        sMapDaysOfWeek = new HashMap();
        sMapDaysOfWeek.put("SUN", new Integer(0));
        sMapDaysOfWeek.put("MON", new Integer(1));
        sMapDaysOfWeek.put("TUE", new Integer(2));
        sMapDaysOfWeek.put("WED", new Integer(3));
        sMapDaysOfWeek.put("THU", new Integer(4));
        sMapDaysOfWeek.put("FRI", new Integer(5));
        sMapDaysOfWeek.put("SAT", new Integer(6));
    }
}

