/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class BobiWISCacheTest
extends BobiBase {
    private static final int WEB_INTELLIGENCE_SERVER_CACHE_MEASURE_COUNT = 8;
    private static final String SERVER_TYPE = "webiserver";
    public Hashtable prevHash = new Hashtable();
    private static final String CACHE_SIZE_KB = "Cache size _Kb_";
    private static final String OUT_DATE_DOCS_IN_CACHE = "Number of out_of_date documents in cache";
    private static final String CACHE_HIGH_MARK = "Cache high mark count";
    private static final String DOCS_OPENED_FROM_CACHE = "Number of documents opened from cache";
    private static final String NO_OF_DOCS = "Number of documents";
    private static final String NO_OF_DOCS_WITH_SWAP_REQUESTS = "Number of document swap";
    private static final String SWAPPED_DOCUMENTS = "Number of swapped documents";
    private static final ArrayList attrArrayList = new ArrayList();
    private static final ArrayList dummymeasureArrayList = new ArrayList();

    public BobiWISCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isDynamicInfoTest = true;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.printOut("Node name :" + this.nodeName);
        String string = "Servers:name=" + this.nodeName + "*,type=" + SERVER_TYPE;
        this.printOut("Query Filter :" + string);
        hashtable2 = this.getAttrs(string, attrArrayList);
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            this.logToErrorFile("WARNING", this.reportingName + ":" + this.entity, "Attributes data hashtable value is null");
            this.addNewMeasure(dummymeasureArrayList);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        while (enumeration.hasMoreElements()) {
            arrayList = new ArrayList();
            String string2 = (String)enumeration.nextElement();
            this.printOut("Info  :" + string2);
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
            d = this.getHashtableData(hashtable3, CACHE_SIZE_KB);
            d4 = this.getHashtableData(hashtable3, DOCS_OPENED_FROM_CACHE);
            d5 = this.getHashtableData(hashtable3, NO_OF_DOCS);
            d7 = this.getHashtableData(hashtable3, NO_OF_DOCS_WITH_SWAP_REQUESTS);
            d8 = this.getHashtableData(hashtable3, SWAPPED_DOCUMENTS);
            if (d5 > 0.0) {
                d6 = this.roundDouble(d4 / d5 * 100.0, 2);
            }
            if (d8 > 0.0) {
                d9 = this.roundDouble(d7 / d8 * 100.0, 2);
            }
            if (this.prevHash != null && this.prevHash.size() > 0 && !this.prevHash.isEmpty()) {
                Hashtable hashtable4 = (Hashtable)this.prevHash.get(string2);
                if (hashtable4 == null || hashtable4.size() == 0 || hashtable4.isEmpty() || hashtable3 == null || hashtable3.size() == 0 || hashtable3.isEmpty()) continue;
                double d10 = this.getHashtableData(hashtable3, OUT_DATE_DOCS_IN_CACHE);
                double d11 = this.getHashtableData(hashtable4, OUT_DATE_DOCS_IN_CACHE);
                double d12 = this.getHashtableData(hashtable3, CACHE_HIGH_MARK);
                double d13 = this.getHashtableData(hashtable4, CACHE_HIGH_MARK);
                double d14 = d10 - d11;
                double d15 = d12 - d13;
                if (bl) {
                    this.timeSinceLastTest = 1.0;
                }
                if (debug) {
                    this.printOut("currOutOfDateDocsInCache  :" + d10);
                    this.printOut("prevOutOfDateDocsInCache  :" + d11);
                    this.printOut("currCacheHighMark  :" + d12);
                    this.printOut("prevCacheHighMark  :" + d13);
                    this.printOut("outOfDateDocsInCache :" + d14);
                    this.printOut("cacheHighMark  :" + d15);
                }
                if (d14 < 0.0) {
                    d14 = -5.0;
                    d2 = -5.0;
                } else {
                    d2 = this.roundDouble(d14 / this.timeSinceLastTest, 2);
                }
                if (d15 < 0.0) {
                    d15 = -5.0;
                    d3 = -5.0;
                } else {
                    d3 = this.roundDouble(d15 / this.timeSinceLastTest, 2);
                }
                if (bl || debug) {
                    this.printOut("Out Of Date Docs In Cache Rate  :" + d2);
                    this.printOut("Max Cache Reached Rate   :" + d3);
                }
            }
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d9));
            this.printOut("Info :" + string2 + "  MeasureArrayList  :" + arrayList);
            if (!bl) {
                this.addNewMeasure(string2, arrayList);
            }
            d = -5.0;
            d2 = -5.0;
            d3 = -5.0;
            d4 = -5.0;
            d5 = -5.0;
            d6 = -5.0;
            d7 = -5.0;
            d8 = -5.0;
            d9 = -5.0;
        }
        this.prevHash = hashtable2;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        BobiWISCacheTest bobiWISCacheTest = new BobiWISCacheTest(stringArray);
        int n = 0;
        int n2 = 3;
        while (n < n2) {
            ++n;
            bobiWISCacheTest.debugComputeMeasures(new Hashtable(), true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static {
        attrArrayList.add(CACHE_SIZE_KB);
        attrArrayList.add(OUT_DATE_DOCS_IN_CACHE);
        attrArrayList.add(CACHE_HIGH_MARK);
        attrArrayList.add(DOCS_OPENED_FROM_CACHE);
        attrArrayList.add(NO_OF_DOCS);
        attrArrayList.add(NO_OF_DOCS_WITH_SWAP_REQUESTS);
        attrArrayList.add(SWAPPED_DOCUMENTS);
        for (int i = 0; i < 8; ++i) {
            dummymeasureArrayList.add(new Double(-5.0));
        }
    }
}

