/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class AS400MessageTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;
    private String msgPath = null;
    private boolean isShowTotal = false;
    private int messageLimit = 10;
    public Hashtable ddHash = new Hashtable();
    ArrayList totalMsgList = null;
    ArrayList needReplyMsgList = null;

    public AS400MessageTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.msgPath = this.getValueForParam("Message_queue_path");
        if (this.msgPath == null || this.msgPath.trim().length() == 0) {
            this.msgPath = "";
        }
        this.isShowTotal = (string = this.getValueForParam("Show_all_messages")) != null && string.trim().length() > 0 && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
        String string2 = this.getValueForParam("Message_limit");
        if (string2 != null && string2.trim().length() > 0) {
            this.messageLimit = Integer.parseInt(string2);
        }
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400MessageTest aS400MessageTest = new AS400MessageTest(stringArray);
        aS400MessageTest.computeMeasures(new Hashtable());
    }

    public void freeTest() {
        this.totalMsgList = new ArrayList();
        this.needReplyMsgList = new ArrayList();
        this.ddHash = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        block17: {
            this.totalMsgList = new ArrayList();
            this.needReplyMsgList = new ArrayList();
            AS400 aS400 = null;
            int n = -5;
            int n2 = -5;
            boolean bl = false;
            try {
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null || this.msgPath == null || this.msgPath.trim().length() == 0) {
                    return;
                }
                ArrayList arrayList = this.myTokenizer(this.msgPath, ",");
                if (debug) {
                    System.out.println("[AS400MessageTest]pathList-->" + arrayList);
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return;
                }
                String string = this.getCurrentDate();
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    Object object;
                    Object object2;
                    MessageQueue messageQueue;
                    String string6 = (String)arrayList.get(i);
                    if (string6 == null || string6.trim().length() == 0) continue;
                    if (this.isShowTotal) {
                        messageQueue = new MessageQueue(aS400);
                        messageQueue.setPath(string6);
                        messageQueue.setListDirection(false);
                        object2 = messageQueue.getMessages(0, this.messageLimit);
                        messageQueue.close();
                        if (object2 != null && ((QueuedMessage[])object2).length > 0) {
                            for (Object object3 : object2) {
                                object = object3.getDate();
                                String string7 = this.getFormattedDate((Calendar)object);
                                if (!string.equals(string7)) {
                                    System.out.println("[" + this.entity + "] there is no messages for current data in Total measure !");
                                    continue;
                                }
                                String string8 = object3.getID();
                                int n4 = object3.getSeverity();
                                int n5 = object3.getType();
                                string5 = this.getMessageType(n5);
                                string4 = object3.getText();
                                string3 = object3.getDefaultReply();
                                string2 = object3.getHelp();
                                if (string2 != null && string2.length() > 4000) {
                                    string2 = string2.substring(0, 3999);
                                }
                                String string9 = this.getFormattedDateAndTime((Calendar)object);
                                String string10 = string8 + "~!~" + n4 + "~!~" + string5 + "~!~" + string4 + "~!~" + string9 + "~!~" + string3 + "~!~" + string2;
                                this.totalMsgList.add(string10);
                            }
                        }
                    }
                    messageQueue = new MessageQueue(aS400);
                    messageQueue.setPath(string6);
                    messageQueue.setListDirection(false);
                    messageQueue.setSelectMessagesNeedReply(true);
                    messageQueue.setSelectMessagesNoNeedReply(false);
                    messageQueue.setSelectSendersCopyMessagesNeedReply(true);
                    messageQueue.close();
                    object2 = messageQueue.getMessages();
                    while (object2.hasMoreElements()) {
                        Object object3;
                        QueuedMessage queuedMessage = (QueuedMessage)object2.nextElement();
                        if (queuedMessage == null) continue;
                        Calendar calendar = queuedMessage.getDate();
                        object3 = this.getFormattedDate(calendar);
                        if (!string.equals(object3)) {
                            System.out.println("[" + this.entity + "] there is no messages for current data");
                            continue;
                        }
                        object = queuedMessage.getID();
                        int n6 = queuedMessage.getSeverity();
                        int n7 = queuedMessage.getType();
                        String string11 = this.getMessageType(n7);
                        String string12 = queuedMessage.getText();
                        string5 = queuedMessage.getDefaultReply();
                        string4 = queuedMessage.getHelp();
                        if (string4 != null && string4.length() > 4000) {
                            string4 = string4.substring(0, 3999);
                        }
                        string3 = this.getFormattedDateAndTime(calendar);
                        string2 = (String)object + "~!~" + n6 + "~!~" + string11 + "~!~" + string12 + "~!~" + string3 + "~!~" + string5 + "~!~" + string4;
                        this.needReplyMsgList.add(string2);
                    }
                }
                if (this.isShowTotal && this.totalMsgList != null && this.totalMsgList.size() > 0) {
                    n = this.totalMsgList.size();
                    this.ddHash.put("TOTAL_MESSAGE", this.totalMsgList);
                }
                if (this.needReplyMsgList != null) {
                    n2 = this.needReplyMsgList.size();
                    this.ddHash.put("NEED_REPLY_MESSAGE", this.needReplyMsgList);
                }
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(n));
                arrayList2.add(new Double(n2));
                if (debug) {
                    System.out.println("[AS400MessageTest]measureList-->" + arrayList2);
                    System.out.println("[AS400MessageTest]ddHash-->" + this.ddHash);
                }
                this.addNewMeasure(arrayList2);
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", this.entity, string);
                if (aS400 == null) break block17;
                aS400.disconnectService(2);
            }
        }
    }

    private String getFormattedDate(Calendar calendar) {
        String string = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
            string = simpleDateFormat.format(calendar.getTime());
            string = string.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String getFormattedDateAndTime(Calendar calendar) {
        String string = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy hh:mm:ss");
            string = simpleDateFormat.format(calendar.getTime());
            string = string.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        try {
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                string3 = string.substring(n, n2).trim();
                arrayList.add(string3);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
            string3 = string.substring(n).trim();
            arrayList.add(string3);
        }
        catch (Exception exception) {
            String string4 = EgInstallInfo.getStackTraceAsString(exception);
            System.err.println("[" + this.entity + "] error message ->" + string4);
        }
        return arrayList;
    }

    private String getCurrentDate() {
        String string = "";
        try {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
            string = simpleDateFormat.format(date);
            string = string.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String getMessageType(int n) {
        String string = "";
        try {
            switch (n) {
                case 1: {
                    string = "Completion";
                    break;
                }
                case 2: {
                    string = "Diagnostic";
                    break;
                }
                case 4: {
                    string = "Informational";
                    break;
                }
                case 5: {
                    string = "Inquiry";
                    break;
                }
                case 6: {
                    string = "SendersCopy";
                    break;
                }
                case 8: {
                    string = "Request";
                    break;
                }
                case 10: {
                    string = "Request With Prompting";
                    break;
                }
                case 14: {
                    string = "Notify";
                    break;
                }
                case 15: {
                    string = "Escape";
                    break;
                }
                case 21: {
                    string = "REPLY_NOT_VALIDITY_CHECKED";
                    break;
                }
                case 22: {
                    string = "REPLY_VALIDITY_CHECKED";
                    break;
                }
                case 23: {
                    string = "REPLY_MESSAGE_DEFAULT_USED";
                    break;
                }
                case 24: {
                    string = "REPLY_SYSTEM_DEFAULT_USED";
                    break;
                }
                case 25: {
                    string = "REPLY_FROM_SYSTEM_REPLY_LIST";
                }
            }
        }
        catch (Exception exception) {
            String string2 = EgInstallInfo.getStackTraceAsString(exception);
            System.err.println("[" + this.entity + "] error message ->" + string2);
        }
        return string;
    }
}

