/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AS400JobTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;
    public int jobPref = 10;
    public Hashtable ddHash = null;
    private ArrayList ddList = null;
    private boolean isDebug = false;

    public AS400JobTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        String string = this.getValueForParam("count");
        try {
            this.jobPref = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.jobPref = 10;
        }
        this.setMeasureCount(this.measureCount);
    }

    public void freeTest() {
        this.ddHash = new Hashtable();
        this.ddList = new ArrayList();
    }

    public static void main(String[] stringArray) {
        AS400JobTest aS400JobTest = new AS400JobTest(stringArray);
        aS400JobTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block11: {
            if (this.isDebug) {
                System.out.println("From AS400JobTest:computeMeasures For target = " + this.targetHost + " system " + this.system + " UserID = " + this.userID + " password = " + this.password);
            }
            AS400 aS400 = null;
            try {
                Object object;
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                this.ddHash = new Hashtable();
                JobList jobList = new JobList(aS400);
                jobList.addJobSelectionCriteria(5, (Object)Boolean.TRUE);
                jobList.addJobSelectionCriteria(6, (Object)Boolean.TRUE);
                jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
                double d = jobList.getLength();
                if (this.isDebug) {
                    System.out.println(" Total no of jobs = " + d);
                }
                Enumeration enumeration = jobList.getJobs();
                while (enumeration.hasMoreElements()) {
                    object = "";
                    String string = "";
                    double d2 = 0.0;
                    String string2 = "";
                    String string3 = "";
                    double d3 = 0.0;
                    String string4 = "";
                    double d4 = 0.0;
                    double d5 = 0.0;
                    try {
                        Job job = (Job)enumeration.nextElement();
                        try {
                            object = job.getName();
                            string = job.getStatus();
                            d2 = job.getCPUUsed() / 1000;
                            string2 = job.getJobDescription();
                            string3 = job.getUser();
                            d3 = job.getAuxiliaryIORequests();
                            string4 = job.getType();
                            d4 = job.getTotalResponseTime();
                            d5 = new Double("" + job.getValue(314));
                        }
                        catch (Exception exception) {
                            d5 = 0.0;
                            continue;
                        }
                        System.out.println("[AS400JobTest]Jobname=" + (String)object + " Status=" + string + " jobtype =" + string4 + " CPUPct=" + d5);
                        this.ddList = new ArrayList();
                        this.ddList.add(object);
                        this.ddList.add(string);
                        this.ddList.add(string3);
                        this.ddList.add(new Double(d3));
                        this.ddList.add(string4);
                        this.ddList.add(string2);
                        this.ddList.add(new Double(d4));
                        this.ddList.add(new Double(d5));
                        if (this.isDebug) {
                            System.out.println("Adding into Hash = CPUPCT " + d5 + " List - " + this.ddList);
                        }
                        this.ddHash.put(new Double(d2), this.ddList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                object = new ArrayList();
                ((ArrayList)object).add(new Double(d));
                this.addNewMeasure((ArrayList)object);
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile(this.entity, "Error", string);
                if (aS400 == null) break block11;
                aS400.disconnectService(2);
            }
        }
    }
}

