/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemStatus;
import java.util.ArrayList;
import java.util.Hashtable;

public class AS400BatchJobTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;

    public AS400BatchJobTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400BatchJobTest aS400BatchJobTest = new AS400BatchJobTest(stringArray);
        aS400BatchJobTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block6: {
            double d = 0.0;
            AS400 aS400 = null;
            try {
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                SystemStatus systemStatus = new SystemStatus(aS400);
                systemStatus.setCaching(true);
                if (systemStatus.isCaching()) {
                    double d2 = systemStatus.getBatchJobsRunning();
                    double d3 = systemStatus.getBatchJobsEndedWithPrinterOutputWaitingToPrint();
                    double d4 = systemStatus.getBatchJobsEnding();
                    double d5 = systemStatus.getBatchJobsHeldOnJobQueue();
                    double d6 = systemStatus.getBatchJobsHeldWhileRunning();
                    double d7 = systemStatus.getBatchJobsOnUnassignedJobQueue();
                    double d8 = systemStatus.getBatchJobsWaitingForMessage();
                    double d9 = systemStatus.getBatchJobsWaitingToRunOrAlreadyScheduled();
                    double d10 = d2 + d3 + d4 + d5 + d6 + d7 + d8 + d9;
                    d = systemStatus.getBatchJobsOnAHeldJobQueue();
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d8));
                    arrayList.add(new Double(d9));
                    if (this.measureCount > 9) {
                        arrayList.add(new Double(d));
                    }
                    systemStatus.setCaching(false);
                    if (debug) {
                        System.out.println("[" + this.entity + "] MeasureList -->" + arrayList);
                    }
                    this.addNewMeasure(arrayList);
                }
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (aS400 == null) break block6;
                aS400.disconnectService(2);
            }
        }
    }
}

