/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;

final class CloneUtil {
    private CloneUtil() {
    }

    protected static Vector cloneQualifiers(Vector qualifiers) {
        Vector<Object> clone = new Vector<Object>(qualifiers.size());
        Enumeration quals = qualifiers.elements();
        while (quals.hasMoreElements()) {
            CIMQualifier qualifier = (CIMQualifier)quals.nextElement();
            clone.add(qualifier.clone());
        }
        return clone;
    }

    protected static Vector cloneProperties(Vector properties) {
        return CloneUtil.cloneProperties(properties, true, true, false);
    }

    protected static Vector cloneProperties(Vector properties, boolean reset) {
        return CloneUtil.cloneProperties(properties, false, false, reset);
    }

    protected static Vector cloneProperties(Vector properties, boolean includeQualifiers, boolean includeClassOrigin, boolean reset) {
        Vector<Object> clone = new Vector<Object>(properties.size());
        Enumeration eProps = properties.elements();
        while (eProps.hasMoreElements()) {
            CIMProperty property = (CIMProperty)eProps.nextElement();
            clone.add(property.clone(includeQualifiers, includeClassOrigin, reset));
        }
        return clone;
    }

    protected static Vector cloneParameter(Vector parameters, boolean includeQualifiers) {
        Vector<Object> clone = new Vector<Object>(parameters.size());
        Enumeration eParams = parameters.elements();
        while (eParams.hasMoreElements()) {
            CIMParameter parameter = (CIMParameter)eParams.nextElement();
            clone.add(parameter.clone(includeQualifiers));
        }
        return clone;
    }

    protected static Vector cloneMethods(Vector methods, boolean includeQualifiers, boolean includeClassOrigin) {
        Vector<Object> clone = new Vector<Object>(methods.size());
        Enumeration eMethods = methods.elements();
        while (eMethods.hasMoreElements()) {
            CIMMethod method = (CIMMethod)eMethods.nextElement();
            clone.add(method.clone(includeQualifiers, includeClassOrigin));
        }
        return clone;
    }
}

